/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.controller.import_export.ExportTemplateStruct;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.utils.TemplateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static String extractTextFileContent(String zipArchiveFullPath, String zipEntryPath) throws ZipExtractFileException {
        String entry;
        try {
            entry = ZipUtils.extractTextFileContent((String)zipArchiveFullPath, (String)zipEntryPath, (String)"UTF-8");
        }
        catch (IllegalArgumentException e) {
            log.warn("Error extract archive in UTF-8, try to use CP866");
            entry = ZipUtils.extractTextFileContent((String)zipArchiveFullPath, (String)zipEntryPath, (String)"CP866");
        }
        return entry;
    }

    public static void extractFile(String zipArchiveFullPath, String zipEntryPath, String destFileFullPath) throws ZipExtractFileException {
        try (FileInputStream fileInputStream = new FileInputStream(zipArchiveFullPath);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && !zipEntry.getName().equals(zipEntryPath)) {
                zipEntry = zipInputStream.getNextEntry();
            }
            File destFile = new File(destFileFullPath);
            File parentFile = destFile.getParentFile();
            if (!parentFile.mkdirs() && !parentFile.isDirectory()) {
                throw new IOException("Destination directory cannot be created: " + parentFile);
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(destFile);){
                IOUtils.copyLarge((InputStream)zipInputStream, (OutputStream)fileOutputStream);
            }
        }
        catch (FileNotFoundException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ZipExtractFileException();
        }
        catch (IOException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ZipExtractFileException();
        }
    }

    /*
     * Exception decompiling
     */
    public static InputStream extractFile(String zipArchiveFullPath, String zipEntryPath) throws ZipExtractFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String findEntry(String zipArchiveFullPath, String fileName) throws ZipExtractFileException {
        String entry;
        try {
            entry = ZipUtils.findEntry((String)zipArchiveFullPath, (String)fileName, (String)"UTF8");
        }
        catch (IllegalArgumentException e) {
            log.warn("Error reading archive in UTF-8, try to use CP866");
            entry = ZipUtils.findEntry((String)zipArchiveFullPath, (String)fileName, (String)"CP866");
        }
        return entry;
    }

    public static void unpackArchiveTo(String zipArchiveFullPath, String destinationFolderFullPath) throws ZipExtractFileException {
        try (FileInputStream fileInputStream = new FileInputStream(zipArchiveFullPath);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String destFullName = FilenameUtils.concat((String)destinationFolderFullPath, (String)zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    File file = new File(destFullName);
                    file.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    IOUtils.copyLarge((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ZipExtractFileException();
        }
        catch (IOException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ZipExtractFileException();
        }
    }

    public static void addTextFileToArchive(String archiveFileName, String fileName, String fileContent) {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(archiveFileName));){
            ZipEntry e = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(e);
            zipOutputStream.write(fileContent.getBytes());
            zipOutputStream.closeEntry();
        }
        catch (FileNotFoundException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static String getPackageExtension(boolean isInternalPackage) {
        return isInternalPackage ? ".prt" : ".zip";
    }

    public static void createZipWithPassword(ExportTemplateStruct exportTemplateStruct, ArrayList<File> filesToZip, String password, boolean isInternalPackage) throws ZipException, FileAlreadyExistsException {
        String filePath = TemplateUtils.getPackageFilePath((String)exportTemplateStruct.getPath(), (ExportTemplateStruct)exportTemplateStruct, (boolean)isInternalPackage);
        File file = new File(filePath);
        if (file.exists() && !exportTemplateStruct.getAllowOverwriteFile().booleanValue()) {
            throw new FileAlreadyExistsException();
        }
        ZipFile zipFile = new ZipFile(filePath);
        zipFile.addFiles(filesToZip, ZipUtils.getZipParametersToAddFiles((String)password));
    }

    public static ZipParameters getZipParametersToAddStreams(String password, String fileName) {
        ZipParameters parameters = ZipUtils.getZipParametersToAddFiles((String)ZipUtils.encodePassword((String)password));
        parameters.setSourceExternalStream(true);
        parameters.setFileNameInZip(fileName);
        return parameters;
    }

    public static String decodePassword(String encodedPassword) {
        return new String(Base64.getDecoder().decode(encodedPassword));
    }

    public static String encodePassword(String password) {
        return Base64.getEncoder().encodeToString(password.getBytes());
    }

    /*
     * Exception decompiling
     */
    private static String extractTextFileContent(String zipArchiveFullPath, String zipEntryPath, String charsetString) throws ZipExtractFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findEntry(String zipArchiveFullPath, String fileName, String charsetString) throws ZipExtractFileException {
        Charset charset = Charset.forName(charsetString);
        try (FileInputStream fileInputStream = new FileInputStream(zipArchiveFullPath);
             ZipInputStream zipInputStream = new ZipInputStream((InputStream)fileInputStream, charset);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryFileName = FilenameUtils.getName((String)zipEntry.getName());
                if (entryFileName.equals(fileName)) {
                    String string = zipEntry.getName();
                    return string;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            return null;
        }
        catch (FileNotFoundException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ZipExtractFileException();
        }
        catch (IOException e) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ZipExtractFileException();
        }
    }

    private static ZipParameters getZipParametersToAddFiles(String password) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setEncryptFiles(true);
        parameters.setEncryptionMethod(99);
        parameters.setAesKeyStrength(1);
        parameters.setPassword(password);
        return parameters;
    }

    private ZipUtils() {
    }
}

