/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.csv;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.exception.ContextCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.UnitCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.validation.PositionInfo;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.xbrl.import_export.XbrlParser;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvCommon;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvContextColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvFootnoteColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvUnitColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvValueColumns;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class XbrlCsvParser
implements XbrlParser {
    private Map<String, AtomicBoolean> footnoteHashMap;

    public XbrlCsvParser(CsvFileSet csvFileSet, Map<String, AtomicBoolean> footnoteHashMap) throws IOException, XbrlImportException, NotFoundException, ContextCsvDuplicateException, UnitCsvDuplicateException {
        this.footnoteHashMap = footnoteHashMap;
        this.processContexts(csvFileSet.getContextsPath());
        this.processUnits(csvFileSet.getUnitsPath());
        this.generateFootnoteKeyFieldHash(csvFileSet.getFootnotesPath());
        this.processValues(csvFileSet.getValuesPath());
        this.processFootnotes(csvFileSet.getFootnotesPath());
    }

    private void generateFootnoteKeyFieldHash(String footnotesXmlPath) throws IOException {
        if (StringUtils.isBlank((CharSequence)footnotesXmlPath) || StringUtils.equalsIgnoreCase((CharSequence)footnotesXmlPath, (CharSequence)"null")) {
            return;
        }
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(footnotesXmlPath), CsvCommon.CHARSET);
        CSVParser records = CsvCommon.CSV_FORMAT.parse((Reader)in);
        for (CSVRecord record : records) {
            String elementName = record.get(CsvFootnoteColumns.ELEMENT_NAME.name);
            String elementUri = record.get(CsvFootnoteColumns.ELEMENT_URI.name);
            String context = record.get(CsvFootnoteColumns.CONTEXT.name);
            String unit = record.get(CsvFootnoteColumns.UNIT.name);
            if (StringUtils.isBlank((CharSequence)elementName) || StringUtils.isBlank((CharSequence)elementUri) || StringUtils.isBlank((CharSequence)context)) continue;
            String key = StringUtils.join(Arrays.asList(elementName, elementUri, context, unit), (String)"|");
            this.footnoteHashMap.putIfAbsent("a" + DigestUtils.sha1Hex((String)key), new AtomicBoolean(false));
        }
    }

    private void processContexts(String contextsXmlPath) throws IOException, XbrlImportException, ContextCsvDuplicateException {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(contextsXmlPath), CsvCommon.CHARSET);
        CSVParser records = CsvCommon.CSV_FORMAT.parse((Reader)in);
        HashMap<Integer, String> entries = new HashMap<Integer, String>();
        boolean hasDuplicates = false;
        int line = 2;
        HashMap duplicates = new HashMap();
        for (CSVRecord record : records) {
            String contextId = record.get(CsvContextColumns.CONTEXT_ID.name);
            if (entries.containsValue(contextId)) {
                hasDuplicates = true;
                duplicates.putIfAbsent(contextId, new ArrayList());
                ((List)duplicates.get(contextId)).add(line);
            }
            if (!hasDuplicates) {
                entries.put(line, contextId);
                XbrlContext xbrlContext = new XbrlContext();
                xbrlContext.getXbrlContextId().setContextId(record.get(CsvContextColumns.CONTEXT_ID.name));
                xbrlContext.setPeriod(record.get(CsvContextColumns.PERIOD.name));
                xbrlContext.setIdentifier(record.get(CsvContextColumns.IDENTIFIER.name));
                xbrlContext.setScheme(record.get(CsvContextColumns.SCHEME.name));
                xbrlContext.setSegment(record.get(CsvContextColumns.SEGMENT.name));
                xbrlContext.setScenario(record.get(CsvContextColumns.SCENARIO.name));
                this.processXbrlContext(xbrlContext, contextsXmlPath, Integer.valueOf(line));
            }
            ++line;
        }
        if (hasDuplicates) {
            throw new ContextCsvDuplicateException(contextsXmlPath, duplicates);
        }
    }

    private void processUnits(String unitsXmlPath) throws IOException, XbrlImportException, UnitCsvDuplicateException {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(unitsXmlPath), CsvCommon.CHARSET);
        CSVParser records = CsvCommon.CSV_FORMAT.parse((Reader)in);
        HashMap<Integer, String> entries = new HashMap<Integer, String>();
        boolean hasDuplicates = false;
        int line = 2;
        HashMap duplicates = new HashMap();
        for (CSVRecord record : records) {
            String unitId = record.get(CsvUnitColumns.UNIT_ID.name);
            if (entries.containsValue(unitId)) {
                hasDuplicates = true;
                duplicates.put(unitId, new ArrayList());
                ((List)duplicates.get(unitId)).add(line);
            }
            if (!hasDuplicates) {
                entries.put(line, unitId);
                XbrlUnit xbrlUnit = new XbrlUnit();
                xbrlUnit.getXbrlUnitId().setUnitId(unitId);
                xbrlUnit.setContent(record.get(CsvUnitColumns.CONTENT.name));
                this.processXbrlUnit(xbrlUnit, unitsXmlPath, Integer.valueOf(line));
            }
            ++line;
        }
        if (hasDuplicates) {
            throw new UnitCsvDuplicateException(unitsXmlPath, duplicates);
        }
    }

    private void processValues(String valuesXmlPath) throws IOException, XbrlImportException, NotFoundException {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(valuesXmlPath), CsvCommon.CHARSET);
        CSVParser records = CsvCommon.CSV_FORMAT.parse((Reader)in);
        int line = 2;
        for (CSVRecord record : records) {
            XbrlValue xbrlValue = new XbrlValue();
            String contextId = record.get(CsvValueColumns.CONTEXT.name);
            xbrlValue.getXbrlValueId().setElementLabel(record.get(CsvValueColumns.ELEMENT_LABEL.name));
            String unitId = record.get(CsvValueColumns.UNIT.name);
            xbrlValue.setElementUri(record.get(CsvValueColumns.ELEMENT_URI.name));
            xbrlValue.setElementName(record.get(CsvValueColumns.ELEMENT_NAME.name));
            xbrlValue.setValue(record.get(CsvValueColumns.VALUE.name));
            xbrlValue.setNil(record.get(CsvValueColumns.NIL.name));
            xbrlValue.setTuple(record.get(CsvValueColumns.TUPLE.name));
            xbrlValue.setPrecision(XbrlCsvParser.safeParseInt((String)record.get(CsvValueColumns.PRECISION.name)));
            xbrlValue.setDecimals(XbrlCsvParser.safeParseInt((String)record.get(CsvValueColumns.DECIMALS.name)));
            xbrlValue.setLang(record.get(CsvValueColumns.LANG.name));
            if (!(StringUtils.isBlank((CharSequence)xbrlValue.getElementName()) || StringUtils.isBlank((CharSequence)xbrlValue.getElementUri()) || StringUtils.isBlank((CharSequence)contextId))) {
                String hash = "a" + DigestUtils.sha1Hex((String)StringUtils.join(Arrays.asList(xbrlValue.getElementName(), xbrlValue.getElementUri(), contextId, unitId), (String)"|"));
                if (this.footnoteHashMap.keySet().contains(hash)) {
                    ((AtomicBoolean)this.footnoteHashMap.get(hash)).set(true);
                    xbrlValue.setId(hash);
                }
            }
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setRowNumber(Integer.valueOf(line));
            this.processXbrlValue(contextId, unitId, xbrlValue, valuesXmlPath, positionInfo);
            ++line;
        }
    }

    public static Integer safeParseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void processFootnotes(String footnotesXmlPath) throws IOException, XbrlImportException {
        if (StringUtils.isBlank((CharSequence)footnotesXmlPath) || StringUtils.equalsIgnoreCase((CharSequence)footnotesXmlPath, (CharSequence)"null")) {
            return;
        }
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(footnotesXmlPath), CsvCommon.CHARSET);
        CSVParser records = CsvCommon.CSV_FORMAT.parse((Reader)in);
        int line = 2;
        for (CSVRecord record : records) {
            XbrlFootnote xbrlFootnote = new XbrlFootnote();
            xbrlFootnote.setFootnoteNo(record.get(CsvFootnoteColumns.FOOTNOTE_ID.name));
            xbrlFootnote.setContent(StringUtils.trim((String)record.get(CsvFootnoteColumns.CONTENT.name)));
            xbrlFootnote.setLanguage(record.get(CsvFootnoteColumns.LANGUAGE.name));
            xbrlFootnote.setExtendedLinkRole(record.get(CsvFootnoteColumns.EXTENDED_LINK_ROLE.name));
            xbrlFootnote.setLocatorRole(record.get(CsvFootnoteColumns.LOCATOR_ROLE.name));
            xbrlFootnote.setElementName(record.get(CsvFootnoteColumns.ELEMENT_NAME.name));
            xbrlFootnote.setElementUri(record.get(CsvFootnoteColumns.ELEMENT_URI.name));
            xbrlFootnote.setContext(record.get(CsvFootnoteColumns.CONTEXT.name));
            xbrlFootnote.setUnit(record.get(CsvFootnoteColumns.UNIT.name));
            String elementName = xbrlFootnote.getElementName();
            String elementUri = xbrlFootnote.getElementUri();
            String context = xbrlFootnote.getContext();
            if (!(StringUtils.isBlank((CharSequence)elementName) || StringUtils.isBlank((CharSequence)elementUri) || StringUtils.isBlank((CharSequence)context))) {
                String key = StringUtils.join(Arrays.asList(elementName, elementUri, context, xbrlFootnote.getUnit()), (String)"|");
                xbrlFootnote.setFootnoteFactId("a" + DigestUtils.sha1Hex((String)key));
            }
            this.processXbrlFootnote(xbrlFootnote, footnotesXmlPath, Integer.valueOf(line));
            ++line;
        }
    }

    public abstract void processXbrlContext(XbrlContext var1, String var2, Integer var3);

    public abstract void processXbrlValue(String var1, String var2, XbrlValue var3, String var4, PositionInfo var5) throws NotFoundException;

    public abstract void processXbrlUnit(XbrlUnit var1, String var2, Integer var3);

    public abstract void processXbrlFootnote(XbrlFootnote var1, String var2, Integer var3);
}

