/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TopHeaderModel {
    private final Integer TABLE_WIDTH;
    private int TOP_HEADER_HEIGHT;
    private ColumnHeader[][] topHeaderModel;
    private ColumnHeader[] leaves;
    private String[] rcCodes;
    private final TLBUiModel tlbUiModel;
    private Map<ColumnHeader, List<AspectData>> columnAspectMap = new HashMap();

    public TopHeaderModel(TLBUiModel tlbUiModel, boolean yLevelAsColumns) {
        this.tlbUiModel = tlbUiModel;
        this.prepareNonAbstractParents(tlbUiModel.getColumnList());
        int headersDepth = TableLinkViewUtils.calcHeadersDepth((List)tlbUiModel.getColumnList()) + 1;
        List leavesList = TopHeaderModel.getLeaves((List)tlbUiModel.getColumnList(), (boolean)false);
        this.TOP_HEADER_HEIGHT = yLevelAsColumns && headersDepth > 2 ? headersDepth + 1 : (tlbUiModel.isXRcCodePresent() ? headersDepth + 1 : headersDepth);
        this.TABLE_WIDTH = tlbUiModel.getColumnList().stream().map(c -> c.getColspan()).reduce(0, Integer::sum);
        this.topHeaderModel = new ColumnHeader[this.TABLE_WIDTH.intValue()][this.TOP_HEADER_HEIGHT];
        this.rcCodes = new String[this.TABLE_WIDTH.intValue()];
        TopHeaderModel.fillTopHeaderCoords((ColumnHeader[][])this.topHeaderModel, (String[])this.rcCodes, (List)tlbUiModel.getColumnList(), (int)0, (int)0);
        TopHeaderModel.buildColumnAspectsMap((List)tlbUiModel.getColumnList(), null);
        this.leaves = leavesList.toArray(new ColumnHeader[leavesList.size()]);
    }

    private void prepareNonAbstractParents(List<ColumnHeader> columnHeaders) {
        this.iterateColumns(columnHeaders, columnHeader -> {
            if (!columnHeader.isAbstractNode() && !columnHeader.getColumnList().isEmpty()) {
                ColumnHeader newColumnHeader = new ColumnHeader();
                newColumnHeader.setCaption(columnHeader.getCaption());
                newColumnHeader.setDataField(columnHeader.getDataField());
                newColumnHeader.setAbstractNode(false);
                newColumnHeader.setColspan(Integer.valueOf(1));
                columnHeader.setDataField(null);
                columnHeader.getColumnList().add(0, newColumnHeader);
            }
        });
        TableLinkViewUtils.calcColspans((List)this.tlbUiModel.getColumnList());
    }

    private void iterateColumns(List<ColumnHeader> columnHeaders, Consumer<ColumnHeader> consumer) {
        columnHeaders.forEach(c -> {
            consumer.accept((ColumnHeader)c);
            this.iterateColumns(c.getColumnList(), consumer);
        });
    }

    public ColumnHeader[][] getTopHeaderModel() {
        return this.topHeaderModel;
    }

    public String[] getRcCodes() {
        return this.rcCodes;
    }

    public static void fillTopHeaderCoords(ColumnHeader[][] topHeaderModel, String[] rcCodes, List<ColumnHeader> columnHeaders, int x, int y) {
        int left = x;
        for (ColumnHeader columnHeader : columnHeaders) {
            if (StringUtils.startsWith((CharSequence)columnHeader.getCaption(), (CharSequence)"header_common_title_")) continue;
            int nextY = y + 1;
            TopHeaderModel.fillTopHeaderCoords((ColumnHeader[][])topHeaderModel, (String[])rcCodes, (List)columnHeader.getColumnList(), (int)left, (int)nextY);
            columnHeader.setX(Integer.valueOf(left));
            columnHeader.setY(Integer.valueOf(y));
            topHeaderModel[left][y] = columnHeader;
            String rcCode = columnHeader.getRcCode();
            if (!StringUtils.isBlank((CharSequence)rcCode)) {
                rcCodes[left] = rcCode;
            }
            left += columnHeader.getColspan().intValue();
        }
    }

    public String[] getDataFields() {
        List topHeaderLeaves = TopHeaderModel.getLeaves((List)this.tlbUiModel.getColumnList(), (boolean)false);
        ColumnHeader[] topHeaderLeavesArray = topHeaderLeaves.toArray(new ColumnHeader[topHeaderLeaves.size()]);
        String[] dataFields = (String[])Arrays.stream(topHeaderLeavesArray).map(columnHeader -> columnHeader != null ? columnHeader.getDataField() : null).toArray(String[]::new);
        return dataFields;
    }

    public static List<ColumnHeader> getLeaves(List<ColumnHeader> columnHeaders, boolean isUnitsConfig) {
        ArrayList<ColumnHeader> result = new ArrayList<ColumnHeader>();
        for (ColumnHeader columnHeader : columnHeaders) {
            if (columnHeader.getColumnList().size() > 0) {
                result.addAll(TopHeaderModel.getLeaves((List)columnHeader.getColumnList(), (boolean)isUnitsConfig));
                if (!isUnitsConfig) continue;
                result.add(columnHeader);
                continue;
            }
            result.add(columnHeader);
        }
        return result;
    }

    public ColumnHeader[] getLeaves() {
        return this.leaves;
    }

    public static void buildColumnAspectsMap(List<ColumnHeader> columnHeaders, ColumnHeader parent) {
        for (ColumnHeader columnHeader : columnHeaders) {
            ArrayList newAspectDataList = new ArrayList();
            if (parent != null) {
                newAspectDataList.addAll(parent.getFullAspectDataList());
            }
            newAspectDataList.addAll(columnHeader.getAspectDataList());
            columnHeader.setFullAspectDataList(newAspectDataList);
            TopHeaderModel.buildColumnAspectsMap((List)columnHeader.getColumnList(), (ColumnHeader)columnHeader);
        }
    }

    public Map<ColumnHeader, List<AspectData>> getColumnAspectMap() {
        return this.columnAspectMap;
    }
}

