/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.IncorrectXAxisException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.SchemaValidationException;
import ru.cbr.xbrl.converter.exception.UnsupportedAlternativeExportRoleException;
import ru.cbr.xbrl.converter.model.DimensionValuePair;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.XlsAspectColumnService;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.SheetModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxParserBase;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxSheet;

/*
 * Exception performing whole class analysis ignored.
 */
public class XlsxParser
extends XlsxParserBase {
    private static final Logger log = LoggerFactory.getLogger(XlsxParser.class);
    public static Set<Integer> incorrectImportedAxisLines = new HashSet();
    public static boolean isRoleWithCorrectXAxis = true;
    public static String importedRoleTitle;
    public static final int TOC_OFFSET = 1;
    public static final int TECH_SHEETS_COUNT = 2;
    private final String xlsxFileName;
    private final BiConsumer<List<AspectCellData>, NotificationEvent> aspectCelldataListConsumer;
    private final Function<XbrlReportRole, TLBUiModel> getTlbUiModelFunction;
    private final HashMap<String, Pair<String, String>> generatedSheetNamesMap;
    private final List<XbrlDimension> explicitDimensions;
    private final Map<String, String> explicitDimensionMap = new HashMap();
    private EventLogService eventLogService;
    private XbrlPackage xbrlPackage;
    private AspectNodeService aspectNodeService;
    private List<String> unsupportedRoles;
    private XlsAspectColumnService xlsAspectColumnService;
    private XbrlReportService xbrlReportService;
    private XbrlDimensionService xbrlDimensionService;
    private int currentTableHeight = 0;
    private ObjectMapper objectMapper = new ObjectMapper();

    public XlsxParser(String xlsxFileName, XbrlPackage xbrlPackage, EventLogService eventLogService, AspectNodeService aspectNodeService, List<XbrlDimension> explicitDimensions, Function<XbrlReportRole, TLBUiModel> getTlbUiModelFunction, BiConsumer<List<AspectCellData>, NotificationEvent> aspectCelldataListConsumer, List<String> unsupportedRoles, XlsAspectColumnService xlsAspectColumnService, XbrlReportService xbrlReportService, XbrlDimensionService xbrlDimensionService) throws SchemaValidationException {
        this.xlsxFileName = xlsxFileName;
        this.aspectCelldataListConsumer = aspectCelldataListConsumer;
        this.getTlbUiModelFunction = getTlbUiModelFunction;
        this.eventLogService = eventLogService;
        this.aspectNodeService = aspectNodeService;
        this.xbrlPackage = xbrlPackage;
        this.generatedSheetNamesMap = this.generateSheetNamesMap(xbrlPackage);
        this.explicitDimensions = explicitDimensions;
        this.unsupportedRoles = unsupportedRoles;
        this.xlsAspectColumnService = xlsAspectColumnService;
        this.xbrlReportService = xbrlReportService;
        this.xbrlDimensionService = xbrlDimensionService;
        explicitDimensions.stream().forEach(xbrlDimension -> this.explicitDimensionMap.put(xbrlDimension.getDimInt(), xbrlDimension.getDimIntLabel()));
    }

    private HashMap<String, Pair<String, String>> generateSheetNamesMap(XbrlPackage xbrlPackage) {
        List roleNames = xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().map(r -> r.getTitle()).collect(Collectors.toList());
        List generatedSheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        HashMap<String, Pair<String, String>> generatedSheetNamesMap = new HashMap<String, Pair<String, String>>();
        for (int i = 0; i < roleNames.size(); ++i) {
            XbrlReportRole role = (XbrlReportRole)xbrlPackage.getXbrlReport().getXbrlReportRoles().get(i);
            generatedSheetNamesMap.putIfAbsent(role.getSystemId(), (Pair<String, String>)new ImmutablePair((Object)role.getTitle(), generatedSheetNames.get(i)));
        }
        return generatedSheetNamesMap;
    }

    private String getSheetRoleSystemId(Sheet sheet) {
        Row systemIdRow = sheet.getRow(2);
        if (systemIdRow == null) {
            return null;
        }
        Cell systemIdCell = systemIdRow.getCell(0);
        if (systemIdCell == null) {
            return null;
        }
        return systemIdCell.getStringCellValue();
    }

    public void parse(Boolean isAlternativeFormat) throws IOException, SchemaValidationException {
        log.info("Parse XLSX workbook: " + this.xlsxFileName);
        Date start = new Date();
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(this.xlsxFileName));
        List xbrlReportRoles = this.xbrlPackage.getXbrlReport().getXbrlReportRoles();
        Map<String, XbrlReportRole> rolesMap = xbrlReportRoles.stream().collect(Collectors.toMap(XbrlReportRole::getSystemId, r -> r));
        AtomicInteger xlsxSheetIndex = new AtomicInteger();
        AtomicLong buildTlbUiDuration = new AtomicLong();
        Iterator sheetIterator = workbook.sheetIterator();
        while (sheetIterator.hasNext()) {
            XSSFSheet xlsxSheet = (XSSFSheet)sheetIterator.next();
            String roleSystemId = this.getSheetRoleSystemId((Sheet)xlsxSheet);
            if (roleSystemId == null || !rolesMap.containsKey(roleSystemId)) continue;
            XbrlReportRole xbrlReportRole = rolesMap.get(roleSystemId);
            int xlsxPageIndex = 1 + xlsxSheetIndex.getAndIncrement();
            Date startTlbuiBuild = new Date();
            log.debug("Prepare role {} ({})", (Object)xbrlReportRole.getTitle(), (Object)xbrlReportRole.getSystemId());
            TLBUiModel tlbUiModel = (TLBUiModel)this.getTlbUiModelFunction.apply(xbrlReportRole);
            buildTlbUiDuration.addAndGet(new Date().getTime() - startTlbuiBuild.getTime());
            log.debug("        Prepare role complete {} ({}) in {} msec", new Object[]{xbrlReportRole.getTitle(), xbrlReportRole.getSystemId(), new Date().getTime() - startTlbuiBuild.getTime()});
            if (tlbUiModel == null) continue;
            if (BooleanUtils.isFalse((Boolean)isAlternativeFormat) && CollectionUtils.isEmpty((Collection)xbrlReportRole.getXbrlRoleDimensionList())) {
                this.unsupportedRoles.add(xbrlReportRole.getSystemId());
                continue;
            }
            TableLinkViewUtils.calcColspans((List)tlbUiModel.getColumnList());
            SheetModel sheetModel = new SheetModel(tlbUiModel, false);
            if (!CollectionUtils.isEmpty((Collection)xbrlReportRole.getXbrlRoleDimensionList())) {
                block7: {
                    if (BooleanUtils.isFalse((Boolean)isAlternativeFormat)) {
                        try {
                            this.importOpenAxisNewFormat(xbrlReportRole, xlsxSheet, sheetModel);
                            break block7;
                        }
                        catch (Exception e) {
                            log.error("Role does not support new format", (Throwable)e);
                            this.unsupportedRoles.add(xbrlReportRole.getSystemId());
                            continue;
                        }
                    }
                    this.importOpenAxis(xbrlReportRole, xlsxSheet, sheetModel);
                }
                tlbUiModel = (TLBUiModel)this.getTlbUiModelFunction.apply(xbrlReportRole);
                sheetModel = new SheetModel(tlbUiModel, false);
            }
            List roleAspectCellDataList = this.parseRole(tlbUiModel.getRoleId(), xlsxSheet, sheetModel, xbrlReportRole, isAlternativeFormat);
            roleAspectCellDataList.forEach(aspectCellData -> {
                aspectCellData.setRoleLabel(xlsxSheet.getSheetName());
                aspectCellData.setRoleId(xbrlReportRole.getId());
            });
            NotificationEvent notificationEvent = new NotificationEvent();
            notificationEvent.setTitle(xbrlReportRole.getTitle());
            int currentStage = xlsxPageIndex;
            notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
            notificationEvent.setTotalNumberOfStages(Integer.valueOf(xbrlReportRoles.size()));
            Float progress = Float.valueOf(Float.valueOf(currentStage).floatValue() / (float)xbrlReportRoles.size());
            notificationEvent.setProgress(progress);
            this.aspectCelldataListConsumer.accept(roleAspectCellDataList, notificationEvent);
        }
        if (xlsxSheetIndex.get() != 0) {
            log.info("Build TLB UI duration summary: " + buildTlbUiDuration.get() + " msec, avg: " + buildTlbUiDuration.get() / (long)xlsxSheetIndex.get());
        }
        log.info("Parse XLSX workbook completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    private void importOpenAxisNewFormat(XbrlReportRole xbrlReportRole, XSSFSheet xlsxSheet, SheetModel sheetModel) {
        ArrayList axisList = new ArrayList(xbrlReportRole.getXbrlRoleDimensionList());
        Map dimensionTitleMap = axisList.stream().filter(a -> a.getFilterOpenAxis() != null).collect(Collectors.toMap(a -> a.getFilterOpenAxis().getTitle(), Function.identity(), (a, b) -> a));
        xbrlReportRole.getXbrlRoleDimensionList().stream().filter(d -> d.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)).forEach(d -> dimensionTitleMap.put((String)this.explicitDimensionMap.get(d.getDimension()), d));
        if (axisList.isEmpty()) {
            return;
        }
        int offset = 4 + sheetModel.getTopHeaderHeight() + 1;
        XSSFRow axisRow = xlsxSheet.getRow(offset);
        LinkedList<String> axisListFromXlsx = new LinkedList<String>();
        for (int i = 0; i < axisList.size(); ++i) {
            XSSFCell cell = axisRow.getCell(i);
            if (cell == null) continue;
            axisListFromXlsx.add(cell.getStringCellValue());
        }
        LinkedList<DimensionValuePair> values = new LinkedList<DimensionValuePair>();
        Iterator rowIterator = xlsxSheet.rowIterator();
        LinkedList added = new LinkedList();
        int previousRow = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() < offset + 1) continue;
            if (previousRow > 0 && row.getRowNum() - previousRow > 1) {
                this.currentTableHeight = previousRow - 4 + 1;
                break;
            }
            previousRow = row.getRowNum();
            for (int i = 0; i < axisListFromXlsx.size(); ++i) {
                String stringCellValue;
                Cell cell = row.getCell(i);
                if (cell == null || !StringUtils.isNotEmpty((CharSequence)(stringCellValue = cell.getStringCellValue()))) continue;
                String preparedValue = stringCellValue.trim();
                String axis = (String)axisListFromXlsx.get(i);
                XbrlRoleDimension dimension = (XbrlRoleDimension)dimensionTitleMap.get(axis);
                if (DimensionType.TYPED_MEMBER.equals((Object)dimension.getDimensionType())) {
                    values.add(DimensionValuePair.of((String)dimension.getFilterOpenAxis().getSystemId(), null, (String)preparedValue, null, (int)i));
                } else if (DimensionType.EXPLICIT_MEMBER.equals((Object)dimension.getDimensionType())) {
                    values.add(DimensionValuePair.of((String)dimension.getDimension(), null, (String)preparedValue, null, (int)i));
                }
                YLevel yLevel = this.getYLevelValue(sheetModel, preparedValue, added);
                if (yLevel == null) continue;
                values.add(DimensionValuePair.of(null, (String)yLevel.getTitle(), (String)stringCellValue, (String)yLevel.getHash(), (int)0));
            }
        }
        this.saveMembers(xbrlReportRole, values, sheetModel.getTlbUiModel().getYRootHash());
    }

    private void importOpenAxis(XbrlReportRole xbrlReportRole, XSSFSheet xlsxSheet, SheetModel sheetModel) throws IOException {
        if (CollectionUtils.isEmpty((Collection)xbrlReportRole.getXbrlRoleDimensionList())) {
            return;
        }
        int offset = 4 + sheetModel.getTopHeaderHeight() + 1;
        TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue((Reader)new StringReader(xbrlReportRole.getStaticStructureJson()), TableLinkBaseStructure.class);
        AxisMemberHierarchy yHierarchy = tableLinkBaseStructure.getYAxis();
        HashMap<String, Set> dimensionParentMap = new HashMap<String, Set>();
        Set dimensionSet = this.calculateDimensionParentHashMap(yHierarchy, dimensionParentMap);
        for (String dimension : dimensionSet) {
            Set existingDimensionSet = dimensionParentMap.computeIfAbsent(yHierarchy.getId(), k -> new HashSet());
            existingDimensionSet.add(dimension);
        }
        Iterator rowIterator = xlsxSheet.rowIterator();
        int previousLevel = 1;
        int previousRow = 0;
        HashMap<Integer, AxisMemberHierarchy> levelAxisMemberHierarchyMap = new HashMap<Integer, AxisMemberHierarchy>();
        levelAxisMemberHierarchyMap.put(0, yHierarchy);
        AxisMemberHierarchy parentMemberHierarchy = yHierarchy;
        HashMap<Integer, String> levelHashMap = new HashMap<Integer, String>();
        while (rowIterator.hasNext()) {
            AxisMemberHierarchy currentHierarchyMember;
            Row row = (Row)rowIterator.next();
            int rowNum = row.getRowNum();
            if (rowNum < offset) {
                previousRow = rowNum;
                continue;
            }
            Cell cell = row.getCell(0);
            if (cell == null || rowNum - previousRow > 1) {
                return;
            }
            previousRow = rowNum;
            String stringCellValue = cell.getStringCellValue();
            if (stringCellValue == null) continue;
            String preparedValue = stringCellValue.trim();
            int spaceCount = StringUtils.indexOf((CharSequence)stringCellValue, (CharSequence)preparedValue);
            int level = spaceCount / 6 + 1;
            if (level <= previousLevel) {
                parentMemberHierarchy = (AxisMemberHierarchy)levelAxisMemberHierarchyMap.get(level - 1);
                HashSet storedLevels = new HashSet(levelHashMap.keySet());
                for (Integer storedLevel : storedLevels) {
                    if (storedLevel < level) continue;
                    levelHashMap.remove(storedLevel);
                }
            }
            if ((currentHierarchyMember = this.getAxisHierarchyMember(parentMemberHierarchy, preparedValue)) == null) continue;
            if (currentHierarchyMember.getNodeType() == NodeType.ASPECT) {
                String hash = parentMemberHierarchy.getId();
                Set possibleDimensions = (Set)dimensionParentMap.get(hash);
                List dimensions = AspectCellData.getDimensionsByStream(currentHierarchyMember.getAspectDataList().stream());
                Set existingDimensions = dimensions.stream().map(AspectData::getAspect).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(existingDimensions) || existingDimensions.size() > 1 || !possibleDimensions.contains(existingDimensions.iterator().next())) continue;
                preparedValue = StringUtils.substringAfterLast((String)preparedValue, (String)(((AspectData)dimensions.iterator().next()).getLabel() + "-"));
                String createdHash = (String)levelHashMap.get(level - 1);
                if (StringUtils.isNotBlank((CharSequence)createdHash)) {
                    hash = createdHash;
                }
                AspectNodeMember newMember = null;
                try {
                    newMember = this.aspectNodeService.saveMember(xbrlReportRole.getId(), (String)existingDimensions.iterator().next(), preparedValue, hash, null);
                }
                catch (NotFoundException e) {
                    EventLog eventLog = new EventLog();
                    eventLog.setEventLogType(EventLog.EventLogType.IMPORT_XLSX);
                    eventLog.setRole(xlsxSheet.getSheetName());
                    eventLog.setMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c \u043e\u0441\u0438 \u0434\u043b\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f: " + stringCellValue);
                    eventLog.setXbrlReportId(this.xbrlPackage.getXbrlReport().getId());
                    this.eventLogService.createInNewTransaction(eventLog);
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                if (newMember != null) {
                    levelHashMap.put(level, newMember.getCommonId());
                }
            }
            previousLevel = level;
            levelAxisMemberHierarchyMap.put(level, currentHierarchyMember);
            parentMemberHierarchy = currentHierarchyMember;
        }
    }

    private AxisMemberHierarchy getAxisHierarchyMember(AxisMemberHierarchy parentMemberHierarchy, String preparedValue) {
        if (parentMemberHierarchy == null) {
            return null;
        }
        List childAxisMemberHierarchyList = parentMemberHierarchy.getAxisMemberHierarchyList();
        if (CollectionUtils.isEmpty((Collection)childAxisMemberHierarchyList)) {
            return null;
        }
        String testValue = preparedValue;
        if (StringUtils.equals((CharSequence)preparedValue, (CharSequence)"empty row header")) {
            testValue = "";
        }
        for (AxisMemberHierarchy axisMemberHierarchy : childAxisMemberHierarchyList) {
            String commonLabel = LabelUtils.calcLabel((List)axisMemberHierarchy.getAspectDataList(), (String)"");
            String aspectLabel = LabelUtils.calcMemberLabel((List)axisMemberHierarchy.getAspectDataList());
            if (StringUtils.equals((CharSequence)commonLabel, (CharSequence)testValue)) {
                return axisMemberHierarchy;
            }
            if (StringUtils.startsWith((CharSequence)testValue, (CharSequence)aspectLabel)) {
                StringUtils.substringAfterLast((String)preparedValue, (String)(aspectLabel + "-"));
                return axisMemberHierarchy;
            }
            if (axisMemberHierarchy.getNodeType() != NodeType.RULE || !StringUtils.equals((CharSequence)axisMemberHierarchy.getLabel(), (CharSequence)preparedValue)) continue;
            return axisMemberHierarchy;
        }
        return null;
    }

    private void findParentDimensionValuePair(int childIndex, List<DimensionValuePair> dimensionValuePairs) {
        DimensionValuePair child = dimensionValuePairs.get(childIndex);
        int level = this.getLevel(child);
        for (int i = childIndex; i >= 0; --i) {
            DimensionValuePair dimensionValuePair = dimensionValuePairs.get(i);
            if (this.getLevel(dimensionValuePair) != level - 1) continue;
            dimensionValuePair.getChildList().add(child);
            return;
        }
    }

    private void findDuplicateAxises(List<DimensionValuePair> dimensionValuePairs, XSSFSheet xlsxSheet) {
        for (DimensionValuePair valuePair : dimensionValuePairs) {
            if (dimensionValuePairs.stream().filter(secondValue -> secondValue.getDimension().equals(valuePair.getDimension()) && secondValue.getValue().equals(valuePair.getValue())).count() <= 1L) continue;
            EventLog eventLog = new EventLog();
            eventLog.setEventLogType(EventLog.EventLogType.IMPORT_XLSX);
            eventLog.setRole(xlsxSheet.getSheetName());
            eventLog.setMessage("\u0414\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0441\u0438: " + valuePair.getValue());
            eventLog.setXbrlReportId(this.xbrlPackage.getXbrlReport().getId());
            this.eventLogService.createInNewTransaction(eventLog);
            throw new SchemaValidationException();
        }
        dimensionValuePairs.forEach(dimensionValuePair -> this.findDuplicateAxises(dimensionValuePair.getChildList(), xlsxSheet));
    }

    private YLevel getYLevelValue(SheetModel sheetModel, String preparedValue, List<YLevel> added) {
        List yLevelList = Optional.ofNullable(sheetModel.getTlbUiModel().getPeriodLevelList().get(0)).map(PeriodLevel::getZLevelList).map(list -> (ZLevel)list.get(0)).map(ZLevel::getYLevelList).orElse(null);
        if (yLevelList == null) {
            return null;
        }
        return this.findYLevel(yLevelList, preparedValue, added);
    }

    private YLevel findYLevel(List<YLevel> yLevelList, String preparedValue, List<YLevel> added) {
        for (YLevel yLevel : yLevelList) {
            YLevel level;
            if ((yLevel.getTitle().startsWith(preparedValue) || yLevel.getTitle().equals("") && preparedValue.equals("empty row header")) && !added.contains(yLevel)) {
                added.add(yLevel);
                return yLevel;
            }
            if (CollectionUtils.isEmpty((Collection)yLevel.getYLevelList()) || (level = this.findYLevel(yLevel.getYLevelList(), preparedValue, added)) == null) continue;
            return level;
        }
        return null;
    }

    private void saveMembers(XbrlReportRole xbrlReportRole, List<DimensionValuePair> values, String parentHash) {
        DimensionValuePair[][] preparedValueList;
        for (DimensionValuePair[] dimensionValuePairs : preparedValueList = this.prepareDimensionValue(values)) {
            String currentHash = parentHash;
            for (DimensionValuePair dimensionValuePair : dimensionValuePairs) {
                if (dimensionValuePair == null) continue;
                try {
                    if (dimensionValuePair.getHash() == null) {
                        AspectNodeMember newMember = this.aspectNodeService.saveMember(xbrlReportRole.getId(), dimensionValuePair.getDimension(), dimensionValuePair.getClearedValue(), currentHash, null);
                        currentHash = newMember.getCommonId();
                        continue;
                    }
                    currentHash = dimensionValuePair.getHash();
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Set<String> calculateDimensionParentHashMap(AxisMemberHierarchy axisMemberHierarchy, Map<String, Set<String>> dimensionHashMap) {
        List axisMemberHierarchyList = axisMemberHierarchy.getAxisMemberHierarchyList();
        List aspectDataList = axisMemberHierarchy.getAspectDataList();
        if (CollectionUtils.isEmpty((Collection)axisMemberHierarchyList)) {
            if (CollectionUtils.isEmpty((Collection)aspectDataList)) {
                return Collections.emptySet();
            }
            return AspectCellData.getDimensionsByStream(aspectDataList.stream()).stream().map(AspectData::getAspect).collect(Collectors.toSet());
        }
        for (AxisMemberHierarchy childMemberHierarchy : axisMemberHierarchyList) {
            Set dimensionSet = this.calculateDimensionParentHashMap(childMemberHierarchy, dimensionHashMap);
            for (String dimension : dimensionSet) {
                Set existingDimensionSet = dimensionHashMap.computeIfAbsent(axisMemberHierarchy.getId(), k -> new HashSet());
                existingDimensionSet.add(dimension);
            }
        }
        return AspectCellData.getDimensionsByStream(aspectDataList.stream()).stream().map(AspectData::getAspect).collect(Collectors.toSet());
    }

    private String findParentHash(String dimension, String parentHash, List<AxisMemberHierarchy> axisMemberHierarchies) {
        AxisMemberHierarchy axisMemberHierarchy;
        boolean isContainsDim;
        String res = null;
        Iterator<AxisMemberHierarchy> iterator = axisMemberHierarchies.iterator();
        while (iterator.hasNext() && (res = (isContainsDim = (axisMemberHierarchy = iterator.next()).getAspectDataList().stream().anyMatch(aspectData -> aspectData.getType().equals((Object)AspectType.DIMENSION) && aspectData.getAspect().equals(dimension))) ? parentHash : this.findParentHash(dimension, axisMemberHierarchy.getId(), axisMemberHierarchy.getAxisMemberHierarchyList())) == null) {
        }
        return res;
    }

    private DimensionValuePair[][] prepareDimensionValue(List<DimensionValuePair> values) {
        Integer max = values.stream().map(DimensionValuePair::getLevel).max(Comparator.naturalOrder()).orElse(0);
        DimensionValuePair[][] result = new DimensionValuePair[values.size()][max + 1];
        for (int i = 0; i < values.size(); ++i) {
            DimensionValuePair current = values.get(i);
            int level = current.getLevel();
            result[i][level] = current;
            if (i == 0 || level == 0) continue;
            System.arraycopy(result[i - 1], 0, result[i], 0, level);
        }
        return result;
    }

    private int getOffset(SheetModel sheetModel) {
        List periodLevelList = sheetModel.getTlbUiModel().getPeriodLevelList();
        int periodLevelOffset = periodLevelList != null ? periodLevelList.size() : 0;
        Integer topHeaderOffset = sheetModel.getTopHeaderHeight();
        return 4 + periodLevelOffset + topHeaderOffset;
    }

    private void validateSchema(XSSFSheet xlsxSheet, SheetModel sheetModel, int labelsRowIndex) throws SchemaValidationException {
        Map sheetModelMap = this.convertSheetModelToMap(sheetModel);
        for (Map.Entry rowEntry : sheetModelMap.entrySet()) {
            int rowNum = (Integer)rowEntry.getKey() + labelsRowIndex + 1;
            XSSFRow row = xlsxSheet.getRow(rowNum);
            for (Map.Entry columnEntry : ((Map)rowEntry.getValue()).entrySet()) {
                XSSFCell cell;
                if (row == null) {
                    log.error("row is null, sheet " + xlsxSheet.getSheetName() + ", row " + rowNum);
                }
                if (columnEntry == null) {
                    log.error("columnEntry is null, sheet " + xlsxSheet.getSheetName() + ", row " + rowNum);
                } else if (columnEntry.getKey() == null) {
                    log.error("columnEntry.getKey() is null, sheet " + xlsxSheet.getSheetName() + ", row " + rowNum);
                }
                if ((cell = row.getCell(((Integer)columnEntry.getKey()).intValue())) != null && this.prepareValue((String)columnEntry.getValue()).equalsIgnoreCase(this.prepareValue(cell.getStringCellValue()))) continue;
                EventLog eventLog = new EventLog();
                eventLog.setEventLogType(EventLog.EventLogType.IMPORT_XLSX);
                eventLog.setAddress(cell == null ? String.format("(%s, %s)", rowNum, (Integer)columnEntry.getKey() + 1) : cell.getAddress().formatAsString());
                eventLog.setRole(xlsxSheet.getSheetName());
                eventLog.setMessage("\u041e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c: " + (String)columnEntry.getValue());
                eventLog.setXbrlReportId(this.xbrlPackage.getXbrlReport().getId());
                this.eventLogService.createInNewTransaction(eventLog);
                throw new SchemaValidationException();
            }
        }
    }

    private String prepareValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return value.trim().replaceAll("[\n\r]", "");
    }

    private Map<Integer, Map<Integer, String>> convertSheetModelToMap(SheetModel sheetModel) {
        HashMap<Integer, Map<Integer, String>> result = new HashMap<Integer, Map<Integer, String>>();
        List allColumns = this.getAllColumns(sheetModel.getTlbUiModel().getColumnList());
        allColumns.forEach(columnHeader -> {
            Integer rowIndex = columnHeader.getY();
            if (!result.containsKey(rowIndex)) {
                result.put(rowIndex, new HashMap());
            }
            ((Map)result.get(rowIndex)).put(columnHeader.getX(), columnHeader.getCaption());
        });
        return result;
    }

    private List<ColumnHeader> getAllColumns(List<ColumnHeader> columns) {
        LinkedList<ColumnHeader> columnList = new LinkedList<ColumnHeader>();
        if (CollectionUtils.isEmpty(columns)) {
            return columnList;
        }
        columnList.addAll(columns);
        for (ColumnHeader column : columns) {
            columnList.addAll(this.getAllColumns(column.getColumnList()));
        }
        return columnList;
    }

    private List<AspectCellData> parseRole(Long roleId, XSSFSheet xlsxSheet, SheetModel sheetModel, XbrlReportRole xbrlReportRole, Boolean isAlternativeFormat) throws SchemaValidationException {
        incorrectImportedAxisLines.clear();
        ArrayList<AspectCellData> roleAspectCellData = new ArrayList<AspectCellData>();
        try {
            TLBUiModel withAddedZ = this.searchZAxises(xbrlReportRole, xlsxSheet);
            if (withAddedZ != null) {
                sheetModel = new SheetModel(withAddedZ, false);
            }
            List periodLevels = sheetModel.getTlbUiModel().getPeriodLevelList();
            for (int periodIndex = 0; periodIndex < periodLevels.size(); ++periodIndex) {
                List periodAspectCellDataList;
                block8: {
                    PeriodLevel periodLevel = (PeriodLevel)periodLevels.get(periodIndex);
                    if (BooleanUtils.isFalse((Boolean)isAlternativeFormat)) {
                        try {
                            periodAspectCellDataList = this.parsePeriodLevelNewFormat(xlsxSheet, sheetModel, periodIndex, periodLevel, xbrlReportRole);
                            break block8;
                        }
                        catch (Exception e) {
                            log.error("Role does not support new format", (Throwable)e);
                            this.unsupportedRoles.add(xbrlReportRole.getSystemId());
                            break;
                        }
                    }
                    periodAspectCellDataList = this.parsePeriodLevel(xlsxSheet, sheetModel, periodIndex, periodLevels, xbrlReportRole);
                }
                roleAspectCellData.addAll(periodAspectCellDataList);
            }
        }
        catch (SchemaValidationException sve) {
            throw sve;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return roleAspectCellData;
    }

    private TLBUiModel searchZAxises(XbrlReportRole xbrlReportRole, XSSFSheet xlsxSheet) throws IOException {
        TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue((Reader)new StringReader(xbrlReportRole.getStaticStructureJson()), TableLinkBaseStructure.class);
        HashSet typedDims = new HashSet();
        HashSet explicitMemValues = new HashSet();
        tableLinkBaseStructure.getZAxis().getAxisMemberHierarchyList().forEach(axisMemberHierarchy -> axisMemberHierarchy.getAspectDataList().forEach(aspectData -> {
            if (aspectData.getType().equals((Object)AspectType.DIMENSION)) {
                if (aspectData.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                    typedDims.add(aspectData.getLabel());
                } else {
                    List members = this.xbrlDimensionService.findMembers(xbrlReportRole.getSystemId(), aspectData.getAspect());
                    members.forEach(xbrlDimension -> explicitMemValues.add(xbrlDimension.getMemIntLabel()));
                }
            }
        }));
        if (typedDims.size() > 0) {
            XSSFRow labelsRow = xlsxSheet.getRow(4);
            HashMap zAxises = new HashMap();
            Iterator cellIterator = labelsRow.iterator();
            while (cellIterator.hasNext()) {
                String cellValue = ((Cell)cellIterator.next()).getStringCellValue();
                if (!cellValue.contains("Z= ")) continue;
                if (cellValue.contains("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b")) {
                    throw new IOException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b");
                }
                if (cellValue.contains("EMPTY_AXIS") || cellValue.contains("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b")) break;
                typedDims.forEach(typedDim -> {
                    if (cellValue.contains((CharSequence)typedDim)) {
                        String temporary;
                        String typedValue = temporary = cellValue.substring(cellValue.indexOf((String)typedDim) + typedDim.length() + 1);
                        ArrayList availTypedDims = new ArrayList(typedDims);
                        availTypedDims.remove(typedDim);
                        int endValue = availTypedDims.stream().mapToInt(secondTypedDim -> temporary.indexOf((String)secondTypedDim)).filter(pos -> pos > 0).min().orElse(-1);
                        if (endValue <= 0) {
                            endValue = explicitMemValues.stream().mapToInt(explicitMemValue -> temporary.indexOf((String)explicitMemValue)).filter(pos -> pos > 0).min().orElse(-1);
                        }
                        if (endValue > 0) {
                            typedValue = typedValue.substring(0, endValue - 2);
                        }
                        if (zAxises.containsKey(typedDim)) {
                            ((Set)zAxises.get(typedDim)).add(typedValue);
                        } else {
                            zAxises.put(typedDim, new HashSet());
                            ((Set)zAxises.get(typedDim)).add(typedValue);
                        }
                    }
                });
            }
            for (String zAxisLabel : zAxises.keySet()) {
                Optional<FilterOpenAxis> zAxis = xbrlReportRole.getXbrlRoleDimensionList().stream().map(XbrlRoleDimension::getFilterOpenAxis).filter(filterOpenAxis -> filterOpenAxis.getTitle().equals(zAxisLabel)).findFirst();
                if (!zAxis.isPresent()) continue;
                Long axisId = zAxis.get().getId();
                ((Set)zAxises.get(zAxisLabel)).forEach(axisValue -> {
                    if (((FilterOpenAxis)zAxis.get()).getAxisMemberList().stream().noneMatch(filterOpenAxisValue -> filterOpenAxisValue.getValue().equals(axisValue))) {
                        FilterOpenAxisValue filterOpenAxisValue2 = new FilterOpenAxisValue();
                        filterOpenAxisValue2.setActive(Boolean.valueOf(true));
                        filterOpenAxisValue2.setValue(axisValue);
                        filterOpenAxisValue2.setFilterOpenAxis((FilterOpenAxis)zAxis.get());
                        this.xbrlReportService.addRoleFilterMember(axisId, filterOpenAxisValue2);
                        ((FilterOpenAxis)zAxis.get()).getAxisMemberList().add(filterOpenAxisValue2);
                    }
                });
            }
            return (TLBUiModel)this.getTlbUiModelFunction.apply(xbrlReportRole);
        }
        return null;
    }

    private List<AspectCellData> parsePeriodLevel(XSSFSheet xlsxSheet, SheetModel sheetModel, int periodIndex, List<PeriodLevel> periodLevels, XbrlReportRole xbrlReportRole) throws SchemaValidationException {
        ArrayList<AspectCellData> editedCells = new ArrayList<AspectCellData>();
        int periodBias = sheetModel.getPeriodBias(periodIndex);
        PeriodLevel periodLevel = periodLevels.get(periodIndex);
        this.validateSchema(xlsxSheet, sheetModel, periodBias);
        XSSFRow labelsRow = xlsxSheet.getRow(periodBias);
        if (labelsRow == null) {
            log.error("Labels xlsx row is null, sheet " + xlsxSheet.getSheetName() + ", row " + periodBias);
            return editedCells;
        }
        List zLevelList = periodLevel.getZLevelList();
        ColumnHeader[] columnLeaves = sheetModel.getTopHeaderModel().getLeaves();
        List mergedRegions = xlsxSheet.getMergedRegions();
        block0: for (int z = 0; z < zLevelList.size(); ++z) {
            int startAxisesIndex;
            int zLabelCol;
            XSSFCell zLabelCell;
            ZLevel zLevel = (ZLevel)zLevelList.get(z);
            List yLevelsUnwinded = sheetModel.getLeftHeaderModel().prepareLeftHeader(zLevel);
            Map yLevelsUnwindedMap = new HashMap();
            boolean isHierarchy = yLevelsUnwinded.stream().anyMatch(y -> !y.getYLevelList().isEmpty());
            if (isHierarchy) {
                yLevelsUnwindedMap = sheetModel.getLeftHeaderModel().getHashMapYLevels(zLevel);
            }
            YLevel.collectFullAspectListForEachYLevel((List)zLevel.getYLevelList(), null);
            int zTableOffset = z * (sheetModel.getTableWidth() + 1);
            XSSFCell periodLabelCell = labelsRow.getCell(zTableOffset);
            if (periodLabelCell == null) {
                log.info("periodLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{periodIndex, xlsxSheet.getSheetName(), zTableOffset, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)periodLabelCell);
            String periodVal = periodLabelCell.getStringCellValue();
            if (!periodVal.endsWith(periodLevel.getLabel())) {
                Optional<PeriodLevel> actualPeriodLevel = periodLevels.stream().filter(p -> periodVal.endsWith(p.getLabel())).findFirst();
                if (actualPeriodLevel.isPresent()) {
                    periodLevel = actualPeriodLevel.get();
                } else {
                    log.info("periodLabelCell value {} does not exist in active periods, sheet {}, col {}: row {}", new Object[]{periodVal, xlsxSheet.getSheetName(), zTableOffset, periodBias});
                    continue;
                }
            }
            if ((zLabelCell = labelsRow.getCell(zLabelCol = zTableOffset + sheetModel.getTableWidth() - 1)) == null) {
                log.info("zLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{z, xlsxSheet.getSheetName(), zLabelCol, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)zLabelCell);
            Map finalYLevelsUnwindedMap = yLevelsUnwindedMap;
            DimensionValuePair[][] dimensions = isHierarchy ? new DimensionValuePair[xlsxSheet.getLastRowNum() + 1][15] : (DimensionValuePair[][])null;
            HashMap<String, Integer> sameAxisCountMap = new HashMap<String, Integer>();
            int endAxisesIndex = startAxisesIndex + sheetModel.getLeftHeaderModel().getLeftHeaderHeight() - 1;
            for (startAxisesIndex = periodBias + sheetModel.getTopHeaderHeight() + 1; startAxisesIndex <= endAxisesIndex; ++startAxisesIndex) {
                int excelRowNum = startAxisesIndex;
                XSSFRow xlsRow = xlsxSheet.getRow(excelRowNum);
                if (isHierarchy && xlsRow == null) continue block0;
                YLevel yLevel = null;
                if (!isHierarchy) {
                    String axisTitle = xlsxSheet.getRow(excelRowNum).getCell(0).getStringCellValue().trim();
                    if (axisTitle.equals("empty row header")) {
                        axisTitle = "";
                    }
                    if (sameAxisCountMap.containsKey(axisTitle)) {
                        sameAxisCountMap.replace(axisTitle, (Integer)sameAxisCountMap.get(axisTitle) + 1);
                    } else {
                        sameAxisCountMap.put(axisTitle, 0);
                    }
                    String bufferTitle = axisTitle;
                    List sameTitleAxises = yLevelsUnwinded.stream().filter(yLevelUnwinded -> yLevelUnwinded.getTitle().trim().equals(bufferTitle)).collect(Collectors.toList());
                    if (sameTitleAxises.size() > 0) {
                        yLevel = (YLevel)sameTitleAxises.get((Integer)sameAxisCountMap.get(axisTitle));
                    }
                } else {
                    DimensionValuePair[] dimension;
                    String collect;
                    String axisHash;
                    XSSFCell yLevelCell = xlsRow.getCell(0);
                    if (yLevelCell != null) {
                        DimensionValuePair dimensionValuePair = DimensionValuePair.of(null, null, (String)yLevelCell.getStringCellValue(), null, (int)0);
                        int level = this.getLevel(dimensionValuePair);
                        dimensions[excelRowNum][level] = dimensionValuePair;
                        if (excelRowNum != 0) {
                            System.arraycopy(dimensions[excelRowNum - 1], 0, dimensions[excelRowNum], 0, level);
                        }
                    }
                    if (sameAxisCountMap.containsKey(axisHash = DigestUtils.md5Hex((String)(collect = Arrays.stream(dimension = dimensions[excelRowNum]).filter(Objects::nonNull).map(DimensionValuePair::getValue).map(String::trim).collect(Collectors.joining()).replace("empty row header", ""))))) {
                        sameAxisCountMap.replace(axisHash, (Integer)sameAxisCountMap.get(axisHash) + 1);
                    } else {
                        sameAxisCountMap.put(axisHash, 0);
                    }
                    yLevel = (YLevel)finalYLevelsUnwindedMap.get(axisHash + "_" + sameAxisCountMap.get(axisHash));
                }
                if (yLevel == null) {
                    log.error("YLevel for xls row not found, row index: {}", (Object)excelRowNum);
                    continue;
                }
                if (xlsRow == null) continue;
                int LEFT_HEADER_WIDTH = sheetModel.isYRcCodePresent() ? 2 : 1;
                YLevel finalYLevel = yLevel;
                PeriodLevel finalPeriodLevel = periodLevel;
                IntStream.range(LEFT_HEADER_WIDTH, columnLeaves.length).forEach(xIndex -> {
                    int excelColNum = zTableOffset + xIndex;
                    ColumnHeader columnHeader = columnLeaves[xIndex];
                    AspectCellData aspectCellData = new AspectCellData();
                    aspectCellData.setAspectDataList(new ArrayList());
                    aspectCellData.getAspectDataList().addAll(finalPeriodLevel.getAspectDataList());
                    aspectCellData.getAspectDataList().addAll(zLevel.getAspectDataList());
                    aspectCellData.getAspectDataList().addAll(finalYLevel.getFullAspectDataList());
                    aspectCellData.getAspectDataList().addAll(columnHeader.getFullAspectDataList());
                    XSSFCell cell = xlsRow.getCell(excelColNum);
                    aspectCellData.setMerged(mergedRegions.stream().anyMatch(arg_0 -> this.lambda$null$30((Cell)cell, arg_0)));
                    this.setCellTypeToString((Cell)cell);
                    String cellValue = cell != null ? cell.getStringCellValue() : null;
                    AspectData concept = aspectCellData.getConcept();
                    if (StringUtils.isNotBlank((CharSequence)cellValue) && concept != null && sheetModel.getEnumerations().containsKey(concept.getAspectValue())) {
                        Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByLabel((Map)sheetModel.getEnumerations(), (String)cellValue, (String)concept.getAspectValue());
                        if (!enumerateItemOptional.isPresent()) {
                            log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{sheetModel.getTlbUiModel().getLabel(), concept.getLabel(), cellValue});
                        }
                        String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getMember() : cellValue;
                        aspectCellData.setCellValue(enumValue);
                    } else {
                        aspectCellData.setCellValue(cellValue);
                    }
                    CellReference cellReference = new CellReference(excelRowNum, excelColNum, false, false);
                    aspectCellData.setAddress(cellReference.formatAsString());
                    if (StringUtils.isNotBlank((CharSequence)aspectCellData.getCellValue())) {
                        List aspectCellDataListNoBD = aspectCellData.getAspectDataList().stream().filter(d -> !"(bound dynamically)".equals(d.getAspectValue())).collect(Collectors.toList());
                        aspectCellData.setAspectDataList(aspectCellDataListNoBD);
                        editedCells.add(aspectCellData);
                    }
                });
            }
        }
        return editedCells;
    }

    private List<AspectCellData> parsePeriodLevelNewFormat(XSSFSheet xlsxSheet, SheetModel sheetModel, int periodIndex, PeriodLevel periodLevel, XbrlReportRole xbrlReportRole) throws SchemaValidationException {
        ArrayList<AspectCellData> editedCells = new ArrayList<AspectCellData>();
        int periodBias = sheetModel.getPeriodBiasNewFormat(periodIndex, this.currentTableHeight);
        XSSFRow labelsRow = xlsxSheet.getRow(periodBias);
        if (labelsRow == null) {
            log.error("Labels xlsx row is null, sheet " + xlsxSheet.getSheetName() + ", row " + periodBias);
            return editedCells;
        }
        List zLevelList = periodLevel.getZLevelList();
        ColumnHeader[] columnLeaves = sheetModel.getTopHeaderModel().getLeaves();
        List mergedRegions = xlsxSheet.getMergedRegions();
        for (int z = 0; z < zLevelList.size(); ++z) {
            int zTableOffset;
            XSSFCell periodLabelCell;
            ZLevel zLevel = (ZLevel)zLevelList.get(z);
            List yLevelsUnwinded = sheetModel.getLeftHeaderModel().prepareLeftHeader(zLevel).stream().filter(y -> y.getChildAspectNodes() == null).collect(Collectors.toList());
            YLevel.collectFullAspectListForEachYLevel((List)zLevel.getYLevelList(), null);
            int leftHeaderWidth = 1;
            if (!xbrlReportRole.getXbrlRoleDimensionList().isEmpty()) {
                leftHeaderWidth = xbrlReportRole.getXbrlRoleDimensionList().size();
            }
            if ((periodLabelCell = labelsRow.getCell(zTableOffset = z * (sheetModel.getTableWidth() + 1 + (leftHeaderWidth == 1 ? 0 : leftHeaderWidth - 1)))) == null) {
                log.info("periodLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{periodIndex, xlsxSheet.getSheetName(), zTableOffset, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)periodLabelCell);
            int zLabelCol = zTableOffset + sheetModel.getTableWidth() - 1;
            XSSFCell zLabelCell = labelsRow.getCell(zLabelCol);
            if (zLabelCell == null) {
                log.info("zLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{z, xlsxSheet.getSheetName(), zLabelCol, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)zLabelCell);
            int FINAL_LEFT_HEADER_WIDTH = leftHeaderWidth;
            IntStream.range(0, yLevelsUnwinded.size()).forEach(yIndex -> {
                YLevel yLevel = (YLevel)yLevelsUnwinded.get(yIndex);
                int excelRowNum = periodBias + yIndex + 1 + sheetModel.getTopHeaderHeight() + 1;
                XSSFRow xlsRow = xlsxSheet.getRow(excelRowNum);
                if (xlsRow != null) {
                    IntStream.range(FINAL_LEFT_HEADER_WIDTH, FINAL_LEFT_HEADER_WIDTH == 1 ? columnLeaves.length : columnLeaves.length + FINAL_LEFT_HEADER_WIDTH - 1).forEach(xIndex -> {
                        int excelColNum = zTableOffset + xIndex;
                        int columnIndex = FINAL_LEFT_HEADER_WIDTH == 1 ? xIndex : xIndex - FINAL_LEFT_HEADER_WIDTH + 1;
                        ColumnHeader columnHeader = columnLeaves[columnIndex];
                        AspectCellData aspectCellData = new AspectCellData();
                        aspectCellData.setAspectDataList(new ArrayList());
                        aspectCellData.getAspectDataList().addAll(periodLevel.getAspectDataList());
                        aspectCellData.getAspectDataList().addAll(zLevel.getAspectDataList());
                        aspectCellData.getAspectDataList().addAll(yLevel.getFullAspectDataList());
                        aspectCellData.getAspectDataList().addAll(columnHeader.getFullAspectDataList());
                        XSSFCell cell = xlsRow.getCell(excelColNum);
                        aspectCellData.setMerged(mergedRegions.stream().anyMatch(arg_0 -> this.lambda$null$34((Cell)cell, arg_0)));
                        this.setCellTypeToString((Cell)cell);
                        String cellValue = cell != null ? cell.getStringCellValue() : null;
                        AspectData concept = aspectCellData.getConcept();
                        if (StringUtils.isNotBlank((CharSequence)cellValue) && concept != null && sheetModel.getEnumerations().containsKey(concept.getAspectValue())) {
                            Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByLabel((Map)sheetModel.getEnumerations(), (String)cellValue, (String)concept.getAspectValue());
                            if (!enumerateItemOptional.isPresent()) {
                                log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{sheetModel.getTlbUiModel().getLabel(), concept.getLabel(), cellValue});
                            }
                            String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getMember() : cellValue;
                            aspectCellData.setCellValue(enumValue);
                        } else {
                            aspectCellData.setCellValue(cellValue);
                        }
                        CellReference cellReference = new CellReference(excelRowNum, excelColNum, false, false);
                        aspectCellData.setAddress(cellReference.formatAsString());
                        if (StringUtils.isNotBlank((CharSequence)aspectCellData.getCellValue())) {
                            List aspectCellDataListNoBD = aspectCellData.getAspectDataList().stream().filter(d -> !"(bound dynamically)".equals(d.getAspectValue())).collect(Collectors.toList());
                            aspectCellData.setAspectDataList(aspectCellDataListNoBD);
                            editedCells.add(aspectCellData);
                        }
                    });
                }
            });
        }
        return editedCells;
    }

    private int getLevel(DimensionValuePair dimensionValuePair) {
        String value = dimensionValuePair.getValue();
        return (value.length() - value.trim().length()) / 6;
    }

    private void setCellTypeToString(Cell cell) {
        if (cell == null) {
            return;
        }
        cell = XlsxParser.getStringCellValue((Cell)cell);
    }

    public static Cell getStringCellValue(Cell cell) {
        if (cell.getCellTypeEnum().equals((Object)CellType.NUMERIC)) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                cell.setCellValue(df.format(cell.getDateCellValue()));
            } else if (String.valueOf(cell.getNumericCellValue()).contains("E")) {
                cell.setCellValue(new BigDecimal(String.valueOf(cell.getNumericCellValue())).toPlainString());
            } else {
                cell.setCellValue(String.valueOf(cell.getNumericCellValue()).replaceAll("0*$", "").replaceAll("\\.$", ""));
            }
        }
        cell.setCellType(CellType.STRING);
        return cell;
    }

    public void parseAspectAsColumns() throws IOException, NotFoundException {
        log.info("Parse XLSX workbook: " + this.xlsxFileName);
        try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(this.xlsxFileName));){
            List xbrlReportRoles = this.xbrlPackage.getXbrlReport().getXbrlReportRoles();
            Map<String, XbrlReportRole> rolesMap = xbrlReportRoles.stream().collect(Collectors.toMap(XbrlReportRole::getSystemId, r -> r));
            int currentStage = 0;
            Iterator sheetIterator = workbook.sheetIterator();
            this.xlsAspectColumnService.clearDimensionMemberCache();
            while (sheetIterator.hasNext()) {
                XSSFSheet xlsxSheet = (XSSFSheet)sheetIterator.next();
                String roleSystemId = this.getSheetRoleSystemId((Sheet)xlsxSheet);
                if (roleSystemId == null || !rolesMap.containsKey(roleSystemId)) continue;
                XbrlReportRole xbrlReportRole = rolesMap.get(roleSystemId);
                importedRoleTitle = xbrlReportRole.getTitle();
                try {
                    TLBUiModel tlbUiModel = Optional.ofNullable(this.searchZAxises(xbrlReportRole, xlsxSheet)).orElse((TLBUiModel)this.getTlbUiModelFunction.apply(xbrlReportRole));
                    List roleAspectCellDataList = null;
                    try {
                        roleAspectCellDataList = this.xlsAspectColumnService.parseAspectAsColumnsRole(xbrlReportRole, tlbUiModel, xlsxSheet);
                    }
                    catch (IncorrectXAxisException e) {
                        log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0435 \u0440\u043e\u043b\u0438 \u043f\u043e X: " + xbrlReportRole.getTitle());
                    }
                    if (roleAspectCellDataList != null) {
                        roleAspectCellDataList.forEach(aspectCellData -> {
                            aspectCellData.setRoleLabel(xlsxSheet.getSheetName());
                            aspectCellData.setRoleId(xbrlReportRole.getId());
                        });
                    }
                    NotificationEvent notificationEvent = new NotificationEvent();
                    notificationEvent.setTitle(xbrlReportRole.getTitle());
                    notificationEvent.setCurrentStage(Integer.valueOf(++currentStage));
                    notificationEvent.setTotalNumberOfStages(Integer.valueOf(xbrlReportRoles.size()));
                    Float progress = Float.valueOf((float)currentStage / (float)xbrlReportRoles.size());
                    notificationEvent.setProgress(progress);
                    this.aspectCelldataListConsumer.accept(roleAspectCellDataList, notificationEvent);
                }
                catch (UnsupportedAlternativeExportRoleException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private /* synthetic */ boolean lambda$null$34(Cell cell, CellRangeAddress region) {
        return this.isRegionContainsCell(region, cell);
    }

    private /* synthetic */ boolean lambda$null$30(Cell cell, CellRangeAddress region) {
        return this.isRegionContainsCell(region, cell);
    }
}

