/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.util.Pair;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.PresetColor;
import org.apache.poi.xddf.usermodel.XDDFColor;
import org.apache.poi.xddf.usermodel.XDDFFillProperties;
import org.apache.poi.xddf.usermodel.XDDFLineProperties;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.DisplayBlanks;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.MarkerStyle;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.PerformanceMetricValue;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.MetricType;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.PerformanceMetricsParser;

public class XlsxPerformanceLogWriter {
    private static final Logger log = LoggerFactory.getLogger(XlsxPerformanceLogWriter.class);
    private DataFormatter dataFormatter = new DataFormatter();
    private XSSFWorkbook workbook = new XSSFWorkbook();
    private String validationLog;
    private Map<String, List<PerformanceMetricValue>> metricValuesByReportName = new LinkedHashMap();
    private String destinationPath;
    private static CellStyle CELL_STYLE_DISABLED;
    private static CellStyle CELL_STYLE_BORDERED;
    private static final String TIMING_RANGE_NAME = "timings";
    private static final String METRICS_SHEET_NAME = "metricsDataSheet";
    private static final int VERTICAL_CHART_INDENT = 2;
    private static final int HORIZONTAL_CHART_INDENT = 1;
    private static final int CHART_WIDTH = 8;
    private static final int CHART_HEIGHT = 12;
    private int chartSheetStartColumn;
    private int metricSheetStartRow;
    private int metricSheetStartColumn;
    private static final NumberFormat numberFormat;
    private static final Set<MetricType> DRAWABLE_METRICS;
    private static final PresetColor[] COLORS;

    public XlsxPerformanceLogWriter(String validationLog, String metricsLog, String destinationPath) throws IOException, XMLStreamException {
        this.validationLog = validationLog;
        new PerformanceMetricsParser().parseXml((InputStream)new FileInputStream(metricsLog)).forEach(performanceMetricValue -> this.metricValuesByReportName.computeIfAbsent(performanceMetricValue.getReportName(), s -> new ArrayList()).add(performanceMetricValue));
        this.destinationPath = destinationPath;
        this.export();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() throws IOException {
        String baseFilename = "Log_Performance_" + LocalDate.now().toString();
        FileOutputStream out = new FileOutputStream(this.destinationPath + File.separator + baseFilename + ".xlsx");
        try (FileInputStream fileInputStream = new FileInputStream(this.validationLog);){
            ArrayList reportNames = new ArrayList(this.metricValuesByReportName.keySet());
            XSSFWorkbook validateWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
            int timeSheetIndex = validateWorkbook.getSheetIndex("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
            Map<String, List> arelleData = StreamSupport.stream(validateWorkbook.getSheetAt(timeSheetIndex).spliterator(), false).skip(1L).collect(Collectors.toMap(row -> this.dataFormatter.formatCellValue(row.getCell(0)), row -> {
                ArrayList<String> data = new ArrayList<String>();
                data.add(this.dataFormatter.formatCellValue(row.getCell(1)));
                data.add(this.dataFormatter.formatCellValue(row.getCell(3)));
                data.add(this.dataFormatter.formatCellValue(row.getCell(4)));
                data.add(this.dataFormatter.formatCellValue(row.getCell(5)));
                return data;
            }));
            Map entrypointUsage = this.getEntryPointsUsage(arelleData);
            this.writeTimingList(reportNames, arelleData);
            validateWorkbook.removeSheetAt(timeSheetIndex);
            XSSFSheet metricsDataSheet = this.workbook.createSheet(METRICS_SHEET_NAME);
            this.workbook.setSheetHidden(this.workbook.getSheetIndex((Sheet)metricsDataSheet), true);
            for (int i = 0; i < this.metricValuesByReportName.keySet().size(); ++i) {
                String reportName = (String)reportNames.get(i);
                if (!arelleData.containsKey(reportName)) continue;
                XSSFSheet chartSheet = this.workbook.createSheet(this.getMetricSheetName(reportName, entrypointUsage, arelleData));
                MetricType[] metricTypesForReportArr = (MetricType[])((List)this.metricValuesByReportName.get(reportName)).stream().map(PerformanceMetricValue::getMetricType).filter(DRAWABLE_METRICS::contains).distinct().sorted(Comparator.comparing(Enum::ordinal)).toArray(MetricType[]::new);
                this.metricSheetStartRow = 0;
                this.metricSheetStartColumn = i * (COLORS.length + 2) + i;
                for (int j = 0; j < metricTypesForReportArr.length; ++j) {
                    MetricType currentTest = metricTypesForReportArr[j];
                    List testMetrics = ((List)this.metricValuesByReportName.get(reportName)).stream().filter(performanceMetricValue -> performanceMetricValue.getMetricType().equals((Object)currentTest) || performanceMetricValue.getMetricType().toString().contains("TIME")).collect(Collectors.toList());
                    this.chartSheetStartColumn = j * 9 + 1;
                    LinkedHashMap chartData = this.writeMetrics(testMetrics, chartSheet, metricsDataSheet);
                    XDDFCategoryDataSource xData = XDDFDataSourcesFactory.fromArray((String[])new String[0], (String)((CellRangeAddress)chartData.remove(TIMING_RANGE_NAME)).formatAsString(METRICS_SHEET_NAME, true));
                    String chartTitle = "";
                    if (currentTest.equals((Object)MetricType.CPU)) {
                        chartTitle = "CPU, %";
                    } else if (currentTest.equals((Object)MetricType.RAM)) {
                        chartTitle = "RAM, Mb";
                    } else if (currentTest.equals((Object)MetricType.HDD_READ)) {
                        chartTitle = "HDD Read, Mb";
                    } else if (currentTest.equals((Object)MetricType.HDD_WRITE)) {
                        chartTitle = "HDD Write, Mb";
                    }
                    this.drawChart(chartSheet, chartTitle, (XDDFDataSource)xData, chartData, this.chartSheetStartColumn, this.chartSheetStartColumn + 8);
                }
            }
        }
        finally {
            this.workbook.write((OutputStream)out);
            out.close();
        }
    }

    private Map<String, Pair<Integer, Integer>> getEntryPointsUsage(Map<String, List<String>> arelleData) {
        HashMap<String, Pair<Integer, Integer>> entryPointsUsageMap = new HashMap<String, Pair<Integer, Integer>>();
        List<String> list = arelleData.values().stream().map(x -> (String)x.get(0)).collect(Collectors.toList());
        list.forEach(x -> {
            if (entryPointsUsageMap.containsKey(x)) {
                Pair pair = (Pair)entryPointsUsageMap.get(x);
                entryPointsUsageMap.put((String)x, (Pair<Integer, Integer>)new Pair(pair.getKey(), (Object)((Integer)pair.getValue() + 1)));
            } else {
                entryPointsUsageMap.put((String)x, (Pair<Integer, Integer>)new Pair((Object)0, (Object)1));
            }
        });
        return entryPointsUsageMap;
    }

    private String getMetricSheetName(String reportName, Map<String, Pair<Integer, Integer>> entrypointUsage, Map<String, List<String>> arelleData) {
        String result;
        String entryPoint = arelleData.get(reportName).get(0);
        Pair<Integer, Integer> pair = entrypointUsage.get(entryPoint);
        Integer used = (Integer)pair.getKey();
        Integer left = (Integer)pair.getValue();
        used = used + 1;
        left = left - 1;
        entrypointUsage.put(entryPoint, (Pair<Integer, Integer>)new Pair((Object)used, (Object)left));
        if (used + left == 1) {
            result = entryPoint.length() > 31 ? entryPoint.substring(31) : entryPoint;
        } else {
            result = entryPoint.length() > 28 ? entryPoint.substring(28) : entryPoint;
            result = result + "_" + used;
        }
        return result;
    }

    private void writeTimingList(List<String> reportNames, Map<String, List<String>> arelleData) {
        XSSFSheet sheet = this.workbook.createSheet("\u0421\u0432\u043e\u0434\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        this.createDisabledStyle(sheet);
        this.createDefaultStyle(sheet);
        this.drawTimingListHeader(sheet);
        this.drawTimingListBody(reportNames, arelleData, sheet);
        this.drawTimingListFooter(sheet);
        this.autoSizeSheetColumns(sheet, 0, 9);
    }

    private void createDisabledStyle(XSSFSheet sheet) {
        XSSFCellStyle style = sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        CELL_STYLE_DISABLED = style;
    }

    private void createDefaultStyle(XSSFSheet sheet) {
        XSSFCellStyle style = sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        CELL_STYLE_BORDERED = style;
    }

    private LinkedHashMap<String, CellRangeAddress> writeMetrics(List<PerformanceMetricValue> testMetrics, XSSFSheet chartSheet, XSSFSheet metricsDataSheet) {
        int clearMetricsCount = (int)testMetrics.stream().filter(testMetric -> !testMetric.getMetricType().toString().contains("TIME")).count();
        int chartSheetRow = 16;
        int chartSheetMomentColumn = this.chartSheetStartColumn;
        int metricSheetRow = this.metricSheetStartRow;
        int metricSheetMomentColumn = this.metricSheetStartColumn;
        int metricSheetValueColumn = this.metricSheetStartColumn + 1;
        LinkedHashMap<String, CellRangeAddress> result = new LinkedHashMap<String, CellRangeAddress>();
        result.put(TIMING_RANGE_NAME, new CellRangeAddress(this.metricSheetStartRow, this.metricSheetStartRow + clearMetricsCount, this.metricSheetStartColumn, this.metricSheetStartColumn));
        for (PerformanceMetricValue metricValue : testMetrics) {
            Cell chartCell;
            XSSFRow chartRow;
            if (metricValue.getMetricType().toString().contains("TIME")) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(this.metricSheetStartRow, this.metricSheetStartRow + clearMetricsCount, metricSheetValueColumn, metricSheetValueColumn);
                String testTitle = "";
                if (metricValue.getMetricType().equals((Object)MetricType.TIME_CREATE)) {
                    testTitle = "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430";
                } else if (metricValue.getMetricType().equals((Object)MetricType.TIME_UPLOAD)) {
                    testTitle = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430";
                } else if (metricValue.getMetricType().equals((Object)MetricType.TIME_VALIDATION)) {
                    testTitle = "\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430";
                }
                result.put(testTitle, cellRangeAddress);
                chartSheetRow = 14;
                chartRow = chartSheet.getRow(chartSheetRow + 1) == null ? chartSheet.createRow(chartSheetRow + 1) : chartSheet.getRow(chartSheetRow + 1);
                chartCell = chartRow.createCell(chartSheetMomentColumn);
                chartCell.setCellValue("\u0412\u0440\u0435\u043c\u044f");
                chartCell.setCellStyle(CELL_STYLE_DISABLED);
                chartCell = chartRow.createCell(chartSheetMomentColumn + 1);
                chartCell.setCellValue(testTitle);
                chartCell.setCellStyle(CELL_STYLE_DISABLED);
                chartSheetMomentColumn += 3;
                chartSheetRow += 2;
                XSSFRow metricsRow = metricsDataSheet.getRow(metricSheetRow - 1);
                double assigner = metricsRow.getCell(metricSheetValueColumn).getNumericCellValue();
                metricsRow.createCell(++metricSheetValueColumn).setCellValue(assigner);
                continue;
            }
            chartRow = chartSheet.getRow(chartSheetRow) == null ? chartSheet.createRow(chartSheetRow) : chartSheet.getRow(chartSheetRow);
            chartCell = chartRow.createCell(chartSheetMomentColumn);
            chartCell.setCellValue(metricValue.getMoment().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
            chartCell.setCellStyle(CELL_STYLE_BORDERED);
            chartCell = chartRow.createCell(chartSheetMomentColumn + 1);
            chartCell.setCellValue(metricValue.getValue());
            chartCell.setCellStyle(CELL_STYLE_BORDERED);
            ++chartSheetRow;
            XSSFRow metricRow = metricsDataSheet.getRow(metricSheetRow) == null ? metricsDataSheet.createRow(metricSheetRow) : metricsDataSheet.getRow(metricSheetRow);
            metricRow.createCell(metricSheetMomentColumn).setCellValue(metricValue.getMoment().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
            metricRow.createCell(metricSheetValueColumn).setCellValue(metricValue.getValue());
            ++metricSheetRow;
        }
        this.metricSheetStartRow = metricSheetRow + 2;
        return result;
    }

    private void drawTimingListFooter(XSSFSheet sheet) {
        int footerRowNum = sheet.getLastRowNum() + 1;
        XSSFRow titleRow = sheet.createRow(footerRowNum);
        titleRow.createCell(0, CellType.STRING).setCellValue("\u0418\u0442\u043e\u0433\u043e");
        titleRow.createCell(1, CellType.STRING).setCellValue("");
        titleRow.createCell(2, CellType.STRING).setCellValue("");
        titleRow.createCell(3, CellType.STRING).setCellValue(this.countColumnSum(sheet, 3));
        titleRow.createCell(4, CellType.STRING).setCellValue(this.countColumnSum(sheet, 4));
        titleRow.createCell(5, CellType.STRING).setCellValue(this.countColumnSum(sheet, 5));
        titleRow.createCell(6, CellType.STRING).setCellValue(this.countColumnSum(sheet, 6));
        titleRow.createCell(7, CellType.STRING).setCellValue(this.countColumnSum(sheet, 7));
        sheet.addMergedRegion(new CellRangeAddress(footerRowNum, footerRowNum, 0, 1));
        this.setCellsStyle((Row)titleRow, CELL_STYLE_BORDERED);
    }

    private String countColumnSum(XSSFSheet sheet, int column) {
        double result = 0.0;
        try {
            for (int i = 1; i < sheet.getLastRowNum(); ++i) {
                if (!Optional.ofNullable(sheet.getRow(i).getCell(column)).isPresent()) continue;
                result += numberFormat.parse(this.dataFormatter.formatCellValue((Cell)sheet.getRow(i).getCell(column))).doubleValue();
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return numberFormat.format(result);
    }

    private void drawTimingListHeader(XSSFSheet sheet) {
        XSSFRow titleRow = sheet.createRow(0);
        titleRow.createCell(0, CellType.STRING).setCellValue("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430");
        titleRow.createCell(1, CellType.STRING).setCellValue("\u0422\u043e\u0447\u043a\u0430 \u0432\u0445\u043e\u0434\u0430");
        titleRow.createCell(2, CellType.STRING).setCellValue("\u0412\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
        titleRow.createCell(3, CellType.STRING).setCellValue("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043e\u0442\u0447\u0435\u0442\u0430, c");
        titleRow.createCell(4, CellType.STRING).setCellValue("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0430\u043a\u0435\u0442\u0430 \u043e\u0442\u0447\u0435\u0442\u0430, c");
        titleRow.createCell(5, CellType.STRING).setCellValue("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430, c");
        titleRow.createCell(6, CellType.STRING).setCellValue("(\u0432\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0438 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438, c)");
        titleRow.createCell(7, CellType.STRING).setCellValue("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c - \u0418\u0442\u043e\u0433\u043e");
        titleRow.createCell(8, CellType.STRING).setCellValue("\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
        this.setCellsStyle((Row)titleRow, CELL_STYLE_DISABLED);
    }

    private void drawTimingListBody(List<String> reportNames, Map<String, List<String>> arelleData, XSSFSheet sheet) {
        for (int i = 0; i < reportNames.size(); ++i) {
            String reportName = reportNames.get(i);
            XSSFRow row = sheet.createRow(i + 1);
            row.createCell(0, CellType.STRING).setCellValue(reportName);
            Map<MetricType, PerformanceMetricValue> reportTimeTests = ((List)this.metricValuesByReportName.get(reportName)).stream().filter(performanceMetricValue -> performanceMetricValue.getMetricType().toString().contains("TIME")).collect(Collectors.toMap(PerformanceMetricValue::getMetricType, performanceMetricValue -> performanceMetricValue));
            Optional<List<String>> reportDataOptional = Optional.ofNullable(arelleData.get(reportName));
            if (!reportDataOptional.isPresent()) {
                row.createCell(1, CellType.STRING).setCellValue("INFO DOESN'T EXIST");
                continue;
            }
            List<String> reportData = reportDataOptional.get();
            row.createCell(1, CellType.STRING).setCellValue(reportData.get(0));
            PerformanceMetricValue timeCreate = reportTimeTests.get(MetricType.TIME_CREATE);
            double netTime = timeCreate.getValue();
            row.createCell(2, CellType.STRING).setCellValue(timeCreate.getMoment().minusSeconds((long)timeCreate.getValue()).withNano(0).toString());
            row.createCell(3, CellType.STRING).setCellValue(numberFormat.format(timeCreate.getValue()));
            PerformanceMetricValue timeUpload = reportTimeTests.get(MetricType.TIME_UPLOAD);
            netTime += timeUpload.getValue();
            row.createCell(4, CellType.STRING).setCellValue(numberFormat.format(timeUpload.getValue()));
            List arelleNumberData = reportData.stream().skip(1L).map(data -> {
                try {
                    return numberFormat.parse((String)data).doubleValue();
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    return 0.0;
                }
            }).collect(Collectors.toList());
            double netValidationTime = (Double)arelleNumberData.get(0) + (Double)arelleNumberData.get(1) + (Double)arelleNumberData.get(2);
            row.createCell(5, CellType.STRING).setCellValue(numberFormat.format(netValidationTime));
            row.createCell(6, CellType.STRING).setCellValue(numberFormat.format(netValidationTime - (Double)arelleNumberData.get(2)));
            row.createCell(7, CellType.STRING).setCellValue(numberFormat.format(netTime + netValidationTime));
            row.createCell(8, CellType.STRING).setCellValue(reportTimeTests.get(MetricType.TIME_VALIDATION).getMoment().withNano(0).toString());
            this.setCellsStyle((Row)row, CELL_STYLE_BORDERED);
        }
    }

    private void autoSizeSheetColumns(XSSFSheet sheet, int from, int to) {
        for (int i = from; i < to; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    private void setCellsStyle(Row titleRow, CellStyle style) {
        titleRow.forEach(x -> x.setCellStyle(style));
    }

    private void drawChart(XSSFSheet chartSheet, String title, XDDFDataSource<String> xData, LinkedHashMap<String, CellRangeAddress> yData, int startColl, int endColl) {
        XSSFDrawing drawing = chartSheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, startColl, 2, endColl, 14);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.displayBlanksAs(DisplayBlanks.GAP);
        chart.getOrAddLegend().setPosition(LegendPosition.BOTTOM);
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        XDDFChartData data = chart.createData(ChartTypes.LINE, (XDDFChartAxis)bottomAxis, leftAxis);
        int currentColor = 0;
        for (Map.Entry<String, CellRangeAddress> axis : yData.entrySet()) {
            CellRangeAddress cellRangeAddress = axis.getValue();
            XDDFLineChartData.Series series = (XDDFLineChartData.Series)data.addSeries(xData, XDDFDataSourcesFactory.fromArray((Number[])new Double[0], (String)cellRangeAddress.formatAsString(METRICS_SHEET_NAME, true)));
            series.setTitle(axis.getKey(), null);
            series.setSmooth(Boolean.valueOf(false));
            series.setMarkerStyle(MarkerStyle.NONE);
            XDDFSolidFillProperties fill = new XDDFSolidFillProperties(XDDFColor.from((PresetColor)COLORS[currentColor]));
            XDDFLineProperties line = new XDDFLineProperties();
            line.setFillProperties((XDDFFillProperties)fill);
            XDDFShapeProperties properties = series.getShapeProperties();
            if (properties == null) {
                properties = new XDDFShapeProperties();
            }
            properties.setLineProperties(line);
            series.setShapeProperties(properties);
            ++currentColor;
        }
        chart.plot(data);
    }

    static {
        numberFormat = NumberFormat.getInstance(Locale.FRANCE);
        DRAWABLE_METRICS = new HashSet<MetricType>(Arrays.asList(MetricType.CPU, MetricType.RAM, MetricType.HDD_READ, MetricType.HDD_WRITE));
        COLORS = new PresetColor[]{PresetColor.RED, PresetColor.GREEN, PresetColor.BLUE};
    }
}

