/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.model.MappingData;
import ru.cbr.xbrl.converter.model.TemplateMapping;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model_main.Template;
import ru.cbr.xbrl.converter.service.TemplateService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.LruCache;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxSheet;

@Transactional(value="cacheTransactionManager", readOnly=true)
public class XlsxTemplateFormWriter {
    private static final Logger log = LoggerFactory.getLogger(XlsxTemplateFormWriter.class);
    private static int numberOfAxisSheets = 0;
    private static final int SKIP = 1;
    private static final int MAIN_Z = 2;
    private static final int SECOND_Z = 3;
    private static final int FACT_CODE = 4;
    private static final int HEADER = 5;
    private final InputStream source;
    private final String destPath;
    private final boolean multipleFiles;
    private final List<List<AspectData>> mainZDimValues;
    private final String ogrn;
    private final Template template;
    private final TemplateMapping mapping;
    private final EditXbrlService editXbrlService;
    private final XbrlReport xbrlReport;
    private final TemplateService templateService;
    private final Map<String, Date> periodParameterFormulaValueMap;
    private final Map<String, Map<String, List<EnumerateItem>>> enumerationsMap;
    private final Map<String, List<String>> headerCodeValues;
    private final Consumer<NotificationEvent> notificationEventConsumer;
    private final boolean allowOverwriteFile;
    private Map<String, Date> periodParameterMap = new HashMap();
    private Map<String, String> defaultDimensions = new HashMap();
    private Map<Integer, List<CellRangeAddress>> currentRegionsByRowNumberMap = new HashMap();

    public XlsxTemplateFormWriter(InputStream source, String destPath, boolean multipleFiles, List<List<AspectData>> mainZDimValues, String ogrn, Template template, TemplateMapping mapping, EditXbrlService editXbrlService, XbrlReport xbrlReport, TemplateService templateService, Map<String, Date> periodParameterFormulaValueMap, Map<String, Map<String, List<EnumerateItem>>> enumerationsMap, Map<String, List<String>> headerCodeValues, Consumer<NotificationEvent> notificationEventConsumer, boolean allowOverwriteFile) throws IOException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        this.source = source;
        this.destPath = destPath;
        this.multipleFiles = multipleFiles;
        this.mainZDimValues = mainZDimValues;
        this.ogrn = ogrn;
        this.template = template;
        this.mapping = mapping;
        this.editXbrlService = editXbrlService;
        this.xbrlReport = xbrlReport;
        this.templateService = templateService;
        this.periodParameterFormulaValueMap = periodParameterFormulaValueMap;
        this.enumerationsMap = enumerationsMap;
        this.headerCodeValues = headerCodeValues;
        this.notificationEventConsumer = notificationEventConsumer;
        this.allowOverwriteFile = allowOverwriteFile;
        this.prepare();
        this.export();
    }

    private void prepare() {
        this.defaultDimensions = this.editXbrlService.getDimensionsDefault();
        this.periodParameterMap = this.templateService.prepareParameterPeriodMap();
    }

    private void export() throws IOException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        String baseFilename = "Form_" + FilenameUtils.getBaseName((String)this.template.getEntryPoint()) + "_" + this.ogrn + "_" + LocalDate.now().toString();
        XSSFWorkbook formWorkbook = new XSSFWorkbook();
        String exportFileAbsolutePath = this.destPath + File.separator + baseFilename + ".xlsx";
        FileOutputStream out = null;
        if (!this.multipleFiles) {
            FileUtils.checkFileWritable((String)exportFileAbsolutePath, (Boolean)this.allowOverwriteFile);
            try {
                out = new FileOutputStream(exportFileAbsolutePath);
            }
            catch (FileNotFoundException e) {
                throw new RewritableFileOpenException();
            }
        }
        XSSFWorkbook templateWorkbook = new XSSFWorkbook(this.source);
        numberOfAxisSheets = templateWorkbook.getNumberOfSheets();
        int axisNumber = 0;
        this.transferWorkbookStyles((Workbook)templateWorkbook, (Workbook)formWorkbook);
        HashMap<String, Long> usedFilename = new HashMap<String, Long>();
        this.editXbrlService.initExistenceContextCache();
        this.templateService.clearClosedMemberCache();
        for (List mainZDimValue : this.mainZDimValues) {
            int sheetNumber = 0;
            this.sendNotificationEvent("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 Z \u043e\u0441\u0435\u0439: " + ++axisNumber + " \u0438\u0437 " + this.mainZDimValues.size(), axisNumber, sheetNumber);
            String zAxisTitle = LabelUtils.calcLabel((List)mainZDimValue, null).replaceAll("[\\\\/:*?\"<>|]", "");
            if (this.multipleFiles) {
                formWorkbook = new XSSFWorkbook();
                this.transferWorkbookStyles((Workbook)templateWorkbook, (Workbook)formWorkbook);
                String filename = baseFilename + "_" + zAxisTitle;
                int maxFilenameLength = 218 - StringUtils.length((CharSequence)(this.destPath + File.separator)) - 5;
                if (maxFilenameLength > 0) {
                    if (filename.length() > maxFilenameLength) {
                        filename = filename.substring(0, maxFilenameLength);
                    }
                } else {
                    log.warn("Path to {} more than 218 characters - not supported Excel", (Object)filename);
                }
                Long number = usedFilename.computeIfAbsent(filename, k -> 0L);
                usedFilename.put(filename, number + 1L);
                if (number > 0L) {
                    String countPrefix = "_" + number;
                    int netLength = filename.length() + countPrefix.length();
                    if (netLength > maxFilenameLength) {
                        filename = filename.substring(0, filename.length() - netLength + maxFilenameLength);
                    }
                    filename = filename + countPrefix;
                }
                try {
                    out = new FileOutputStream(this.destPath + File.separator + filename + ".xlsx");
                }
                catch (FileNotFoundException e) {
                    throw new RewritableFileOpenException();
                }
            }
            Iterator sheetIterator = templateWorkbook.sheetIterator();
            while (sheetIterator.hasNext()) {
                Sheet sheet = (Sheet)sheetIterator.next();
                this.sendNotificationEvent("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 Z \u043e\u0441\u0435\u0439: " + axisNumber + " \u0438\u0437 " + this.mainZDimValues.size() + ", \u043b\u0438\u0441\u0442 " + ++sheetNumber, axisNumber, sheetNumber);
                int sheetIndex = templateWorkbook.getSheetIndex(sheet);
                if (templateWorkbook.isSheetHidden(sheetIndex) || templateWorkbook.isSheetVeryHidden(sheetIndex) || StringUtils.equals((CharSequence)sheet.getSheetName(), (CharSequence)"\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b")) continue;
                this.currentRegionsByRowNumberMap = sheet.getMergedRegions().stream().collect(Collectors.groupingBy(CellRangeAddressBase::getFirstRow));
                this.writeFormSheet((Workbook)formWorkbook, sheet, mainZDimValue.size() > 0 ? (AspectData)mainZDimValue.get(0) : null, zAxisTitle);
            }
            if (!this.multipleFiles) continue;
            formWorkbook.write((OutputStream)out);
            out.close();
        }
        if (!this.multipleFiles) {
            formWorkbook.write((OutputStream)out);
            out.close();
        }
        this.editXbrlService.clearExistenceContextCache();
        this.templateService.clearClosedMemberCache();
        templateWorkbook.close();
    }

    private void transferWorkbookStyles(Workbook source, Workbook target) {
        for (int i = 1; i < source.getNumCellStyles(); ++i) {
            CellStyle sourceStyle = source.getCellStyleAt(i);
            CellStyle targetStyle = target.createCellStyle();
            targetStyle.cloneStyleFrom(sourceStyle);
        }
    }

    private void writeFormSheet(Workbook formWorkbook, Sheet xlsxSheet, AspectData mainZDimValue, String zAxisTitle) {
        String sheetName = formWorkbook.getNumberOfSheets() + 1 + " " + (xlsxSheet.getSheetName().substring(0, xlsxSheet.getSheetName().length() >= 15 ? 14 : xlsxSheet.getSheetName().length()) + zAxisTitle).replace(" ", "");
        Sheet formSheet = formWorkbook.createSheet(sheetName);
        this.copyContentSheet(xlsxSheet, formSheet, formWorkbook, mainZDimValue);
    }

    private void copyContentSheet(Sheet sourceSheet, Sheet targetSheet, Workbook targetWorkbook, AspectData mainZDimValue) {
        Cell rangeCell;
        Iterator sourceRows = sourceSheet.rowIterator();
        int[] tableArgs = new int[3];
        CellRangeAddress range = null;
        Row rangeRow = sourceSheet.getRow(0);
        if (rangeRow != null && (rangeCell = rangeRow.getCell(0)) != null) {
            rangeCell.setCellType(CellType.STRING);
            String rangeString = rangeCell.getStringCellValue();
            if (rangeString.startsWith("R_")) {
                range = CellRangeAddress.valueOf((String)rangeString.substring(2).replace("_", ":"));
                if (sourceSheet.getRow(range.getLastRow() + 1) == null) {
                    sourceSheet.createRow(range.getLastRow() + 1);
                    sourceRows = sourceSheet.rowIterator();
                }
                sourceRows.next();
                tableArgs[0] = tableArgs[0] - 1;
            }
        }
        ArrayList<Row> rangeRows = new ArrayList<Row>();
        ArrayList secondZDimValues = new ArrayList();
        int startRangeDeviation = 0;
        while (sourceRows.hasNext()) {
            Row sourceRow = (Row)sourceRows.next();
            if (range != null) {
                if (range.containsRow(sourceRow.getRowNum())) {
                    if (rangeRows.size() == 0) {
                        startRangeDeviation = tableArgs[0];
                    }
                    rangeRows.add(sourceRow);
                }
                if (sourceRow.getRowNum() == range.getLastRow() + 1 && rangeRows.size() > 0) {
                    if (secondZDimValues.size() > 0) {
                        if (tableArgs[2] == 0) {
                            startRangeDeviation = startRangeDeviation - rangeRows.size() - 1;
                            this.removeRange(tableArgs[0] - startRangeDeviation - 1, targetSheet);
                            tableArgs[0] = startRangeDeviation;
                        }
                        secondZDimValues.remove(0);
                        while (secondZDimValues.size() > 0) {
                            tableArgs[0] = tableArgs[0] + rangeRows.size() + 1;
                            tableArgs[2] = 0;
                            for (Row sourceRangeRow : rangeRows) {
                                this.copyRow(sourceRangeRow, targetSheet, targetWorkbook, tableArgs, mainZDimValue, true, range, secondZDimValues);
                            }
                            secondZDimValues.remove(0);
                            if (tableArgs[2] == 0) {
                                this.removeRange(tableArgs[0] - startRangeDeviation - 1, targetSheet);
                                tableArgs[0] = startRangeDeviation;
                                continue;
                            }
                            startRangeDeviation = tableArgs[0];
                        }
                        tableArgs[0] = tableArgs[0] + 1;
                    } else {
                        log.error("Sheet " + targetSheet.getSheetName() + " has range but not have second Z dimension");
                    }
                }
            }
            this.copyRow(sourceRow, targetSheet, targetWorkbook, tableArgs, mainZDimValue, false, range, secondZDimValues);
        }
        for (int i = 0; i < tableArgs[1]; ++i) {
            targetSheet.setColumnWidth(i, sourceSheet.getColumnWidth(i));
        }
    }

    private void removeRange(int rangeSize, Sheet sheet) {
        int last = sheet.getLastRowNum() + 1;
        for (int i = last - rangeSize; i < last; ++i) {
            Optional.ofNullable(sheet.getRow(i)).ifPresent(row -> {
                ArrayList<Integer> regions = new ArrayList<Integer>();
                for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                    if (!sheet.getMergedRegion(j).containsRow(row.getRowNum())) continue;
                    regions.add(j);
                }
                sheet.removeMergedRegions(regions);
                sheet.removeRow(row);
            });
        }
    }

    private void copyRow(Row sourceRow, Sheet targetSheet, Workbook targetWorkbook, int[] tableArgs, AspectData mainZDimValue, boolean isRangeCopying, CellRangeAddress range, List<AspectData> secondZDimValues) {
        Map mappingData = this.fillRowMappingData(sourceRow);
        List axisData = this.isValidOpenAxisRow(sourceRow, mappingData, mainZDimValue, secondZDimValues);
        if (axisData != null) {
            ArrayList mappingDataList = new ArrayList(mappingData.values());
            List expandedAxises = this.templateService.expandOpenAxis(axisData, ((MappingData)mappingDataList.get(0)).getRoleCode(), true);
            Optional<MappingData> memDataOptional = mappingDataList.stream().filter(data -> data.getSpecifiedMem() != null).findFirst();
            if (memDataOptional.isPresent()) {
                MappingData specifiedMemData = memDataOptional.get();
                Map roleAspectData = (Map)this.mapping.getRolesAspectData().get(specifiedMemData.getRoleCode());
                List axisDataList = specifiedMemData.isTransposition() ? (List)((Map)roleAspectData.get("X")).get(specifiedMemData.getXCode()) : (List)((Map)roleAspectData.get("Y")).get(specifiedMemData.getYCode());
                AspectData checkableDim = (AspectData)axisDataList.get(axisDataList.size() - 1);
                String mem = specifiedMemData.getSpecifiedMem();
                expandedAxises = expandedAxises.stream().filter(axis -> {
                    if (mem.startsWith("-")) {
                        return axis.stream().noneMatch(aspectData -> aspectData.getAspect().equals(checkableDim.getAspect()) && aspectData.getAspectValue().equals(mem.substring(1)));
                    }
                    return axis.stream().anyMatch(aspectData -> aspectData.getAspect().equals(checkableDim.getAspect()) && aspectData.getAspectValue().equals(mem));
                }).collect(Collectors.toList());
            }
            for (int i = 0; i < expandedAxises.size(); ++i) {
                List axis2 = (List)expandedAxises.get(i);
                Row targetRow = this.fillRowContent(targetWorkbook, targetSheet, sourceRow, mainZDimValue, axis2, tableArgs, i == 0, isRangeCopying, range, secondZDimValues, mappingData);
                if (targetRow == null) continue;
                tableArgs[0] = tableArgs[0] + 1;
            }
            tableArgs[0] = tableArgs[0] - 1;
        } else {
            Row targetRow = this.fillRowContent(targetWorkbook, targetSheet, sourceRow, mainZDimValue, null, tableArgs, true, isRangeCopying, range, secondZDimValues, mappingData);
            if (targetRow == null) {
                tableArgs[0] = tableArgs[0] - 1;
            }
        }
    }

    private void transferCellFormatting(XSSFRichTextString richSourceCellValue, XSSFRichTextString richTargetCellValue) {
        if (richSourceCellValue.length() == richTargetCellValue.length()) {
            for (int i = 1; i < richSourceCellValue.numFormattingRuns(); ++i) {
                int start = richSourceCellValue.getIndexOfFormattingRun(i);
                int end = start + richSourceCellValue.getLengthOfFormattingRun(i);
                richTargetCellValue.applyFont(start, end, (Font)richSourceCellValue.getFontOfFormattingRun(i));
            }
        }
    }

    private Row fillRowContent(Workbook targetWorkbook, Sheet targetSheet, Row sourceRow, AspectData mainZDimValue, List<AspectData> expandedAxisData, int[] tableArgs, boolean copyLabel, boolean isRangeCopying, CellRangeAddress range, List<AspectData> secondZDimValues, Map<Integer, MappingData> rowMappingData) {
        int rowNumSrc = sourceRow.getRowNum();
        Row targetRow = targetSheet.createRow(rowNumSrc + tableArgs[0]);
        Iterator sourceCells = sourceRow.cellIterator();
        HashMap<Integer, String> axisLabelCellNumMap = new HashMap<Integer, String>();
        ArrayList<Integer> zCodexIndexes = new ArrayList<Integer>();
        int columnDeviation = 0;
        block7: while (sourceCells.hasNext()) {
            Date date;
            Cell sourceCell = (Cell)sourceCells.next();
            if (isRangeCopying && range != null) {
                if (sourceCell.getColumnIndex() > range.getLastColumn()) break;
                if (sourceCell.getColumnIndex() < range.getFirstColumn()) continue;
            }
            MappingData mappingData = rowMappingData.get(sourceCell.getColumnIndex());
            String cellValue = sourceCell.getStringCellValue().trim();
            Cell targetCell = targetRow.createCell(sourceCell.getColumnIndex() + columnDeviation);
            CellStyle targetCellStyle = targetWorkbook.getCellStyleAt((int)sourceCell.getCellStyle().getIndex());
            targetCell.setCellStyle(targetCellStyle);
            boolean cellInRange = range != null && range.containsRow(sourceCell.getRowIndex()) && range.containsColumn(sourceCell.getColumnIndex());
            switch (this.getMappingType(cellValue, isRangeCopying, sourceCell, range, mainZDimValue, secondZDimValues, mappingData)) {
                case 1: {
                    targetCell.setCellValue("");
                    continue block7;
                }
                case 2: {
                    if (!copyLabel && !cellValue.contains("M_")) continue block7;
                    targetCell.setCellValue(mainZDimValue.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER) ? mainZDimValue.getAspectValue() : this.templateService.getValueForExplicitDimension(mainZDimValue));
                    zCodexIndexes.add(targetCell.getColumnIndex());
                    continue block7;
                }
                case 3: {
                    if (cellInRange) {
                        if (!copyLabel && !cellValue.contains("M_")) continue block7;
                        targetCell.setCellValue(secondZDimValues.get(0).getDimensionType().equals((Object)DimensionType.TYPED_MEMBER) ? secondZDimValues.get(0).getAspectValue() : this.templateService.getValueForExplicitDimension(secondZDimValues.get(0)));
                        zCodexIndexes.add(targetCell.getColumnIndex());
                        continue block7;
                    }
                    targetCell.setCellValue("");
                    log.error("Sheet " + targetSheet.getSheetName() + " contains second Z dimension code outside of preset range");
                    continue block7;
                }
                case 4: {
                    List zAxisData;
                    List codeData = (List)this.mapping.getCodesAspectData().get(mappingData.getFullCode());
                    Map roleCodes = (Map)this.mapping.getRolesAspectData().get(mappingData.getRoleCode());
                    Map zData = (Map)roleCodes.get("Z");
                    List list = zAxisData = zData.containsKey("1") ? (List)zData.get("1") : zData.getOrDefault("1N", Collections.emptyList());
                    if (zAxisData.size() == 2) {
                        this.fillSecondZAxis(cellInRange, targetSheet.getSheetName(), zAxisData, mainZDimValue, secondZDimValues);
                    }
                    ArrayList checkedDataList = new ArrayList();
                    if (!mappingData.isTransposition() && mappingData.getXCode().contains("N") || mappingData.isTransposition() && mappingData.getYCode().contains("N")) {
                        this.expandCellHorizontal(checkedDataList, mappingData, roleCodes, codeData);
                    } else {
                        checkedDataList.add(new ArrayList(codeData));
                    }
                    for (List list2 : checkedDataList) {
                        targetCell = targetRow.createCell(sourceCell.getColumnIndex() + columnDeviation);
                        targetCell.setCellStyle(targetCellStyle);
                        boolean codeInRangeIncludeSecondZ = cellInRange && secondZDimValues.size() > 0 && this.templateService.isBelong(list2, secondZDimValues.get(0), false);
                        String factValue = !mappingData.isHidden() ? this.findFactValueByDataList(codeInRangeIncludeSecondZ, mappingData, list2, expandedAxisData, zAxisData, mainZDimValue, secondZDimValues) : "";
                        targetCell.setCellValue(factValue);
                        if (tableArgs[2] == 0 && codeInRangeIncludeSecondZ && !factValue.equals("")) {
                            tableArgs[2] = 1;
                        }
                        ++columnDeviation;
                    }
                    --columnDeviation;
                    continue block7;
                }
                case 5: {
                    List headerCellValues = (List)this.headerCodeValues.get(mappingData.getFullCode());
                    if (!CollectionUtils.isEmpty((Collection)headerCellValues)) {
                        for (String headerValue : headerCellValues) {
                            targetCell = targetRow.createCell(sourceCell.getColumnIndex() + columnDeviation);
                            targetCell.setCellStyle(targetCellStyle);
                            targetCell.setCellValue(!mappingData.isHidden() ? headerValue : "");
                            ++columnDeviation;
                        }
                    } else if (mappingData.getXCode().contains("D") || mappingData.getYCode().contains("D")) {
                        targetCell.setCellValue(mappingData.isHidden() ? "" : this.calculateDynamicAxisValue(mappingData.getFullCode().split(":")));
                        ++columnDeviation;
                    }
                    --columnDeviation;
                    continue block7;
                }
            }
            if (mappingData != null && mappingData.isTitle()) {
                if (mappingData.isHidden()) continue;
                axisLabelCellNumMap.put(sourceCell.getColumnIndex() + columnDeviation, (mappingData.isTransposition() ? "T_" : "") + mappingData.getFullCode());
                continue;
            }
            if (mappingData == null && cellValue.contains("Z:") && cellValue.indexOf("Z:") <= 2) {
                targetCell.setCellValue("");
                log.error("Sheet " + targetSheet.getSheetName() + " contains unknown Z dimension code");
                continue;
            }
            if (!copyLabel || StringUtils.isBlank((CharSequence)(cellValue = StringUtils.startsWith((CharSequence)cellValue, (CharSequence)"#") ? ((date = (Date)this.periodParameterMap.get(cellValue.substring(1))) == null ? "" : PeriodDates.formatDate((Date)date)) : sourceCell.getStringCellValue()))) continue;
            XSSFRichTextString richSourceCellValue = (XSSFRichTextString)sourceCell.getRichStringCellValue();
            XSSFRichTextString richTargetCellValue = (XSSFRichTextString)targetCell.getRichStringCellValue();
            richTargetCellValue.setString(StringUtils.isBlank((CharSequence)cellValue) ? null : cellValue);
            this.transferCellFormatting(richSourceCellValue, richTargetCellValue);
            targetCell.setCellValue((RichTextString)richTargetCellValue);
        }
        if (this.isEmptyRow(sourceRow, targetRow, expandedAxisData, axisLabelCellNumMap, zCodexIndexes)) {
            targetSheet.removeRow(targetRow);
            return null;
        }
        this.pasteAxisLabels(targetRow, expandedAxisData, axisLabelCellNumMap);
        this.pasteCellRanges(rowNumSrc, tableArgs, targetSheet);
        if (targetRow.getLastCellNum() > tableArgs[1]) {
            tableArgs[1] = targetRow.getLastCellNum();
        }
        targetRow.setHeight((short)-1);
        return targetRow;
    }

    private boolean isEmptyRow(Row sourceRow, Row targetRow, List<AspectData> expandedAxisData, Map<Integer, String> axisLabelCellNumMap, List<Integer> zCodexIndexes) {
        return expandedAxisData != null && IteratorUtils.toList((Iterator)targetRow.cellIterator()).stream().allMatch(cell -> cell.getStringCellValue().equals("") || zCodexIndexes.contains(cell.getColumnIndex())) && IteratorUtils.toList((Iterator)sourceRow.cellIterator()).stream().anyMatch(cell -> !cell.getStringCellValue().equals("") && !axisLabelCellNumMap.containsValue(cell.getStringCellValue().trim()));
    }

    private void pasteAxisLabels(Row targetRow, List<AspectData> expandedAxisData, Map<Integer, String> axisLabelCellNumMap) {
        for (Map.Entry<Integer, String> axisLabelCellNum : axisLabelCellNumMap.entrySet()) {
            Cell labelCell = targetRow.getCell(axisLabelCellNum.getKey().intValue());
            String[] codeParts = axisLabelCellNum.getValue().split(":");
            if (expandedAxisData != null) {
                AspectData lastDim = this.findLastDimByAxisCode(this.mapping.getRolesAspectData(), codeParts, expandedAxisData);
                if (lastDim == null) continue;
                String lastDimLabel = lastDim.getDimensionType() == DimensionType.EXPLICIT_MEMBER ? lastDim.getLabel() : lastDim.getAspectValue();
                labelCell.setCellValue(lastDimLabel);
                continue;
            }
            if (!StringUtils.contains((CharSequence)codeParts[1], (CharSequence)"D") && !StringUtils.contains((CharSequence)codeParts[2], (CharSequence)"D")) continue;
            labelCell.setCellValue(this.calculateDynamicAxisValue(codeParts));
        }
    }

    private int getMappingType(String cellValue, boolean isRangeCopying, Cell sourceCell, CellRangeAddress range, AspectData mainZDimValue, List<AspectData> secondZDimValues, MappingData mappingData) {
        if (cellValue.equals("<->") || isRangeCopying && sourceCell.getColumnIndex() < range.getFirstColumn()) {
            return 1;
        }
        if (mainZDimValue != null && this.isValidZCode(cellValue, mainZDimValue)) {
            return 2;
        }
        if (secondZDimValues.size() > 0 && this.isValidZCode(cellValue, secondZDimValues.get(0))) {
            return 3;
        }
        if (mappingData != null) {
            String fullCode = mappingData.getFullCode();
            if (this.mapping.getCodesAspectData().containsKey(fullCode)) {
                return 4;
            }
            boolean transposition = mappingData.isTransposition();
            if (this.headerCodeValues.containsKey(fullCode) && (!transposition && mappingData.getYCode().equals("0") || transposition && mappingData.getXCode().equals("0"))) {
                return 5;
            }
        }
        return -1;
    }

    private void fillSecondZAxis(boolean cellInRange, String sheetName, List<AspectData> zAxisData, AspectData mainZDimValue, List<AspectData> secondZDimValues) {
        if (!cellInRange) {
            log.error("Sheet " + sheetName + " contains mapping code outside of preset range");
        } else if (secondZDimValues.size() == 0) {
            if (this.templateService.isBelong(zAxisData, mainZDimValue, false)) {
                ArrayList<AspectData> secondZDim = new ArrayList<AspectData>(zAxisData);
                secondZDim.removeIf(dim -> this.templateService.haveSameParams(dim, mainZDimValue));
                List expandedSecondZDim = this.templateService.buildZAxisDataCortege(this.templateService.fillDimensionValues(secondZDim));
                expandedSecondZDim.forEach(axisElement -> secondZDimValues.add((AspectData)axisElement.get(0)));
            } else {
                log.error("Sheet " + sheetName + " contains mapping codes with many Z dims, but without main Z dim");
            }
        } else if (!this.templateService.isBelong(zAxisData, secondZDimValues.get(0), false)) {
            log.error("Sheet " + sheetName + " contains mapping codes with different second Z dimension");
        }
    }

    private void expandCellHorizontal(List<List<AspectData>> checkedDataList, MappingData mappingData, Map<String, Map<String, List<AspectData>>> roleCodes, List<AspectData> codeData) {
        List<AspectData> data = !mappingData.isTransposition() ? roleCodes.get("X").get(mappingData.getXCode()) : roleCodes.get("Y").get(mappingData.getYCode());
        List expandedColumnAxisData = this.templateService.expandOpenAxis(data, mappingData.getRoleCode(), false);
        expandedColumnAxisData.removeIf(axis -> !this.templateService.isBelong(axis, (AspectData)data.get(data.size() - 1), false));
        for (List expandedXAxis : expandedColumnAxisData) {
            ArrayList<AspectData> xAxisData = new ArrayList<AspectData>(codeData);
            xAxisData.removeAll(xAxisData.stream().filter(aspectData -> expandedXAxis.stream().anyMatch(expandDim -> this.templateService.haveSameParams(expandDim, aspectData))).collect(Collectors.toList()));
            xAxisData.addAll(expandedXAxis);
            checkedDataList.add(xAxisData);
        }
    }

    private String findFactValueByDataList(boolean codeInRangeIncludeSecondZ, MappingData mappingData, List<AspectData> checkedData, List<AspectData> expandedAxisData, List<AspectData> zAxisData, AspectData mainZDimValue, List<AspectData> secondZDimValues) {
        String factValue = "";
        if (expandedAxisData != null) {
            checkedData.removeAll(checkedData.stream().filter(aspectData -> expandedAxisData.stream().anyMatch(expandDim -> this.templateService.haveSameParams(expandDim, aspectData))).collect(Collectors.toList()));
            checkedData.addAll(expandedAxisData);
        }
        if (zAxisData.size() == 0) {
            this.calculateCurrentDatesForAspectData(checkedData);
            factValue = this.findFactValue(checkedData);
        } else if (this.templateService.isBelong(zAxisData, mainZDimValue, false)) {
            checkedData.removeAll(checkedData.stream().filter(aspectData -> this.templateService.haveSameParams(mainZDimValue, aspectData)).collect(Collectors.toList()));
            checkedData.add(mainZDimValue);
            if (codeInRangeIncludeSecondZ) {
                checkedData.removeAll(checkedData.stream().filter(aspectData -> this.templateService.haveSameParams((AspectData)secondZDimValues.get(0), aspectData)).collect(Collectors.toList()));
                checkedData.add(secondZDimValues.get(0));
            }
            this.calculateCurrentDatesForAspectData(checkedData);
            factValue = this.findFactValue(checkedData);
        }
        Map enumerations = (Map)this.enumerationsMap.get(mappingData.getRoleCode());
        AspectData concept = new AspectCellData(checkedData).getConcept();
        if (concept != null) {
            Optional item;
            String conceptStr = concept.getAspectValue();
            if (enumerations != null && enumerations.containsKey(conceptStr) && (item = XslxSheet.getEnumeratedFactValueByMember((Map)enumerations, (String)factValue, (String)conceptStr)).isPresent()) {
                factValue = ((EnumerateItem)item.get()).getLabel();
            }
        }
        return factValue;
    }

    private void pasteCellRanges(int rowNumSrc, int[] tableArgs, Sheet targetSheet) {
        List cellRangeAddresses = (List)this.currentRegionsByRowNumberMap.get(rowNumSrc);
        if (CollectionUtils.isEmpty((Collection)cellRangeAddresses)) {
            return;
        }
        cellRangeAddresses.forEach(cellRangeAddress -> {
            try {
                int firstRow = cellRangeAddress.getFirstRow();
                int lastRow = cellRangeAddress.getLastRow();
                CellRangeAddress createdCellRangeAddress = new CellRangeAddress(rowNumSrc + tableArgs[0], rowNumSrc + tableArgs[0] + (lastRow - firstRow), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
                targetSheet.addMergedRegion(createdCellRangeAddress);
            }
            catch (IllegalStateException ex) {
                log.error("Merged region exist or intersect");
            }
        });
    }

    private AspectData findLastDimByAxisCode(Map<String, Map<String, Map<String, List<AspectData>>>> rolesAspectData, String[] codeParts, List<AspectData> expandedAxisData) {
        String axis;
        String axisCode;
        if (CollectionUtils.isEmpty(rolesAspectData) || codeParts == null || codeParts.length != 3) {
            return null;
        }
        if (codeParts[0].contains("H_")) {
            return new AspectData();
        }
        boolean transposition = StringUtils.contains((CharSequence)codeParts[0], (CharSequence)"T_");
        if (transposition) {
            codeParts[0] = StringUtils.replaceFirst((String)codeParts[0], (String)"T_", (String)"");
            axisCode = codeParts[1];
            axis = "X";
        } else {
            axisCode = codeParts[2];
            axis = "Y";
        }
        codeParts[0] = StringUtils.replaceFirst((String)codeParts[0], (String)"C_", (String)"");
        Map<String, Map<String, List<AspectData>>> roleAxisMap = rolesAspectData.get(codeParts[0]);
        if (CollectionUtils.isEmpty(roleAxisMap)) {
            return null;
        }
        Map<String, List<AspectData>> roleAxisCodeMap = roleAxisMap.get(axis);
        if (CollectionUtils.isEmpty(roleAxisCodeMap)) {
            return null;
        }
        List<AspectData> aspectData = roleAxisCodeMap.get(axisCode);
        if (CollectionUtils.isEmpty(aspectData)) {
            return null;
        }
        AspectData lastDimension = AspectCellData.getLastDimensionByStream(aspectData.stream());
        Optional<AspectData> any = expandedAxisData.stream().filter(expandedAspectData -> expandedAspectData.getType() == lastDimension.getType() && StringUtils.equals((CharSequence)expandedAspectData.getAspect(), (CharSequence)lastDimension.getAspect())).findAny();
        return any.orElse(null);
    }

    private String calculateDynamicAxisValue(String[] codeParts) {
        List yAspectData;
        Map roleAspectData = (Map)this.mapping.getRolesAspectData().get(codeParts[0].substring(2));
        ArrayList codeData = new ArrayList();
        List xAspectData = (List)((Map)roleAspectData.get("X")).get(codeParts[1]);
        if (!CollectionUtils.isEmpty((Collection)xAspectData)) {
            codeData.addAll(xAspectData);
        }
        if (!CollectionUtils.isEmpty((Collection)(yAspectData = (List)((Map)roleAspectData.get("Y")).get(codeParts[2])))) {
            codeData.addAll(yAspectData);
        }
        this.calculateCurrentDatesForAspectData(codeData);
        return LabelUtils.calcLabel(codeData.stream().filter(aspectData -> aspectData.getType() == AspectType.PARAMS_PERIOD).collect(Collectors.toList()), null);
    }

    private boolean isValidZCode(String string, AspectData zDimData) {
        return string.endsWith("Z:" + zDimData.getAspect());
    }

    private Map<Integer, MappingData> fillRowMappingData(Row row) {
        HashMap<Integer, MappingData> mappingDataMap = new HashMap<Integer, MappingData>();
        List cells = IteratorUtils.toList((Iterator)row.cellIterator());
        cells.forEach(cell -> cell.setCellType(CellType.STRING));
        for (Cell cell2 : cells) {
            String[] codeParts;
            String cellValue;
            if (cell2 == null || (cellValue = cell2.getStringCellValue().trim()).equals("")) continue;
            MappingData mappingData = new MappingData();
            int startMem = cellValue.indexOf("(");
            int endMem = cellValue.indexOf(")");
            if (startMem != -1 && endMem != -1 && startMem < endMem) {
                mappingData.setSpecifiedMem(cellValue.substring(cellValue.indexOf("(") + 1, cellValue.indexOf(")")));
                cellValue = cellValue.substring(0, cellValue.indexOf("("));
            }
            if ((codeParts = cellValue.split(":")).length != 3) continue;
            if (codeParts[0].contains("C_")) {
                codeParts[0] = codeParts[0].replaceFirst("C_", "");
                mappingData.setTitle(true);
            }
            if (codeParts[0].contains("T_")) {
                codeParts[0] = codeParts[0].replaceFirst("T_", "");
                mappingData.setTransposition(true);
            }
            if (codeParts[0].contains("H_")) {
                codeParts[0] = codeParts[0].replaceFirst("H_", "");
                mappingData.setHidden(true);
            }
            if (!this.mapping.getRolesAspectData().keySet().contains(codeParts[0])) continue;
            mappingData.setRoleCode(codeParts[0]);
            mappingData.setXCode(codeParts[1]);
            mappingData.setYCode(codeParts[2]);
            mappingDataMap.put(cell2.getColumnIndex(), mappingData);
        }
        return mappingDataMap;
    }

    private List<AspectData> isValidOpenAxisRow(Row row, Map<Integer, MappingData> mappingDataMap, AspectData mainZDimValue, List<AspectData> secondZDimValues) {
        String hierarchyCode;
        if (mappingDataMap.size() == 0) {
            return null;
        }
        int startIndex = mappingDataMap.keySet().stream().min(Integer::compareTo).orElse(0);
        int endIndex = mappingDataMap.keySet().stream().max(Integer::compareTo).orElse(0);
        int columnIndex = startIndex;
        boolean transposition = false;
        if (mappingDataMap.values().stream().anyMatch(MappingData::isTransposition)) {
            if (mappingDataMap.values().stream().allMatch(MappingData::isTransposition)) {
                transposition = true;
            } else {
                return null;
            }
        }
        String hierarchyEndCode = null;
        List hierarchyEndCodeData = null;
        ArrayList<Cell> titleCells = new ArrayList<Cell>();
        for (int i = startIndex; i <= endIndex; ++i) {
            List hierarchyCodeData;
            Cell currentCell = row.getCell(i);
            if (currentCell == null) continue;
            String cellValue = currentCell.getStringCellValue().trim();
            if (cellValue.equals("<->") || cellValue.equals("") || mainZDimValue != null && this.isValidZCode(cellValue, mainZDimValue) || secondZDimValues.size() > 0 && this.isValidZCode(cellValue, secondZDimValues.get(0))) {
                ++columnIndex;
                continue;
            }
            MappingData mappingData = mappingDataMap.get(currentCell.getColumnIndex());
            if (mappingData == null) {
                return null;
            }
            if (currentCell.getColumnIndex() != columnIndex) continue;
            if (mappingData.isTitle()) {
                titleCells.add(currentCell);
                ++columnIndex;
                continue;
            }
            String string = hierarchyCode = transposition ? mappingData.getXCode() : mappingData.getYCode();
            if (!hierarchyCode.contains("N")) {
                return null;
            }
            Map roleAspectData = (Map)this.mapping.getRolesAspectData().get(mappingData.getRoleCode());
            List list = hierarchyCodeData = transposition ? (List)((Map)roleAspectData.get("X")).get(mappingData.getXCode()) : (List)((Map)roleAspectData.get("Y")).get(mappingData.getYCode());
            if (hierarchyEndCodeData == null) {
                hierarchyEndCode = hierarchyCode;
                hierarchyEndCodeData = hierarchyCodeData;
                ++columnIndex;
                continue;
            }
            if (hierarchyCode.equals(hierarchyEndCode) && hierarchyEndCodeData.size() == hierarchyCodeData.size() && this.templateService.isBelong(hierarchyEndCodeData, hierarchyCodeData, false)) {
                ++columnIndex;
                continue;
            }
            return null;
        }
        if (hierarchyEndCode == null || hierarchyEndCodeData == null) {
            if (titleCells.size() == 0) {
                return null;
            }
            int codeDepth = -1;
            String roleCode = null;
            for (Cell titleCell : titleCells) {
                MappingData mappingData = mappingDataMap.get(titleCell.getColumnIndex());
                String hierarchyCode2 = transposition ? mappingData.getXCode() : mappingData.getYCode();
                int currentCodeDepth = hierarchyCode2.split("-").length;
                if (currentCodeDepth < codeDepth) continue;
                codeDepth = currentCodeDepth;
                hierarchyEndCode = hierarchyCode2;
                roleCode = mappingData.getRoleCode();
            }
            if (hierarchyEndCode == null || roleCode == null) {
                return null;
            }
            Map roleAspectData = (Map)this.mapping.getRolesAspectData().get(roleCode);
            List list = hierarchyEndCodeData = transposition ? (List)((Map)roleAspectData.get("X")).get(hierarchyEndCode) : (List)((Map)roleAspectData.get("Y")).get(hierarchyEndCode);
            if (hierarchyEndCodeData == null) {
                return null;
            }
        }
        for (Cell titleCell : titleCells) {
            List hierarchyCodeData;
            MappingData mappingData = mappingDataMap.get(titleCell.getColumnIndex());
            Map roleAspectData = (Map)this.mapping.getRolesAspectData().get(mappingData.getRoleCode());
            hierarchyCode = transposition ? mappingData.getXCode() : mappingData.getYCode();
            List list = hierarchyCodeData = transposition ? (List)((Map)roleAspectData.get("X")).get(hierarchyEndCode) : (List)((Map)roleAspectData.get("Y")).get(hierarchyEndCode);
            if (hierarchyEndCode.contains(hierarchyCode) && this.templateService.isBelong(hierarchyEndCodeData, hierarchyCodeData, false)) continue;
            return null;
        }
        return hierarchyEndCodeData;
    }

    private void calculateCurrentDatesForAspectData(List<AspectData> aspectDataList) {
        if (CollectionUtils.isEmpty(aspectDataList)) {
            return;
        }
        for (AspectData aspectData : aspectDataList) {
            Date date;
            String periodFormula;
            if (aspectData == null || aspectData.getType() != AspectType.PARAMS_PERIOD || StringUtils.isBlank((CharSequence)(periodFormula = aspectData.getPeriodFormula())) || (date = (Date)this.periodParameterFormulaValueMap.get(periodFormula)) == null) continue;
            aspectData.setAspectValue(PeriodDates.formatDate((Date)date));
        }
    }

    private String findFactValue(List<AspectData> codeAspectData) {
        AspectCellData aspectCellData = new AspectCellData(codeAspectData);
        String contextId = this.editXbrlService.findContext(this.xbrlReport, aspectCellData, this.defaultDimensions, new LruCache(100), true);
        AspectData concept = aspectCellData.getConcept();
        XbrlValue xbrlValue = this.editXbrlService.findValue(concept.getAspectValue(), this.xbrlReport, contextId);
        return xbrlValue != null ? xbrlValue.getValue() : "";
    }

    private void sendNotificationEvent(String title, int currentStage, int sheetNumber) {
        int totalStages = this.mainZDimValues.size();
        NotificationEvent notificationEvent = new NotificationEvent();
        notificationEvent.setTitle(title);
        notificationEvent.setTotalNumberOfStages(Integer.valueOf(totalStages));
        notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
        float progress = sheetNumber <= numberOfAxisSheets ? ((float)(currentStage - 1) + (float)sheetNumber / (float)numberOfAxisSheets) / (float)totalStages : (float)(currentStage / totalStages);
        notificationEvent.setProgress(Float.valueOf(progress));
        this.notificationEventConsumer.accept(notificationEvent);
    }
}

