/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.UnsupportedAlternativeExportRoleException;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.service.import_export.XlsAspectColumnService;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxContentSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxEnumerationDataSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxWriterConfiguration;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxWriter;

@Service
public class XslxWriter {
    private static final Logger log = LoggerFactory.getLogger(XslxWriter.class);
    private final String xslxFileName;
    private final XbrlPackage xbrlPackage;
    private final Function<XbrlReportRole, TLBUiModel> tlbUiModelFunction;
    private final Consumer<NotificationEvent> notificationEventConsumer;
    private final XlsxEnumerationDataSheet xlsxEnumerationDataSheet;
    private final Boolean xlsxWriteAspectData;
    private final String currency;
    private final Boolean xlsxWriteAxisId;
    private final boolean multipleFiles;
    private final String path;
    private final CellEditableCheckerFunction cellEditableCheckerFunction;
    private final boolean yLevelAsColumns;
    private List<String> unsupportedRoleList;
    private final XlsAspectColumnService xlsAspectColumnService;

    @Autowired
    public XslxWriter(XlsxWriterConfiguration xlsxWriterConfiguration, XlsAspectColumnService xlsAspectColumnService) {
        this.xslxFileName = xlsxWriterConfiguration.getXslxFileName();
        this.currency = xlsxWriterConfiguration.getCurrency();
        this.xlsxWriteAspectData = xlsxWriterConfiguration.getXlsxWriteAspectData();
        this.xlsxWriteAxisId = xlsxWriterConfiguration.getXlsxWriteAxisId();
        this.xbrlPackage = xlsxWriterConfiguration.getXbrlPackage();
        this.tlbUiModelFunction = xlsxWriterConfiguration.getTlbUiModelFunction();
        this.notificationEventConsumer = xlsxWriterConfiguration.getNotificationEventConsumer();
        this.xlsxEnumerationDataSheet = new XlsxEnumerationDataSheet(xlsxWriterConfiguration.getXslxFileName());
        this.multipleFiles = xlsxWriterConfiguration.isMultipleFiles();
        this.path = xlsxWriterConfiguration.getPath();
        this.cellEditableCheckerFunction = xlsxWriterConfiguration.getCellEditableCheckerFunction();
        this.yLevelAsColumns = xlsxWriterConfiguration.isyLevelAsColumns();
        this.xlsAspectColumnService = xlsAspectColumnService;
    }

    public List<String> draw() throws IOException, RewritableFileOpenException {
        ArrayList<String> unsupportedRoleList = new ArrayList<String>();
        XSSFWorkbook workbook = new XSSFWorkbook();
        List sortedRoles = this.xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().sorted(Comparator.comparing(XbrlReportRole::getCompareString)).collect(Collectors.toList());
        new XlsxContentSheet(workbook, this.xbrlPackage, sortedRoles, null, this.currency);
        int totalRoles = this.xbrlPackage.getXbrlReport().getXbrlReportRoles().size();
        List roleNames = this.xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().sorted(Comparator.comparing(XbrlReportRole::getCompareString)).map(XbrlReportRole::getTitle).collect(Collectors.toList());
        List sheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        for (int i = 0; i < sortedRoles.size(); ++i) {
            FileOutputStream out;
            String fileName = this.xslxFileName;
            String sheetTitle = (String)sheetNames.get(i);
            if (this.multipleFiles) {
                workbook = new XSSFWorkbook();
                fileName = FilenameUtils.concat((String)this.path, (String)(sheetTitle + ".xlsx"));
            }
            XbrlReportRole xbrlReportRole = (XbrlReportRole)sortedRoles.get(i);
            int currentStage = i + 1;
            this.sendNotificationEvent(totalRoles, xbrlReportRole, currentStage);
            try {
                out = new FileOutputStream(fileName);
            }
            catch (FileNotFoundException e) {
                throw new RewritableFileOpenException();
            }
            TLBUiModel tlbUiModel = (TLBUiModel)this.tlbUiModelFunction.apply(xbrlReportRole);
            tlbUiModel.getEnumerations().forEach((arg_0, arg_1) -> ((XlsxEnumerationDataSheet)this.xlsxEnumerationDataSheet).add(arg_0, arg_1));
            try {
                XslxSheet xslxSheet = new XslxSheet(workbook, xbrlReportRole, sheetTitle, tlbUiModel, this.xlsxEnumerationDataSheet, this.xlsxWriteAspectData, this.xlsxWriteAxisId, this.cellEditableCheckerFunction, this.yLevelAsColumns);
                if (this.yLevelAsColumns) {
                    this.xlsAspectColumnService.drawRoleWithYLevelColumns(xslxSheet, tlbUiModel);
                } else {
                    xslxSheet.draw(tlbUiModel);
                }
            }
            catch (UnsupportedAlternativeExportRoleException e) {
                unsupportedRoleList.add(xbrlReportRole.getSystemId());
            }
            workbook.write((OutputStream)out);
            out.close();
        }
        if (!this.multipleFiles) {
            this.xlsxEnumerationDataSheet.drawEnumerationsPage(workbook);
        }
        return unsupportedRoleList;
    }

    private void sendNotificationEvent(int totalRoles, XbrlReportRole xbrlReportRole, int currentStage) {
        NotificationEvent notificationEvent = new NotificationEvent();
        notificationEvent.setTitle(xbrlReportRole.getTitle());
        notificationEvent.setTotalNumberOfStages(Integer.valueOf(totalRoles));
        notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
        Float progress = Float.valueOf(Float.valueOf(currentStage).floatValue() / (float)totalRoles);
        notificationEvent.setProgress(progress);
        this.notificationEventConsumer.accept(notificationEvent);
    }

    public List<String> getUnsupportedRoleList() {
        return this.unsupportedRoleList;
    }

    public void setUnsupportedRoleList(List<String> unsupportedRoleList) {
        this.unsupportedRoleList = unsupportedRoleList;
    }
}

