/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxEnumerationDataSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition.XslxPresentationDefinitionWriter;

public class XslxPresentationDefinitionSheet {
    private static final Logger log = LoggerFactory.getLogger(XslxPresentationDefinitionSheet.class);
    private final XSSFSheet sheet;
    private final PresentationDefinitionRole presentationDefinitionRole;
    private final List<AspectCellData> cells;
    private XlsxEnumerationDataSheet xlsxEnumerationDataSheet;
    private CellStyle CELL_STYLE_BORDERED;
    private CellStyle CELL_STYLE_HEADER;
    private CellStyle CELL_STYLE_DISABLED;
    private List<String> periodsKeys = new ArrayList();
    private int sizeTable;
    public static final int TABLE_TOP = 4;
    private final XslxPresentationDefinitionWriter.CellEditableCheckerFunction cellEditableCheckerFunction;
    private Map<String, List<EnumerateItem>> memEnums = new HashMap();

    public XslxPresentationDefinitionSheet(XSSFWorkbook workbook, PresentationDefinitionRole role, List<AspectCellData> cells, String sheetTitle, XlsxEnumerationDataSheet xlsxEnumerationDataSheet, XslxPresentationDefinitionWriter.CellEditableCheckerFunction cellEditableCheckerFunction, Map<String, List<EnumerateItem>> memEnums) {
        this.presentationDefinitionRole = role;
        this.cells = cells;
        this.xlsxEnumerationDataSheet = xlsxEnumerationDataSheet;
        this.cellEditableCheckerFunction = cellEditableCheckerFunction;
        this.memEnums = memEnums;
        this.sheet = workbook.createSheet(sheetTitle);
        this.drawRoleInfo(workbook);
        this.createDefaultStyle();
        this.createBoldStyle();
        this.createDisabledStyle();
        this.drawTableHeader();
        this.drawData();
        this.setWidths();
    }

    private void drawData() {
        int offsetVertical = 5;
        String previousName = null;
        HashMap dimensionsValue = new HashMap();
        HashMap periods = new HashMap(this.periodsKeys.size());
        AspectCellData previous = null;
        ArrayList sortedCells = new ArrayList();
        this.cells.stream().map(aspectCellData -> aspectCellData.getConcept().getAspectValue()).sorted().collect(Collectors.toSet()).forEach(concept -> {
            List cellsByConcept = this.cells.stream().filter(aspectCellData -> aspectCellData.getConcept().getAspectValue().equals(concept)).sorted(Comparator.comparing(AspectCellData::buildDimensionHash)).collect(Collectors.toList());
            sortedCells.addAll(cellsByConcept);
        });
        for (AspectCellData cellData : sortedCells) {
            AspectData conceptAspect = cellData.getConcept();
            String conceptName = this.presentationDefinitionRole.getConcepts().stream().filter(c -> ((String)c.getKey()).equals(conceptAspect.getAspectValue())).findFirst().map(Pair::getValue).orElse(null);
            List dimensions = this.presentationDefinitionRole.getDimensions();
            if (conceptName == null) continue;
            if (!(previousName == null || conceptName.equals(previousName) && previous.buildDimensionHash().equals(cellData.buildDimensionHash()))) {
                this.writeData(previousName, dimensionsValue, periods, offsetVertical, previous.getConcept(), previous.getDimensions());
                dimensionsValue = dimensions != null ? new HashMap(this.presentationDefinitionRole.getDimensions().size()) : new HashMap();
                periods = new HashMap(this.periodsKeys.size());
                ++offsetVertical;
            }
            if (dimensions != null) {
                this.groupDimensions(dimensionsValue, cellData, dimensions);
            }
            this.groupPeriods(periods, cellData, this.presentationDefinitionRole);
            previousName = conceptName;
            previous = cellData;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.cells)) {
            this.writeData(previousName, dimensionsValue, periods, offsetVertical, previous.getConcept(), previous.getDimensions());
        }
    }

    private void groupPeriods(Map<String, String> periods, AspectCellData cellData, PresentationDefinitionRole presentationDefinitionRole) {
        String aspectValue = cellData.getPeriodAspect().getAspectValue();
        for (String period : this.periodsKeys) {
            if (!aspectValue.equals(period)) continue;
            periods.put(period, cellData.getCellValue());
        }
    }

    private void groupDimensions(Map<String, String> dimensionsValue, AspectCellData cellData, List<Pair<String, String>> dimensions) {
        for (Pair<String, String> d : dimensions) {
            AspectData aspectData = cellData.getDimensions().stream().filter(dim -> dim.getAspect().equals(d.getKey())).findFirst().orElse(null);
            String key = (String)d.getKey();
            if (aspectData != null) {
                String aspectValue;
                if (dimensionsValue.containsKey(key)) {
                    if (!dimensionsValue.get(key).equals("")) continue;
                    aspectValue = aspectData.getAspectValue();
                    if (!this.memEnums.isEmpty() && this.memEnums.containsKey(key)) {
                        aspectValue = this.getDimensionValue(key, aspectValue);
                    }
                    dimensionsValue.replace(key, aspectValue);
                    continue;
                }
                aspectValue = aspectData.getAspectValue();
                if (!this.memEnums.isEmpty() && this.memEnums.containsKey(key)) {
                    aspectValue = this.getDimensionValue(key, aspectValue);
                }
                dimensionsValue.put((String)d.getKey(), aspectValue);
                continue;
            }
            if (dimensionsValue.containsKey(key)) continue;
            dimensionsValue.put(key, "");
        }
    }

    private String getDimensionValue(String key, String aspectValue) {
        return (aspectValue = this.getDimensionValueFromMember(key, aspectValue)) == null ? "" : aspectValue;
    }

    private String getDimensionValueFromMember(String key, String aspectValue) {
        return ((List)this.memEnums.get(key)).stream().filter(value -> value.getMember().equals(aspectValue)).findFirst().map(EnumerateItem::getLabel).orElse(null);
    }

    private void writeData(String previousName, Map<String, String> dimensions, Map<String, String> periods, int offsetVertical, AspectData aspectData, List<AspectData> previousDimensions) {
        int offsetHorizontal = 0;
        if (previousName != null) {
            XSSFRow row = this.sheet.createRow(offsetVertical);
            XSSFCell cell = row.createCell(offsetHorizontal++);
            cell.setCellStyle(this.CELL_STYLE_HEADER);
            cell.setCellValue(previousName);
            List dim = this.presentationDefinitionRole.getDimensions();
            if (dim != null) {
                for (Pair d : dim) {
                    cell = row.createCell(offsetHorizontal++);
                    cell.setCellStyle(this.CELL_STYLE_BORDERED);
                    if (this.xlsxEnumerationDataSheet.getEnumPageItemsMap().containsKey(d.getKey())) {
                        this.addEnumConstraintsToCell((Cell)cell, this.xlsxEnumerationDataSheet.getEnumReference((String)d.getKey()));
                    }
                    cell.setCellValue(dimensions.get(d.getKey()));
                }
            }
            for (String period : this.periodsKeys) {
                cell = row.createCell(offsetHorizontal++);
                cell.setCellStyle(this.CELL_STYLE_BORDERED);
                String value = periods.get(period);
                String aspectValue = aspectData.getAspectValue();
                if (this.xlsxEnumerationDataSheet.getEnumPageItemsMap().containsKey(aspectValue)) {
                    this.addEnumConstraintsToCell((Cell)cell, this.xlsxEnumerationDataSheet.getEnumReference(aspectValue));
                    String newValue = this.getValueForConstraince(value, aspectValue);
                    cell.setCellValue(newValue);
                    continue;
                }
                cell.setCellValue(value);
            }
        }
    }

    private String getValueForConstraince(String value, String aspectValue) {
        Map mapItems = this.xlsxEnumerationDataSheet.getEnumPageItemsMap();
        XlsxEnumerationDataSheet.EnumPageItem pageItem = (XlsxEnumerationDataSheet.EnumPageItem)mapItems.get(aspectValue);
        if (pageItem == null) {
            return value;
        }
        String memberValue = pageItem.getEnumerateItems().stream().filter(item -> item.getMember().equals(value)).findFirst().map(EnumerateItem::getLabel).orElse(null);
        return StringUtils.isNotEmpty((CharSequence)memberValue) ? memberValue : value;
    }

    private void drawTableHeader() {
        XSSFRow row = this.sheet.createRow(4);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f");
        cell.setCellStyle(this.CELL_STYLE_HEADER);
        List dimensions = this.presentationDefinitionRole.getDimensions();
        int i = 1;
        if (dimensions != null) {
            for (Pair d : dimensions) {
                cell = row.createCell(i++);
                cell.setCellValue((String)d.getValue());
                cell.setCellStyle(this.CELL_STYLE_HEADER);
            }
        }
        List periods = this.presentationDefinitionRole.getPeriods();
        ArrayList<Object> periodsValues = new ArrayList<Object>();
        for (Pair pair : periods) {
            this.periodsKeys.add(pair.getKey());
            periodsValues.add(pair.getValue());
        }
        for (AspectCellData aspectCellData : this.cells) {
            String value = aspectCellData.getPeriodAspect().getAspectValue();
            if (this.periodsKeys.contains(value)) continue;
            this.periodsKeys.add(value);
            periodsValues.add(value);
        }
        for (String string : periodsValues) {
            cell = row.createCell(i++);
            cell.setCellValue(string);
            cell.setCellStyle(this.CELL_STYLE_HEADER);
        }
        this.sizeTable = i;
    }

    private void drawRoleInfo(XSSFWorkbook workbook) {
        XSSFCell cellToc = this.sheet.createRow(0).createCell(0);
        cellToc.setCellValue("TOC");
        XSSFHyperlink link = workbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        link.setAddress("'TOC'!A1");
        cellToc.setHyperlink((Hyperlink)link);
        this.sheet.createRow(1).createCell(0).setCellValue(this.presentationDefinitionRole.getRoledefinition());
        this.sheet.createRow(2).createCell(0).setCellValue(this.presentationDefinitionRole.getSystemId());
    }

    private void addEnumConstraintsToCell(Cell cell, String values) {
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRow().getRowNum(), cell.getRow().getRowNum(), cell.getColumnIndex(), cell.getColumnIndex());
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(this.sheet);
        XSSFDataValidationConstraint constraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(values);
        XSSFDataValidation dataValidation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)constraint, addressList);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setShowErrorBox(true);
        this.sheet.addValidationData((DataValidation)dataValidation);
    }

    private void setWidths() {
        this.sheet.setColumnWidth(0, 12750);
        for (int x = 1; x < this.sizeTable; ++x) {
            this.sheet.setColumnWidth(x, 5100);
        }
    }

    public void createDefaultStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        this.CELL_STYLE_BORDERED = style;
    }

    public void createBoldStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont defaultFont = this.sheet.getWorkbook().createFont();
        defaultFont.setFontHeightInPoints((short)10);
        defaultFont.setFontName("Arial");
        defaultFont.setColor(IndexedColors.BLACK.getIndex());
        defaultFont.setItalic(false);
        style.setFont((Font)defaultFont);
        this.CELL_STYLE_HEADER = style;
    }

    public void createDisabledStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.CELL_STYLE_DISABLED = style;
    }
}

