/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.DeltaTagNameNotCorrectException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model_main.Template;

public class DeltaXmlParser {
    private static final Logger log = LoggerFactory.getLogger(DeltaXmlParser.class);
    private static final QName TEMPLATE_QNAME = new QName("template");
    private static final QName CREATE_DATE_ATTR_QNAME = new QName("createDate");
    private static final QName NAME_ATTR_QNAME = new QName("name");
    private static final QName VERSION_ATTR_QNAME = new QName("version");
    private static final QName ENTRYPOINT_ATTR_QNAME = new QName("entryPoint");
    private static final QName TAXONOMY_VERSION_ATTR_QNAME = new QName("taxonomyVersion");
    private Set<Namespace> namespaces = new HashSet();
    private final Template template;

    public DeltaXmlParser(Template template, InputStream inputStream) throws DeltaTagNameNotCorrectException, XbrlImportException, IncompatibleSchemaRefException {
        this.template = template;
        this.parseXml(inputStream);
    }

    private void parseXml(InputStream inputStream) throws DeltaTagNameNotCorrectException, IncompatibleSchemaRefException, XbrlImportException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BOMInputStream(inputStream), StandardCharsets.UTF_8));
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.peek();
                this.processEvent(xmlEvent);
                xmlEventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            if (e.getMessage().contains("The entity name must immediately follow the '&' in the entity reference.") || e.getMessage().contains("must not contain") || e.getMessage().contains("must be followed by either attribute specifications")) {
                throw new DeltaTagNameNotCorrectException("\u0422\u0435\u0433 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0434\u0435\u043b\u044c\u0442\u044b \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0441\u0438\u043c\u0432\u043e\u043b");
            }
        }
        catch (Exception e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processEvent(XMLEvent xmlEvent) throws XbrlImportException, IncompatibleSchemaRefException {
        try {
            if (xmlEvent.isStartDocument()) return;
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                Iterator<Namespace> it = startElement.getNamespaces();
                while (it.hasNext()) {
                    Namespace ns = it.next();
                    this.namespaces.add(ns);
                }
                this.parseSchemeRefStartEvents(startElement);
                return;
            }
            if (!xmlEvent.isCharacters() && !xmlEvent.isEndElement() && !xmlEvent.isEndDocument()) return;
        }
        catch (Exception e) {
            if (e instanceof IncompatibleSchemaRefException) {
                throw (IncompatibleSchemaRefException)((Object)e);
            }
            log.info("Parsing error: " + xmlEvent.getLocation());
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlImportException();
        }
    }

    private void parseSchemeRefStartEvents(StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, TEMPLATE_QNAME)) {
            this.template.setCreateDate((java.util.Date)Date.valueOf(startElement.getAttributeByName(CREATE_DATE_ATTR_QNAME).getValue()));
            this.template.setName(startElement.getAttributeByName(NAME_ATTR_QNAME).getValue());
            this.template.setVersion(Integer.parseInt(startElement.getAttributeByName(VERSION_ATTR_QNAME).getValue()));
            this.template.setEntryPoint(startElement.getAttributeByName(ENTRYPOINT_ATTR_QNAME).getValue());
            this.template.setTaxonomyVersion(startElement.getAttributeByName(TAXONOMY_VERSION_ATTR_QNAME).getValue());
        }
    }
}

