/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.controller.import_export.ExportTemplateStruct;
import ru.cbr.xbrl.converter.model.TemplateMapping;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.service.TemplateService;
import ru.cbr.xbrl.converter.utils.StaxPrettyPrintHandler;

public class MappingXmlWriter {
    private static final Logger log = LoggerFactory.getLogger(MappingXmlWriter.class);
    private final XbrlReport xbrlReport;
    private final ExportTemplateStruct exportTemplateStruct;
    private final OutputStream outputStream;
    private final TemplateService templateService;
    private final XMLStreamWriter xmlOut;
    private ObjectMapper objectMapper = new ObjectMapper();

    public MappingXmlWriter(XbrlReport xbrlReport, ExportTemplateStruct exportTemplateStruct, OutputStream outputStream, TemplateService templateService) throws XMLStreamException, UnsupportedEncodingException {
        this.xbrlReport = xbrlReport;
        this.exportTemplateStruct = exportTemplateStruct;
        this.outputStream = outputStream;
        this.templateService = templateService;
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
        StaxPrettyPrintHandler handler = new StaxPrettyPrintHandler(xmlStreamWriter);
        this.xmlOut = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.prepare();
        this.writeData();
    }

    private void prepare() {
        try {
            this.xmlOut.writeStartDocument("UTF-8", "1.0");
            this.xmlOut.writeCharacters(System.getProperty("line.separator"));
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void writeData() {
        try {
            TemplateMapping templateMapping = new TemplateMapping();
            List selectedRoles = this.xbrlReport.getXbrlReportRoles().stream().filter(xbrlReportRole -> this.exportTemplateStruct.getReportRoleIds().contains(xbrlReportRole.getId())).collect(Collectors.toList());
            for (XbrlReportRole selectedRole : selectedRoles) {
                TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue((Reader)new StringReader(selectedRole.getStaticStructureJson()), TableLinkBaseStructure.class);
                LinkedHashMap xCodes = new LinkedHashMap();
                tableLinkBaseStructure.getXAxis().getAxisMemberHierarchyList().remove(0);
                this.templateService.fillAxisCodes(xCodes, tableLinkBaseStructure.getXAxis(), "", new ArrayList());
                LinkedHashMap yCodes = new LinkedHashMap();
                this.templateService.fillAxisCodes(yCodes, tableLinkBaseStructure.getYAxis(), "", new ArrayList());
                LinkedHashMap notWashedZCodes = new LinkedHashMap();
                this.templateService.fillAxisCodes(notWashedZCodes, tableLinkBaseStructure.getZAxis(), "", new ArrayList());
                Map zCodes = this.templateService.processZCodes(notWashedZCodes);
                String roleCode = selectedRole.getRoleId();
                yCodes.keySet().forEach(yCode -> xCodes.keySet().forEach(xCode -> {
                    String factCode = roleCode + ":" + xCode + ":" + yCode;
                    ArrayList aspectData = new ArrayList();
                    aspectData.addAll((Collection)xCodes.get(xCode));
                    aspectData.addAll((Collection)yCodes.get(yCode));
                    aspectData.addAll(zCodes.containsKey("1") ? (Collection)zCodes.get("1") : (Collection)zCodes.getOrDefault("1N", Collections.emptyList()));
                    templateMapping.getCodesAspectData().put(factCode, aspectData);
                }));
                LinkedHashMap aspects = new LinkedHashMap();
                LinkedHashMap aspectData = new LinkedHashMap();
                for (String xCode : xCodes.keySet()) {
                    aspectData.put(xCode, xCodes.get(xCode));
                }
                aspects.put("X", aspectData);
                aspectData = new LinkedHashMap();
                for (String yCode2 : yCodes.keySet()) {
                    aspectData.put(yCode2, yCodes.get(yCode2));
                }
                aspects.put("Y", aspectData);
                aspectData = new LinkedHashMap();
                for (String zCode : zCodes.keySet()) {
                    List zDims = (List)zCodes.get(zCode);
                    zDims.forEach(dim -> {
                        String dimCode = "Z:" + dim.getAspect();
                        if (!templateMapping.getZDimensions().containsKey(dimCode)) {
                            templateMapping.getZDimensions().put(dimCode, dim);
                        }
                    });
                    aspectData.put(zCode, zDims);
                }
                aspects.put("Z", aspectData);
                templateMapping.getRolesAspectData().put(roleCode, aspects);
            }
            String json = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter().writeValueAsString((Object)templateMapping);
            this.xmlOut.writeStartElement("mapping");
            this.xmlOut.writeCharacters(json);
            this.xmlOut.writeCharacters(System.getProperty("line.separator"));
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndDocument();
            OutputStreamWriter osw = new OutputStreamWriter(this.outputStream);
            osw.write("");
            osw.flush();
            this.xmlOut.flush();
            this.xmlOut.close();
        }
        catch (IOException | XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

