/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.utils.StaxPrettyPrintHandler;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.MetricType;

public class PerformanceMetricsWriter {
    private static final Logger log = LoggerFactory.getLogger(PerformanceMetricsWriter.class);
    private final OutputStream outputStream;
    private final XMLStreamWriter xmlOut;

    public PerformanceMetricsWriter(OutputStream outputStream) throws XMLStreamException {
        this.outputStream = outputStream;
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
        StaxPrettyPrintHandler handler = new StaxPrettyPrintHandler(xmlStreamWriter);
        this.xmlOut = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.writeBaseInfo();
    }

    private void writeBaseInfo() {
        try {
            this.xmlOut.writeStartDocument("UTF-8", "1.0");
            this.xmlOut.writeCharacters(System.getProperty("line.separator"));
            this.xmlOut.writeStartElement("metrics");
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public synchronized void writeMetricValue(String reportName, MetricType metricType, double value) {
        try {
            this.xmlOut.writeStartElement("metric");
            this.xmlOut.writeAttribute("report", reportName);
            this.xmlOut.writeAttribute("type", metricType.toString());
            this.xmlOut.writeAttribute("value", Double.toString(value));
            this.xmlOut.writeAttribute("moment", LocalTime.now().withNano(0).toString());
            this.xmlOut.writeEndElement();
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void closeWriting() {
        try {
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndDocument();
            OutputStreamWriter osw = new OutputStreamWriter(this.outputStream);
            osw.write("");
            osw.flush();
            this.xmlOut.flush();
            this.xmlOut.close();
        }
        catch (IOException | XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

