/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ru.cbr.xbrl.converter.exception.XMLSyntaxException;
import ru.cbr.xbrl.converter.model.ReportData;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.RepParamsXmlParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class RepParamsXmlParser {
    private static final Logger log = LoggerFactory.getLogger(RepParamsXmlParser.class);
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    private static final QName REPORT_QNAME = new QName("Report");
    private static final QName FILENAME_QNAME = new QName("filename");
    private static final QName ENTRYPOINT_QNAME = new QName("entrypoint");
    private static final QName REPORTDATE_QNAME = new QName("reportdate");
    private static final QName REF_PERIOD_START_QNAME = new QName("refPeriodStart");
    private static final QName REF_PERIOD_END_QNAME = new QName("refPeriodEnd");
    private static final QName PERFORMANCE_INDICATORS_QNAME = new QName("PerformanceIndicators");
    private static final QName PERFORMANCE_CPU_QNAME = new QName("CPU");
    private static final QName PERFORMANCE_HDD_QNAME = new QName("HDD");
    private static final QName PERFORMANCE_RAM_QNAME = new QName("RAM");
    private static final QName REPORT_PARAMS_QNAME = new QName("ReportParams");
    private static final QName CURRENT_PERIOD_END_QNAME = new QName("CurrentPeriodEnd");
    private static final QName CURRENT_PERIOD_START_QNAME = new QName("CurrentPeriodStart");
    private static final QName START_QUART_QNAME = new QName("startQuart");
    private static final QName REG_START_INS_YEAR_QNAME = new QName("RegStartInsYear");
    private List<ReportData> reportDataList = new ArrayList();
    private ReportData reportData;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReportData> parseXml(File xmlFile, boolean onlyValidationMode) throws Exception {
        this.validateAgainstXSD(xmlFile, onlyValidationMode);
        try (FileInputStream xmlInputStream = new FileInputStream(xmlFile);){
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)xmlInputStream), StandardCharsets.UTF_8));
            while (xmlEventReader.hasNext()) {
                block25: {
                    EndElement endElement;
                    XMLEvent xmlEvent;
                    block23: {
                        StartElement startElement;
                        block24: {
                            xmlEvent = xmlEventReader.peek();
                            if (!xmlEvent.isStartElement()) break block23;
                            startElement = xmlEvent.asStartElement();
                            if (!startElement.getName().equals(REPORT_QNAME)) break block24;
                            this.reportData = new ReportData();
                            String fileName = startElement.getAttributeByName(FILENAME_QNAME).getValue();
                            if (!StringUtils.isNotBlank((CharSequence)fileName)) throw new XMLSyntaxException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 filename \u0437\u0430\u0434\u043d\u0430\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e: " + fileName);
                            if (!fileName.endsWith(".xml") && !fileName.endsWith(".xbrl")) {
                                throw new XMLSyntaxException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 filename \u0437\u0430\u0434\u043d\u0430\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e: " + fileName);
                            }
                            this.reportData.setFilename(fileName);
                            Attribute reportDateAttribute = startElement.getAttributeByName(REPORTDATE_QNAME);
                            if (reportDateAttribute != null) {
                                this.reportData.setReportDate(formatter.parse(GregorianDateMatcher.matches((String)reportDateAttribute.getValue(), (String)REPORTDATE_QNAME.toString())));
                            }
                            Date date = formatter.parse(GregorianDateMatcher.matches((String)startElement.getAttributeByName(REF_PERIOD_END_QNAME).getValue(), (String)REF_PERIOD_END_QNAME.toString()));
                            System.out.println("date:>>" + date);
                            this.reportData.setRefPeriodEnd(date);
                            break block25;
                        }
                        if (startElement.getName().equals(PERFORMANCE_INDICATORS_QNAME)) {
                            Attribute ramAttribute;
                            Attribute hddAttribute;
                            Attribute cpuAttribute = startElement.getAttributeByName(PERFORMANCE_CPU_QNAME);
                            if (cpuAttribute != null) {
                                this.reportData.setCpuCheckRate(Integer.parseInt(startElement.getAttributeByName(PERFORMANCE_CPU_QNAME).getValue()));
                            }
                            if ((hddAttribute = startElement.getAttributeByName(PERFORMANCE_HDD_QNAME)) != null) {
                                this.reportData.setHddCheckRate(Integer.parseInt(hddAttribute.getValue()));
                            }
                            if ((ramAttribute = startElement.getAttributeByName(PERFORMANCE_RAM_QNAME)) != null) {
                                this.reportData.setRamCheckRate(Integer.parseInt(ramAttribute.getValue()));
                            }
                        }
                        break block25;
                    }
                    if (xmlEvent.isEndElement() && (endElement = xmlEvent.asEndElement()).getName().equals(REPORT_QNAME)) {
                        this.reportDataList.add(this.reportData);
                    }
                }
                xmlEventReader.nextEvent();
            }
            List list = this.reportDataList;
            return list;
        }
        catch (XMLSyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    private void validateAgainstXSD(File xmlFile, boolean onlyValidationMode) throws XMLSyntaxException, IOException, SAXException {
        ClassPathResource xsdResource = new ClassPathResource(onlyValidationMode ? "xsd/rep_params_validation/ValidationModeRepParamsValidator.xsd" : "xsd/rep_params_validation/PerformanceModeRepParamsValidator.xsd");
        try (InputStream xsdInputStream = xsdResource.getInputStream();
             FileInputStream xmlInputStream = new FileInputStream(xmlFile);){
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(xsdInputStream));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xmlInputStream));
        }
        catch (SAXParseException ex) {
            throw new XMLSyntaxException("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u0444\u0430\u0439\u043b\u0430 RepParams.xml \u043d\u0435 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 " + ex.getLineNumber());
        }
    }
}

