/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NamespaceNotFoundException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.utils.StaxPrettyPrintHandler;
import ru.cbr.xbrl.converter.xbrl.import_export.XbrlWriter;

public class XbrlXmlWriter
implements XbrlWriter {
    private static final Logger log = LoggerFactory.getLogger(XbrlXmlWriter.class);
    private final ConfigProperties.Namespace nsXbrli;
    private final ConfigProperties.Namespace nsLink;
    private final ConfigProperties.Namespace nsXlink;
    private final List<ConfigProperties.Namespace> namespaces;
    private final OutputStream outputStream;
    private final XMLStreamWriter xmlOut;
    private final String pathToXsd;
    private List<String> processedFootnoteFactList = new ArrayList();
    private List<String> processedFootnoteValueList = new ArrayList();
    private Map<String, String> footnoteValueIdMap = new HashMap();

    public XbrlXmlWriter(OutputStream outputStream, List<ConfigProperties.Namespace> namespaces, String pathToXsd) throws XMLStreamException, NamespaceNotFoundException, UnsupportedEncodingException {
        this.outputStream = outputStream;
        this.namespaces = namespaces;
        this.pathToXsd = pathToXsd;
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")));
        StaxPrettyPrintHandler handler = new StaxPrettyPrintHandler(xmlStreamWriter);
        this.xmlOut = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.nsXbrli = this.findNamespaceByPrefix("xbrli");
        this.nsLink = this.findNamespaceByPrefix("link");
        this.nsXlink = this.findNamespaceByPrefix("xlink");
    }

    public void prepare(Supplier<String> currentVersion) throws XbrlExportException {
        HashSet<String> processedPrefixes = new HashSet<String>();
        try {
            this.xmlOut.setDefaultNamespace(this.nsXbrli.getUri());
            this.xmlOut.writeStartDocument("UTF-8", "1.0");
            this.xmlOut.writeCharacters(System.getProperty("line.separator"));
            this.xmlOut.writeComment(" Instance generator - Anketa-redaktor XBRL ver " + currentVersion.get() + " ");
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "xbrl", this.nsXbrli.getUri());
            for (ConfigProperties.Namespace ns : this.namespaces) {
                String prefix = ns.getPrefix();
                if (processedPrefixes.contains(prefix)) continue;
                this.xmlOut.writeNamespace(prefix, ns.getUri());
                processedPrefixes.add(prefix);
            }
            this.writeSchemaRef();
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlContext(XbrlContext xbrlContext) throws XbrlExportException {
        try {
            this.writeContext(xbrlContext);
        }
        catch (IOException | XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlUnit(XbrlUnit xbrlUnit) throws XbrlExportException {
        try {
            this.writeUnit(xbrlUnit);
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlValue(XbrlValue xbrlValue) throws XbrlExportException {
        try {
            this.writeValue(xbrlValue);
        }
        catch (XMLStreamException | NamespaceNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlFootnote(XbrlFootnote xbrlFootnote) throws XbrlExportException {
        try {
            this.writeFootnote(xbrlFootnote);
        }
        catch (XMLStreamException | NamespaceNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void finalize() throws XbrlExportException {
        try {
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndDocument();
            this.xmlOut.flush();
            this.xmlOut.close();
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    private void writeSchemaRef() throws XMLStreamException {
        this.xmlOut.writeEmptyElement(this.nsLink.getPrefix(), "schemaRef", this.nsLink.getUri());
        this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "type", "simple");
        this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "href", this.pathToXsd);
    }

    private void writeContextEnity(XbrlContext context) throws XMLStreamException, IOException {
        this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "entity", this.nsXbrli.getUri());
        this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "identifier", this.nsXbrli.getUri());
        this.xmlOut.writeAttribute("scheme", context.getScheme());
        this.xmlOut.writeCharacters(context.getIdentifier());
        this.xmlOut.writeEndElement();
        this.writeContextSegment(context);
        this.xmlOut.writeEndElement();
    }

    private void writeContextPeriod(XbrlContext context) throws XMLStreamException {
        this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "period", this.nsXbrli.getUri());
        String[] periodDates = context.getPeriod().split(",");
        if (periodDates.length == 1) {
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "instant", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters(periodDates[0]);
            this.xmlOut.writeEndElement();
        } else {
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "startDate", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters(StringUtils.trim((String)periodDates[0]));
            this.xmlOut.writeEndElement();
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "endDate", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters(StringUtils.trim((String)periodDates[1]));
            this.xmlOut.writeEndElement();
        }
        this.xmlOut.writeEndElement();
    }

    private void writeContextScenario(XbrlContext context) throws XMLStreamException, IOException {
        if (StringUtils.isNotBlank((CharSequence)context.getScenario()) && !StringUtils.isWhitespace((CharSequence)context.getScenario())) {
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "scenario", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters("");
            this.xmlOut.flush();
            OutputStreamWriter osw = new OutputStreamWriter(this.outputStream);
            osw.write(context.getScenario());
            osw.flush();
            this.xmlOut.writeEndElement();
        }
    }

    private void writeContextSegment(XbrlContext context) throws XMLStreamException, IOException {
        if (StringUtils.isNotBlank((CharSequence)context.getSegment()) && !StringUtils.isWhitespace((CharSequence)context.getSegment())) {
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "segment", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters("");
            this.xmlOut.flush();
            OutputStreamWriter osw = new OutputStreamWriter(this.outputStream);
            osw.write(context.getSegment());
            osw.flush();
            this.xmlOut.writeEndElement();
        }
    }

    private void writeContext(XbrlContext context) throws XMLStreamException, IOException {
        this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "context", this.nsXbrli.getUri());
        this.xmlOut.writeAttribute("id", context.getXbrlContextId().getContextId());
        this.writeContextEnity(context);
        this.writeContextPeriod(context);
        this.writeContextScenario(context);
        this.xmlOut.writeEndElement();
    }

    private void writeUnit(XbrlUnit unit) throws XMLStreamException {
        this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "unit", this.nsXbrli.getUri());
        this.xmlOut.writeAttribute("id", unit.getXbrlUnitId().getUnitId());
        String[] contents = unit.getContent().split("\\s*/\\s*");
        if (contents.length == 1) {
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "measure", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters(unit.getContent());
            this.xmlOut.writeEndElement();
        } else {
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "divide", this.nsXbrli.getUri());
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "unitNumerator", this.nsXbrli.getUri());
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "measure", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters(contents[0]);
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndElement();
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "unitDenominator", this.nsXbrli.getUri());
            this.xmlOut.writeStartElement(this.nsXbrli.getPrefix(), "measure", this.nsXbrli.getUri());
            this.xmlOut.writeCharacters(contents[1]);
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndElement();
        }
        this.xmlOut.writeEndElement();
    }

    private void writeValue(XbrlValue xbrlValue) throws NamespaceNotFoundException, XMLStreamException {
        ConfigProperties.Namespace elementNamespace = this.findNamespaceByUri(xbrlValue.getElementUri());
        this.xmlOut.writeStartElement(elementNamespace.getPrefix(), xbrlValue.getElementName(), elementNamespace.getUri());
        this.xmlOut.writeAttribute("contextRef", xbrlValue.getXbrlValueId().getXbrlContextId());
        if (xbrlValue.getDecimals() != null) {
            this.xmlOut.writeAttribute("decimals", xbrlValue.getDecimals().toString());
        } else if (xbrlValue.getPrecision() != null) {
            this.xmlOut.writeAttribute("precision", xbrlValue.getPrecision().toString());
        }
        if (xbrlValue.getXbrlUnit() != null) {
            this.xmlOut.writeAttribute("unitRef", xbrlValue.getXbrlUnit());
        }
        if (xbrlValue.getId() != null) {
            this.xmlOut.writeAttribute("id", xbrlValue.getId());
        }
        this.xmlOut.writeCharacters(xbrlValue.getValue());
        this.xmlOut.writeEndElement();
    }

    public void writeFootnoteStartTag() throws XbrlExportException {
        try {
            this.xmlOut.writeStartElement(this.nsLink.getPrefix(), "footnoteLink", this.nsLink.getUri());
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "type", "extended");
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "role", "http://www.xbrl.org/2003/role/link");
            this.processedFootnoteFactList.clear();
            this.processedFootnoteValueList.clear();
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeFootnoteEndTag() throws XbrlExportException {
        try {
            this.xmlOut.writeEndElement();
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    private void writeFootnote(XbrlFootnote xbrlFootnote) throws XMLStreamException, NamespaceNotFoundException {
        if (xbrlFootnote == null) {
            return;
        }
        String footnoteFactId = xbrlFootnote.getFootnoteFactId();
        if (StringUtils.isBlank((CharSequence)footnoteFactId)) {
            return;
        }
        String footnoteContent = xbrlFootnote.getContent();
        if (StringUtils.isBlank((CharSequence)footnoteContent)) {
            return;
        }
        if (!this.processedFootnoteFactList.contains(footnoteFactId)) {
            this.xmlOut.writeStartElement(this.nsLink.getPrefix(), "loc", this.nsLink.getUri());
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "type", "locator");
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "href", "#" + footnoteFactId);
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "label", "fact_" + footnoteFactId);
            this.xmlOut.writeEndElement();
            this.processedFootnoteFactList.add(footnoteFactId);
        }
        if (!this.processedFootnoteValueList.contains(footnoteContent)) {
            this.xmlOut.writeStartElement(this.nsLink.getPrefix(), "footnote", this.nsLink.getUri());
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "type", "resource");
            String footnoteId = UUID.randomUUID().toString();
            String footnoteLabel = "footnote-" + footnoteId;
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "label", footnoteLabel);
            this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "role", "http://www.xbrl.org/2003/role/footnote");
            this.xmlOut.writeAttribute("xml", "", "lang", "ru");
            this.xmlOut.writeCharacters(footnoteContent);
            this.xmlOut.writeEndElement();
            this.processedFootnoteValueList.add(footnoteContent);
            this.footnoteValueIdMap.put(footnoteContent, footnoteLabel);
        }
        this.xmlOut.writeStartElement(this.nsLink.getPrefix(), "footnoteArc", this.nsLink.getUri());
        this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "type", "arc");
        this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "arcrole", "http://www.xbrl.org/2003/arcrole/fact-footnote");
        this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "from", "fact_" + footnoteFactId);
        this.xmlOut.writeAttribute(this.nsXlink.getPrefix(), this.nsXlink.getUri(), "to", (String)this.footnoteValueIdMap.get(footnoteContent));
        this.xmlOut.writeAttribute("order", StringUtils.isBlank((CharSequence)xbrlFootnote.getFootnoteNo()) ? "" : xbrlFootnote.getFootnoteNo());
        this.xmlOut.writeEndElement();
    }

    private ConfigProperties.Namespace findNamespaceByPrefix(String prefix) throws NamespaceNotFoundException {
        ConfigProperties.Namespace n = this.namespaces.stream().filter(ns -> ns.getPrefix().equals(prefix)).findFirst().get();
        if (n == null) {
            throw new NamespaceNotFoundException();
        }
        return n;
    }

    private ConfigProperties.Namespace findNamespaceByUri(String uri) throws NamespaceNotFoundException {
        ConfigProperties.Namespace n = this.namespaces.stream().filter(ns -> ns.getUri().equals(uri)).findFirst().get();
        if (n == null) {
            throw new NamespaceNotFoundException();
        }
        return n;
    }
}

