/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xblr.converter.updater;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import ru.cbr.xblr.converter.updater.ErrorCodeEnum;
import ru.cbr.xblr.converter.updater.UpdaterApplication;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class UpdaterApplication
extends JFrame
implements PropertyChangeListener,
CommandLineRunner {
    private static final String APP_PROCESS_NAME = "Anketa-redaktor XBRL.exe";
    private static final String PROGRAM_DIR_NAME = "bin";
    private static final String VERSION_FILE_NAME = "ver";
    private static final String UPDATE_DIR_NAME = "update";
    private static final String SCRIPTS_DIR_NAME = "scripts";
    private static final String PROFILE_ELECTRON_DIR_NAME = "Anketa-redaktor XBRL";
    private static final String PROFILE_PROGRAMM_DIR_NAME = "AnketaXBRL";
    private static final String UNINSTALLER_FILE_NAME = "Uninstall.exe";
    private static final String PROGRESS_PROPERTY = "progress";
    private static Logger log = LoggerFactory.getLogger(UpdaterApplication.class);
    private static BackgroundWorker worker;
    private static JProgressBar progressBar;
    private static JLabel progressLabel;
    private static JLabel actionLabel;
    private static JLabel errorLabel;
    private static JButton closeButton;
    private static ConfigurableApplicationContext context;
    private ErrorCodeEnum error = ErrorCodeEnum.NO_ERROR;

    public UpdaterApplication() {
        worker = new BackgroundWorker(this);
        worker.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static void main(String[] args) throws IOException {
        if (args != null && args.length > 0) {
            String[] splitFirst = args[0].split("=");
            String key = splitFirst[0];
            if (key.equals("md5") && splitFirst.length == 2) {
                File file = new File(splitFirst[1]);
                if (!file.exists()) {
                    System.out.println("File for md5 calculation does not exist. Exit.");
                    return;
                }
                FileInputStream is = new FileInputStream(file);
                String digest = DigestUtils.md5Hex((InputStream)is);
                System.out.println("File digest:: \r\n" + digest);
            }
            return;
        }
        SpringApplication app = new SpringApplication(new Object[]{UpdaterApplication.class});
        app.setBannerMode(Banner.Mode.OFF);
        context = app.run(args);
    }

    public void run(String ... strings) throws Exception {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(false);
            this.createAndShowGUI();
        });
    }

    private void createAndShowGUI() {
        Font openSans = new Font("SansSerif", 0, 14);
        Font openSansSemiBold = new Font("SansSerif", 0, 14);
        Color activeColor = new Color(0x66CCFF);
        UpdaterApplication frame = new UpdaterApplication();
        frame.setDefaultCloseOperation(3);
        frame.setUndecorated(true);
        frame.setResizable(false);
        frame.getContentPane().setLayout(null);
        frame.getContentPane().setBackground(new Color(15726073));
        actionLabel.setBounds(30, 65, 700, 38);
        actionLabel.setText("<html>\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043f\u043e\u044f\u0432\u0438\u0432\u0448\u0438\u0435\u0441\u044f \u043e\u043a\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u043c\u0438 \u0438 \u0434\u043e\u0436\u0434\u0438\u0442\u0435\u0441\u044c \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438</html>");
        actionLabel.setFont(openSansSemiBold);
        actionLabel.setForeground(new Color(1651268));
        frame.getContentPane().add(actionLabel);
        progressBar.setMinimum(0);
        progressBar.setMaximum(100);
        progressBar.setValue(0);
        progressBar.setBorderPainted(false);
        progressBar.setForeground(activeColor);
        progressBar.setBackground(new Color(13490400));
        progressBar.setBounds(30, 112, 714, 6);
        frame.getContentPane().add(progressBar);
        progressLabel.setBounds(30, 125, 80, 14);
        progressLabel.setText("0%");
        progressLabel.setFont(openSans);
        progressLabel.setForeground(new Color(0x888888));
        frame.getContentPane().add(progressLabel);
        closeButton.setBounds(600, 250, 140, 60);
        closeButton.addActionListener(e -> System.exit(0));
        closeButton.setFocusPainted(false);
        closeButton.setVisible(false);
        closeButton.setBorderPainted(false);
        closeButton.setContentAreaFilled(false);
        try {
            closeButton.setIcon(new ImageIcon(IOUtils.toByteArray((InputStream)new ClassPathResource("icons\\close.png").getInputStream())));
            closeButton.setRolloverEnabled(true);
            closeButton.setRolloverIcon(new ImageIcon(IOUtils.toByteArray((InputStream)new ClassPathResource("icons\\close-hover.png").getInputStream())));
            log.info("close button loaded.");
        }
        catch (IOException e2) {
            log.info("close button default loaded.");
            closeButton.setBounds(590, 250, 150, 31);
            closeButton.setFont(openSansSemiBold);
            closeButton.setBackground(activeColor);
            closeButton.setForeground(new Color(0xFFFFFF));
            closeButton.setText("\u0417\u0410\u041a\u0420\u042b\u0422\u042c");
        }
        frame.getContentPane().add(closeButton);
        errorLabel.setBounds(30, 170, 714, 40);
        errorLabel.setText("<html>\u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442 \u043b\u0438\u0431\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u043c\u0443 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443.</html>");
        errorLabel.setFont(new Font("SansSerif", 0, 14));
        errorLabel.setForeground(new Color(1651268));
        errorLabel.setVisible(false);
        frame.getContentPane().add(errorLabel);
        frame.setPreferredSize(new Dimension(774, 324));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        worker.execute();
    }

    private static void delete(File file) {
        if (file == null) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File childFile : files) {
            if (childFile == null || !childFile.exists()) continue;
            if (childFile.isDirectory()) {
                UpdaterApplication.delete((File)childFile);
                continue;
            }
            if (childFile.delete()) continue;
            log.info("File " + childFile.getAbsolutePath() + " COULD NOT BE DELETED");
        }
        if (!file.delete()) {
            if (file.isDirectory()) {
                log.info("Directory " + file.getAbsolutePath() + " COULD NOT BE DELETED");
            } else {
                log.info("File" + file.getAbsolutePath() + " COULD NOT BE DELETED");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            progressBar.setValue(progress);
            progressLabel.setText(progress + "%");
        }
    }

    static /* synthetic */ ErrorCodeEnum access$000(UpdaterApplication x0) {
        return x0.error;
    }

    static /* synthetic */ JLabel access$100() {
        return errorLabel;
    }

    static /* synthetic */ JButton access$200() {
        return closeButton;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ ErrorCodeEnum access$002(UpdaterApplication x0, ErrorCodeEnum x1) {
        x0.error = x1;
        return x0.error;
    }

    static /* synthetic */ void access$400(File x0) {
        UpdaterApplication.delete((File)x0);
    }

    static /* synthetic */ ConfigurableApplicationContext access$500() {
        return context;
    }

    static {
        progressBar = new JProgressBar();
        progressLabel = new JLabel();
        actionLabel = new JLabel();
        errorLabel = new JLabel();
        closeButton = new JButton();
    }
}

