const log4js = require('log4js');
const nconf = require('nconf');
const nconfFormatYaml = require('nconf-yaml');
const fs = require('fs');
const path = require('path');
const log = log4js.getLogger("app-config");

const configDefaultDev = path.normalize(__dirname + '/config.default.yml');
const configLocalDev = path.normalize(__dirname + '/config.yml');

const configDefaultProd = path.normalize(__dirname + '/../../config.default.yml');
log.info('configDefaultProd', configDefaultProd);
const configLocalProd = path.normalize(__dirname + '/../../config.yml');
log.info('configLocalProd', configLocalProd);
const configUserProd = path.normalize(process.env.appdata + '\\AnketaXBRL\\electronapp\\resources\\config.yml');
log.info('configUserProd', configUserProd);
log.info('configDefaultDev', configDefaultDev);

if (fs.existsSync(configLocalDev)) {
  log.info('Using config local-dev: ' + configLocalDev );
  nconf.file('config-local-dev', {
    file: configLocalDev,
    format: nconfFormatYaml
  });
}

nconf.file('config-default-dev', {
  file: configDefaultDev,
  format: nconfFormatYaml
});

if (fs.existsSync(configLocalProd)) {
  log.info('Using config local-prod: ' + configLocalProd );
  nconf.file('config-local-prod', {
    file: configLocalProd,
    format: nconfFormatYaml
  });
}

if (fs.existsSync(configDefaultProd)) {
  log.info('Using config default-prod: ' + configDefaultProd );
  nconf.file('config-default-prod', {
    file: configDefaultProd,
    format: nconfFormatYaml
  });
}

if (fs.existsSync(configUserProd)) {
  log.info('Using config user-prod: ' + configUserProd );
  nconf.file('config-user-prod', {
    file: configUserProd,
    format: nconfFormatYaml
  });
}

var appConfig = nconf.get("application");

if (appConfig.backend.jvmOptions.toString().toLowerCase().indexOf("-xmx") === -1) {
  var xmxParam = "-Xmx" + Math.floor(require('os').totalmem()/1048576) + "M";
  appConfig.backend.jvmOptions.unshift(xmxParam);
}

log.info("Effective configuration", JSON.stringify(appConfig, null, 4));

global.appConfig = appConfig;

module.exports = appConfig;
