/*!
 * devextreme-angular
 * Version: 17.1.6
 * Build date: Wed Sep 06 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { ElementRef, NgZone, OnDestroy, AfterContentInit, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DxDropDownBox from 'devextreme/ui/drop_down_box';
import { DxValidatorComponent } from './validator';
import { ControlValueAccessor } from '@angular/forms';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiItemComponent } from './nested/item-dxi';
export declare class DxDropDownBoxComponent extends DxComponent implements OnDestroy, AfterContentInit, ControlValueAccessor, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxDropDownBox;
    validator: DxValidatorComponent;
    acceptCustomValue: any;
    accessKey: any;
    activeStateEnabled: any;
    contentTemplate: any;
    dataSource: any;
    deferRendering: any;
    disabled: any;
    displayExpr: any;
    dropDownButtonTemplate: any;
    dropDownOptions: any;
    elementAttr: any;
    focusStateEnabled: any;
    height: any;
    hint: any;
    hoverStateEnabled: any;
    inputAttr: any;
    isValid: any;
    items: any;
    name: any;
    opened: any;
    placeholder: any;
    readOnly: any;
    rtlEnabled: any;
    showClearButton: any;
    tabIndex: any;
    text: any;
    validationError: any;
    validationMessageMode: any;
    value: any;
    valueChangeEvent: any;
    valueExpr: any;
    visible: any;
    width: any;
    onChange: any;
    onClosed: any;
    onCopy: any;
    onCut: any;
    onDisposing: any;
    onEnterKey: any;
    onFocusIn: any;
    onFocusOut: any;
    onInitialized: any;
    onInput: any;
    onKeyDown: any;
    onKeyPress: any;
    onKeyUp: any;
    onOpened: any;
    onOptionChanged: any;
    onPaste: any;
    onValueChanged: any;
    acceptCustomValueChange: any;
    accessKeyChange: any;
    activeStateEnabledChange: any;
    contentTemplateChange: any;
    dataSourceChange: any;
    deferRenderingChange: any;
    disabledChange: any;
    displayExprChange: any;
    dropDownButtonTemplateChange: any;
    dropDownOptionsChange: any;
    elementAttrChange: any;
    focusStateEnabledChange: any;
    heightChange: any;
    hintChange: any;
    hoverStateEnabledChange: any;
    inputAttrChange: any;
    isValidChange: any;
    itemsChange: any;
    nameChange: any;
    openedChange: any;
    placeholderChange: any;
    readOnlyChange: any;
    rtlEnabledChange: any;
    showClearButtonChange: any;
    tabIndexChange: any;
    textChange: any;
    validationErrorChange: any;
    validationMessageModeChange: any;
    valueChange: any;
    valueChangeEventChange: any;
    valueExprChange: any;
    visibleChange: any;
    widthChange: any;
    change(_: any): void;
    touched: () => void;
    itemsChildren: QueryList<DxiItemComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost);
    protected _createInstance(element: any, options: any): DxDropDownBox;
    writeValue(value: any): void;
    setDisabledState(isDisabled: boolean): void;
    registerOnChange(fn: (_: any) => void): void;
    registerOnTouched(fn: () => void): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
    ngAfterContentInit(): void;
}
export declare class DxDropDownBoxModule {
}
