/**
 * DevExtreme (core/memorized_callbacks.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var $ = require("../core/renderer");
var MemorizedCallbacks = function() {
    var memory = [];
    var callbacks = $.Callbacks();
    this.add = function(fn) {
        $.each(memory, function(_, item) {
            fn.apply(fn, item)
        });
        callbacks.add(fn)
    };
    this.remove = function(fn) {
        callbacks.remove(fn)
    };
    this.fire = function() {
        memory.push(arguments);
        callbacks.fire.apply(callbacks, arguments)
    }
};
module.exports = MemorizedCallbacks;
