/*!
 * DevExtreme (dx.viz-web.debug.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            exports: {},
            id: moduleId,
            loaded: false
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.loaded = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.p = "";
    return __webpack_require__(0)
}([
    /*!******************************!*\
      !*** multi dx.viz-web.debug ***!
      \******************************/
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! c:\Projects\DevExtreme\17.1\BuildLabel\Temp\DevExtreme.v17.1\repo\GitHub\js\bundles\dx.viz-web.js */ 658)
    }, , , ,
    /*!**************************************************!*\
      !*** ./js/bundles/modules/parts/widgets-base.js ***!
      \**************************************************/
    function(module, exports, __webpack_require__) {
        var DevExpress = __webpack_require__( /*! ./core */ 5);
        __webpack_require__( /*! ./data */ 185);
        var ui = DevExpress.ui = __webpack_require__( /*! ../../../bundles/modules/ui */ 197);
        ui.themes = __webpack_require__( /*! ../../../ui/themes */ 143);
        ui.setTemplateEngine = __webpack_require__( /*! ../../../ui/set_template_engine */ 198);
        ui.dialog = __webpack_require__( /*! ../../../ui/dialog */ 199);
        ui.notify = __webpack_require__( /*! ../../../ui/notify */ 204);
        ui.dxActionSheet = __webpack_require__( /*! ../../../ui/action_sheet */ 206);
        ui.dxAutocomplete = __webpack_require__( /*! ../../../ui/autocomplete */ 208);
        ui.dxBox = __webpack_require__( /*! ../../../ui/box */ 252);
        ui.dxButton = __webpack_require__( /*! ../../../ui/button */ 201);
        ui.dxCalendar = __webpack_require__( /*! ../../../ui/calendar */ 253);
        ui.dxCheckBox = __webpack_require__( /*! ../../../ui/check_box */ 248);
        ui.dxColorBox = __webpack_require__( /*! ../../../ui/color_box */ 260);
        ui.dxDateBox = __webpack_require__( /*! ../../../ui/date_box */ 267);
        ui.dxDeferRendering = __webpack_require__( /*! ../../../ui/defer_rendering */ 279);
        ui.dxDropDownBox = __webpack_require__( /*! ../../../ui/drop_down_box */ 280);
        ui.dxDropDownMenu = __webpack_require__( /*! ../../../ui/drop_down_menu */ 281);
        ui.dxFileUploader = __webpack_require__( /*! ../../../ui/file_uploader */ 282);
        ui.dxForm = __webpack_require__( /*! ../../../ui/form */ 285);
        ui.dxGallery = __webpack_require__( /*! ../../../ui/gallery */ 297);
        ui.dxList = __webpack_require__( /*! ../../../ui/list */ 218);
        ui.dxLoadIndicator = __webpack_require__( /*! ../../../ui/load_indicator */ 238);
        ui.dxLoadPanel = __webpack_require__( /*! ../../../ui/load_panel */ 246);
        ui.dxLookup = __webpack_require__( /*! ../../../ui/lookup */ 298);
        ui.dxMap = __webpack_require__( /*! ../../../ui/map */ 299);
        ui.dxMultiView = __webpack_require__( /*! ../../../ui/multi_view */ 292);
        ui.dxNavBar = __webpack_require__( /*! ../../../ui/nav_bar */ 306);
        ui.dxNumberBox = __webpack_require__( /*! ../../../ui/number_box */ 263);
        ui.dxOverlay = __webpack_require__( /*! ../../../ui/overlay */ 109);
        ui.dxPopover = __webpack_require__( /*! ../../../ui/popover */ 207);
        ui.dxPopup = __webpack_require__( /*! ../../../ui/popup */ 200);
        ui.dxProgressBar = __webpack_require__( /*! ../../../ui/progress_bar */ 283);
        ui.dxRadioGroup = __webpack_require__( /*! ../../../ui/radio_group */ 308);
        ui.dxRangeSlider = __webpack_require__( /*! ../../../ui/range_slider */ 310);
        ui.dxResizable = __webpack_require__( /*! ../../../ui/resizable */ 111);
        ui.dxResponsiveBox = __webpack_require__( /*! ../../../ui/responsive_box */ 290);
        ui.dxScrollView = __webpack_require__( /*! ../../../ui/scroll_view */ 233);
        ui.dxSelectBox = __webpack_require__( /*! ../../../ui/select_box */ 317);
        ui.dxSlider = __webpack_require__( /*! ../../../ui/slider */ 311);
        ui.dxSwitch = __webpack_require__( /*! ../../../ui/switch */ 318);
        ui.dxTabPanel = __webpack_require__( /*! ../../../ui/tab_panel */ 291);
        ui.dxTabs = __webpack_require__( /*! ../../../ui/tabs */ 293);
        ui.dxTagBox = __webpack_require__( /*! ../../../ui/tag_box */ 319);
        ui.dxTextArea = __webpack_require__( /*! ../../../ui/text_area */ 320);
        ui.dxTextBox = __webpack_require__( /*! ../../../ui/text_box */ 211);
        ui.dxTileView = __webpack_require__( /*! ../../../ui/tile_view */ 321);
        ui.dxToast = __webpack_require__( /*! ../../../ui/toast */ 205);
        ui.dxToolbar = __webpack_require__( /*! ../../../ui/toolbar */ 322);
        ui.dxTooltip = __webpack_require__( /*! ../../../ui/tooltip */ 314);
        ui.dxTrackBar = __webpack_require__( /*! ../../../ui/track_bar */ 284);
        DevExpress.validationEngine = __webpack_require__( /*! ../../../ui/validation_engine */ 117);
        ui.dxValidationSummary = __webpack_require__( /*! ../../../ui/validation_summary */ 295);
        ui.dxValidationGroup = __webpack_require__( /*! ../../../ui/validation_group */ 296);
        ui.dxValidator = __webpack_require__( /*! ../../../ui/validator */ 288);
        ui.CollectionWidget = __webpack_require__( /*! ../../../ui/collection/ui.collection_widget.edit */ 149);
        ui.dxDropDownEditor = __webpack_require__( /*! ../../../ui/drop_down_editor/ui.drop_down_editor */ 210);
        module.exports = ui
    },
    /*!******************************************!*\
      !*** ./js/bundles/modules/parts/core.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var DevExpress = __webpack_require__( /*! ../../../bundles/modules/core */ 6);
        DevExpress.framework = __webpack_require__( /*! ../../../bundles/modules/framework */ 91);
        __webpack_require__( /*! ../../../integration/angular */ 144);
        __webpack_require__( /*! ../../../integration/knockout */ 92);
        __webpack_require__( /*! ../../../localization/globalize/core */ 176);
        __webpack_require__( /*! ../../../localization/globalize/message */ 178);
        __webpack_require__( /*! ../../../localization/globalize/number */ 179);
        __webpack_require__( /*! ../../../localization/globalize/date */ 180);
        __webpack_require__( /*! ../../../localization/globalize/currency */ 181);
        __webpack_require__( /*! ../../../events/click */ 75);
        __webpack_require__( /*! ../../../events/contextmenu */ 165);
        __webpack_require__( /*! ../../../events/double_click */ 182);
        __webpack_require__( /*! ../../../events/drag */ 110);
        __webpack_require__( /*! ../../../events/hold */ 164);
        __webpack_require__( /*! ../../../events/hover */ 103);
        __webpack_require__( /*! ../../../events/pointer */ 76);
        __webpack_require__( /*! ../../../events/swipe */ 183);
        __webpack_require__( /*! ../../../events/transform */ 184);
        module.exports = DevExpress
    },
    /*!************************************!*\
      !*** ./js/bundles/modules/core.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var DevExpress = window.DevExpress = window.DevExpress || {};
        var errors = DevExpress.errors = __webpack_require__( /*! ../../core/errors */ 7);
        if (DevExpress._DEVEXTREME_BUNDLE_INITIALIZED) {
            throw errors.Error("E0024")
        }
        DevExpress._DEVEXTREME_BUNDLE_INITIALIZED = true;
        DevExpress.clientExporter = __webpack_require__( /*! ../../client_exporter */ 20);
        DevExpress.VERSION = __webpack_require__( /*! ../../core/version */ 19);
        DevExpress.Class = __webpack_require__( /*! ../../core/class */ 25);
        DevExpress.DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 43);
        DevExpress.Component = __webpack_require__( /*! ../../core/component */ 48);
        DevExpress.registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 57);
        DevExpress.devices = __webpack_require__( /*! ../../core/devices */ 53);
        DevExpress.Color = __webpack_require__( /*! ../../color */ 38);
        var $ = __webpack_require__( /*! ../../core/renderer */ 9);
        var compareVersions = __webpack_require__( /*! ../../core/utils/version */ 17).compare;
        if (compareVersions($.fn.jquery, [1, 10]) < 0) {
            throw errors.Error("E0012")
        }
        var animationFrame = __webpack_require__( /*! ../../animation/frame */ 59);
        DevExpress.requestAnimationFrame = function() {
            errors.log("W0000", "DevExpress.requestAnimationFrame", "15.2", "Use the 'DevExpress.utils.requestAnimationFrame' method instead.");
            return animationFrame.requestAnimationFrame.apply(animationFrame, arguments)
        };
        DevExpress.cancelAnimationFrame = function() {
            errors.log("W0000", "DevExpress.cancelAnimationFrame", "15.2", "Use the 'DevExpress.utils.cancelAnimationFrame' method instead.");
            return animationFrame.cancelAnimationFrame.apply(animationFrame, arguments)
        };
        DevExpress.EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 51);
        DevExpress.utils = {};
        DevExpress.utils.requestAnimationFrame = animationFrame.requestAnimationFrame;
        DevExpress.utils.cancelAnimationFrame = animationFrame.cancelAnimationFrame;
        DevExpress.utils.initMobileViewport = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 60).initMobileViewport;
        DevExpress.utils.extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 11).extendFromObject;
        DevExpress.utils.createComponents = __webpack_require__( /*! ../../core/utils/dom */ 56).createComponents;
        DevExpress.utils.triggerShownEvent = __webpack_require__( /*! ../../core/utils/dom */ 56).triggerShownEvent;
        DevExpress.utils.triggerHidingEvent = __webpack_require__( /*! ../../core/utils/dom */ 56).triggerHidingEvent;
        DevExpress.utils.resetActiveElement = __webpack_require__( /*! ../../core/utils/dom */ 56).resetActiveElement;
        DevExpress.utils.findBestMatches = __webpack_require__( /*! ../../core/utils/common */ 14).findBestMatches;
        DevExpress.createQueue = __webpack_require__( /*! ../../core/utils/queue */ 62).create;
        DevExpress.utils.dom = __webpack_require__( /*! ../../core/utils/dom */ 56);
        DevExpress.utils.common = __webpack_require__( /*! ../../core/utils/common */ 14);
        DevExpress.utils.date = __webpack_require__( /*! ../../core/utils/date */ 63);
        DevExpress.utils.browser = __webpack_require__( /*! ../../core/utils/browser */ 23);
        DevExpress.utils.inflector = __webpack_require__( /*! ../../core/utils/inflector */ 39);
        DevExpress.utils.resizeCallbacks = __webpack_require__( /*! ../../core/utils/window */ 44).resizeCallbacks;
        DevExpress.utils.console = __webpack_require__( /*! ../../core/utils/console */ 13);
        DevExpress.utils.string = __webpack_require__( /*! ../../core/utils/string */ 18);
        DevExpress.utils.support = __webpack_require__( /*! ../../core/utils/support */ 61);
        DevExpress.processHardwareBackButton = __webpack_require__( /*! ../../mobile/process_hardware_back_button */ 64);
        DevExpress.viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 55).value;
        DevExpress.hideTopOverlay = __webpack_require__( /*! ../../mobile/hide_top_overlay */ 65);
        DevExpress.formatHelper = __webpack_require__( /*! ../../format_helper */ 66);
        var config = DevExpress.config = __webpack_require__( /*! ../../core/config */ 15);
        Object.defineProperty(DevExpress, "rtlEnabled", {
            get: function() {
                errors.log("W0003", "DevExpress", "rtlEnabled", "16.1", "Use the 'DevExpress.config' method instead");
                return config().rtlEnabled
            },
            set: function(value) {
                errors.log("W0003", "DevExpress", "rtlEnabled", "16.1", "Use the 'DevExpress.config' method instead");
                config({
                    rtlEnabled: value
                })
            }
        });
        Object.defineProperty(DevExpress, "designMode", {
            get: function() {
                return config().designMode
            },
            set: function(value) {
                config({
                    designMode: value
                })
            }
        });
        DevExpress.animationPresets = __webpack_require__( /*! ../../animation/presets/presets */ 67).presets;
        DevExpress.fx = __webpack_require__( /*! ../../animation/fx */ 68);
        DevExpress.TransitionExecutor = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 74).TransitionExecutor;
        DevExpress.AnimationPresetCollection = __webpack_require__( /*! ../../animation/presets/presets */ 67).PresetCollection;
        module.exports = DevExpress.events = {};
        DevExpress.events.click = __webpack_require__( /*! ../../events/click */ 75);
        DevExpress.events.utils = __webpack_require__( /*! ../../events/utils */ 71);
        DevExpress.events.GestureEmitter = __webpack_require__( /*! ../../events/gesture/emitter.gesture */ 86);
        DevExpress.localization = __webpack_require__( /*! ../../localization */ 88);
        module.exports = DevExpress
    },
    /*!***************************!*\
      !*** ./js/core/errors.js ***!
      \***************************/
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ./utils/error */ 8);
        module.exports = errorUtils({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The onCustomItemCreating action should return an item or Promise of jQuery Deferred object resolved when an item is created",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}"
        })
    },
    /*!********************************!*\
      !*** ./js/core/utils/error.js ***!
      \********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            extend = __webpack_require__( /*! ./extend */ 11).extend,
            consoleUtils = __webpack_require__( /*! ./console */ 13),
            stringUtils = __webpack_require__( /*! ./string */ 18),
            version = __webpack_require__( /*! ../version */ 19);
        var ERROR_URL = "http://js.devexpress.com/error/" + version.split(".").slice(0, 2).join("_") + "/";
        module.exports = function(baseErrors, errors) {
            var exports = {
                ERROR_MESSAGES: extend(errors, baseErrors),
                Error: function() {
                    return makeError($.makeArray(arguments))
                },
                log: function(id) {
                    var method = "log";
                    if (/^E\d+$/.test(id)) {
                        method = "error"
                    } else {
                        if (/^W\d+$/.test(id)) {
                            method = "warn"
                        }
                    }
                    consoleUtils.logger[method]("log" === method ? id : combineMessage($.makeArray(arguments)))
                }
            };
            var combineMessage = function(args) {
                var id = args[0];
                args = args.slice(1);
                return formatMessage(id, formatDetails(id, args))
            };
            var formatDetails = function(id, args) {
                args = [exports.ERROR_MESSAGES[id]].concat(args);
                return stringUtils.format.apply(this, args).replace(/\.*\s*?$/, "")
            };
            var formatMessage = function(id, details) {
                return stringUtils.format.apply(this, ["{0} - {1}. See:\n{2}", id, details, ERROR_URL + id])
            };
            var makeError = function(args) {
                var id, details, message;
                id = args[0];
                args = args.slice(1);
                details = formatDetails(id, args);
                message = formatMessage(id, details);
                return extend(new Error(message), {
                    __id: id,
                    __details: details
                })
            };
            return exports
        }
    },
    /*!*****************************!*\
      !*** ./js/core/renderer.js ***!
      \*****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! jquery */ 10);
        module.exports = $
    },
    /*!*************************!*\
      !*** external "jQuery" ***!
      \*************************/
    function(module, exports) {
        module.exports = jQuery
    },
    /*!*********************************!*\
      !*** ./js/core/utils/extend.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var isPlainObject = __webpack_require__( /*! ./type */ 12).isPlainObject;
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (source.hasOwnProperty(prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        var extend = function(target) {
            target = target || {};
            var i = 1,
                deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var clone, targetValue = target[key],
                        sourceValue = source[key],
                        sourceValueIsArray = false;
                    if (target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && (isPlainObject(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && isPlainObject(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend;
        exports.extendFromObject = extendFromObject
    },
    /*!*******************************!*\
      !*** ./js/core/utils/type.js ***!
      \*******************************/
    function(module, exports) {
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object),
                ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        exports.isEmptyObject = isEmptyObject;
        exports.isPlainObject = isPlainObject
    },
    /*!**********************************!*\
      !*** ./js/core/utils/console.js ***!
      \**********************************/
    function(module, exports, __webpack_require__) {
        var isFunction = __webpack_require__( /*! ./common */ 14).isFunction;
        var logger = function() {
            var console = window.console;

            function info(text) {
                if (!console || !isFunction(console.info)) {
                    return
                }
                console.info(text)
            }

            function warn(text) {
                if (!console || !isFunction(console.warn)) {
                    return
                }
                console.warn(text)
            }

            function error(text) {
                if (!console || !isFunction(console.error)) {
                    return
                }
                console.error(text)
            }
            return {
                info: info,
                warn: warn,
                error: error
            }
        }();
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.logger = logger;
        exports.debug = debug
    },
    /*!*********************************!*\
      !*** ./js/core/utils/common.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            config = __webpack_require__( /*! ../config */ 15),
            deferredUtils = __webpack_require__( /*! ../../integration/jquery/deferred */ 16);
        var type = function(object) {
            var types = {
                    "[object Array]": "array",
                    "[object Date]": "date",
                    "[object Object]": "object",
                    "[object Null]": "null"
                },
                typeOfObject = Object.prototype.toString.call(object);
            return "object" === typeof object ? types[typeOfObject] || "object" : typeof object
        };
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        var isString = function(object) {
            return "string" === typeof object
        };
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        var isObject = function(object) {
            return "object" === type(object)
        };
        var isDate = function(object) {
            return "date" === type(object)
        };
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        var isFunction = function(object) {
            return "function" === typeof object
        };
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        var isDomNode = function(node) {
            return node instanceof Element
        };
        var ensureDefined = function(value, defaultValue) {
            return isDefined(value) ? value : defaultValue
        };
        var executeAsync = function(action, context) {
            var timerId, deferred = $.Deferred(),
                normalizedContext = context || this,
                task = {
                    promise: deferred.promise(),
                    abort: function() {
                        clearTimeout(timerId);
                        deferred.rejectWith(normalizedContext)
                    }
                },
                callback = function() {
                    var result = action.call(normalizedContext);
                    if (result && result.done && isFunction(result.done)) {
                        result.done(function() {
                            deferred.resolveWith(normalizedContext)
                        })
                    } else {
                        deferred.resolveWith(normalizedContext)
                    }
                };
            timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || $.Deferred();
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName,
                    currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = deferredUtils.when.apply($, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [],
                maxMatchCount = 0;
            $.each(items, function(index, itemSrc) {
                var matchCount = 0,
                    item = mapFn ? mapFn(itemSrc) : itemSrc;
                $.each(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                $.each(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            switch (typeof raw) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [raw.x || raw.h, raw.y || raw.v];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var splitQuad = function(raw) {
            switch (typeof raw) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var normalizeKey = function(id) {
            var key = isString(id) ? id : id.toString(),
                arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && $.each(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        var isArraysEqualByValue = function(array1, array2, deep) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], deep + 1)) {
                    return false
                }
            }
            return true
        };
        var isObjectsEqualByValue = function(object1, object2, deep) {
            for (var propertyName in object1) {
                if (object1.hasOwnProperty(propertyName) && !equalByValue(object1[propertyName], object2[propertyName], deep + 1)) {
                    return false
                }
            }
            for (propertyName in object2) {
                if (!(propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var equalByValue = function(object1, object2, deep) {
            if (object1 === object2) {
                return true
            }
            var maxDeep = 3;
            deep = deep || 0;
            if (deep >= maxDeep) {
                return true
            }
            if (isObject(object1) && isObject(object2)) {
                return isObjectsEqualByValue(object1, object2, deep)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return isArraysEqualByValue(object1, object2, deep)
                } else {
                    if (isDate(object1) && isDate(object2)) {
                        return object1.getTime() === object2.getTime()
                    }
                }
            }
            return false
        };
        var getKeyHash = function(key) {
            if (isObject(key) || Array.isArray(key)) {
                try {
                    var keyHash = JSON.stringify(key);
                    return "{}" === keyHash ? key : keyHash
                } catch (e) {
                    return key
                }
            }
            return key
        };
        var escapeRegExp = function(string) {
            return string.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&")
        };
        var applyServerDecimalSeparator = function(value) {
            var separator = config().serverDecimalSeparator;
            if (isDefined(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        var noop = function() {};
        var grep = function(elements, checkFunction, invert) {
            var check, result = [],
                expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        exports.type = type;
        exports.isDefined = isDefined;
        exports.isString = isString;
        exports.isNumeric = isNumeric;
        exports.isObject = isObject;
        exports.isDate = isDate;
        exports.isBoolean = isBoolean;
        exports.isFunction = isFunction;
        exports.isPrimitive = isPrimitive;
        exports.isExponential = isExponential;
        exports.isWindow = isWindow;
        exports.isDomNode = isDomNode;
        exports.ensureDefined = ensureDefined;
        exports.executeAsync = executeAsync;
        exports.deferRender = deferRender;
        exports.deferRenderer = deferRenderer;
        exports.deferUpdate = deferUpdate;
        exports.deferUpdater = deferUpdater;
        exports.splitPair = splitPair;
        exports.splitQuad = splitQuad;
        exports.findBestMatches = findBestMatches;
        exports.normalizeKey = normalizeKey;
        exports.denormalizeKey = denormalizeKey;
        exports.equalByValue = equalByValue;
        exports.getKeyHash = getKeyHash;
        exports.escapeRegExp = escapeRegExp;
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        exports.noop = noop;
        exports.grep = grep
    },
    /*!***************************!*\
      !*** ./js/core/config.js ***!
      \***************************/
    function(module, exports, __webpack_require__) {
        var extendUtils = __webpack_require__( /*! ./utils/extend */ 11),
            config = {
                rtlEnabled: false,
                defaultCurrency: "USD",
                designMode: false,
                serverDecimalSeparator: ".",
                forceIsoDateParsing: true,
                wrapActionsBeforeExecute: false
            };
        module.exports = function() {
            if (!arguments.length) {
                return config
            }
            extendUtils.extend(config, arguments[0])
        }
    },
    /*!*******************************************!*\
      !*** ./js/integration/jquery/deferred.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            compareVersion = __webpack_require__( /*! ../../core/utils/version */ 17).compare;
        exports.fromPromise = function(promise, context) {
            var isDeferred = promise && commonUtils.isFunction(promise.done) && commonUtils.isFunction(promise.fail);
            if (isDeferred) {
                return promise
            }
            var d = $.Deferred();
            promise.then(function() {
                d.resolveWith.apply(d, [context].concat([$.makeArray(arguments)]))
            }, function() {
                d.rejectWith.apply(d, [context].concat([$.makeArray(arguments)]))
            });
            return d
        };
        exports.when = compareVersion($.fn.jquery, [3]) < 0 ? $.when : function(singleArg) {
            if (0 === arguments.length) {
                return $.Deferred().resolve()
            } else {
                if (1 === arguments.length) {
                    return singleArg && singleArg.then ? singleArg : $.Deferred().resolve(singleArg)
                } else {
                    return $.when.apply($, arguments)
                }
            }
        }
    },
    /*!**********************************!*\
      !*** ./js/core/utils/version.js ***!
      \**********************************/
    function(module, exports) {
        exports.compare = function(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10),
                    yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    },
    /*!*********************************!*\
      !*** ./js/core/utils/string.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ./common */ 14);
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        var pairToObject = function(raw) {
            var pair = commonUtils.splitPair(raw),
                h = parseInt(pair && pair[0], 10),
                v = parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var quadToObject = function(raw) {
            var quad = commonUtils.splitQuad(raw),
                left = parseInt(quad && quad[0], 10),
                top = parseInt(quad && quad[1], 10),
                right = parseInt(quad && quad[2], 10),
                bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        var stringFormat = function() {
            var replaceDollarCount, reg, value, s = arguments[0],
                values = $.makeArray(arguments).slice(1);
            if (commonUtils.isFunction(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === commonUtils.type(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([\+\*\?\\\.\[\^\]\$\(\)\{\}\><\|\=\!\:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.encodeHtml = encodeHtml;
        exports.pairToObject = pairToObject;
        exports.quadToObject = quadToObject;
        exports.format = stringFormat;
        exports.replaceAll = replaceAll;
        exports.isEmpty = isEmpty
    },
    /*!****************************!*\
      !*** ./js/core/version.js ***!
      \****************************/
    function(module, exports) {
        module.exports = "17.1.6"
    },
    /*!*******************************!*\
      !*** ./js/client_exporter.js ***!
      \*******************************/
    function(module, exports, __webpack_require__) {
        var fileSaver = __webpack_require__( /*! ./client_exporter/file_saver */ 21).fileSaver,
            _isFunction = __webpack_require__( /*! ./core/utils/common */ 14).isFunction;
        exports.export = function(data, options, getData) {
            if (!data) {
                return
            }
            var exportingAction = options.exportingAction,
                exportedAction = options.exportedAction,
                fileSavingAction = options.fileSavingAction,
                eventArgs = {
                    fileName: options.fileName,
                    format: options.format,
                    cancel: false
                };
            _isFunction(exportingAction) && exportingAction(eventArgs);
            if (!eventArgs.cancel) {
                getData(data, options, function(blob) {
                    _isFunction(exportedAction) && exportedAction();
                    if (_isFunction(fileSavingAction)) {
                        eventArgs.data = blob;
                        fileSavingAction(eventArgs)
                    }
                    if (!eventArgs.cancel) {
                        fileSaver.saveAs(eventArgs.fileName, options.format, blob, options.proxyUrl)
                    }
                })
            }
        };
        exports.fileSaver = fileSaver;
        exports.excel = {
            creator: __webpack_require__( /*! ./client_exporter/excel_creator */ 24).ExcelCreator,
            getData: __webpack_require__( /*! ./client_exporter/excel_creator */ 24).getData,
            formatConverter: __webpack_require__( /*! ./client_exporter/excel_format_converter */ 31)
        };
        exports.excel.__internals = __webpack_require__( /*! ./client_exporter/excel_creator */ 24).__internals;
        exports.image = {
            creator: __webpack_require__( /*! ./client_exporter/image_creator */ 37).imageCreator,
            getData: __webpack_require__( /*! ./client_exporter/image_creator */ 37).getData
        };
        exports.pdf = {
            getData: __webpack_require__( /*! ./client_exporter/pdf_creator */ 40).getData
        };
        exports.svg = {
            creator: __webpack_require__( /*! ./client_exporter/svg_creator */ 41).svgCreator,
            getData: __webpack_require__( /*! ./client_exporter/svg_creator */ 41).getData
        }
    },
    /*!******************************************!*\
      !*** ./js/client_exporter/file_saver.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            errors = __webpack_require__( /*! ../ui/widget/ui.errors */ 22),
            browser = __webpack_require__( /*! ../core/utils/browser */ 23),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            FILE_EXTESIONS = {
                EXCEL: "xlsx",
                CSS: "css",
                PNG: "png",
                JPEG: "jpeg",
                GIF: "gif",
                SVG: "svg",
                PDF: "pdf"
            };
        var MIME_TYPES = exports.MIME_TYPES = {
            CSS: "text/css",
            EXCEL: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            PNG: "image/png",
            JPEG: "image/jpeg",
            GIF: "image/gif",
            SVG: "image/svg+xml",
            PDF: "application/pdf"
        };
        exports.fileSaver = {
            _getDataUri: function(format, data) {
                return "data:" + MIME_TYPES[format] + ";base64," + data
            },
            _linkDownloader: function(fileName, href, callback) {
                var exportLinkElement = document.createElement("a"),
                    attributes = {
                        download: fileName,
                        href: href
                    };
                if (commonUtils.isDefined(callback)) {
                    attributes.onclick = callback
                }
                document.body.appendChild(exportLinkElement);
                $(exportLinkElement).css({
                    display: "none"
                }).text("load").attr(attributes)[0].click();
                return exportLinkElement
            },
            _formDownloader: function(proxyUrl, fileName, contentType, data, callback) {
                var formAttributes = {
                        method: "post",
                        action: proxyUrl,
                        enctype: "multipart/form-data"
                    },
                    exportForm = $("<form>").css({
                        display: "none"
                    }).attr(formAttributes);
                if (commonUtils.isDefined(callback)) {
                    exportForm.submit(callback)
                }
                exportForm.append('<input type="hidden" name="fileName" value="' + fileName + '" />');
                exportForm.append('<input type="hidden" name="contentType" value="' + contentType + '" />');
                exportForm.append('<input type="hidden" name="data" value="' + data + '" />');
                exportForm.appendTo("body");
                exportForm.submit();
                if (exportForm.submit()) {
                    exportForm.remove()
                }
                return exportForm
            },
            _saveByProxy: function(proxyUrl, fileName, format, data, callback) {
                return this._formDownloader(proxyUrl, fileName, MIME_TYPES[format], data, callback)
            },
            _winJSBlobSave: function(blob, fileName, format) {
                var savePicker = new Windows.Storage.Pickers.FileSavePicker;
                savePicker.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.documentsLibrary;
                savePicker.fileTypeChoices.insert(MIME_TYPES[format], ["." + FILE_EXTESIONS[format]]);
                savePicker.suggestedFileName = fileName;
                savePicker.pickSaveFileAsync().then(function(file) {
                    if (file) {
                        file.openAsync(Windows.Storage.FileAccessMode.readWrite).then(function(outputStream) {
                            var inputStream = blob.msDetachStream();
                            Windows.Storage.Streams.RandomAccessStream.copyAsync(inputStream, outputStream).then(function() {
                                outputStream.flushAsync().done(function() {
                                    inputStream.close();
                                    outputStream.close()
                                })
                            })
                        })
                    }
                })
            },
            _saveBlobAs: function(fileName, format, data, linkClick) {
                this._blobSaved = false;
                if (commonUtils.isDefined(navigator.msSaveOrOpenBlob)) {
                    navigator.msSaveOrOpenBlob(data, fileName);
                    this._blobSaved = true
                } else {
                    if (commonUtils.isDefined(window.WinJS)) {
                        this._winJSBlobSave(data, fileName, format);
                        this._blobSaved = true
                    } else {
                        var URL = window.URL || window.webkitURL || window.mozURL || window.msURL || window.oURL;
                        linkClick = commonUtils.isDefined(linkClick) ? linkClick : function() {
                            var link = $("#dxExportLink");
                            URL.revokeObjectURL(link.attr("href"));
                            link.remove()
                        };
                        if (commonUtils.isDefined(URL)) {
                            return this._linkDownloader(fileName, URL.createObjectURL(data), linkClick)
                        }
                    }
                }
            },
            saveAs: function(fileName, format, data, proxyURL, linkClick) {
                fileName += "." + FILE_EXTESIONS[format];
                if (commonUtils.isFunction(window.Blob)) {
                    this._saveBlobAs(fileName, format, data)
                } else {
                    if (commonUtils.isDefined(proxyURL) && !commonUtils.isDefined(navigator.userAgent.match(/iPad/i))) {
                        this._saveByProxy(proxyURL, fileName, format, data)
                    } else {
                        if (!commonUtils.isDefined(navigator.userAgent.match(/iPad/i))) {
                            errors.log("E1034")
                        }
                        if (browser.msie && parseInt(browser.version) < 10) {
                            return
                        }
                        this._linkDownloader(fileName, this._getDataUri(format, data), linkClick)
                    }
                }
            }
        }
    },
    /*!***********************************!*\
      !*** ./js/ui/widget/ui.errors.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../../core/utils/error */ 8),
            errors = __webpack_require__( /*! ../../core/errors */ 7);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1036: "Validation rules are not defined for any form item",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The JSZip script is referenced after DevExtreme scripts",
            E1042: 'Deferred selection cannot be performed. Set the "key" field for the data store',
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the '{0}' error",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view"
        })
    },
    /*!**********************************!*\
      !*** ./js/core/utils/browser.js ***!
      \**********************************/
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 11).extend;
        var webkitRegExp = /(webkit)[ \/]([\w.]+)/,
            ieRegExp = /(msie) (\d{1,2}\.\d)/,
            ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/,
            msEdge = /(edge)\/((\d+)?[\w\.]+)/,
            safari = /(safari)/i,
            mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {},
                matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [],
                browserName = matches[1],
                browserVersion = matches[2];
            if ("webkit" === browserName && ua.indexOf("chrome") < 0 && safari.exec(ua)) {
                browserName = "safari";
                result.webkit = true;
                browserVersion = /Version\/([0-9.]+)/i.exec(ua);
                browserVersion = browserVersion && browserVersion[1]
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        module.exports = extend({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent))
    },
    /*!*********************************************!*\
      !*** ./js/client_exporter/excel_creator.js ***!
      \*********************************************/
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 25),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            errors = __webpack_require__( /*! ../ui/widget/ui.errors */ 22),
            stringUtils = __webpack_require__( /*! ../core/utils/string */ 18),
            JSZip = __webpack_require__( /*! jszip */ 30),
            fileSaver = __webpack_require__( /*! ./file_saver */ 21),
            excelFormatConverter = __webpack_require__( /*! ./excel_format_converter */ 31),
            XML_TAG = '<?xml version="1.0" encoding="utf-8"?>',
            GROUP_SHEET_PR_XML = '<sheetPr><outlinePr summaryBelow="0"/></sheetPr>',
            SINGLE_SHEET_PR_XML = "<sheetPr/>",
            BASE_STYLE_XML = '<fonts count="2"><font><sz val="11"/><color theme="1"/><name val="Calibri"/><family val="2"/><scheme val="minor"/></font><font><b/><sz val="11"/><color theme="1"/><name val="Calibri"/><family val="2"/><scheme val="minor"/></font></fonts><fills count="1"><fill><patternFill patternType="none"/></fill></fills><borders count="1"><border><left style="thin"><color rgb="FFD3D3D3"/></left><right style="thin"><color rgb="FFD3D3D3"/></right><top style="thin"><color rgb="FFD3D3D3"/></top><bottom style="thin"><color rgb="FFD3D3D3"/></bottom></border></borders><cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>',
            OPEN_XML_FORMAT_URL = "http://schemas.openxmlformats.org",
            RELATIONSHIP_PART_NAME = "rels",
            XL_FOLDER_NAME = "xl",
            WORKBOOK_FILE_NAME = "workbook.xml",
            CONTENTTYPES_FILE_NAME = "[Content_Types].xml",
            SHAREDSTRING_FILE_NAME = "sharedStrings.xml",
            STYLE_FILE_NAME = "styles.xml",
            WORKSHEETS_FOLDER = "worksheets",
            WORKSHEET_FILE_NAME = "sheet1.xml",
            VALID_TYPES = {
                "boolean": "b",
                date: "d",
                number: "n",
                string: "s"
            },
            EXCEL_START_TIME = Date.UTC(1899, 11, 30),
            DAYS_COUNT_BEFORE_29_FEB_1900 = 60,
            BOLD_STYLES_COUNT = 4,
            MAX_DIGIT_WIDTH_IN_PIXELS = 7,
            CUSTOM_FORMAT_START_INDEX = 165;
        exports.ExcelCreator = Class.inherit({
            _getXMLTag: function(tagName, attributes, content) {
                var i, attr, result = "<" + tagName,
                    length = attributes.length;
                for (i = 0; i < length; i++) {
                    attr = attributes[i];
                    result = result + " " + attr.name + '="' + attr.value + '"'
                }
                return commonUtils.isDefined(content) ? result + ">" + content + "</" + tagName + ">" : result + " />"
            },
            _getCellIndex: function(rowIndex, cellIndex) {
                var charCode, sheetIndex = "",
                    max = 26;
                if (this._maxIndex[0] < Number(rowIndex)) {
                    this._maxIndex[0] = Number(rowIndex)
                }
                if (this._maxIndex[1] < Number(cellIndex)) {
                    this._maxIndex[1] = Number(cellIndex)
                }
                while (true) {
                    charCode = 65 + (cellIndex >= max ? cellIndex % max : Math.ceil(cellIndex));
                    sheetIndex = String.fromCharCode(charCode) + sheetIndex;
                    if (cellIndex >= max) {
                        cellIndex = Math.floor(cellIndex / max) - 1
                    } else {
                        break
                    }
                }
                return sheetIndex + rowIndex
            },
            _getDataType: function(dataType) {
                return VALID_TYPES[dataType] || "s"
            },
            _formatObjectConverter: function(format, precision, dataType) {
                var result = {
                    format: format,
                    precision: precision,
                    dataType: dataType
                };
                if (commonUtils.isObject(format)) {
                    return extend(result, format, {
                        format: format.type,
                        currency: format.currency
                    })
                }
                return result
            },
            _appendFormat: function(format, precision, dataType) {
                var currency, newFormat = this._formatObjectConverter(format, precision, dataType);
                format = newFormat.format;
                precision = newFormat.precision;
                currency = newFormat.currency;
                dataType = newFormat.dataType;
                format = excelFormatConverter.convertFormat(format, precision, dataType, currency);
                if (format) {
                    if (inArray(format, this._styleFormat) === -1) {
                        this._styleFormat.push(format)
                    }
                    return inArray(format, this._styleFormat) + 1
                }
            },
            _appendString: function(value) {
                if (commonUtils.isDefined(value)) {
                    value = String(value);
                    if (value.length) {
                        value = stringUtils.encodeHtml(value);
                        if (void 0 === this._stringHash[value]) {
                            this._stringHash[value] = this._stringArray.length;
                            this._stringArray.push(value)
                        }
                        return this._stringHash[value]
                    }
                }
            },
            _getExcelDateValue: function(date) {
                var days, totalTime;
                if (commonUtils.isDate(date)) {
                    days = Math.floor((Date.UTC(date.getFullYear(), date.getMonth(), date.getDate()) - EXCEL_START_TIME) / 864e5);
                    if (days < DAYS_COUNT_BEFORE_29_FEB_1900) {
                        days--
                    }
                    totalTime = (3600 * date.getHours() + 60 * date.getMinutes() + date.getSeconds()) / 86400;
                    return days + totalTime
                }
            },
            _prepareValue: function(rowIndex, cellIndex) {
                var dataProvider = this._dataProvider,
                    value = dataProvider.getCellValue(rowIndex, cellIndex),
                    type = this._getDataType(dataProvider.getCellType(rowIndex, cellIndex)),
                    formatID = this._styleArray[this._dataProvider.getStyleId(rowIndex, cellIndex)].formatID,
                    format = commonUtils.isNumeric(formatID) ? this._styleFormat[formatID - 1] : null;
                if ("d" === type && !commonUtils.isDate(value)) {
                    type = "s"
                }
                switch (type) {
                    case "s":
                        value = this._appendString(value);
                        break;
                    case "d":
                        value = this._getExcelDateValue(value, format);
                        type = "n"
                }
                return {
                    value: value,
                    type: type
                }
            },
            _getDataArray: function() {
                var rowIndex, cellIndex, cellsArray, cellData, cellsLength, that = this,
                    result = [],
                    dataProvider = that._dataProvider,
                    rowsLength = dataProvider.getRowsCount(),
                    columns = dataProvider.getColumns();
                for (rowIndex = 0; rowIndex < rowsLength; rowIndex++) {
                    cellsArray = [];
                    cellsLength = columns.length;
                    for (cellIndex = 0; cellIndex !== cellsLength; cellIndex++) {
                        cellData = that._prepareValue(rowIndex, cellIndex);
                        cellsArray.push({
                            style: dataProvider.getStyleId(rowIndex, cellIndex),
                            value: cellData.value,
                            type: cellData.type
                        })
                    }
                    if (!that._needSheetPr && dataProvider.getGroupLevel(rowIndex) > 0) {
                        that._needSheetPr = true
                    }
                    result.push(cellsArray)
                }
                return result
            },
            _getBoldStyleID: function(alignment) {
                for (var i = 0; i < BOLD_STYLES_COUNT - 1; i++) {
                    if (this._styleArray[i].alignment === alignment) {
                        return i
                    }
                }
            },
            _calculateWidth: function(pixelsWidth) {
                pixelsWidth = parseInt(pixelsWidth, 10);
                if (!pixelsWidth || pixelsWidth < 5) {
                    pixelsWidth = 100
                }
                return Math.min(255, Math.floor((pixelsWidth - 5) / MAX_DIGIT_WIDTH_IN_PIXELS * 100 + .5) / 100)
            },
            _prepareStyleData: function() {
                var that = this,
                    styles = that._dataProvider.getStyles();
                that._dataProvider.getColumns().forEach(function(column) {
                    that._colsArray.push(that._calculateWidth(column.width))
                });
                styles.forEach(function(style) {
                    that._styleArray.push({
                        bold: !!style.bold,
                        alignment: style.alignment || "left",
                        formatID: that._appendFormat(style.format, style.precision, style.dataType),
                        wrapText: style.wrapText
                    })
                })
            },
            _prepareCellData: function() {
                this._cellsArray = this._getDataArray()
            },
            _createXMLRelationships: function(xmlRelationships) {
                return this._getXMLTag("Relationships", [{
                    name: "xmlns",
                    value: OPEN_XML_FORMAT_URL + "/package/2006/relationships"
                }], xmlRelationships)
            },
            _createXMLRelationship: function(id, type, target) {
                return this._getXMLTag("Relationship", [{
                    name: "Id",
                    value: "rId" + id
                }, {
                    name: "Type",
                    value: OPEN_XML_FORMAT_URL + "/officeDocument/2006/relationships/" + type
                }, {
                    name: "Target",
                    value: target
                }])
            },
            _getWorkbookContent: function() {
                var content = '<bookViews><workbookView xWindow="0" yWindow="0" windowWidth="0" windowHeight="0"/></bookViews><sheets><sheet name="Sheet" sheetId="1" r:id="rId1" /></sheets><definedNames><definedName name="_xlnm.Print_Titles" localSheetId="0">Sheet!$1:$1</definedName><definedName name="_xlnm._FilterDatabase" hidden="0" localSheetId="0">Sheet!$A$1:$F$6332</definedName></definedNames>';
                return XML_TAG + this._getXMLTag("workbook", [{
                    name: "xmlns:r",
                    value: OPEN_XML_FORMAT_URL + "/officeDocument/2006/relationships"
                }, {
                    name: "xmlns",
                    value: OPEN_XML_FORMAT_URL + "/spreadsheetml/2006/main"
                }], content)
            },
            _getContentTypesContent: function() {
                return XML_TAG + '<Types xmlns="' + OPEN_XML_FORMAT_URL + '/package/2006/content-types"><Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" /><Default Extension="xml" ContentType="application/xml" /><Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" /><Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" /><Override PartName="/xl/sharedStrings.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml" /><Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" /></Types>'
            },
            _generateStylesXML: function() {
                var formatIndex, that = this,
                    folder = that._zip.folder(XL_FOLDER_NAME),
                    xmlStyles = [],
                    XML = "";
                for (formatIndex = 0; formatIndex < that._styleFormat.length; formatIndex++) {
                    that._styleFormat[formatIndex] = that._getXMLTag("numFmt", [{
                        name: "numFmtId",
                        value: Number(formatIndex) + CUSTOM_FORMAT_START_INDEX
                    }, {
                        name: "formatCode",
                        value: that._styleFormat[formatIndex]
                    }])
                }
                XML = XML + that._getXMLTag("numFmts", [{
                    name: "count",
                    value: that._styleFormat.length
                }], that._styleFormat.join("")) + BASE_STYLE_XML;
                this._styleArray.forEach(function(style) {
                    xmlStyles.push(that._getXMLTag("xf", [{
                        name: "xfId",
                        value: 0
                    }, {
                        name: "applyAlignment",
                        value: 1
                    }, {
                        name: "fontId",
                        value: Number(!!style.bold)
                    }, {
                        name: "applyNumberFormat",
                        value: commonUtils.isDefined(style.formatID) ? 1 : 0
                    }, {
                        name: "numFmtId",
                        value: commonUtils.isDefined(style.formatID) ? Number(style.formatID) + CUSTOM_FORMAT_START_INDEX - 1 : 0
                    }], that._getXMLTag("alignment", [{
                        name: "vertical",
                        value: "top"
                    }, {
                        name: "wrapText",
                        value: Number(!!style.wrapText)
                    }, {
                        name: "horizontal",
                        value: style.alignment
                    }])))
                });
                XML += that._getXMLTag("cellXfs", [{
                    name: "count",
                    value: xmlStyles.length
                }], xmlStyles.join(""));
                XML += that._getXMLTag("cellStyles", [{
                    name: "count",
                    value: 1
                }], that._getXMLTag("cellStyle", [{
                    name: "name",
                    value: "Normal"
                }, {
                    name: "xfId",
                    value: 0
                }, {
                    name: "builtinId",
                    value: 0
                }]));
                XML = XML_TAG + that._getXMLTag("styleSheet", [{
                    name: "xmlns",
                    value: OPEN_XML_FORMAT_URL + "/spreadsheetml/2006/main"
                }], XML);
                folder.file(STYLE_FILE_NAME, XML);
                that._styleArray = []
            },
            _generateStringsXML: function() {
                var stringIndex, folder = this._zip.folder(XL_FOLDER_NAME),
                    stringsLength = this._stringArray.length,
                    sharedStringXml = XML_TAG;
                for (stringIndex = 0; stringIndex < stringsLength; stringIndex++) {
                    this._stringArray[stringIndex] = this._getXMLTag("si", [], this._getXMLTag("t", [], this._stringArray[stringIndex]))
                }
                sharedStringXml += this._getXMLTag("sst", [{
                    name: "xmlns",
                    value: OPEN_XML_FORMAT_URL + "/spreadsheetml/2006/main"
                }, {
                    name: "count",
                    value: this._stringArray.length
                }, {
                    name: "uniqueCount",
                    value: this._stringArray.length
                }], this._stringArray.join(""));
                folder.file(SHAREDSTRING_FILE_NAME, sharedStringXml);
                this._stringArray = []
            },
            _getPaneXML: function() {
                var attributes = [{
                        name: "activePane",
                        value: "bottomLeft"
                    }, {
                        name: "state",
                        value: "frozen"
                    }],
                    frozenArea = this._dataProvider.getFrozenArea();
                if (!(frozenArea.x || frozenArea.y)) {
                    return ""
                }
                if (frozenArea.x) {
                    attributes.push({
                        name: "xSplit",
                        value: frozenArea.x
                    })
                }
                if (frozenArea.y) {
                    attributes.push({
                        name: "ySplit",
                        value: frozenArea.y
                    })
                }
                attributes.push({
                    name: "topLeftCell",
                    value: this._getCellIndex(frozenArea.y + 1, frozenArea.x)
                });
                return this._getXMLTag("pane", attributes)
            },
            _generateWorksheetXML: function() {
                var colIndex, rowIndex, cellData, xmlCells, maxCellIndex, cellsLength, counter = 0,
                    xmlRows = [],
                    rowsLength = this._cellsArray.length,
                    colsLength = this._colsArray.length,
                    rSpans = "1:" + colsLength,
                    headerRowCount = this._dataProvider.getHeaderRowCount ? this._dataProvider.getHeaderRowCount() : 1,
                    xmlResult = [
                        ['<?xml version="1.0" encoding="UTF-8" standalone="yes"?><worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">', this._needSheetPr ? GROUP_SHEET_PR_XML : SINGLE_SHEET_PR_XML, '<dimension ref="A1:', this._getCellIndex(this._maxIndex[0], this._maxIndex[1]) + '"/><sheetViews><sheetView ' + (this._rtlEnabled ? 'rightToLeft="1" ' : "") + 'tabSelected="1" workbookViewId="0">' + this._getPaneXML() + '</sheetView></sheetViews><sheetFormatPr defaultRowHeight="15" outlineLevelRow="', this._dataProvider.getRowsCount() > 0 ? this._dataProvider.getGroupLevel(0) : 0, '" x14ac:dyDescent="0.25"/>'].join("")
                    ];
                for (colIndex = 0; colIndex < colsLength; colIndex++) {
                    this._colsArray[colIndex] = this._getXMLTag("col", [{
                        name: "width",
                        value: this._colsArray[colIndex]
                    }, {
                        name: "min",
                        value: Number(colIndex) + 1
                    }, {
                        name: "max",
                        value: Number(colIndex) + 1
                    }])
                }
                xmlResult.push(this._getXMLTag("cols", [], this._colsArray.join("")) + "<sheetData>");
                for (rowIndex = 0; rowIndex < rowsLength; rowIndex++) {
                    xmlCells = [];
                    cellsLength = this._cellsArray[rowIndex].length;
                    for (colIndex = 0; colIndex < cellsLength; colIndex++) {
                        rowIndex = Number(rowIndex);
                        cellData = this._cellsArray[rowIndex][colIndex];
                        xmlCells.push(this._getXMLTag("c", [{
                            name: "r",
                            value: this._getCellIndex(rowIndex + 1, colIndex)
                        }, {
                            name: "s",
                            value: cellData.style
                        }, {
                            name: "t",
                            value: cellData.type
                        }], commonUtils.isDefined(cellData.value) ? this._getXMLTag("v", [], cellData.value) : null))
                    }
                    xmlRows.push(this._getXMLTag("row", [{
                        name: "r",
                        value: Number(rowIndex) + 1
                    }, {
                        name: "spans",
                        value: rSpans
                    }, {
                        name: "outlineLevel",
                        value: rowIndex >= headerRowCount ? this._dataProvider.getGroupLevel(rowIndex) : 0
                    }, {
                        name: "x14ac:dyDescent",
                        value: "0.25"
                    }], xmlCells.join("")));
                    this._cellsArray[rowIndex] = null;
                    if (counter++ > 1e4) {
                        xmlResult.push(xmlRows.join(""));
                        xmlRows = [];
                        counter = 0
                    }
                }
                xmlResult.push(xmlRows.join(""));
                xmlRows = [];
                maxCellIndex = this._getCellIndex(this._maxIndex[0], this._maxIndex[1]);
                xmlResult.push("</sheetData>" + (this._options.autoFilterEnabled ? '<autoFilter ref="A' + this._dataProvider.getHeaderRowCount() + ":" + maxCellIndex + '" />' : "") + this._generateMergingXML() + '<ignoredErrors><ignoredError sqref="A1:' + maxCellIndex + '" numberStoredAsText="1" /></ignoredErrors></worksheet>');
                this._zip.folder(XL_FOLDER_NAME).folder(WORKSHEETS_FOLDER).file(WORKSHEET_FILE_NAME, xmlResult.join(""));
                this._colsArray = [];
                this._cellsArray = [];
                xmlResult = []
            },
            _generateMergingXML: function() {
                var k, l, cellIndex, rowIndex, mergeArrayLength, mergeIndex, rowsLength = commonUtils.isDefined(this._dataProvider.getHeaderRowCount) ? this._dataProvider.getHeaderRowCount() : this._dataProvider.getRowsCount(),
                    columnsLength = this._dataProvider.getColumns().length,
                    usedArea = [],
                    mergeArray = [],
                    mergeXML = "";
                for (rowIndex = 0; rowIndex < rowsLength; rowIndex++) {
                    for (cellIndex = 0; cellIndex !== columnsLength; cellIndex++) {
                        if (!commonUtils.isDefined(usedArea[rowIndex]) || !commonUtils.isDefined(usedArea[rowIndex][cellIndex])) {
                            var cellMerge = this._dataProvider.getCellMerging(rowIndex, cellIndex);
                            if (cellMerge.colspan || cellMerge.rowspan) {
                                mergeArray.push({
                                    start: this._getCellIndex(rowIndex + 1, cellIndex),
                                    end: this._getCellIndex(rowIndex + 1 + (cellMerge.rowspan || 0), cellIndex + (cellMerge.colspan || 0))
                                });
                                for (k = rowIndex; k <= rowIndex + cellMerge.rowspan || 0; k++) {
                                    for (l = cellIndex; l <= cellIndex + cellMerge.colspan || 0; l++) {
                                        if (!commonUtils.isDefined(usedArea[k])) {
                                            usedArea[k] = []
                                        }
                                        usedArea[k][l] = true
                                    }
                                }
                            }
                        }
                    }
                }
                mergeArrayLength = mergeArray.length;
                for (mergeIndex = 0; mergeIndex < mergeArrayLength; mergeIndex++) {
                    mergeXML += this._getXMLTag("mergeCell", [{
                        name: "ref",
                        value: mergeArray[mergeIndex].start + ":" + mergeArray[mergeIndex].end
                    }])
                }
                return mergeXML.length ? this._getXMLTag("mergeCells", [{
                    name: "count",
                    value: mergeArrayLength
                }], mergeXML) : ""
            },
            _generateCommonXML: function() {
                var xmlRelationships, relsFileContent = XML_TAG + this._createXMLRelationships(this._createXMLRelationship(1, "officeDocument", "xl/" + WORKBOOK_FILE_NAME)),
                    folder = this._zip.folder(XL_FOLDER_NAME),
                    relsXML = XML_TAG;
                this._zip.folder("_" + RELATIONSHIP_PART_NAME).file("." + RELATIONSHIP_PART_NAME, relsFileContent);
                xmlRelationships = this._createXMLRelationship(1, "worksheet", "worksheets/" + WORKSHEET_FILE_NAME) + this._createXMLRelationship(2, "styles", STYLE_FILE_NAME) + this._createXMLRelationship(3, "sharedStrings", SHAREDSTRING_FILE_NAME);
                relsXML += this._createXMLRelationships(xmlRelationships);
                folder.folder("_" + RELATIONSHIP_PART_NAME).file(WORKBOOK_FILE_NAME + ".rels", relsXML);
                folder.file(WORKBOOK_FILE_NAME, this._getWorkbookContent());
                this._zip.file(CONTENTTYPES_FILE_NAME, this._getContentTypesContent())
            },
            _generateContent: function() {
                this._prepareStyleData();
                this._prepareCellData();
                this._generateWorkXML();
                this._generateCommonXML()
            },
            _generateWorkXML: function() {
                this._generateStylesXML();
                this._generateStringsXML();
                this._generateWorksheetXML()
            },
            ctor: function(dataProvider, options) {
                this._rtlEnabled = options && !!options.rtlEnabled;
                this._options = options;
                this._maxIndex = [1, 2];
                this._stringArray = [];
                this._stringHash = {};
                this._styleArray = [];
                this._colsArray = [];
                this._cellsArray = [];
                this._styleFormat = [];
                this._needSheetPr = false;
                this._dataProvider = dataProvider;
                if (commonUtils.isDefined(JSZip)) {
                    this._zip = new JSZip
                } else {
                    this._zip = null
                }
            },
            _checkZipState: function() {
                if (!this._zip) {
                    throw errors.Error("E1041")
                }
            },
            ready: function() {
                return this._dataProvider.ready()
            },
            getData: function(isBlob) {
                var options = {
                    type: isBlob ? "blob" : "base64",
                    compression: "DEFLATE",
                    mimeType: fileSaver.MIME_TYPES.EXCEL
                };
                this._checkZipState();
                this._generateContent();
                return this._zip.generateAsync ? this._zip.generateAsync(options) : this._zip.generate(options)
            }
        });
        exports.getData = function(data, options, callback) {
            var excelCreator = new exports.ExcelCreator(data, options);
            excelCreator._checkZipState();
            excelCreator.ready().done(function() {
                if (excelCreator._zip.generateAsync) {
                    excelCreator.getData(commonUtils.isFunction(window.Blob)).then(callback)
                } else {
                    callback(excelCreator.getData(commonUtils.isFunction(window.Blob)))
                }
            })
        };
        exports.__internals = {
            CONTENTTYPES_FILE_NAME: CONTENTTYPES_FILE_NAME,
            RELATIONSHIP_PART_NAME: RELATIONSHIP_PART_NAME,
            XL_FOLDER_NAME: XL_FOLDER_NAME,
            WORKBOOK_FILE_NAME: WORKBOOK_FILE_NAME,
            STYLE_FILE_NAME: STYLE_FILE_NAME,
            WORKSHEET_FILE_NAME: WORKSHEET_FILE_NAME,
            WORKSHEETS_FOLDER: WORKSHEETS_FOLDER,
            SHAREDSTRING_FILE_NAME: SHAREDSTRING_FILE_NAME,
            GROUP_SHEET_PR_XML: GROUP_SHEET_PR_XML,
            SINGLE_SHEET_PR_XML: SINGLE_SHEET_PR_XML
        }
    },
    /*!**************************!*\
      !*** ./js/core/class.js ***!
      \**************************/
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ./errors */ 7);
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var overridden, memberName, member, that = this;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var argument, name, i, classObj = this;
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    if (name in classObj.prototype) {
                        throw errors.Error("E0002", name)
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            if (this.parent === parentClass) {
                return true
            }
            if (!this.parent || !this.parent.subclassOf) {
                return false
            }
            return this.parent.subclassOf(parentClass)
        };
        var abstract = function() {
            throw errors.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || this === window || "function" !== typeof this.constructor) {
                    throw errors.Error("E0003")
                }
                var i, instance = this,
                    ctor = instance.ctor,
                    includedCtors = instance.constructor._includedCtors,
                    includedPostCtors = instance.constructor._includedPostCtors;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        module.exports = classImpl
    },
    /*!********************************!*\
      !*** ./js/core/utils/array.js ***!
      \********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ./common */ 14),
            objectUtils = __webpack_require__( /*! ./object */ 27);
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            $.each(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            $.each(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {},
                parameterIndex = 0;
            $.each(items, function(index, item) {
                index = item[indexParameterName];
                if (commonUtils.isDefined(index)) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                    delete item[indexParameterName]
                }
            });
            objectUtils.orderEach(indexedItems, function(index, items) {
                $.each(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            $.each(items, function() {
                if (!commonUtils.isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                    this[indexParameterName] = parameterIndex++
                }
            });
            return parameterIndex
        };
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        exports.isEmpty = isEmpty;
        exports.wrapToArray = wrapToArray;
        exports.intersection = intersection;
        exports.removeDuplicates = removeDuplicates;
        exports.normalizeIndexes = normalizeIndexes;
        exports.inArray = inArray
    },
    /*!*********************************!*\
      !*** ./js/core/utils/object.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ./common */ 14),
            typeUtils = __webpack_require__( /*! ./type */ 12),
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 28);
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        var orderEach = function(map, func) {
            var key, i, keys = [];
            for (key in map) {
                if (map.hasOwnProperty(key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = commonUtils.isNumeric(x),
                    isNumberY = commonUtils.isNumeric(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && variableWrapper.isWrapped(target[property])) {
                variableWrapper.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function(target, changes, extendComplexObject, assignByReference) {
            var prevValue, newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if (target === newValue) {
                    continue
                }
                if (typeUtils.isPlainObject(newValue) && !(newValue instanceof $.Event)) {
                    var goDeeper = extendComplexObject ? commonUtils.isObject(prevValue) : typeUtils.isPlainObject(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.clone = clone;
        exports.orderEach = orderEach;
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!*******************************************!*\
      !*** ./js/core/utils/variable_wrapper.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var logger = __webpack_require__( /*! ./console */ 13).logger,
            dependencyInjector = __webpack_require__( /*! ./dependency_injector */ 29);
        module.exports = dependencyInjector({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        })
    },
    /*!**********************************************!*\
      !*** ./js/core/utils/dependency_injector.js ***!
      \**********************************************/
    function(module, exports, __webpack_require__) {
        module.exports = function(object) {
            var $ = __webpack_require__( /*! ../../core/renderer */ 9),
                extend = __webpack_require__( /*! ./extend */ 11).extend,
                isFunction = __webpack_require__( /*! ./common */ 14).isFunction,
                Class = __webpack_require__( /*! ../class */ 25);
            var BaseClass = Class.inherit(object),
                InjectedClass = BaseClass,
                instance = new InjectedClass(object),
                initialFields = {};
            var injectFields = function(injectionObject, initial) {
                $.each(injectionObject, function(key) {
                    if (isFunction(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                extend(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
    },
    /*!*******************************!*\
      !*** external "window.JSZip" ***!
      \*******************************/
    function(module, exports) {
        module.exports = window.JSZip
    },
    /*!******************************************************!*\
      !*** ./js/client_exporter/excel_format_converter.js ***!
      \******************************************************/
    function(module, exports, __webpack_require__) {
        var commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            stringUtils = __webpack_require__( /*! ../core/utils/string */ 18),
            numberFormatter = __webpack_require__( /*! ../localization/number */ 32),
            dateLocalization = __webpack_require__( /*! ../localization/date */ 33),
            getLanguageID = __webpack_require__( /*! ../localization/language_codes */ 35).getLanguageId,
            UNSUPPORTED_FORMAT_MAPPING = {
                quarter: "shortDate",
                quarterAndYear: "shortDate",
                minute: "longTime",
                millisecond: "longTime"
            },
            FORMAT_SEPARATORS = " .,:;/\\<>()-",
            ARABIC_ZERO_CODE = 1632,
            DEFINED_NUMBER_FORMTATS = {
                thousands: "#,##0{0},&quot;K&quot;",
                millions: "#,##0{0},,&quot;M&quot;",
                billions: "#,##0{0},,,&quot;B&quot;",
                trillions: "#,##0{0},,,,&quot;T&quot;",
                percent: "0{0}%",
                decimal: "#{0}",
                fixedpoint: "#,##0{0}",
                exponential: "0{0}E+00",
                currency: " "
            };
        __webpack_require__( /*! ../localization/currency */ 36);
        var excelFormatConverter = module.exports = {
            _applyPrecision: function(format, precision) {
                var result, i;
                if (precision > 0) {
                    result = "decimal" !== format ? "." : "";
                    for (i = 0; i < precision; i++) {
                        result += "0"
                    }
                    return result
                }
                return ""
            },
            _getCurrencyFormat: function(currency) {
                return numberFormatter.getOpenXmlCurrencyFormat(currency)
            },
            _isDigit: function(char) {
                var code = char && char.charCodeAt(0);
                return char >= "0" && char <= "9" || code >= ARABIC_ZERO_CODE && code < ARABIC_ZERO_CODE + 10
            },
            _getDifference: function(defaultPattern, patterns, processedIndexes) {
                var isDigit, i = 0,
                    that = this,
                    result = [];
                var patternsFilter = function(pattern) {
                    return defaultPattern[i] !== pattern[i]
                };
                if (!Array.isArray(patterns)) {
                    patterns = [patterns]
                }
                for (i = 0; i < defaultPattern.length; i++) {
                    if (processedIndexes.indexOf(i) < 0 && patterns.filter(patternsFilter).length) {
                        do {
                            isDigit = that._isDigit(defaultPattern[i]);
                            if (!result.length && !isDigit && that._isDigit(patterns[0][i])) {
                                break
                            }
                            result.push(i);
                            processedIndexes.unshift(i);
                            i++
                        } while (defaultPattern[i] && FORMAT_SEPARATORS.indexOf(defaultPattern[i]) < 0 && isDigit === that._isDigit(defaultPattern[i]));
                        break
                    }
                }
                if (1 === result.length && ("0" === defaultPattern[processedIndexes[0] - 1] || "٠" === defaultPattern[processedIndexes[0] - 1])) {
                    processedIndexes.unshift(processedIndexes[0] - 1)
                }
                return result
            },
            _replaceCharsCore: function(pattern, indexes, char, patternPositions) {
                var baseCharIndex = indexes[0];
                var patternIndex = baseCharIndex < patternPositions.length ? patternPositions[baseCharIndex] : baseCharIndex;
                indexes.forEach(function(_, index) {
                    pattern = pattern.substr(0, patternIndex + index) + (char.length > 1 ? char[index] : char) + pattern.substr(patternIndex + index + 1)
                });
                if (1 === indexes.length) {
                    pattern = pattern.replace("0" + char, char + char);
                    pattern = pattern.replace("٠" + char, char + char)
                }
                return pattern
            },
            _replaceChars: function(pattern, indexes, char, patternPositions) {
                var i, index, patternIndex;
                if (!this._isDigit(pattern[indexes[0]] || "0")) {
                    var letterCount = Math.max(indexes.length <= 3 ? 3 : 4, char.length);
                    while (indexes.length > letterCount) {
                        index = indexes.pop();
                        patternIndex = patternPositions[index];
                        patternPositions[index] = -1;
                        for (i = index + 1; i < patternPositions.length; i++) {
                            patternPositions[i]--
                        }
                        pattern = pattern.substr(0, patternIndex) + pattern.substr(patternIndex + 1)
                    }
                    index = indexes[indexes.length - 1] + 1, patternIndex = index < patternPositions.length ? patternPositions[index] : index;
                    while (indexes.length < letterCount) {
                        indexes.push(indexes[indexes.length - 1] + 1);
                        for (i = index; i < patternPositions.length; i++) {
                            patternPositions[i]++
                        }
                        pattern = pattern.substr(0, patternIndex) + " " + pattern.substr(patternIndex)
                    }
                }
                pattern = this._replaceCharsCore(pattern, indexes, char, patternPositions);
                return pattern
            },
            _format: function(value, format) {
                if (Array.isArray(value)) {
                    return value.map(function(value) {
                        return (dateLocalization.format(value, format) || "").toString()
                    })
                }
                return (dateLocalization.format(value, format) || "").toString()
            },
            _escapeChars: function(pattern, defaultPattern, processedIndexes, patternPositions) {
                var escapeIndexes = defaultPattern.split("").map(function(char, index) {
                    if (processedIndexes.indexOf(index) < 0 && (FORMAT_SEPARATORS.indexOf(char) < 0 || "/" === char)) {
                        return patternPositions[index]
                    }
                    return -1
                });
                pattern = pattern.split("").map(function(char, index) {
                    if (escapeIndexes.indexOf(index) >= 0) {
                        return "\\" + char
                    }
                    return char
                }).join("");
                pattern = pattern.replace("AM\\/PM", "AM/PM");
                return pattern
            },
            _hasArabicDigits: function(text) {
                var code;
                for (var i = 0; i < text.length; i++) {
                    code = text.charCodeAt(i);
                    if (code >= ARABIC_ZERO_CODE && code < ARABIC_ZERO_CODE + 10) {
                        return true
                    }
                }
                return false
            },
            _convertDateFormat: function(format) {
                format = UNSUPPORTED_FORMAT_MAPPING[format && format.type || format] || format;
                var that = this,
                    processedIndexes = [],
                    defaultPattern = that._format(new Date(2009, 8, 8, 6, 5, 4), format),
                    patternPositions = defaultPattern.split("").map(function(_, index) {
                        return index
                    }),
                    result = defaultPattern,
                    datePatterns = [{
                        date: new Date(2009, 8, 8, 6, 5, 2),
                        pattern: "s"
                    }, {
                        date: new Date(2009, 8, 8, 6, 2, 4),
                        pattern: "m"
                    }, {
                        date: new Date(2009, 8, 8, 2, 5, 4),
                        pattern: "H"
                    }, {
                        date: new Date(2009, 8, 8, 18, 5, 4),
                        pattern: "AM/PM"
                    }, {
                        date: new Date(2009, 8, 1, 6, 5, 4),
                        pattern: "d"
                    }, {
                        date: [new Date(2009, 8, 2, 6, 5, 4), new Date(2009, 8, 3, 6, 5, 4), new Date(2009, 8, 4, 6, 5, 4)],
                        pattern: "d"
                    }, {
                        date: new Date(2009, 9, 6, 6, 5, 4),
                        pattern: "M"
                    }, {
                        date: new Date(1998, 8, 8, 6, 5, 4),
                        pattern: "y"
                    }];
                if (!result) {
                    return
                }
                datePatterns.forEach(function(test) {
                    var diff = that._getDifference(defaultPattern, that._format(test.date, format), processedIndexes);
                    result = that._replaceChars(result, diff, test.pattern, patternPositions)
                });
                result = that._escapeChars(result, defaultPattern, processedIndexes, patternPositions);
                result = that._getLanguageInfo(defaultPattern) + result;
                return result
            },
            _getLanguageInfo: function(defaultPattern) {
                var languageID = getLanguageID(),
                    languageIDStr = languageID ? languageID.toString(16) : "",
                    languageInfo = "";
                if (this._hasArabicDigits(defaultPattern)) {
                    while (languageIDStr.length < 3) {
                        languageIDStr = "0" + languageIDStr
                    }
                    languageInfo = "[$-2010" + languageIDStr + "]"
                } else {
                    if (languageIDStr) {
                        languageInfo = "[$-" + languageIDStr + "]"
                    }
                }
                return languageInfo
            },
            _convertNumberFormat: function(format, precision, currency) {
                var result, excelFormat = "currency" === format ? this._getCurrencyFormat(currency) : DEFINED_NUMBER_FORMTATS[format.toLowerCase()];
                if (excelFormat) {
                    result = stringUtils.format(excelFormat, this._applyPrecision(format, precision))
                }
                return result
            },
            convertFormat: function(format, precision, type, currency) {
                if (commonUtils.isDefined(format)) {
                    if ("date" === type) {
                        return excelFormatConverter._convertDateFormat(format)
                    } else {
                        if (commonUtils.isString(format) && DEFINED_NUMBER_FORMTATS[format.toLowerCase()]) {
                            return excelFormatConverter._convertNumberFormat(format, precision, currency)
                        }
                    }
                }
            }
        }
    },
    /*!***********************************!*\
      !*** ./js/localization/number.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 29),
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            isPlainObject = __webpack_require__( /*! ../core/utils/type */ 12).isPlainObject,
            errors = __webpack_require__( /*! ../core/errors */ 7);
        var MAX_LARGE_NUMBER_POWER = 4,
            DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = dependencyInjector({
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatList, formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                formatList = formatType.split(" ");
                $.each(formatList, function(index, value) {
                    if (inArray(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value),
                    power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                var powerPostfix;
                var result;
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var powString, power = this._calculateNumberPower(value, DECIMAL_BASE),
                    number = this._getNumberByPower(value, power, DECIMAL_BASE);
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                value = (value * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",") + (parts[1] ? "." + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : value.toFixed(formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value.toString()
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!isPlainObject(format)) {
                    format = {
                        type: format
                    }
                }
                if (format.type) {
                    format.type = format.type.toLowerCase()
                }
                return format
            },
            format: function(value, format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof format) {
                    return value
                }
                format = format && format.formatter || format;
                if ("function" === typeof format) {
                    return format(value)
                }
                format = this._normalizeFormat(format);
                if (!format.type) {
                    format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(format.type);
                if (!numberConfig) {
                    return
                }
                return this._formatNumber(value, numberConfig, format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                if (format) {
                    errors.log("W0011")
                }
                return parseFloat(text.replace(/^\D+|,+/g, ""))
            }
        });
        module.exports = numberLocalization
    },
    /*!*********************************!*\
      !*** ./js/localization/date.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            numberLocalization = __webpack_require__( /*! ./number */ 32),
            dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 29),
            isString = __webpack_require__( /*! ../core/utils/common */ 14).isString,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            errors = __webpack_require__( /*! ../core/errors */ 7);
        __webpack_require__( /*! ./core */ 34);
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            mediumdatemediumtime: "MMMM d, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var parseTime = function(text) {
            var now = new Date,
                parts = text.split(" "),
                time = parts[0].split(":"),
                hours = Number(time[0]),
                minutes = Number(time[1]),
                second = Number(time[2]) || 0,
                pm = /^pm$/i.test(parts[1]),
                isValid = second < 60 && minutes < 60 && hours > 0 && hours < 13;
            if (!isValid) {
                return null
            }
            if (!pm && 12 === hours) {
                hours = 0
            }
            if (pm && 12 !== hours) {
                hours += 12
            }
            return new Date(now.getFullYear(), now.getMonth(), now.getDate(), hours, minutes, second)
        };
        var removeTimezoneOffset = function(date) {
            return new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
        };
        var months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
            days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        var amPm = function(date) {
            return date.getHours() >= 12 ? "PM" : "AM"
        };
        var getTwelveHourTimeFormat = function(hours) {
            return hours % 12 || 12
        };
        var formatNumber = function(number, precision) {
            return numberLocalization.format(number, {
                type: "decimal",
                precision: precision
            })
        };
        var FORMATTERS = {
            millisecond: function(date) {
                return formatNumber(date.getMilliseconds(date), 3)
            },
            second: function(date) {
                return formatNumber(date.getSeconds(), 2)
            },
            minute: function(date) {
                return formatNumber(date.getMinutes(), 2)
            },
            h: function(date) {
                return formatNumber(getTwelveHourTimeFormat(date.getHours()), 1)
            },
            hh: function(date) {
                return formatNumber(getTwelveHourTimeFormat(date.getHours()), 2)
            },
            hour: function(date) {
                return formatNumber(date.getHours(), 2)
            },
            day: function(date) {
                return String(date.getDate())
            },
            dayofweek: function(date) {
                return days[date.getDay()]
            },
            M: function(date) {
                return date.getMonth() + 1
            },
            MM: function(date) {
                return formatNumber(date.getMonth() + 1, 2)
            },
            month: function(date) {
                return months[date.getMonth()]
            },
            year: function(date) {
                return String(date.getFullYear())
            },
            shortyear: function(date) {
                return String(date.getFullYear()).substr(2, 2)
            },
            shorttime: function(date) {
                return FORMATTERS.h(date) + ":" + FORMATTERS.minute(date) + " " + amPm(date)
            },
            shortdate: function(date) {
                return [FORMATTERS.M(date), FORMATTERS.day(date), FORMATTERS.year(date)].join("/")
            },
            shortdateshorttime: function(date) {
                return [FORMATTERS.shortdate(date), FORMATTERS.shorttime(date)].join(", ")
            },
            mediumdatemediumtime: function(date) {
                return [FORMATTERS.monthandday(date), FORMATTERS.shorttime(date)].join(", ")
            },
            monthandyear: function(date) {
                return [FORMATTERS.month(date), FORMATTERS.year(date)].join(" ")
            },
            monthandday: function(date) {
                return [FORMATTERS.month(date), FORMATTERS.day(date)].join(" ")
            },
            longdate: function(date) {
                return FORMATTERS.dayofweek(date) + ", " + FORMATTERS.month(date) + " " + FORMATTERS.day(date) + ", " + FORMATTERS.year(date)
            },
            longtime: function(date) {
                return [FORMATTERS.h(date), FORMATTERS.minute(date), FORMATTERS.second(date)].join(":") + " " + amPm(date)
            },
            longdatelongtime: function(date) {
                return [FORMATTERS.longdate(date), FORMATTERS.longtime(date)].join(", ")
            },
            d: function(date) {
                return formatNumber(date.getDate(), 1)
            },
            dd: function(date) {
                return formatNumber(date.getDate(), 2)
            },
            "d MMMM": function(date) {
                return FORMATTERS.day(date) + " " + FORMATTERS.month(date)
            },
            "yyyy/M/d": function(date) {
                return [FORMATTERS.year(date), FORMATTERS.M(date), FORMATTERS.day(date)].join("/")
            },
            "yyyy/MM/dd": function(date) {
                return [FORMATTERS.year(date), FORMATTERS.MM(date), FORMATTERS.dd(date)].join("/")
            },
            "dd.MM.yyyy": function(date) {
                return [FORMATTERS.dd(date), FORMATTERS.MM(date), FORMATTERS.year(date)].join(".")
            },
            "HH:mm": function(date) {
                return [FORMATTERS.hour(date), FORMATTERS.minute(date)].join(":")
            },
            "HH:mm:ss": function(date) {
                return [FORMATTERS["HH:mm"](date), FORMATTERS.second(date)].join(":")
            },
            "h:mm:ss": function(date) {
                return [FORMATTERS.h(date), FORMATTERS.minute(date), FORMATTERS.second(date)].join(":")
            },
            "h:mm:ss:SSS": function(date) {
                return [FORMATTERS.h(date), FORMATTERS.minute(date), FORMATTERS.second(date), FORMATTERS.SSS(date)].join(":")
            },
            "yyyy/MM/dd HH:mm:ss": function(date) {
                return [FORMATTERS["yyyy/MM/dd"](date), FORMATTERS["HH:mm:ss"](date)].join(" ")
            },
            "yyyy-MM-dd hh:mm:ss.SSS a": function(date) {
                return [
                    [FORMATTERS.year(date), FORMATTERS.MM(date), FORMATTERS.dd(date)].join("-"), [FORMATTERS.hh(date), FORMATTERS.minute(date), FORMATTERS.second(date)].join(":") + "." + FORMATTERS.SSS(date), amPm(date)
                ].join(" ")
            },
            "yyyy-MM-dd": function(date) {
                return [FORMATTERS.year(date), FORMATTERS.MM(date), FORMATTERS.dd(date)].join("-")
            },
            yyyyMMddTHHmmss: function(date) {
                return [FORMATTERS.year(date), FORMATTERS.MM(date), FORMATTERS.dd(date), "T", FORMATTERS.hour(date), FORMATTERS.minute(date), FORMATTERS.second(date)].join("")
            },
            "datetime-local": function(date) {
                return FORMATTERS["yyyy-MM-dd"](date) + "T" + FORMATTERS["HH:mm:ss"](date)
            },
            "yyyy-MM-ddTHH:mm:ssZ": function(date) {
                return FORMATTERS["datetime-local"](date) + "Z"
            },
            "yyyy-MM-ddTHH:mmZ": function(date) {
                return FORMATTERS["yyyy-MM-dd"](date) + "T" + FORMATTERS.hour(date) + ":" + FORMATTERS.minute(date) + "Z"
            },
            "dd/MM/yyyy": function(date) {
                return [FORMATTERS.dd(date), FORMATTERS.MM(date), FORMATTERS.year(date)].join("/")
            },
            "yyyy MMMM d": function(date) {
                return [FORMATTERS.year(date), FORMATTERS.month(date), FORMATTERS.day(date)].join(" ")
            },
            "EEEE, d": function(date) {
                return [FORMATTERS.dayofweek(date), FORMATTERS.d(date)].join(", ")
            },
            "EEEE MM yy": function(date) {
                return [FORMATTERS.dayofweek(date), FORMATTERS.MM(date), FORMATTERS.shortyear(date)].join(" ")
            },
            "d MMMM yyyy": function(date) {
                return [FORMATTERS.day(date), FORMATTERS.month(date), FORMATTERS.year(date)].join(" ")
            },
            E: function(date) {
                return cutCaptions([FORMATTERS.dayofweek(date)], "abbreviated")[0]
            },
            EEE: function(date) {
                return FORMATTERS.E(date)
            },
            "EEE hh": function(date) {
                return [FORMATTERS.EEE(date), FORMATTERS.hh(date)].join(" ")
            },
            "ss SSS": function(date) {
                return [FORMATTERS.second(date), FORMATTERS.SSS(date)].join(" ")
            },
            quarter: function(date) {
                var month = date.getMonth();
                if (month >= 0 && month < 3) {
                    return "Q1"
                }
                if (month > 2 && month < 6) {
                    return "Q2"
                }
                if (month > 5 && month < 9) {
                    return "Q3"
                }
                return "Q4"
            },
            quarterandyear: function(date) {
                return FORMATTERS.quarter(date) + " " + FORMATTERS.year(date)
            }
        };
        var parseWithoutTimezone = function(text) {
            if ("Z" !== text.slice(-1)) {
                text += "Z"
            }
            return removeTimezoneOffset(new Date(text))
        };
        var PARSERS = {
            day: function(text) {
                var now = new Date;
                return new Date(now.getFullYear(), now.getMonth(), Number(text))
            },
            hour: function(text) {
                var now = new Date;
                return new Date(now.getFullYear(), now.getMonth(), now.getDate(), Number(text))
            },
            minute: function(text) {
                var now = new Date;
                return new Date(now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), Number(text))
            },
            month: function(text) {
                return new Date((new Date).getFullYear(), inArray(text, months))
            },
            monthandday: function(text) {
                var parts = text.split(" "),
                    result = PARSERS.month(parts[0]);
                result.setDate(Number(parts[1]));
                return result
            },
            monthandyear: function(text) {
                var parts = text.split(" "),
                    result = PARSERS.month(parts[0]);
                result.setYear(Number(parts[1]));
                return result
            },
            year: function(text) {
                var date = new Date(new Date(0));
                date.setUTCFullYear(Number(text));
                return removeTimezoneOffset(date)
            },
            second: function(text) {
                var now = new Date;
                return new Date(now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), now.getMinutes(), Number(text))
            },
            shortyear: function(text) {
                var MAX_YEAR_IN_XXI_CENTURY = 36;
                var year = Number(text);
                if (year > MAX_YEAR_IN_XXI_CENTURY) {
                    year += 1900
                } else {
                    year += 2e3
                }
                return PARSERS.year(year)
            },
            shortdate: function(text) {
                if (!/^(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])\/\d{1,4}/.test(text)) {
                    return
                }
                var parts = text.split("/");
                var date = new Date(Number(parts[2]), Number(parts[0]) - 1, Number(parts[1]));
                if (parts[2].length < 3) {
                    date.setFullYear(Number(parts[2]), Number(parts[0]) - 1, Number(parts[1]))
                }
                return date
            },
            longtime: function(text) {
                return parseTime(text)
            },
            shorttime: function(text) {
                return parseTime(text)
            },
            millisecond: function(text) {
                return new Date(Number(text))
            },
            "yyyy MMMM d": function(text) {
                var parts = text.split(" ");
                if (3 !== parts.length) {
                    return
                }
                return new Date(Number(parts[0]), inArray(parts[1], months), Number(parts[2]))
            },
            "HH:mm": function(text) {
                var parts = text.split(":");
                return new Date(0, 0, 0, Number(parts[0]), Number(parts[1]), 0, 0)
            },
            "yyyy-MM-ddTHH:mm:ssZ": parseWithoutTimezone,
            "yyyy-MM-ddTHH:mmZ": parseWithoutTimezone,
            "datetime-local": parseWithoutTimezone,
            mediumdatemediumtime: function(text) {
                var parts = text.split(", "),
                    dateParts = parts[0].split(" "),
                    timeParts = parts[1].split(" ");
                var amPm = 2 === timeParts.length ? timeParts.pop() : void 0;
                var result = PARSERS.month(dateParts[0]);
                result.setDate(Number(dateParts[1]));
                timeParts = timeParts[0].split(":");
                var hours = Number(timeParts[0]);
                switch (String(amPm).toLowerCase()) {
                    case "am":
                        hours = 12 === hours ? 0 : hours;
                        break;
                    case "pm":
                        hours = 12 === hours ? 12 : hours + 12
                }
                result.setHours(hours);
                result.setMinutes(Number(timeParts[1]));
                return result
            }
        };
        $.each(FORMATS_TO_PATTERN_MAP, function(key, value) {
            value = value.replace(/'/g, "");
            FORMATTERS[value] = FORMATTERS[key];
            PARSERS[value] = PARSERS[key]
        });
        var getByFormat = function(obj, format) {
            return isString(format) && (obj[format.toLowerCase()] || obj[format.replace(/'/g, "")])
        };
        var cutCaptions = function(captions, format) {
            var lengthByFormat = {
                abbreviated: 3,
                "short": 2,
                narrow: 1
            };
            return $.map(captions, function(caption) {
                return caption.substr(0, lengthByFormat[format])
            })
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = dependencyInjector({
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format,
                    result = [];
                $.each(pattern.split(/\W+/), function(_, formatPart) {
                    $.each(possiblePartPatterns, function(partName, possiblePatterns) {
                        if (inArray(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return cutCaptions(months, format)
            },
            getDayNames: function(format) {
                return cutCaptions(days, format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            format: function(date, format) {
                if (!date) {
                    return
                }
                if (!format) {
                    return date
                }
                var formatter;
                if ("function" === typeof format) {
                    formatter = format
                } else {
                    if (format.formatter) {
                        formatter = format.formatter
                    } else {
                        format = format.type || format;
                        formatter = getByFormat(FORMATTERS, format)
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var result, parser;
                if (!text) {
                    return
                }
                if (!format) {
                    return new Date(text)
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if (format.type || format.formatter) {
                    format = format.type
                }
                if (format && "function" !== typeof format) {
                    parser = getByFormat(PARSERS, format)
                }
                if (parser) {
                    result = parser(text)
                } else {
                    errors.log("W0012");
                    result = new Date(text)
                }
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                return 0
            }
        });
        module.exports = dateLocalization
    },
    /*!*********************************!*\
      !*** ./js/localization/core.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 29);
        module.exports = dependencyInjector({
            locale: function() {
                var currentLocale = "en";
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }()
        })
    },
    /*!*******************************************!*\
      !*** ./js/localization/language_codes.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var locale = __webpack_require__( /*! ./core */ 34).locale,
            LANGUAGE_CODES = {
                ar: 1,
                bg: 2,
                ca: 3,
                "zh-Hans": 4,
                cs: 5,
                da: 6,
                de: 7,
                el: 8,
                en: 9,
                es: 10,
                fi: 11,
                fr: 12,
                he: 13,
                hu: 14,
                is: 15,
                it: 16,
                ja: 17,
                ko: 18,
                nl: 19,
                no: 20,
                pl: 21,
                pt: 22,
                rm: 23,
                ro: 24,
                ru: 25,
                hr: 26,
                sk: 27,
                sq: 28,
                sv: 29,
                th: 30,
                tr: 31,
                ur: 32,
                id: 33,
                uk: 34,
                be: 35,
                sl: 36,
                et: 37,
                lv: 38,
                lt: 39,
                tg: 40,
                fa: 41,
                vi: 42,
                hy: 43,
                az: 44,
                eu: 45,
                hsb: 46,
                mk: 47,
                tn: 50,
                xh: 52,
                zu: 53,
                af: 54,
                ka: 55,
                fo: 56,
                hi: 57,
                mt: 58,
                se: 59,
                ga: 60,
                ms: 62,
                kk: 63,
                ky: 64,
                sw: 65,
                tk: 66,
                uz: 67,
                tt: 68,
                bn: 69,
                pa: 70,
                gu: 71,
                or: 72,
                ta: 73,
                te: 74,
                kn: 75,
                ml: 76,
                as: 77,
                mr: 78,
                sa: 79,
                mn: 80,
                bo: 81,
                cy: 82,
                km: 83,
                lo: 84,
                gl: 86,
                kok: 87,
                syr: 90,
                si: 91,
                iu: 93,
                am: 94,
                tzm: 95,
                ne: 97,
                fy: 98,
                ps: 99,
                fil: 100,
                dv: 101,
                ha: 104,
                yo: 106,
                quz: 107,
                nso: 108,
                ba: 109,
                lb: 110,
                kl: 111,
                ig: 112,
                ii: 120,
                arn: 122,
                moh: 124,
                br: 126,
                ug: 128,
                mi: 129,
                oc: 130,
                co: 131,
                gsw: 132,
                sah: 133,
                qut: 134,
                rw: 135,
                wo: 136,
                prs: 140,
                gd: 145,
                "ar-SA": 1025,
                "bg-BG": 1026,
                "ca-ES": 1027,
                "zh-TW": 1028,
                "cs-CZ": 1029,
                "da-DK": 1030,
                "de-DE": 1031,
                "el-GR": 1032,
                "en-US": 1033,
                "fi-FI": 1035,
                "fr-FR": 1036,
                "he-IL": 1037,
                "hu-HU": 1038,
                "is-IS": 1039,
                "it-IT": 1040,
                "ja-JP": 1041,
                "ko-KR": 1042,
                "nl-NL": 1043,
                "nb-NO": 1044,
                "pl-PL": 1045,
                "pt-BR": 1046,
                "rm-CH": 1047,
                "ro-RO": 1048,
                "ru-RU": 1049,
                "hr-HR": 1050,
                "sk-SK": 1051,
                "sq-AL": 1052,
                "sv-SE": 1053,
                "th-TH": 1054,
                "tr-TR": 1055,
                "ur-PK": 1056,
                "id-ID": 1057,
                "uk-UA": 1058,
                "be-BY": 1059,
                "sl-SI": 1060,
                "et-EE": 1061,
                "lv-LV": 1062,
                "lt-LT": 1063,
                "tg-Cyrl-TJ": 1064,
                "fa-IR": 1065,
                "vi-VN": 1066,
                "hy-AM": 1067,
                "az-Latn-AZ": 1068,
                "eu-ES": 1069,
                "hsb-DE": 1070,
                "mk-MK": 1071,
                "tn-ZA": 1074,
                "xh-ZA": 1076,
                "zu-ZA": 1077,
                "af-ZA": 1078,
                "ka-GE": 1079,
                "fo-FO": 1080,
                "hi-IN": 1081,
                "mt-MT": 1082,
                "se-NO": 1083,
                "ms-MY": 1086,
                "kk-KZ": 1087,
                "ky-KG": 1088,
                "sw-KE": 1089,
                "tk-TM": 1090,
                "uz-Latn-UZ": 1091,
                "tt-RU": 1092,
                "bn-IN": 1093,
                "pa-IN": 1094,
                "gu-IN": 1095,
                "or-IN": 1096,
                "ta-IN": 1097,
                "te-IN": 1098,
                "kn-IN": 1099,
                "ml-IN": 1100,
                "as-IN": 1101,
                "mr-IN": 1102,
                "sa-IN": 1103,
                "mn-MN": 1104,
                "bo-CN": 1105,
                "cy-GB": 1106,
                "km-KH": 1107,
                "lo-LA": 1108,
                "gl-ES": 1110,
                "kok-IN": 1111,
                "syr-SY": 1114,
                "si-LK": 1115,
                "iu-Cans-CA": 1117,
                "am-ET": 1118,
                "ne-NP": 1121,
                "fy-NL": 1122,
                "ps-AF": 1123,
                "fil-PH": 1124,
                "dv-MV": 1125,
                "ha-Latn-NG": 1128,
                "yo-NG": 1130,
                "quz-BO": 1131,
                "nso-ZA": 1132,
                "ba-RU": 1133,
                "lb-LU": 1134,
                "kl-GL": 1135,
                "ig-NG": 1136,
                "ii-CN": 1144,
                "arn-CL": 1146,
                "moh-CA": 1148,
                "br-FR": 1150,
                "ug-CN": 1152,
                "mi-NZ": 1153,
                "oc-FR": 1154,
                "co-FR": 1155,
                "gsw-FR": 1156,
                "sah-RU": 1157,
                "qut-GT": 1158,
                "rw-RW": 1159,
                "wo-SN": 1160,
                "prs-AF": 1164,
                "gd-GB": 1169,
                "ar-IQ": 2049,
                "zh-CN": 2052,
                "de-CH": 2055,
                "en-GB": 2057,
                "es-MX": 2058,
                "fr-BE": 2060,
                "it-CH": 2064,
                "nl-BE": 2067,
                "nn-NO": 2068,
                "pt-PT": 2070,
                "sr-Latn-CS": 2074,
                "sv-FI": 2077,
                "az-Cyrl-AZ": 2092,
                "dsb-DE": 2094,
                "se-SE": 2107,
                "ga-IE": 2108,
                "ms-BN": 2110,
                "uz-Cyrl-UZ": 2115,
                "bn-BD": 2117,
                "mn-Mong-CN": 2128,
                "iu-Latn-CA": 2141,
                "tzm-Latn-DZ": 2143,
                "quz-EC": 2155,
                "ar-EG": 3073,
                "zh-HK": 3076,
                "de-AT": 3079,
                "en-AU": 3081,
                "es-ES": 3082,
                "fr-CA": 3084,
                "sr-Cyrl-CS": 3098,
                "se-FI": 3131,
                "quz-PE": 3179,
                "ar-LY": 4097,
                "zh-SG": 4100,
                "de-LU": 4103,
                "en-CA": 4105,
                "es-GT": 4106,
                "fr-CH": 4108,
                "hr-BA": 4122,
                "smj-NO": 4155,
                "ar-DZ": 5121,
                "zh-MO": 5124,
                "de-LI": 5127,
                "en-NZ": 5129,
                "es-CR": 5130,
                "fr-LU": 5132,
                "bs-Latn-BA": 5146,
                "smj-SE": 5179,
                "ar-MA": 6145,
                "en-IE": 6153,
                "es-PA": 6154,
                "fr-MC": 6156,
                "sr-Latn-BA": 6170,
                "sma-NO": 6203,
                "ar-TN": 7169,
                "en-ZA": 7177,
                "es-DO": 7178,
                "sr-Cyrl-BA": 7194,
                "sma-SE": 7227,
                "ar-OM": 8193,
                "en-JM": 8201,
                "es-VE": 8202,
                "bs-Cyrl-BA": 8218,
                "sms-FI": 8251,
                "ar-YE": 9217,
                "en-029": 9225,
                "es-CO": 9226,
                "sr-Latn-RS": 9242,
                "smn-FI": 9275,
                "ar-SY": 10241,
                "en-BZ": 10249,
                "es-PE": 10250,
                "sr-Cyrl-RS": 10266,
                "ar-JO": 11265,
                "en-TT": 11273,
                "es-AR": 11274,
                "sr-Latn-ME": 11290,
                "ar-LB": 12289,
                "en-ZW": 12297,
                "es-EC": 12298,
                "sr-Cyrl-ME": 12314,
                "ar-KW": 13313,
                "en-PH": 13321,
                "es-CL": 13322,
                "ar-AE": 14337,
                "es-UY": 14346,
                "ar-BH": 15361,
                "es-PY": 15370,
                "ar-QA": 16385,
                "en-IN": 16393,
                "es-BO": 16394,
                "en-MY": 17417,
                "es-SV": 17418,
                "en-SG": 18441,
                "es-HN": 18442,
                "es-NI": 19466,
                "es-PR": 20490,
                "es-US": 21514,
                "bs-Cyrl": 25626,
                "bs-Latn": 26650,
                "sr-Cyrl": 27674,
                "sr-Latn": 28698,
                smn: 28731,
                "az-Cyrl": 29740,
                sms: 29755,
                zh: 30724,
                nn: 30740,
                bs: 30746,
                "az-Latn": 30764,
                sma: 30779,
                "uz-Cyrl": 30787,
                "mn-Cyrl": 30800,
                "iu-Cans": 30813,
                "zh-Hant": 31748,
                nb: 31764,
                sr: 31770,
                "tg-Cyrl": 31784,
                dsb: 31790,
                smj: 31803,
                "uz-Latn": 31811,
                "mn-Mong": 31824,
                "iu-Latn": 31837,
                "tzm-Latn": 31839,
                "ha-Latn": 31848
            };
        exports.getLanguageId = function() {
            return LANGUAGE_CODES[locale()]
        }
    },
    /*!*************************************!*\
      !*** ./js/localization/currency.js ***!
      \*************************************/
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            numberLocalization = __webpack_require__( /*! ./number */ 32);
        numberLocalization.inject({
            _formatNumberCore: function(value, format, formatConfig) {
                if ("currency" === format) {
                    formatConfig.precision = formatConfig.precision || 0;
                    return this.getCurrencySymbol().symbol + this.format(value, extend({}, formatConfig, {
                        type: "fixedpoint"
                    }))
                }
                return this.callBase.apply(this, arguments)
            },
            getCurrencySymbol: function() {
                return {
                    symbol: "$"
                }
            },
            getOpenXmlCurrencyFormat: function() {
                return "$#,##0{0}_);\\($#,##0{0}\\)"
            }
        })
    },
    /*!*********************************************!*\
      !*** ./js/client_exporter/image_creator.js ***!
      \*********************************************/
    function(module, exports, __webpack_require__) {
        var clipPaths, imageDeferreds, patterns, filters, $ = __webpack_require__( /*! ../core/renderer */ 9),
            Color = __webpack_require__( /*! ../color */ 38),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            camelize = __webpack_require__( /*! ../core/utils/inflector */ 39).camelize,
            when = __webpack_require__( /*! ../integration/jquery/deferred */ 16).when,
            _math = Math,
            PI = _math.PI,
            _min = _math.min,
            _abs = _math.abs,
            _sqrt = _math.sqrt,
            _pow = _math.pow,
            _atan2 = _math.atan2,
            _cos = _math.cos,
            _sin = _math.sin,
            _each = $.each,
            _extend = extend,
            _number = Number,
            IMAGE_QUALITY = 1,
            TEXT_DECORATION_LINE_WIDTH_COEFF = .05,
            DEFAULT_MARGIN_SIZE = {
                x: 30,
                y: 20
            },
            DEFAULT_FONT_SIZE = "10px",
            DEFAULT_FONT_FAMILY = "sans-serif",
            DEFAULT_TEXT_COLOR = "#000";

        function createCanvas(width, height, withoutMargins) {
            var canvas = $("<canvas>")[0];
            canvas.width = width + (withoutMargins ? 0 : 2 * DEFAULT_MARGIN_SIZE.x);
            canvas.height = height + (withoutMargins ? 0 : 2 * DEFAULT_MARGIN_SIZE.y);
            return canvas
        }

        function getStringFromCanvas(canvas, mimeType) {
            var dataURL = canvas.toDataURL(mimeType, IMAGE_QUALITY),
                imageData = atob(dataURL.substring(("data:" + mimeType + ";base64,").length));
            return imageData
        }

        function arcTo(x1, y1, x2, y2, radius, largeArcFlag, clockwise, context) {
            var opSide, adjSide, centerX, centerY, startAngle, endAngle, cBx = (x1 + x2) / 2,
                cBy = (y1 + y2) / 2,
                aB = _atan2(y1 - y2, x1 - x2),
                k = largeArcFlag ? 1 : -1;
            aB += 90 * (PI / 180) * (clockwise ? 1 : -1);
            opSide = _sqrt(_pow(x2 - x1, 2) + _pow(y2 - y1, 2)) / 2;
            adjSide = _sqrt(_abs(_pow(radius, 2) - _pow(opSide, 2)));
            centerX = cBx + k * (adjSide * _cos(aB));
            centerY = cBy + k * (adjSide * _sin(aB));
            startAngle = _atan2(y1 - centerY, x1 - centerX);
            endAngle = _atan2(y2 - centerY, x2 - centerX);
            context.arc(centerX, centerY, radius, startAngle, endAngle, !clockwise)
        }

        function getElementOptions(element) {
            var coords, attr = parseAttributes(element.attributes || {}),
                style = element.style || {},
                options = _extend({}, attr, {
                    text: element.textContent.replace(/\s+/g, " "),
                    textAlign: "middle" === attr["text-anchor"] ? "center" : attr["text-anchor"]
                }),
                transform = attr.transform;
            if (transform) {
                coords = transform.match(/translate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/);
                if (coords) {
                    coords = coords[0].match(/-*\d+([.]\d+)*/g);
                    options.translateX = _number(coords[0]);
                    options.translateY = coords[1] ? _number(coords[1]) : 0
                }
                coords = transform.match(/rotate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*,*\s*-*\d+([.]\d+)*)*/);
                if (coords) {
                    coords = coords[0].match(/-*\d+([.]\d+)*/g);
                    options.rotationAngle = _number(coords[0]);
                    options.rotationX = coords[1] && _number(coords[1]);
                    options.rotationY = coords[2] && _number(coords[2])
                }
            }
            parseStyles(style, options);
            return options
        }

        function drawRect(context, options) {
            var x = options.x,
                y = options.y,
                width = options.width,
                height = options.height,
                cornerRadius = options.rx;
            if (!cornerRadius) {
                context.rect(options.x, options.y, options.width, options.height)
            } else {
                cornerRadius = _min(cornerRadius, width / 2, height / 2);
                context.save();
                context.translate(x, y);
                context.moveTo(width / 2, 0);
                context.arcTo(width, 0, width, height, cornerRadius);
                context.arcTo(width, height, 0, height, cornerRadius);
                context.arcTo(0, height, 0, 0, cornerRadius);
                context.arcTo(0, 0, cornerRadius, 0, cornerRadius);
                context.lineTo(width / 2, 0);
                context.restore()
            }
        }

        function drawImage(context, options) {
            var d = $.Deferred(),
                image = new Image;
            image.onload = function() {
                context.save();
                context.globalAlpha = options.globalAlpha;
                transformElement(context, options);
                clipElement(context, options);
                context.drawImage(image, options.x, options.y, options.width, options.height);
                context.restore();
                d.resolve()
            };
            image.onerror = function() {
                d.resolve()
            };
            imageDeferreds.push(d);
            image.setAttribute("crossOrigin", "anonymous");
            image.src = options["xlink:href"]
        }

        function drawPath(context, dAttr) {
            var param1, param2, dArray = dAttr.split(" "),
                i = 0;
            do {
                param1 = _number(dArray[i + 1]);
                param2 = _number(dArray[i + 2]);
                switch (dArray[i]) {
                    case "M":
                        context.moveTo(param1, param2);
                        i += 3;
                        break;
                    case "L":
                        context.lineTo(param1, param2);
                        i += 3;
                        break;
                    case "C":
                        context.bezierCurveTo(param1, param2, _number(dArray[i + 3]), _number(dArray[i + 4]), _number(dArray[i + 5]), _number(dArray[i + 6]));
                        i += 7;
                        break;
                    case "A":
                        arcTo(_number(dArray[i - 2]), _number(dArray[i - 1]), _number(dArray[i + 6]), _number(dArray[i + 7]), param1, _number(dArray[i + 4]), _number(dArray[i + 5]), context);
                        i += 8;
                        break;
                    case "Z":
                        context.closePath();
                        i += 1
                }
            } while (i < dArray.length)
        }

        function parseStyles(style, options) {
            _each(style, function(_, field) {
                if ("" !== style[field]) {
                    options[camelize(field)] = style[field]
                }
            });
            options.textDecoration = options.textDecoration || options.textDecorationLine;
            options.globalAlpha = options.opacity || options.globalAlpha
        }

        function parseUrl(urlString) {
            var matches = urlString && urlString.match(/url\(.*\#(.*?)["']?\)/i);
            return matches && matches[1]
        }

        function setFontStyle(context, options) {
            var fontParams = [];
            options.fontSize = options.fontSize || DEFAULT_FONT_SIZE;
            options.fontFamily || DEFAULT_FONT_FAMILY;
            options.fill = options.fill || DEFAULT_TEXT_COLOR;
            options.fontStyle && fontParams.push(options.fontStyle);
            options.fontWeight && fontParams.push(options.fontWeight);
            fontParams.push(options.fontSize);
            fontParams.push(options.fontFamily);
            context.font = fontParams.join(" ");
            context.textAlign = options.textAlign;
            context.fillStyle = options.fill;
            context.globalAlpha = options.globalAlpha
        }

        function drawText(context, options) {
            setFontStyle(context, options);
            options.text && context.fillText(options.text, options.x || 0, options.y || 0);
            strokeElement(context, options, true);
            drawTextDecoration(context, options)
        }

        function drawTextDecoration(context, options) {
            if (!options.textDecoration || "none" === options.textDecoration) {
                return
            }
            var x = options.x,
                textWidth = context.measureText(options.text).width,
                textHeight = parseInt(options.fontSize, 10),
                lineHeight = textHeight * TEXT_DECORATION_LINE_WIDTH_COEFF < 1 ? 1 : textHeight * TEXT_DECORATION_LINE_WIDTH_COEFF,
                y = options.y;
            switch (options.textDecoration) {
                case "line-through":
                    y -= textHeight / 3 + lineHeight / 2;
                    break;
                case "overline":
                    y -= textHeight - lineHeight;
                    break;
                case "underline":
                    y += lineHeight
            }
            context.rect(x, y, textWidth, lineHeight);
            fillElement(context, options);
            strokeElement(context, options)
        }

        function createClipPath(element) {
            clipPaths[element.attributes.id.textContent] = element.childNodes[0]
        }

        function createPattern(element) {
            patterns[element.attributes.id.textContent] = element
        }

        function aggregateOpacity(options) {
            options.strokeOpacity = void 0 !== options["stroke-opacity"] ? options["stroke-opacity"] : 1;
            options.fillOpacity = void 0 !== options["fill-opacity"] ? options["fill-opacity"] : 1;
            if (void 0 !== options.opacity) {
                options.strokeOpacity *= options.opacity;
                options.fillOpacity *= options.opacity
            }
        }

        function hasTspan(element) {
            var nodes = element.childNodes;
            for (var i = 0; i < nodes.length; i++) {
                if ("tspan" === nodes[i].tagName) {
                    return true
                }
            }
            return false
        }

        function drawTextElement(childNodes, context, options) {
            var line, lines = [],
                offset = 0;
            for (var i = 0; i < childNodes.length; i++) {
                var element = childNodes[i];
                if (void 0 === element.tagName) {
                    drawElement(element, context, options)
                } else {
                    if ("tspan" === element.tagName || "text" === element.tagName) {
                        var elementOptions = getElementOptions(element),
                            mergedOptions = _extend({}, options, elementOptions);
                        if ("tspan" === element.tagName && hasTspan(element)) {
                            drawTextElement(element.childNodes, context, mergedOptions);
                            continue
                        }
                        mergedOptions.textAlign = "start";
                        if (!line || void 0 !== elementOptions.x) {
                            line = {
                                elements: [],
                                options: [],
                                widths: [],
                                offsets: []
                            };
                            lines.push(line)
                        }
                        if (void 0 !== elementOptions.dy) {
                            offset += Number(elementOptions.dy)
                        }
                        line.elements.push(element);
                        line.options.push(mergedOptions);
                        line.offsets.push(offset);
                        setFontStyle(context, mergedOptions);
                        line.widths.push(context.measureText(mergedOptions.text).width)
                    }
                }
            }
            lines.forEach(function(line) {
                var commonWidth = line.widths.reduce(function(commonWidth, width) {
                        return commonWidth + width
                    }, 0),
                    xDiff = 0,
                    currentOffset = 0;
                if ("center" === options.textAlign) {
                    xDiff = commonWidth / 2
                }
                if ("end" === options.textAlign) {
                    xDiff = commonWidth
                }
                line.options.forEach(function(o, index) {
                    var width = line.widths[index];
                    o.x = o.x - xDiff + currentOffset;
                    o.y += line.offsets[index];
                    currentOffset += width
                });
                line.elements.forEach(function(element, index) {
                    drawTextElement(element.childNodes, context, line.options[index])
                })
            })
        }

        function drawElement(element, context, parentOptions) {
            var tagName = element.tagName,
                isText = "text" === tagName || "tspan" === tagName || void 0 === tagName,
                isImage = "image" === tagName,
                options = _extend({}, parentOptions, getElementOptions(element));
            if ("hidden" === options.visibility) {
                return
            }
            context.save();
            !isImage && transformElement(context, options);
            clipElement(context, options);
            aggregateOpacity(options);
            context.beginPath();
            switch (element.tagName) {
                case void 0:
                    drawText(context, options);
                    break;
                case "text":
                case "tspan":
                    drawTextElement(element.childNodes, context, options);
                    break;
                case "image":
                    drawImage(context, options);
                    break;
                case "path":
                    drawPath(context, options.d);
                    break;
                case "rect":
                    drawRect(context, options);
                    context.closePath();
                    break;
                case "circle":
                    context.arc(options.cx, options.cy, options.r, 0, 2 * PI, 1)
            }
            applyFilter(context, options);
            if (!isText) {
                fillElement(context, options);
                strokeElement(context, options)
            }
            context.restore()
        }

        function applyFilter(context, options) {
            var filterOptions, id = parseUrl(options.filter);
            if (id) {
                filterOptions = filters && filters[id];
                if (!filterOptions) {
                    filterOptions = {
                        offsetX: 0,
                        offsetY: 0,
                        blur: 0,
                        color: "#000"
                    }
                }
                context.shadowOffsetX = filterOptions.offsetX;
                context.shadowOffsetY = filterOptions.offsetY;
                context.shadowColor = filterOptions.color;
                context.shadowBlur = filterOptions.blur
            }
        }

        function transformElement(context, options) {
            context.translate(options.translateX || 0, options.translateY || 0);
            delete options.translateX;
            delete options.translateY;
            if (options.rotationAngle) {
                context.translate(options.rotationX || 0, options.rotationY || 0);
                context.rotate(options.rotationAngle * PI / 180);
                context.translate(-(options.rotationX || 0), -(options.rotationY || 0));
                delete options.rotationAngle;
                delete options.rotationX;
                delete options.rotationY
            }
        }

        function clipElement(context, options) {
            if (options["clip-path"]) {
                drawElement(clipPaths[parseUrl(options["clip-path"])], context, {});
                context.clip();
                delete options["clip-path"]
            }
        }

        function hex2rgba(hexColor, alpha) {
            var color = new Color(hexColor);
            return "rgba(" + color.r + "," + color.g + "," + color.b + "," + alpha + ")"
        }

        function createFilter(element) {
            var color, opacity, filterOptions = {};
            _each(element.childNodes, function(_, node) {
                var attr = node.attributes;
                if (!attr.result) {
                    return
                }
                switch (attr.result.value) {
                    case "gaussianBlurResult":
                        if (attr.stdDeviation) {
                            filterOptions.blur = _number(attr.stdDeviation.value)
                        }
                        break;
                    case "offsetResult":
                        filterOptions.offsetX = _number(attr.dx.value);
                        filterOptions.offsetY = _number(attr.dy.value);
                        break;
                    case "floodResult":
                        color = attr["flood-color"] ? attr["flood-color"].value : "#000";
                        opacity = attr["flood-opacity"] ? attr["flood-opacity"].value : 1;
                        filterOptions.color = hex2rgba(color, opacity)
                }
            });
            filters[element.id] = filterOptions
        }

        function drawCanvasElements(elements, context, parentOptions) {
            var options;
            _each(elements, function(_, element) {
                switch (element.tagName && element.tagName.toLowerCase()) {
                    case "g":
                        options = _extend({}, parentOptions, getElementOptions(element));
                        context.save();
                        transformElement(context, options);
                        clipElement(context, options);
                        drawCanvasElements(element.childNodes, context, options);
                        context.restore();
                        break;
                    case "defs":
                        clipPaths = {};
                        patterns = {};
                        filters = {};
                        drawCanvasElements(element.childNodes, context);
                        break;
                    case "clippath":
                        createClipPath(element);
                        break;
                    case "pattern":
                        createPattern(element);
                        break;
                    case "filter":
                        createFilter(element);
                        break;
                    default:
                        drawElement(element, context, parentOptions)
                }
            })
        }

        function setLineDash(context, options) {
            var matches = options["stroke-dasharray"] && options["stroke-dasharray"].match(/(\d+)/g);
            if (matches && matches.length && context.setLineDash) {
                matches = $.map(matches, function(item) {
                    return _number(item)
                });
                context.setLineDash(matches)
            }
        }

        function strokeElement(context, options, isText) {
            var stroke = options.stroke;
            if (stroke && "none" !== stroke && 0 !== options["stroke-width"]) {
                setLineDash(context, options);
                context.lineJoin = options["stroke-linejoin"];
                context.lineWidth = options["stroke-width"];
                context.globalAlpha = options.strokeOpacity;
                context.strokeStyle = stroke;
                isText ? context.strokeText(options.text, options.x, options.y) : context.stroke()
            }
        }

        function getPattern(context, fill) {
            var pattern = patterns[parseUrl(fill)],
                options = getElementOptions(pattern),
                patternCanvas = createCanvas(options.width, options.height, true),
                patternContext = patternCanvas.getContext("2d");
            drawCanvasElements(pattern.childNodes, patternContext, options);
            return context.createPattern(patternCanvas, "repeat")
        }

        function fillElement(context, options) {
            var fill = options.fill;
            if (fill && "none" !== fill) {
                context.fillStyle = fill.search(/url/) === -1 ? fill : getPattern(context, fill);
                context.globalAlpha = options.fillOpacity;
                context.fill()
            }
        }
        var parseAttributes = function(attributes) {
            var attr, newAttributes = {};
            $.each(attributes, function(index, item) {
                attr = item.textContent;
                if (isFinite(attr)) {
                    attr = _number(attr)
                }
                newAttributes[item.name.toLowerCase()] = attr
            });
            return newAttributes
        };

        function drawBackground(context, width, height, backgroundColor) {
            context.fillStyle = backgroundColor || "#ffffff";
            context.fillRect(-DEFAULT_MARGIN_SIZE.x, -DEFAULT_MARGIN_SIZE.y, width + 2 * DEFAULT_MARGIN_SIZE.x, height + 2 * DEFAULT_MARGIN_SIZE.y)
        }

        function getCanvasFromSvg(markup, width, height, backgroundColor) {
            var canvas = createCanvas(width, height),
                context = canvas.getContext("2d"),
                parser = new DOMParser,
                elem = parser.parseFromString(markup, "image/svg+xml"),
                svgElem = elem.childNodes[0];
            context.translate(DEFAULT_MARGIN_SIZE.x, DEFAULT_MARGIN_SIZE.y);
            imageDeferreds = [];
            document.body.appendChild(canvas);
            if (svgElem.attributes.direction) {
                canvas.dir = svgElem.attributes.direction.textContent
            }
            drawBackground(context, width, height, backgroundColor);
            drawCanvasElements(svgElem.childNodes, context, {});
            document.body.removeChild(canvas);
            return canvas
        }

        function resolveString(string, canvas, mimeType) {
            when.apply($, imageDeferreds).done(function() {
                var resultString = getStringFromCanvas(canvas, mimeType);
                string.resolve(resultString)
            })
        }
        exports.imageCreator = {
            getImageData: function(markup, options) {
                var mimeType = "image/" + options.format,
                    string = $.Deferred(),
                    width = options.width,
                    height = options.height,
                    backgroundColor = options.backgroundColor;
                if (commonUtils.isFunction(options.__parseAttributesFn)) {
                    parseAttributes = options.__parseAttributesFn
                }
                resolveString(string, getCanvasFromSvg(markup, width, height, backgroundColor), mimeType);
                return string
            },
            getData: function(markup, options) {
                var that = this,
                    imageData = exports.imageCreator.getImageData(markup, options),
                    mimeType = "image/" + options.format,
                    data = $.Deferred();
                when(imageData).done(function(binaryData) {
                    imageData = commonUtils.isFunction(window.Blob) ? that._getBlob(binaryData, mimeType) : that._getBase64(binaryData);
                    data.resolve(imageData)
                });
                return data
            },
            _getBlob: function(binaryData, mimeType) {
                var i, dataArray = new Uint8Array(binaryData.length);
                for (i = 0; i < binaryData.length; i++) {
                    dataArray[i] = binaryData.charCodeAt(i)
                }
                return new Blob([dataArray.buffer], {
                    type: mimeType
                })
            },
            _getBase64: function(binaryData) {
                return window.btoa(binaryData)
            }
        };
        exports.getData = function(data, options, callback) {
            exports.imageCreator.getData(data, options).done(callback)
        }
    },
    /*!*********************!*\
      !*** ./js/color.js ***!
      \*********************/
    function(module, exports) {
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    v = parseInt(colorString[3], 10),
                    rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    l = parseInt(colorString[3], 10),
                    rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var str, i = 0,
                ii = standardColorTypes.length;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var H, S, V, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                delta = max - min;
            V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var vDec, vInc, vMin, index, a, r, g, b;
            index = Math.floor(h % 360 / 60);
            vMin = (100 - s) * v / 100;
            a = (v - vMin) * (h % 60 / 60);
            vInc = vMin + a;
            vDec = v - a;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var h, s, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                maxMinSum = max + min,
                l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r, g, b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s,
                    p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        var _round = Math.round;
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor),
                    result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false
        };
        module.exports = Color
    },
    /*!************************************!*\
      !*** ./js/core/utils/inflector.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9);
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return $.map(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        var camelize = function(text, upperFirst) {
            return $.map(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        var titleize = function(text) {
            return $.map(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        var captionize = function(name) {
            var i, char, captionList = [],
                isPrevCharNewWord = false,
                isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() || char in ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.dasherize = dasherize;
        exports.camelize = camelize;
        exports.humanize = humanize;
        exports.titleize = titleize;
        exports.underscore = underscore;
        exports.captionize = captionize
    },
    /*!*******************************************!*\
      !*** ./js/client_exporter/pdf_creator.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            VERSION = __webpack_require__( /*! ../core/version */ 19),
            imageCreator = __webpack_require__( /*! ./image_creator */ 37).imageCreator,
            isFunction = __webpack_require__( /*! ../core/utils/common */ 14).isFunction,
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            when = __webpack_require__( /*! ../integration/jquery/deferred */ 16).when,
            mainPageTemplate = "%PDF-1.3\r\n2 0 obj\r\n<</ProcSet[/PDF/ImageB/ImageC/ImageI]/XObject<</I0 5 0 R>>>>\r\nendobj\r\n4 0 obj\r\n<</Type/Pages/Kids[1 0 R]/Count 1>>\r\nendobj\r\n7 0 obj\r\n<</OpenAction[1 0 R /FitH null]/Type/Catalog/Pages 4 0 R/PageLayout/OneColumn>>\r\nendobj\r\n1 0 obj\r\n<</Type/Page/Resources 2 0 R/MediaBox[0 0 _width_ _height_]/Contents 3 0 R/Parent 4 0 R>>\r\nendobj\r\n",
            contentTemplate = "3 0 obj\r\n<</Length 52>>stream\r\n0.20 w\n0 G\nq _width_ 0 0 _height_ 0.00 0.00 cm /I0 Do Q\r\nendstream\r\nendobj\r\n",
            infoTemplate = "6 0 obj\r\n<</CreationDate _date_/Producer(DevExtreme _version_)>>\r\nendobj\r\n",
            imageStartTemplate = "5 0 obj\r\n<</Type/XObject/Subtype/Image/Width _width_/Height _height_/ColorSpace/DeviceRGB/BitsPerComponent 8/Filter/DCTDecode/Length _length_>>stream\r\n",
            imageEndTemplate = "\r\nendstream\r\nendobj\r\n",
            trailerTemplate = "trailer\r\n<<\r\n/Size 8\r\n/Root 7 0 R\r\n/Info 6 0 R\r\n>>\r\nstartxref\r\n_length_\r\n%%EOF",
            xrefTemplate = "xref\r\n0 8\r\n0000000000 65535 f\r\n0000000241 00000 n\r\n0000000010 00000 n\r\n_main_ 00000 n\r\n0000000089 00000 n\r\n_image_ 00000 n\r\n_info_ 00000 n\r\n0000000143 00000 n\r\n",
            DEFAULT_MARGIN_X = 60,
            DEFAULT_MARGIN_Y = 40;
        var pad = function(str, len) {
            return str.length < len ? pad("0" + str, len) : str
        };
        var composePdfString = function(imageString, options, curDate) {
            var width = options.width + DEFAULT_MARGIN_X,
                height = options.height + DEFAULT_MARGIN_Y,
                widthPt = (.75 * width).toFixed(2),
                heightPt = (.75 * height).toFixed(2);
            var mainPage = mainPageTemplate.replace("_width_", widthPt).replace("_height_", heightPt),
                content = contentTemplate.replace("_width_", widthPt).replace("_height_", heightPt),
                info = infoTemplate.replace("_date_", curDate).replace("_version_", VERSION),
                image = imageStartTemplate.replace("_width_", width).replace("_height_", height).replace("_length_", imageString.length) + imageString + imageEndTemplate,
                xref = getXref(mainPage.length, content.length, info.length);
            var mainContent = mainPage + content + info + image,
                trailer = trailerTemplate.replace("_length_", mainContent.length);
            return mainContent + xref + trailer
        };
        var getXref = function(mainPageLength, contentLength, infoLength) {
            return xrefTemplate.replace("_main_", pad(mainPageLength + "", 10)).replace("_info_", pad(mainPageLength + contentLength + "", 10)).replace("_image_", pad(mainPageLength + contentLength + infoLength + "", 10))
        };
        var getCurDate = function() {
            return new Date
        };
        var getBlob = function(binaryData) {
            var i = 0,
                dataArray = new Uint8Array(binaryData.length);
            for (; i < binaryData.length; i++) {
                dataArray[i] = binaryData.charCodeAt(i)
            }
            return new Blob([dataArray.buffer], {
                type: "application/pdf"
            })
        };
        var getBase64 = function(binaryData) {
            return window.btoa(binaryData)
        };
        exports.getData = function(data, options, callback) {
            var imageData = imageCreator.getImageData(data, extend({}, options, {
                    format: "jpeg"
                })),
                blob = $.Deferred();
            blob.done(callback);
            when(imageData).done(function(imageString) {
                var binaryData = composePdfString(imageString, options, getCurDate()),
                    pdfData = isFunction(window.Blob) ? getBlob(binaryData) : getBase64(binaryData);
                blob.resolve(pdfData)
            })
        };
        exports.__tests = {
            set_composePdfString: function(func) {
                exports.__tests.composePdfString = composePdfString;
                composePdfString = func
            },
            restore_composePdfString: function(func) {
                if (exports.__tests.composePdfString) {
                    composePdfString = exports.__tests.composePdfString;
                    exports.__tests.composePdfString = null
                }
            },
            set_getCurDate: function(func) {
                exports.__tests.getCurDate = getCurDate;
                getCurDate = func
            },
            restore_getCurDate: function(func) {
                if (exports.__tests.getCurDate) {
                    getCurDate = exports.__tests.getCurDate;
                    exports.__tests.getCurDate = null
                }
            },
            set_getBlob: function(func) {
                exports.__tests.getBlob = getBlob;
                getBlob = func
            },
            restore_getBlob: function(func) {
                if (exports.__tests.getBlob) {
                    getBlob = exports.__tests.getBlob;
                    exports.__tests.getBlob = null
                }
            },
            set_getBase64: function(func) {
                exports.__tests.getBase64 = getBase64;
                getBase64 = func
            },
            restore_getBase64: function(func) {
                if (exports.__tests.getBase64) {
                    getBase64 = exports.__tests.getBase64;
                    exports.__tests.getBase64 = null
                }
            }
        }
    },
    /*!*******************************************!*\
      !*** ./js/client_exporter/svg_creator.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            getSvgMarkup = __webpack_require__( /*! ../core/utils/svg */ 42).getSvgMarkup,
            when = __webpack_require__( /*! ../integration/jquery/deferred */ 16).when;
        exports.svgCreator = {
            _markup: "",
            _imageArray: {},
            _imageDeferreds: [],
            _getBinaryFile: function(src, callback) {
                var xhr = new XMLHttpRequest;
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === xhr.DONE) {
                        if (200 === xhr.status && xhr.response) {
                            callback(xhr.response)
                        } else {
                            callback(false)
                        }
                    }
                };
                xhr.open("GET", src, true);
                xhr.responseType = "arraybuffer";
                xhr.send()
            },
            _loadImages: function() {
                var that = this;
                $.each(that._imageArray, function(src) {
                    var deferred = new $.Deferred;
                    that._imageDeferreds.push(deferred);
                    that._getBinaryFile(src, function(response) {
                        if (!response) {
                            delete that._imageArray[src];
                            deferred.resolve();
                            return
                        }
                        var i, binary = "",
                            bytes = new Uint8Array(response),
                            length = bytes.byteLength;
                        for (i = 0; i < length; i++) {
                            binary += String.fromCharCode(bytes[i])
                        }
                        that._imageArray[src] = "data:image/png;base64," + btoa(binary);
                        deferred.resolve()
                    })
                })
            },
            _parseImages: function(element) {
                var href, that = this;
                if ("image" === element.tagName) {
                    href = $(element).attr("xlink:href");
                    if (!that._imageArray[href]) {
                        that._imageArray[href] = ""
                    }
                }
                $.each(element.childNodes, function(_, element) {
                    that._parseImages(element)
                })
            },
            _prepareImages: function(svgElem) {
                this._parseImages(svgElem);
                this._loadImages();
                return when.apply($, this._imageDeferreds)
            },
            getData: function(data, options) {
                var markup, that = this,
                    xmlVersion = '<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>',
                    blob = $.Deferred(),
                    parser = new DOMParser,
                    elem = parser.parseFromString(data, "image/svg+xml"),
                    svgElem = elem.childNodes[0],
                    $svgObject = $(svgElem);
                $svgObject.css("background-color", options.backgroundColor);
                markup = xmlVersion + getSvgMarkup($svgObject.get(0));
                that._prepareImages(svgElem).done(function() {
                    $.each(that._imageArray, function(href, dataURI) {
                        markup = markup.split(href).join(dataURI)
                    });
                    blob.resolve(commonUtils.isFunction(window.Blob) ? that._getBlob(markup) : that._getBase64(markup))
                });
                return blob
            },
            _getBlob: function(markup) {
                return new Blob([markup], {
                    type: "image/svg+xml"
                })
            },
            _getBase64: function(markup) {
                return window.btoa(markup)
            }
        };
        exports.getData = function(data, options, callback) {
            exports.svgCreator.getData(data, options).done(callback)
        }
    },
    /*!******************************!*\
      !*** ./js/core/utils/svg.js ***!
      \******************************/
    function(module, exports) {
        function getMarkup(element) {
            var temp = document.createElement("div");
            temp.appendChild(element.cloneNode(true));
            return temp.innerHTML
        }

        function fixIENamespaces(markup) {
            var first = true;
            markup = markup.replace(/xmlns="[\s\S]*?"/gi, function(match) {
                if (!first) {
                    return ""
                }
                first = false;
                return match
            });
            return markup.replace(/xmlns:NS1="[\s\S]*?"/gi, "").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi, 'xmlns:xlink="$1"')
        }

        function decodeHtmlEntities(markup) {
            return markup.replace(/&quot;/gi, "&#34;").replace(/&amp;/gi, "&#38;").replace(/&apos;/gi, "&#39;").replace(/&lt;/gi, "&#60;").replace(/&gt;/gi, "&#62;").replace(/&nbsp;/gi, "&#160;").replace(/&shy;/gi, "&#173;")
        }
        exports.getSvgMarkup = function(element) {
            return fixIENamespaces(decodeHtmlEntities(getMarkup(element)))
        }
    },
    /*!**********************************!*\
      !*** ./js/core/dom_component.js ***!
      \**********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            extend = __webpack_require__( /*! ./utils/extend */ 11).extend,
            config = __webpack_require__( /*! ./config */ 15),
            errors = __webpack_require__( /*! ./errors */ 7),
            windowResizeCallbacks = __webpack_require__( /*! ./utils/window */ 44).resizeCallbacks,
            commonUtils = __webpack_require__( /*! ./utils/common */ 14),
            inArray = __webpack_require__( /*! ./utils/array */ 26).inArray,
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 45),
            Component = __webpack_require__( /*! ./component */ 48),
            abstract = Component.abstract;
        var RTL_DIRECTION_CLASS = "dx-rtl",
            VISIBILITY_CHANGE_CLASS = "dx-visibility-change-handler",
            VISIBILITY_CHANGE_EVENTNAMESPACE = "VisibilityChange";
        var DOMComponent = Component.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: config().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                })
            },
            ctor: function(element, options) {
                this._$element = $(element);
                publicComponentUtils.attachInstanceToElement(this._$element, this, this._dispose);
                this.callBase(options)
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && this._convertRulesToOptions(this.constructor._classCustomRules).hasOwnProperty(name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    windowResizeCallbacks.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _render: function() {
                this._renderElementAttributes();
                this._toggleRTLDirection(this.option("rtlEnabled"));
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _renderElementAttributes: function() {
                var attributes = extend({}, this.option("elementAttr")),
                    classNames = attributes.class;
                delete attributes.class;
                this.element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                this.element().addClass(VISIBILITY_CHANGE_CLASS);
                this._attachVisibilityChangeHandlers()
            },
            _renderDimensions: function() {
                var width = this.option("width"),
                    height = this.option("height"),
                    $element = this.element();
                $element.outerWidth(width);
                $element.outerHeight(height)
            },
            _attachDimensionChangeHandlers: function() {
                var that = this;
                var resizeEventName = "dxresize." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                that.element().off(resizeEventName).on(resizeEventName, function() {
                    that._dimensionChanged()
                })
            },
            _attachVisibilityChangeHandlers: function() {
                var that = this;
                var hidingEventName = "dxhiding." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                var shownEventName = "dxshown." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                that._isHidden = !that._isVisible();
                that.element().off(hidingEventName).on(hidingEventName, function() {
                    that._checkVisibilityChanged("hiding")
                }).off(shownEventName).on(shownEventName, function() {
                    that._checkVisibilityChanged("shown")
                })
            },
            _isVisible: function() {
                return this.element().is(":visible")
            },
            _checkVisibilityChanged: function(event) {
                if ("hiding" === event && this._isVisible() && !this._isHidden) {
                    this._visibilityChanged(false);
                    this._isHidden = true
                } else {
                    if ("shown" === event && this._isVisible() && this._isHidden) {
                        this._isHidden = false;
                        this._visibilityChanged(true)
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract
            },
            _clean: commonUtils.noop,
            _modelByElement: function() {
                var modelByElement = this.option("modelByElement") || commonUtils.noop;
                return modelByElement(this.element())
            },
            _invalidate: function() {
                if (!this._updateLockCount) {
                    throw errors.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._render()
            },
            _dispose: function() {
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    windowResizeCallbacks.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                this.element().toggleClass(RTL_DIRECTION_CLASS, rtl)
            },
            _createComponent: function(element, component, config) {
                var that = this;
                config = config || {};
                var synchronizableOptions = commonUtils.grep(["rtlEnabled", "disabled"], function(value) {
                    return !(value in config)
                });
                var nestedComponentOptions = that.option("nestedComponentOptions") || commonUtils.noop;
                that._extendConfig(config, extend({
                    integrationOptions: this.option("integrationOptions"),
                    rtlEnabled: this.option("rtlEnabled"),
                    disabled: this.option("disabled")
                }, nestedComponentOptions(this)));
                var instance;
                if (commonUtils.isString(component)) {
                    var $element = $(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(args) {
                        if (inArray(args.name, synchronizableOptions) >= 0) {
                            instance.option(args.name, args.value)
                        }
                    };
                    that.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        that.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                $.each(extendConfig, function(key, value) {
                    config[key] = config.hasOwnProperty(key) ? config[key] : value
                })
            },
            _defaultActionConfig: function() {
                return extend(this.callBase(), {
                    context: this._modelByElement(this.element())
                })
            },
            _defaultActionArgs: function() {
                var element = this.element(),
                    model = this._modelByElement(this.element());
                return extend(this.callBase(), {
                    element: element,
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                    case "elementAttr":
                        this._invalidate();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            endUpdate: function() {
                var requireRender = !this._initializing && !this._initialized;
                this.callBase.apply(this, arguments);
                if (!this._updateLockCount) {
                    if (requireRender) {
                        this._render()
                    } else {
                        if (this._requireRefresh) {
                            this._requireRefresh = false;
                            this._refresh()
                        }
                    }
                }
            },
            element: function() {
                return this._$element
            }
        });
        DOMComponent.getInstance = function($element) {
            return publicComponentUtils.getInstanceByElement($($element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        module.exports = DOMComponent
    },
    /*!*********************************!*\
      !*** ./js/core/utils/window.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9);
        var resizeCallbacks = function() {
            var prevSize, callbacks = $.Callbacks(),
                jqWindow = $(window),
                resizeEventHandlerAttached = false,
                originalCallbacksAdd = callbacks.add,
                originalCallbacksRemove = callbacks.remove;
            var formatSize = function() {
                return {
                    width: jqWindow.width(),
                    height: jqWindow.height()
                }
            };
            var handleResize = function() {
                var now = formatSize();
                if (now.width === prevSize.width && now.height === prevSize.height) {
                    return
                }
                var changedDimension;
                if (now.width === prevSize.width) {
                    changedDimension = "height"
                }
                if (now.height === prevSize.height) {
                    changedDimension = "width"
                }
                prevSize = now;
                setTimeout(function() {
                    callbacks.fire(changedDimension)
                })
            };
            prevSize = formatSize();
            callbacks.add = function() {
                var result = originalCallbacksAdd.apply(callbacks, arguments);
                if (!resizeEventHandlerAttached && callbacks.has()) {
                    jqWindow.on("resize", handleResize);
                    resizeEventHandlerAttached = true
                }
                return result
            };
            callbacks.remove = function() {
                var result = originalCallbacksRemove.apply(callbacks, arguments);
                if (!callbacks.has() && resizeEventHandlerAttached) {
                    jqWindow.off("resize", handleResize);
                    resizeEventHandlerAttached = false
                }
                return result
            };
            return callbacks
        }();
        var defaultScreenFactorFunc = function(width) {
            if (width < 768) {
                return "xs"
            } else {
                if (width < 992) {
                    return "sm"
                } else {
                    if (width < 1200) {
                        return "md"
                    } else {
                        return "lg"
                    }
                }
            }
        };
        var getCurrentScreenFactor = function(screenFactorCallback) {
            var screenFactorFunc = screenFactorCallback || defaultScreenFactorFunc;
            return screenFactorFunc($(window).width())
        };
        exports.resizeCallbacks = resizeCallbacks;
        exports.defaultScreenFactorFunc = defaultScreenFactorFunc;
        exports.getCurrentScreenFactor = getCurrentScreenFactor
    },
    /*!*******************************************!*\
      !*** ./js/core/utils/public_component.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            WeakMap = __webpack_require__( /*! ../polyfills/weak_map */ 46),
            commonUtils = __webpack_require__( /*! ./common */ 14),
            removeEvent = __webpack_require__( /*! ../remove_event */ 47);
        var COMPONENT_NAMES_DATA_KEY = "dxComponents",
            ANONYMOUS_COMPONENT_DATA_KEY = "dxPrivateComponent";
        var componentNames = new WeakMap,
            nextAnonymousComponent = 0;
        var getName = exports.name = function(componentClass, newName) {
            if (commonUtils.isDefined(newName)) {
                componentNames.set(componentClass, newName);
                return
            }
            if (!componentNames.has(componentClass)) {
                var generatedName = ANONYMOUS_COMPONENT_DATA_KEY + nextAnonymousComponent++;
                componentNames.set(componentClass, generatedName);
                return generatedName
            }
            return componentNames.get(componentClass)
        };
        exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
            var data = $.data($element.get(0)),
                name = getName(componentInstance.constructor);
            data[name] = componentInstance;
            if (disposeFn) {
                $element.one(removeEvent, function() {
                    disposeFn.call(componentInstance)
                })
            }
            if (!data[COMPONENT_NAMES_DATA_KEY]) {
                data[COMPONENT_NAMES_DATA_KEY] = []
            }
            data[COMPONENT_NAMES_DATA_KEY].push(name)
        };
        exports.getInstanceByElement = function($element, componentClass) {
            var name = getName(componentClass);
            return $.data($element.get(0), name)
        }
    },
    /*!***************************************!*\
      !*** ./js/core/polyfills/weak_map.js ***!
      \***************************************/
    function(module, exports, __webpack_require__) {
        var inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            WeakMap = window.WeakMap;
        if (!WeakMap) {
            WeakMap = function() {
                var keys = [],
                    values = [];
                this.set = function(key, value) {
                    var index = inArray(key, keys);
                    if (index === -1) {
                        keys.push(key);
                        values.push(value)
                    } else {
                        values[index] = value
                    }
                };
                this.get = function(key) {
                    var index = inArray(key, keys);
                    if (index === -1) {
                        return
                    }
                    return values[index]
                };
                this.has = function(key) {
                    var index = inArray(key, keys);
                    if (index === -1) {
                        return false
                    }
                    return true
                }
            }
        }
        module.exports = WeakMap
    },
    /*!*********************************!*\
      !*** ./js/core/remove_event.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            jQuery = __webpack_require__( /*! jquery */ 10),
            cleanData = jQuery.cleanData,
            specialEvents = $.event.special;
        var eventName = "dxremove",
            eventPropName = "dxRemoveEvent";
        jQuery.cleanData = function(elements) {
            elements = [].slice.call(elements);
            for (var i = 0; i < elements.length; i++) {
                var $element = $(elements[i]);
                if ($element.prop(eventPropName)) {
                    $element.removeProp(eventPropName);
                    $element.triggerHandler(eventName)
                }
            }
            return cleanData(elements)
        };
        specialEvents[eventName] = {
            noBubble: true,
            setup: function() {
                $(this).prop(eventPropName, true)
            }
        };
        module.exports = eventName
    },
    /*!******************************!*\
      !*** ./js/core/component.js ***!
      \******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            Config = __webpack_require__( /*! ./config */ 15),
            extend = __webpack_require__( /*! ./utils/extend */ 11).extend,
            Class = __webpack_require__( /*! ./class */ 25),
            Action = __webpack_require__( /*! ./action */ 49),
            errors = __webpack_require__( /*! ./errors */ 7),
            coreDataUtils = __webpack_require__( /*! ./utils/data */ 50),
            commonUtils = __webpack_require__( /*! ./utils/common */ 14),
            typeUtils = __webpack_require__( /*! ./utils/type */ 12),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 51),
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 45),
            devices = __webpack_require__( /*! ./devices */ 53),
            isFunction = commonUtils.isFunction,
            noop = commonUtils.noop;
        var cachedGetters = {};
        var cachedSetters = {};
        var Component = Class.inherit({
            _setDeprecatedOptions: function() {
                this._deprecatedOptions = {}
            },
            _getDeprecatedOptions: function() {
                return this._deprecatedOptions
            },
            _getOptionAliasesByName: function(optionName) {
                return $.map(this._deprecatedOptions, function(deprecate, aliasName) {
                    return optionName === deprecate.alias ? aliasName : void 0
                })
            },
            _getDefaultOptions: function() {
                return {
                    onInitialized: null,
                    onOptionChanged: null,
                    onDisposing: null,
                    defaultOptionsRules: null
                }
            },
            _setDefaultOptions: function() {
                this._options = this._getDefaultOptions()
            },
            _defaultOptionsRules: function() {
                return []
            },
            _setOptionsByDevice: function(customRules) {
                var rules = this._defaultOptionsRules();
                if (Array.isArray(customRules)) {
                    rules = rules.concat(customRules)
                }
                var rulesOptions = this._convertRulesToOptions(rules);
                extend(true, this._options, rulesOptions);
                for (var fieldName in this._optionsByReference) {
                    if (rulesOptions.hasOwnProperty(fieldName)) {
                        this._options[fieldName] = rulesOptions[fieldName]
                    }
                }
            },
            _convertRulesToOptions: function(rules) {
                var options = {};
                var currentDevice = devices.current();
                var deviceMatch = function(device, filter) {
                    filter = $.makeArray(filter);
                    return 1 === filter.length && typeUtils.isEmptyObject(filter[0]) || commonUtils.findBestMatches(device, filter).length > 0
                };
                for (var i = 0; i < rules.length; i++) {
                    var match, rule = rules[i],
                        deviceFilter = rule.device || {};
                    if (isFunction(deviceFilter)) {
                        match = deviceFilter(currentDevice)
                    } else {
                        match = deviceMatch(currentDevice, deviceFilter)
                    }
                    if (match) {
                        extend(options, rule.options)
                    }
                }
                return options
            },
            _isInitialOptionValue: function(name) {
                var optionValue = this.option(name),
                    initialOptionValue = this.initialOption(name),
                    isInitialOption = isFunction(optionValue) && isFunction(initialOptionValue) ? optionValue.toString() === initialOptionValue.toString() : commonUtils.equalByValue(optionValue, initialOptionValue);
                return isInitialOption
            },
            _setOptionsByReference: function() {
                this._optionsByReference = {}
            },
            _getOptionsByReference: function() {
                return this._optionsByReference
            },
            ctor: function(options) {
                this.NAME = publicComponentUtils.name(this.constructor);
                options = options || {};
                if (options.eventsStrategy) {
                    this.setEventsStrategy(options.eventsStrategy)
                }
                this._options = {};
                this._updateLockCount = 0;
                this._optionChangedCallbacks = options._optionChangedCallbacks || $.Callbacks();
                this._disposingCallbacks = options._disposingCallbacks || $.Callbacks();
                this.beginUpdate();
                try {
                    this._suppressDeprecatedWarnings();
                    this._setOptionsByReference();
                    this._setDeprecatedOptions();
                    this._setDefaultOptions();
                    if (options && options.onInitializing) {
                        options.onInitializing.apply(this, [options])
                    }
                    this._setOptionsByDevice(options.defaultOptionsRules);
                    this._resumeDeprecatedWarnings();
                    this._initOptions(options)
                } finally {
                    this.endUpdate()
                }
            },
            _initOptions: function(options) {
                this.option(options)
            },
            _optionValuesEqual: function(name, oldValue, newValue) {
                oldValue = coreDataUtils.toComparable(oldValue, true);
                newValue = coreDataUtils.toComparable(newValue, true);
                if (oldValue && newValue && oldValue.jquery && newValue.jquery) {
                    return newValue.is(oldValue)
                }
                var oldValueIsNaN = oldValue !== oldValue,
                    newValueIsNaN = newValue !== newValue;
                if (oldValueIsNaN && newValueIsNaN) {
                    return true
                }
                if (null === oldValue || "object" !== typeof oldValue) {
                    return oldValue === newValue
                }
                return false
            },
            _init: function() {
                this._createOptionChangedAction();
                this.on("disposing", function(args) {
                    this._disposingCallbacks.fireWith(this, [args])
                }.bind(this))
            },
            _createOptionChangedAction: function() {
                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                    excludeValidators: ["disabled", "readOnly", "designMode"]
                })
            },
            _createDisposingAction: function() {
                this._disposingAction = this._createActionByOption("onDisposing", {
                    excludeValidators: ["disabled", "readOnly", "designMode"]
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onDisposing":
                    case "onInitialized":
                        break;
                    case "onOptionChanged":
                        this._createOptionChangedAction();
                        break;
                    case "defaultOptionsRules":
                }
            },
            _dispose: function() {
                this._optionChangedCallbacks.empty();
                this._createDisposingAction();
                this._disposingAction();
                this._disposeEvents();
                this._disposed = true
            },
            instance: function() {
                return this
            },
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                this._updateLockCount = Math.max(this._updateLockCount - 1, 0);
                if (!this._updateLockCount) {
                    if (!this._initializing && !this._initialized) {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._updateLockCount++;
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly", "designMode"]
                            })();
                            this._updateLockCount--;
                            this._initialized = true
                        }
                    }
                }
            },
            _logWarningIfDeprecated: function(option) {
                var info = this._deprecatedOptions[option];
                if (info && !this._deprecatedOptionsSuppressed) {
                    this._logDeprecatedWarning(option, info)
                }
            },
            _logDeprecatedWarningCount: 0,
            _logDeprecatedWarning: function(option, info) {
                var message = info.message || "Use the '" + info.alias + "' option instead";
                errors.log("W0001", this.NAME, option, info.since, message);
                ++this._logDeprecatedWarningCount
            },
            _suppressDeprecatedWarnings: function() {
                this._deprecatedOptionsSuppressed = true
            },
            _resumeDeprecatedWarnings: function() {
                this._deprecatedOptionsSuppressed = false
            },
            _optionChanging: noop,
            _notifyOptionChanged: function(option, value, previousValue) {
                var that = this;
                if (this._initialized) {
                    var optionNames = [option].concat(that._getOptionAliasesByName(option));
                    for (var i = 0; i < optionNames.length; i++) {
                        var name = optionNames[i],
                            args = {
                                name: name.split(/[.\[]/)[0],
                                fullName: name,
                                value: value,
                                previousValue: previousValue
                            };
                        that._optionChangedCallbacks.fireWith(that, [extend(that._defaultActionArgs(), args)]);
                        that._optionChangedAction(extend({}, args));
                        if (!that._disposed) {
                            that._optionChanged(args)
                        }
                    }
                }
            },
            initialOption: function(optionName) {
                var currentOptions, currentInitialized = this._initialized;
                if (!this._initialOptions) {
                    currentOptions = this._options;
                    this._options = {};
                    this._initialized = false;
                    this._setDefaultOptions();
                    this._setOptionsByDevice(currentOptions.defaultOptionsRules);
                    this._initialOptions = this._options;
                    this._options = currentOptions;
                    this._initialized = currentInitialized
                }
                return this._initialOptions[optionName]
            },
            _defaultActionConfig: function() {
                return {
                    context: this,
                    component: this
                }
            },
            _defaultActionArgs: function() {
                return {
                    component: this
                }
            },
            _createAction: function(actionSource, config) {
                var action, that = this;
                return function(e) {
                    if (!arguments.length) {
                        e = {}
                    }
                    if (e instanceof $.Event) {
                        throw Error("Action must be executed with jQuery.Event like action({ jQueryEvent: event })")
                    }
                    if (!typeUtils.isPlainObject(e)) {
                        e = {
                            actionValue: e
                        }
                    }
                    action = action || new Action(actionSource, extend(config, that._defaultActionConfig()));
                    return action.execute.call(action, extend(e, that._defaultActionArgs()))
                }
            },
            _createActionByOption: function(optionName, config) {
                var action, eventName, actionFunc, that = this;
                var result = function() {
                    if (!eventName) {
                        config = config || {};
                        if ("string" !== typeof optionName) {
                            throw errors.Error("E0008")
                        }
                        if (0 === optionName.indexOf("on")) {
                            eventName = that._getEventName(optionName)
                        }
                        if (0 !== optionName.indexOf("on")) {
                            throw Error("The '" + optionName + "' option name should start with 'on' prefix")
                        }
                        actionFunc = that.option(optionName)
                    }
                    if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !that.hasEvent(eventName)) {
                        return
                    }
                    if (!action) {
                        var beforeExecute = config.beforeExecute;
                        config.beforeExecute = function(args) {
                            that.fireEvent(eventName, args.args);
                            beforeExecute && beforeExecute.apply(that, arguments)
                        };
                        that._suppressDeprecatedWarnings();
                        action = that._createAction(actionFunc, config);
                        that._resumeDeprecatedWarnings()
                    }
                    if (Config().wrapActionsBeforeExecute) {
                        var beforeActionExecute = that.option("beforeActionExecute") || noop;
                        action = beforeActionExecute(that, action, config) || action
                    }
                    return action.apply(that, arguments)
                };
                if (!Config().wrapActionsBeforeExecute) {
                    var onActionCreated = that.option("onActionCreated") || noop;
                    result = onActionCreated(that, result, config) || result
                }
                return result
            },
            _getEventName: function(actionName) {
                return actionName.charAt(2).toLowerCase() + actionName.substr(3)
            },
            hasActionSubscription: function(actionName) {
                return !!this.option(actionName) || this.hasEvent(this._getEventName(actionName))
            },
            isOptionDeprecated: function(name) {
                var deprecatedOptions = this._getDeprecatedOptions();
                return deprecatedOptions.hasOwnProperty(name)
            },
            option: function() {
                var normalizeOptionName = function(that, name) {
                    var deprecate;
                    if (name) {
                        if (!that._cachedDeprecateNames) {
                            that._cachedDeprecateNames = [];
                            for (var optionName in that._deprecatedOptions) {
                                that._cachedDeprecateNames.push(optionName)
                            }
                        }
                        for (var i = 0; i < that._cachedDeprecateNames.length; i++) {
                            if (that._cachedDeprecateNames[i] === name) {
                                deprecate = that._deprecatedOptions[name];
                                break
                            }
                        }
                        if (deprecate) {
                            that._logWarningIfDeprecated(name);
                            var alias = deprecate.alias;
                            if (alias) {
                                name = alias
                            }
                        }
                    }
                    return name
                };
                var getPreviousName = function(fullName) {
                    var splitNames = fullName.split(".");
                    splitNames.pop();
                    return splitNames.join(".")
                };
                var getFieldName = function(fullName) {
                    var splitNames = fullName.split(".");
                    return splitNames[splitNames.length - 1]
                };
                var getOptionValue = function(options, name, unwrapObservables) {
                    var getter = cachedGetters[name];
                    if (!getter) {
                        getter = cachedGetters[name] = coreDataUtils.compileGetter(name)
                    }
                    return getter(options, {
                        functionsAsIs: true,
                        unwrapObservables: unwrapObservables
                    })
                };
                var clearOptionsField = function(options, name) {
                    delete options[name];
                    var previousFieldName = getPreviousName(name),
                        fieldName = getFieldName(name),
                        fieldObject = previousFieldName ? getOptionValue(options, previousFieldName, false) : options;
                    if (fieldObject) {
                        delete fieldObject[fieldName]
                    }
                };
                var setOptionsField = function(options, fullName, value) {
                    var fieldObject, fieldName = "";
                    do {
                        if (fieldName) {
                            fieldName = "." + fieldName
                        }
                        fieldName = getFieldName(fullName) + fieldName;
                        fullName = getPreviousName(fullName);
                        fieldObject = fullName ? getOptionValue(options, fullName, false) : options
                    } while (!fieldObject);
                    fieldObject[fieldName] = value
                };
                var normalizeOptionValue = function(that, options, name, value) {
                    if (name) {
                        var alias = normalizeOptionName(that, name);
                        if (alias && alias !== name) {
                            setOptionsField(options, alias, value);
                            clearOptionsField(options, name)
                        }
                    }
                };
                var prepareOption = function(that, options, name, value) {
                    if (typeUtils.isPlainObject(value)) {
                        for (var valueName in value) {
                            prepareOption(that, options, name + "." + valueName, value[valueName])
                        }
                    }
                    normalizeOptionValue(that, options, name, value)
                };
                var setOptionValue = function(that, name, value) {
                    if (!cachedSetters[name]) {
                        cachedSetters[name] = coreDataUtils.compileSetter(name)
                    }
                    var path = name.split(/[.\[]/);
                    cachedSetters[name](that._options, value, {
                        functionsAsIs: true,
                        merge: !that._getOptionsByReference()[name],
                        unwrapObservables: path.length > 1 && !!that._getOptionsByReference()[path[0]]
                    })
                };
                var setOption = function(that, name, value) {
                    var previousValue = getOptionValue(that._options, name, false);
                    if (that._optionValuesEqual(name, previousValue, value)) {
                        return
                    }
                    if (that._initialized) {
                        that._optionChanging(name, previousValue, value)
                    }
                    setOptionValue(that, name, value);
                    that._notifyOptionChanged(name, value, previousValue)
                };
                return function(options, value) {
                    var that = this,
                        name = options;
                    if (arguments.length < 2 && "object" !== commonUtils.type(name)) {
                        name = normalizeOptionName(that, name);
                        return getOptionValue(that._options, name)
                    }
                    if ("string" === typeof name) {
                        options = {};
                        options[name] = value
                    }
                    that.beginUpdate();
                    try {
                        var optionName;
                        for (optionName in options) {
                            prepareOption(that, options, optionName, options[optionName])
                        }
                        for (optionName in options) {
                            setOption(that, optionName, options[optionName])
                        }
                    } finally {
                        that.endUpdate()
                    }
                }
            }()
        }).include(EventsMixin);
        module.exports = Component
    },
    /*!***************************!*\
      !*** ./js/core/action.js ***!
      \***************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            config = __webpack_require__( /*! ./config */ 15),
            commonUtils = __webpack_require__( /*! ./utils/common */ 14),
            typeUtils = __webpack_require__( /*! ./utils/type */ 12),
            Class = __webpack_require__( /*! ./class */ 25);
        var Action = Class.inherit({
            ctor: function(action, config) {
                config = config || {};
                this._action = action;
                this._context = config.context || window;
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            },
            execute: function() {
                var e = {
                    action: this._action,
                    args: Array.prototype.slice.call(arguments),
                    context: this._context,
                    component: this._component,
                    validatingTargetName: this._validatingTargetName,
                    cancel: false,
                    handled: false
                };
                var beforeExecute = this._beforeExecute,
                    afterExecute = this._afterExecute;
                if (!this._validateAction(e)) {
                    return
                }
                beforeExecute && beforeExecute.call(this._context, e);
                if (e.cancel) {
                    return
                }
                var result = this._executeAction(e);
                var argsBag = e.args[0];
                if (argsBag && argsBag.cancel) {
                    return
                }
                afterExecute && afterExecute.call(this._context, e);
                return result
            },
            _validateAction: function(e) {
                var excludeValidators = this._excludeValidators,
                    executors = Action.executors;
                for (var name in executors) {
                    if (!excludeValidators[name]) {
                        var executor = executors[name];
                        if (executor.validate) {
                            executor.validate(e)
                        }
                        if (e.cancel) {
                            return false
                        }
                    }
                }
                return true
            },
            _executeAction: function(e) {
                var result, executors = Action.executors;
                for (var name in executors) {
                    var executor = executors[name];
                    if (executor.execute) {
                        executor.execute(e)
                    }
                    if (e.handled) {
                        result = e.result;
                        break
                    }
                }
                return result
            }
        });
        Action.executors = {};
        Action.registerExecutor = function(name, executor) {
            if (typeUtils.isPlainObject(name)) {
                $.each(name, Action.registerExecutor);
                return
            }
            Action.executors[name] = executor
        };
        Action.unregisterExecutor = function() {
            var args = $.makeArray(arguments);
            $.each(args, function() {
                delete Action.executors[this]
            })
        };
        Action.registerExecutor({
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if (commonUtils.isFunction(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        });
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0],
                    element = args[e.validatingTargetName] || args.element;
                if (element && condition(element)) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            designMode: {
                validate: function(e) {
                    if (config().designMode) {
                        e.cancel = true
                    }
                }
            },
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *")
                })
            }
        });
        module.exports = Action
    },
    /*!*******************************!*\
      !*** ./js/core/utils/data.js ***!
      \*******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            errors = __webpack_require__( /*! ../errors */ 7),
            Class = __webpack_require__( /*! ../class */ 25),
            objectUtils = __webpack_require__( /*! ./object */ 27),
            commonUtils = __webpack_require__( /*! ./common */ 14),
            typeUtils = __webpack_require__( /*! ./type */ 12),
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 28),
            unwrapVariable = variableWrapper.unwrap,
            isWrapped = variableWrapper.isWrapped,
            assign = variableWrapper.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName) {
            if ("this" === propName) {
                return obj
            }
            return obj[propName]
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new errors.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };
        var unwrap = function(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        };
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = $.makeArray(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs,
                        current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            break
                        }
                        var next = unwrap(current[path[i]], options);
                        if (!functionAsIs && commonUtils.isFunction(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if (commonUtils.isFunction(expr)) {
                return expr
            }
        };
        var combineGetters = function(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                $.each(compiledGetters, function(name) {
                    var current, path, last, i, value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    current = result || (result = {});
                    path = name.split(".");
                    last = path.length - 1;
                    for (i = 0; i < last; i++) {
                        current = current[path[i]] = {}
                    }
                    current[path[i]] = value
                });
                return result
            }
        };
        var compileSetter = function(expr) {
            expr = expr || "this";
            expr = bracketsToDots(expr);
            var pos = expr.lastIndexOf("."),
                targetGetter = compileGetter(expr.substr(0, pos)),
                targetPropName = expr.substr(1 + pos);
            return function(obj, value, options) {
                options = prepareOptions(options);
                var target = targetGetter(obj, {
                        functionsAsIs: options.functionsAsIs,
                        unwrapObservables: options.unwrapObservables
                    }),
                    prevTargetValue = readPropValue(target, targetPropName);
                if (!options.functionsAsIs && commonUtils.isFunction(prevTargetValue) && !isWrapped(prevTargetValue)) {
                    target[targetPropName](value)
                } else {
                    prevTargetValue = unwrap(prevTargetValue, options);
                    if (options.merge && typeUtils.isPlainObject(value) && (void 0 === prevTargetValue || typeUtils.isPlainObject(prevTargetValue)) && !(value instanceof $.Event)) {
                        if (!prevTargetValue) {
                            assignPropValue(target, targetPropName, {}, options)
                        }
                        target = unwrap(readPropValue(target, targetPropName), options);
                        objectUtils.deepExtendArraySafe(target, value, false, true)
                    } else {
                        assignPropValue(target, targetPropName, value, options)
                    }
                }
            }
        };
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof Class && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.compileGetter = compileGetter;
        exports.compileSetter = compileSetter;
        exports.toComparable = toComparable
    },
    /*!*********************************!*\
      !*** ./js/core/events_mixin.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            DefaultEventsStrategy = __webpack_require__( /*! ./events_strategy */ 52),
            isPlainObject = __webpack_require__( /*! ./utils/type */ 12).isPlainObject;
        module.exports = {
            ctor: function() {
                this._events = {};
                this.setEventsStrategy(new DefaultEventsStrategy(this))
            },
            setEventsStrategy: function(strategy) {
                this._eventsStrategy = strategy
            },
            hasEvent: function(eventName) {
                return this._eventsStrategy.hasEvent(eventName)
            },
            fireEvent: function(eventName, eventArgs) {
                this._eventsStrategy.fireEvent(eventName, eventArgs);
                return this
            },
            on: function(eventName, eventHandler) {
                if (isPlainObject(eventName)) {
                    $.each(eventName, function(e, h) {
                        this.on(e, h)
                    }.bind(this))
                } else {
                    this._eventsStrategy.on(eventName, eventHandler)
                }
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            },
            _disposeEvents: function() {
                this._eventsStrategy.dispose()
            }
        }
    },
    /*!************************************!*\
      !*** ./js/core/events_strategy.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            isFunction = __webpack_require__( /*! ./utils/common */ 14).isFunction,
            Class = __webpack_require__( /*! ./class */ 25);
        module.exports = Class.inherit({
            ctor: function(owner) {
                this._events = {};
                this._owner = owner
            },
            hasEvent: function(eventName) {
                var callbacks = this._events[eventName];
                if (callbacks) {
                    return callbacks.has()
                }
                return false
            },
            fireEvent: function(eventName, eventArgs) {
                var callbacks = this._events[eventName];
                if (callbacks) {
                    callbacks.fireWith(this._owner, eventArgs)
                }
            },
            on: function(eventName, eventHandler) {
                var addFn, callbacks = this._events[eventName];
                if (!callbacks) {
                    callbacks = $.Callbacks();
                    this._events[eventName] = callbacks
                }
                addFn = callbacks.originalAdd || callbacks.add;
                addFn.call(callbacks, eventHandler)
            },
            off: function(eventName, eventHandler) {
                var callbacks = this._events[eventName];
                if (callbacks) {
                    if (isFunction(eventHandler)) {
                        callbacks.remove(eventHandler)
                    } else {
                        callbacks.empty()
                    }
                }
            },
            dispose: function() {
                $.each(this._events, function() {
                    this.empty()
                })
            }
        })
    },
    /*!****************************!*\
      !*** ./js/core/devices.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            extend = __webpack_require__( /*! ./utils/extend */ 11).extend,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 12).isPlainObject,
            Class = __webpack_require__( /*! ./class */ 25),
            errors = __webpack_require__( /*! ./errors */ 7),
            resizeCallbacks = __webpack_require__( /*! ./utils/window */ 44).resizeCallbacks,
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 51),
            SessionStorage = __webpack_require__( /*! ./utils/storage */ 54).sessionStorage,
            viewPort = __webpack_require__( /*! ./utils/view_port */ 55),
            Config = __webpack_require__( /*! ./config */ 15);
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            win8: "MSAppHost",
            win8Phone: "Windows Phone 8.0",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop",
            win10Phone: "Windows Phone 10.0",
            win10: "MSAppHost/3.0"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            win: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            win: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/),
                    isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent),
                    isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                if (!(isPhone || isTablet || isDesktop)) {
                    return
                }
                var matches = userAgent.match(/windows phone (\d+).(\d+)/i) || userAgent.match(/windows nt (\d+).(\d+)/i),
                    version = [];
                if (matches) {
                    version.push(parseInt(matches[1], 10), parseInt(matches[2], 10))
                } else {
                    matches = userAgent.match(/msapphost(\/(\d+).(\d+))?/i);
                    matches && version.push(3 === parseInt(matches[2], 10) ? 10 : 8)
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "win",
                    version: version,
                    grade: "A"
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent),
                    matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [],
                    isIPhone4 = 480 === window.screen.height,
                    grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent),
                    matches = userAgent.match(/android (\d+)\.(\d+)\.?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [],
                    worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4),
                    grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = Class.inherit({
            ctor: function(options) {
                this._window = options && options.window || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this.changed = $.Callbacks();
                this._recalculateOrientation();
                resizeCallbacks.add(this._recalculateOrientation.bind(this))
            },
            current: function(deviceOrName) {
                if (deviceOrName) {
                    this._currentDevice = this._getDevice(deviceOrName);
                    this._forced = true;
                    this.changed.fire();
                    if ("win" === this._currentDevice.platform && 8 === this._currentDevice.version[0]) {
                        errors.log("W0010", "the 'win8' theme", "16.1", "Use the 'win10' theme instead.")
                    }
                    return
                }
                if (!this._currentDevice) {
                    deviceOrName = void 0;
                    try {
                        deviceOrName = this._getDeviceOrNameFromWindowScope()
                    } catch (e) {
                        deviceOrName = this._getDeviceNameFromSessionStorage()
                    } finally {
                        if (!deviceOrName) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        }
                        if (deviceOrName) {
                            this._forced = true
                        }
                    }
                    this._currentDevice = this._getDevice(deviceOrName)
                }
                return this._currentDevice
            },
            real: function() {
                var forceDevice = arguments[0];
                if (isPlainObject(forceDevice)) {
                    extend(this._realDevice, forceDevice);
                    return
                }
                return extend({}, this._realDevice)
            },
            orientation: function() {
                return this._currentOrientation
            },
            isForced: function() {
                return this._forced
            },
            isRippleEmulator: function() {
                return !!this._window.tinyHippos
            },
            _getCssClasses: function(device) {
                var result = [];
                var realDevice = this._realDevice;
                device = device || this.current();
                if (device.deviceType) {
                    result.push("dx-device-" + device.deviceType);
                    if ("desktop" !== device.deviceType) {
                        result.push("dx-device-mobile")
                    }
                }
                result.push("dx-device-" + realDevice.platform);
                if (realDevice.version && realDevice.version.length) {
                    result.push("dx-device-" + realDevice.platform + "-" + realDevice.version[0])
                }
                if (devices.isSimulator()) {
                    result.push("dx-simulator")
                }
                if (Config().rtlEnabled) {
                    result.push("dx-rtl")
                }
                return result
            },
            attachCssClasses: function(element, device) {
                this._deviceClasses = this._getCssClasses(device).join(" ");
                $(element).addClass(this._deviceClasses)
            },
            detachCssClasses: function(element) {
                $(element).removeClass(this._deviceClasses)
            },
            isSimulator: function() {
                try {
                    return this._isSimulator || this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                } catch (e) {
                    return false
                }
            },
            forceSimulator: function() {
                this._isSimulator = true
            },
            _getDevice: function(deviceName) {
                if ("genericPhone" === deviceName) {
                    deviceName = {
                        deviceType: "phone",
                        platform: "generic",
                        generic: true
                    }
                }
                if (isPlainObject(deviceName)) {
                    return this._fromConfig(deviceName)
                } else {
                    var ua;
                    if (deviceName) {
                        ua = KNOWN_UA_TABLE[deviceName];
                        if (!ua) {
                            throw errors.Error("E0005")
                        }
                    } else {
                        ua = navigator.userAgent
                    }
                    return this._fromUA(ua)
                }
            },
            _getDeviceOrNameFromWindowScope: function() {
                var result;
                if (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]) {
                    result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                }
                return result
            },
            _getDeviceNameFromSessionStorage: function() {
                var sessionStorage = SessionStorage();
                if (!sessionStorage) {
                    return
                }
                var deviceOrName = sessionStorage.getItem("dx-force-device");
                try {
                    return JSON.parse(deviceOrName)
                } catch (ex) {
                    return deviceOrName
                }
            },
            _fromConfig: function(config) {
                var result = extend({}, DEFAULT_DEVICE, this._currentDevice, config),
                    shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        win: "win" === result.platform,
                        generic: "generic" === result.platform
                    };
                return extend(result, shortcuts)
            },
            _fromUA: function(ua) {
                var config;
                $.each(uaParsers, function(platform, parser) {
                    config = parser(ua);
                    return !config
                });
                if (config) {
                    return this._fromConfig(config)
                }
                var isMac = /(mac os)/.test(ua.toLowerCase()),
                    deviceWithOS = DEFAULT_DEVICE;
                deviceWithOS.mac = isMac;
                return deviceWithOS
            },
            _changeOrientation: function() {
                var $window = $(this._window),
                    orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                if (this._currentOrientation === orientation) {
                    return
                }
                this._currentOrientation = orientation;
                this.fireEvent("orientationChanged", [{
                    orientation: orientation
                }])
            },
            _recalculateOrientation: function() {
                var windowWidth = $(this._window).width();
                if (this._currentWidth === windowWidth) {
                    return
                }
                this._currentWidth = windowWidth;
                this._changeOrientation()
            }
        }).include(EventsMixin);
        var devices = new Devices;
        viewPort.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        if (!devices.isForced() && "win" === devices.current().platform) {
            devices.current({
                version: [10]
            })
        }
        module.exports = devices
    },
    /*!**********************************!*\
      !*** ./js/core/utils/storage.js ***!
      \**********************************/
    function(module, exports) {
        var getSessionStorage = function() {
            var sessionStorage;
            try {
                sessionStorage = window.sessionStorage
            } catch (e) {}
            return sessionStorage
        };
        exports.sessionStorage = getSessionStorage
    },
    /*!************************************!*\
      !*** ./js/core/utils/view_port.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            ready = __webpack_require__( /*! ./dom */ 56).ready,
            changeCallback = $.Callbacks(),
            $originalViewPort = $();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = $(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : $("body");
                changeCallback.fire(isNewViewportFound ? value() : $(), prevViewPort)
            }
        }();
        ready(function() {
            value(".dx-viewport")
        });
        exports.value = value;
        exports.changeCallback = changeCallback;
        exports.originalViewPort = function() {
            return $originalViewPort
        }
    },
    /*!******************************!*\
      !*** ./js/core/utils/dom.js ***!
      \******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            errors = __webpack_require__( /*! ../errors */ 7),
            inArray = __webpack_require__( /*! ./array */ 26).inArray,
            commonUtils = __webpack_require__( /*! ./common */ 14);
        var resetActiveElement = function() {
            var activeElement = document.activeElement;
            if (activeElement && activeElement !== document.body && activeElement.blur) {
                activeElement.blur()
            }
        };
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = $(startTarget),
                $endTarget = $(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents(),
                $endParents = $endTarget.parents(),
                startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = $(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    $(changeHandlers[i]).triggerHandler(eventName)
                }
            }
        };
        var uniqueId = function() {
            var counter = 0;
            return function(prefix) {
                return (prefix || "") + counter++
            }
        }();
        var dataOptionsAttributeName = "data-options";
        var getElementOptions = function(element) {
            var result, optionsString = $(element).attr(dataOptionsAttributeName);
            if ("{" !== $.trim(optionsString).charAt(0)) {
                optionsString = "{" + optionsString + "}"
            }
            try {
                result = new Function("return " + optionsString)()
            } catch (ex) {
                throw errors.Error("E3018", ex, optionsString)
            }
            return result
        };
        var createComponents = function(elements, componentTypes) {
            var result = [],
                selector = "[" + dataOptionsAttributeName + "]";
            var $items = elements.find(selector).add(elements.filter(selector));
            $items.each(function(index, element) {
                var $element = $(element),
                    options = getElementOptions(element);
                for (var componentName in options) {
                    if (!componentTypes || inArray(componentName, componentTypes) > -1) {
                        if ($element[componentName]) {
                            $element[componentName](options[componentName]);
                            result.push($element[componentName]("instance"))
                        }
                    }
                }
            });
            return result
        };
        var createMarkupFromString = function(str) {
            if (!window.WinJS) {
                return $(str)
            }
            var tempElement = $("<div />");
            window.WinJS.Utilities.setInnerHTMLUnsafe(tempElement.get(0), str);
            return tempElement.contents()
        };
        var normalizeTemplateElement = function(element) {
            var $element = commonUtils.isDefined(element) && (element.nodeType || element.jquery) ? $(element) : $("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        var toggleAttr = function($target, attr, value) {
            value ? $target.attr(attr, value) : $target.removeAttr(attr)
        };
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        exports.ready = function(callback) {
            if ("complete" === document.readyState || "loading" !== document.readyState && !document.documentElement.doScroll) {
                callback();
                return
            }
            var loadedCallback = function() {
                callback();
                document.removeEventListener("DOMContentLoaded", loadedCallback)
            };
            document.addEventListener("DOMContentLoaded", loadedCallback)
        };
        exports.resetActiveElement = resetActiveElement;
        exports.createMarkupFromString = createMarkupFromString;
        exports.triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.getElementOptions = getElementOptions;
        exports.createComponents = createComponents;
        exports.normalizeTemplateElement = normalizeTemplateElement;
        exports.clearSelection = clearSelection;
        exports.uniqueId = uniqueId;
        exports.closestCommonParent = closestCommonParent;
        exports.clipboardText = clipboardText;
        exports.toggleAttr = toggleAttr
    },
    /*!******************************************!*\
      !*** ./js/core/component_registrator.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            jQuery = __webpack_require__( /*! jquery */ 10),
            errors = __webpack_require__( /*! ./errors */ 7),
            MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 58),
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 45);
        var callbacks = new MemorizedCallbacks;
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }
            publicComponentUtils.name(componentClass, name);
            callbacks.fire(name, componentClass)
        };
        registerComponent.callbacks = callbacks;
        var registerJQueryComponent = function(name, componentClass) {
            $.fn[name] = jQuery.fn[name] = function(options) {
                var result, isMemberInvoke = "string" === typeof options;
                if (isMemberInvoke) {
                    var memberName = options,
                        memberArgs = $.makeArray(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw errors.Error("E0009", name)
                        }
                        var member = instance[memberName],
                            memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        callbacks.add(registerJQueryComponent);
        module.exports = registerComponent
    },
    /*!****************************************!*\
      !*** ./js/core/memorized_callbacks.js ***!
      \****************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9);
        var MemorizedCallbacks = function() {
            var memory = [];
            var callbacks = $.Callbacks();
            this.add = function(fn) {
                $.each(memory, function(_, item) {
                    fn.apply(fn, item)
                });
                callbacks.add(fn)
            };
            this.remove = function(fn) {
                callbacks.remove(fn)
            };
            this.fire = function() {
                memory.push(arguments);
                callbacks.fire.apply(callbacks, arguments)
            }
        };
        module.exports = MemorizedCallbacks
    },
    /*!*******************************!*\
      !*** ./js/animation/frame.js ***!
      \*******************************/
    function(module, exports) {
        var FRAME_ANIMATION_STEP_TIME = 1e3 / 60,
            request = function(callback) {
                return this.setTimeout(callback, FRAME_ANIMATION_STEP_TIME)
            },
            cancel = function(requestID) {
                this.clearTimeout(requestID)
            },
            nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame,
            nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
        if (nativeRequest && nativeCancel) {
            request = nativeRequest;
            cancel = nativeCancel
        }
        if (nativeRequest && !nativeCancel) {
            var canceledRequests = {};
            request = function(callback) {
                var requestId = nativeRequest.call(window, function() {
                    try {
                        if (requestId in canceledRequests) {
                            return
                        }
                        callback.apply(this, arguments)
                    } finally {
                        delete canceledRequests[requestId]
                    }
                });
                return requestId
            };
            cancel = function(requestId) {
                canceledRequests[requestId] = true
            }
        }
        exports.requestAnimationFrame = request.bind(window);
        exports.cancelAnimationFrame = cancel.bind(window)
    },
    /*!****************************************************************!*\
      !*** ./js/mobile/init_mobile_viewport/init_mobile_viewport.js ***!
      \****************************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            resizeCallbacks = __webpack_require__( /*! ../../core/utils/window */ 44).resizeCallbacks,
            support = __webpack_require__( /*! ../../core/utils/support */ 61),
            devices = __webpack_require__( /*! ../../core/devices */ 53);
        var initMobileViewport = function(options) {
            options = extend({}, options);
            var realDevice = devices.real();
            var allowZoom = options.allowZoom;
            var allowPan = options.allowPan;
            var allowSelection = "allowSelection" in options ? options.allowSelection : "generic" === realDevice.platform;
            var metaSelector = "meta[name=viewport]";
            if (!$(metaSelector).length) {
                $("<meta />").attr("name", "viewport").appendTo("head")
            }
            var metaVerbs = ["width=device-width"],
                msTouchVerbs = [];
            if (allowZoom) {
                msTouchVerbs.push("pinch-zoom")
            } else {
                metaVerbs.push("initial-scale=1.0", "maximum-scale=1.0, user-scalable=no")
            }
            if (allowPan) {
                msTouchVerbs.push("pan-x", "pan-y")
            }
            if (!allowPan && !allowZoom) {
                $("html, body").css({
                    "-ms-content-zooming": "none",
                    "-ms-user-select": "none",
                    overflow: "hidden"
                })
            } else {
                $("html").css("-ms-overflow-style", "-ms-autohiding-scrollbar")
            }
            if (!allowSelection && support.supportProp("user-select")) {
                $(".dx-viewport").css(support.styleProp("user-select"), "none")
            }
            $(metaSelector).attr("content", metaVerbs.join());
            $("html").css("-ms-touch-action", msTouchVerbs.join(" ") || "none");
            realDevice = devices.real();
            if (support.touch && !("win" === realDevice.platform && 10 === realDevice.version[0])) {
                $(document).off(".dxInitMobileViewport").on("dxpointermove.dxInitMobileViewport", function(e) {
                    var count = e.pointers.length,
                        isTouchEvent = "touch" === e.pointerType,
                        zoomDisabled = !allowZoom && count > 1,
                        panDisabled = !allowPan && 1 === count && !e.isScrollingEvent;
                    if (isTouchEvent && (zoomDisabled || panDisabled)) {
                        e.preventDefault()
                    }
                })
            }
            if (realDevice.ios) {
                var isPhoneGap = "file:" === document.location.protocol;
                if (!isPhoneGap) {
                    resizeCallbacks.add(function() {
                        var windowWidth = $(window).width();
                        $("body").width(windowWidth)
                    })
                }
            }
            if (realDevice.android) {
                resizeCallbacks.add(function() {
                    setTimeout(function() {
                        document.activeElement.scrollIntoViewIfNeeded()
                    })
                })
            }
        };
        exports.initMobileViewport = initMobileViewport
    },
    /*!**********************************!*\
      !*** ./js/core/utils/support.js ***!
      \**********************************/
    function(module, exports, __webpack_require__) {
        var inflector = __webpack_require__( /*! ./inflector */ 39),
            inArray = __webpack_require__( /*! ./array */ 26).inArray,
            devices = __webpack_require__( /*! ../devices */ 53);
        var camelize = inflector.camelize;
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"],
            cssPrefixes = {
                "": "",
                Webkit: "-webkit-",
                Moz: "-moz-",
                O: "-o-",
                ms: "-ms-"
            },
            styles = document.createElement("dx").style;
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var forEachPrefixes = function(prop, callBack) {
            prop = camelize(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = camelize(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result
        };
        var styleProp = function(prop) {
            return forEachPrefixes(prop, function(specific) {
                if (specific in styles) {
                    return specific
                }
            })
        };
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in styles) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        var supportProp = function(prop) {
            return !!styleProp(prop)
        };
        var isNativeScrollingSupported = function() {
            var realDevice = devices.real(),
                realPlatform = realDevice.platform,
                realVersion = realDevice.version,
                isObsoleteAndroid = realVersion && realVersion[0] < 4 && "android" === realPlatform,
                isNativeScrollDevice = !isObsoleteAndroid && inArray(realPlatform, ["ios", "android", "win"]) > -1 || realDevice.mac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = document.createElement("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        var touchEvents = "ontouchstart" in window && !("callPhantom" in window),
            pointerEvents = !!window.navigator.pointerEnabled || !!window.navigator.msPointerEnabled,
            touchPointersPresent = !!window.navigator.maxTouchPoints || !!window.navigator.msMaxTouchPoints;
        exports.touchEvents = touchEvents;
        exports.pointerEvents = pointerEvents;
        exports.touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.transition = supportProp("transition");
        exports.transitionEndEventName = transitionEndEventNames[styleProp("transition")];
        exports.animation = supportProp("animation");
        exports.nativeScrolling = isNativeScrollingSupported();
        exports.styleProp = styleProp;
        exports.stylePropPrefix = stylePropPrefix;
        exports.supportProp = supportProp;
        exports.hasKo = !!window.ko;
        exports.inputType = inputType
    },
    /*!********************************!*\
      !*** ./js/core/utils/queue.js ***!
      \********************************/
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 7),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when;

        function createQueue(discardPendingTasks) {
            var _tasks = [],
                _busy = false;

            function exec() {
                while (_tasks.length) {
                    _busy = true;
                    var task = _tasks.shift(),
                        result = task();
                    if (void 0 === result) {
                        continue
                    }
                    if (result.then) {
                        when(result).always(exec);
                        return
                    }
                    throw errors.Error("E0015")
                }
                _busy = false
            }

            function add(task, removeTaskCallback) {
                if (!discardPendingTasks) {
                    _tasks.push(task)
                } else {
                    if (_tasks[0] && removeTaskCallback) {
                        removeTaskCallback(_tasks[0])
                    }
                    _tasks = [task]
                }
                if (!_busy) {
                    exec()
                }
            }

            function busy() {
                return _busy
            }
            return {
                add: add,
                busy: busy
            }
        }
        exports.create = createQueue;
        exports.enqueue = createQueue().add
    },
    /*!*******************************!*\
      !*** ./js/core/utils/date.js ***!
      \*******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ./common */ 14),
            camelize = __webpack_require__( /*! ./inflector */ 39).camelize,
            isObject = commonUtils.isObject,
            isString = commonUtils.isString,
            isDate = commonUtils.isDate,
            isDefined = commonUtils.isDefined;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime(),
                millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i, dateUnitCount, dateUnitInterval, dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"],
                result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if (isObject(tickInterval)) {
                $.each(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if (isString(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };
        var convertDateUnitToMilliseconds = function(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        };
        var getDateUnitInterval = function(tickInterval) {
            var i, maxInterval = -1;
            if (isString(tickInterval)) {
                return tickInterval
            }
            if (isObject(tickInterval)) {
                $.each(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        };
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };
        var correctDateWithUnitBeginning = function(date, dateInterval, withCorrection) {
            date = new Date(date.getTime());
            var firstQuarterMonth, oldDate = new Date(date.getTime()),
                dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date.setMilliseconds(0);
                    break;
                case "minute":
                    date.setSeconds(0, 0);
                    break;
                case "hour":
                    date.setMinutes(0, 0, 0);
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date.setDate(date.getDate() - date.getDay());
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    if (date.getMonth() !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0)
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        };
        var trimTime = function(date) {
            return dateUtils.correctDateWithUnitBeginning(date, "day")
        };
        var getDatesDifferences = function(date1, date2) {
            var differences, counter = 0;
            differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            $.each(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime()),
                intervalObject = isString(interval) ? getDateIntervalByString(interval.toLowerCase()) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setHours(result.getHours() + intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setMinutes(result.getMinutes() + intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setSeconds(result.getSeconds() + intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setMilliseconds(value.getMilliseconds() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return isDate(value) ? addDateInterval(value, interval, dir) : value + interval * dir
        };
        var getSequenceByInterval = function(min, max, interval) {
            var cur, intervals = [];
            intervals.push(isDate(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };
        var getLastMonthDay = function(date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        };
        var sameView = function(view, date1, date2) {
            return dateUtils[camelize("same " + view)](date1, date2)
        };
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };
        var getDateIntervalByString = function(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.days = 7;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        };
        var sameDate = function(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        };
        var sameMonthAndYear = function(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        };
        var sameYear = function(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        };
        var sameDecade = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10,
                startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100,
                startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };
        var getFirstDecadeInCentury = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        };
        var getFirstYearInDecade = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        };
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth(), 1);
            return newDate
        };
        var getLastMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return newDate
        };
        var getFirstWeekDate = function(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        };
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day"),
                resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var normalizeDate = function(date, min, max) {
            var normalizedDate = date;
            if (!isDefined(date)) {
                return date
            }
            if (isDefined(min) && date < min) {
                normalizedDate = min
            }
            if (isDefined(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        };
        var fixTimezoneGap = function(oldDate, newDate) {
            if (!isDefined(oldDate)) {
                return
            }
            var sign, trial, diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            sign = 1 === diff || diff === -23 ? -1 : 1;
            trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        };
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };
        var getTimezonesDifference = function(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        };
        var makeDate = function(date) {
            return new Date(date)
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            sameView: sameView,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval
        };
        module.exports = dateUtils
    },
    /*!***************************************************!*\
      !*** ./js/mobile/process_hardware_back_button.js ***!
      \***************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            hardwareBack = $.Callbacks();
        module.exports = function() {
            hardwareBack.fire()
        };
        module.exports.processCallback = hardwareBack
    },
    /*!***************************************!*\
      !*** ./js/mobile/hide_top_overlay.js ***!
      \***************************************/
    function(module, exports, __webpack_require__) {
        var inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray;
        var hideCallback = function() {
            var callbacks = [];
            return {
                add: function(callback) {
                    var indexOfCallback = inArray(callback, callbacks);
                    if (indexOfCallback === -1) {
                        callbacks.push(callback)
                    }
                },
                remove: function(callback) {
                    var indexOfCallback = inArray(callback, callbacks);
                    if (indexOfCallback !== -1) {
                        callbacks.splice(indexOfCallback, 1)
                    }
                },
                fire: function() {
                    var callback = callbacks.pop(),
                        result = !!callback;
                    if (result) {
                        callback()
                    }
                    return result
                },
                hasCallback: function() {
                    return callbacks.length > 0
                },
                reset: function() {
                    callbacks = []
                }
            }
        }();
        module.exports = function() {
            return hideCallback.fire()
        };
        module.exports.hideCallback = hideCallback
    },
    /*!*****************************!*\
      !*** ./js/format_helper.js ***!
      \*****************************/
    function(module, exports, __webpack_require__) {
        var commonUtils = __webpack_require__( /*! ./core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ./core/utils/type */ 12),
            dateUtils = __webpack_require__( /*! ./core/utils/date */ 63),
            numberLocalization = __webpack_require__( /*! ./localization/number */ 32),
            dateLocalization = __webpack_require__( /*! ./localization/date */ 33),
            dependencyInjector = __webpack_require__( /*! ./core/utils/dependency_injector */ 29),
            logger = __webpack_require__( /*! ./core/utils/console */ 13).logger;
        __webpack_require__( /*! ./localization/currency */ 36);
        module.exports = dependencyInjector({
            format: function(value, format, precision) {
                var formatIsValid = commonUtils.isString(format) && "" !== format || typeUtils.isPlainObject(format) || commonUtils.isFunction(format),
                    valueIsValid = commonUtils.isNumeric(value) || commonUtils.isDate(value);
                if (!formatIsValid || !valueIsValid) {
                    return commonUtils.isDefined(value) ? value.toString() : ""
                }
                if (commonUtils.isFunction(format)) {
                    return format(value)
                }
                if (void 0 !== precision) {
                    logger.warn("Option 'precision' is deprecated. Use field 'precision' of a format object instead.")
                }
                if (commonUtils.isString(format)) {
                    format = {
                        type: format,
                        precision: precision
                    }
                }
                if (commonUtils.isNumeric(value)) {
                    return numberLocalization.format(value, format)
                }
                if (commonUtils.isDate(value)) {
                    return dateLocalization.format(value, format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return dateLocalization.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences) {
                var resultFormat = [];
                if (dateDifferences.millisecond) {
                    resultFormat.push("millisecond")
                }
                if (dateDifferences.hour || dateDifferences.minute || dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    resultFormat.unshift("shortdate");
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    resultFormat.unshift("monthandday");
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    var dayFormatter = function(date) {
                        return dateLocalization.format(date, "dayofweek") + ", " + dateLocalization.format(date, "day")
                    };
                    resultFormat.unshift(dayFormatter);
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var resultFormat, maxDiff, currentDiff, i;
                if (ticks.length > 1) {
                    maxDiff = dateUtils.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = dateUtils.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var resultFormat, dateDifferences, dateUnitInterval, dateDifferencesConverter = {
                        week: "day"
                    },
                    correctDateDifferences = function(dateDifferences, tickInterval, value) {
                        switch (tickInterval) {
                            case "year":
                            case "quarter":
                                dateDifferences.month = value;
                            case "month":
                                dateDifferences.day = value;
                            case "week":
                            case "day":
                                dateDifferences.hour = value;
                            case "hour":
                                dateDifferences.minute = value;
                            case "minute":
                                dateDifferences.second = value;
                            case "second":
                                dateDifferences.millisecond = value
                        }
                    },
                    correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                        if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                            if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                                differences.millisecond = true;
                                differences.second = false
                            }
                        } else {
                            if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                                if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                    differences.second = true;
                                    differences.minute = false
                                }
                            } else {
                                if (!maxDate.getMinutes() && maxDate.getHours()) {
                                    if (maxDate.getHours() - minDate.getHours() === 1) {
                                        differences.minute = true;
                                        differences.hour = false
                                    }
                                } else {
                                    if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                        if (maxDate.getDate() - minDate.getDate() === 1) {
                                            differences.hour = true;
                                            differences.day = false
                                        }
                                    } else {
                                        if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                            if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                                differences.day = true;
                                                differences.month = false
                                            }
                                        } else {
                                            if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                                if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                    differences.month = true;
                                                    differences.year = false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    };
                tickInterval = commonUtils.isString(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                dateDifferences = dateUtils.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = dateUtils.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = dateUtils.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        })
    },
    /*!*****************************************!*\
      !*** ./js/animation/presets/presets.js ***!
      \*****************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Component = __webpack_require__( /*! ../../core/component */ 48),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            devices = __webpack_require__( /*! ../../core/devices */ 53),
            fx = __webpack_require__( /*! ../fx */ 68);
        var directionPostfixes = {
            forward: " dx-forward",
            backward: " dx-backward",
            none: " dx-no-direction",
            undefined: " dx-no-direction"
        };
        var optionPrefix = "preset_";
        var AnimationPresetCollection = Component.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._registeredPresets = [];
                this.resetToDefaults()
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    defaultAnimationDuration: 400,
                    defaultAnimationDelay: 0,
                    defaultStaggerAnimationDuration: 300,
                    defaultStaggerAnimationDelay: 40,
                    defaultStaggerAnimationStartDelay: 500
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function(device) {
                        return device.phone
                    },
                    options: {
                        defaultStaggerAnimationDuration: 350,
                        defaultStaggerAnimationDelay: 50,
                        defaultStaggerAnimationStartDelay: 0
                    }
                }, {
                    device: function() {
                        return devices.current().android || devices.real.android
                    },
                    options: {
                        defaultAnimationDelay: 100
                    }
                }])
            },
            _getPresetOptionName: function(animationName) {
                return optionPrefix + animationName
            },
            _createAndroidSlideAnimationConfig: function(throughOpacity, widthMultiplier) {
                var that = this;
                var createBaseConfig = function(configModifier) {
                    return {
                        type: "slide",
                        delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                        duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                    }
                };
                return {
                    enter: function($element, configModifier) {
                        var width = $element.parent().width() * widthMultiplier,
                            direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.to = {
                            left: 0,
                            opacity: 1
                        };
                        if ("forward" === direction) {
                            config.from = {
                                left: width,
                                opacity: throughOpacity
                            }
                        } else {
                            if ("backward" === direction) {
                                config.from = {
                                    left: -width,
                                    opacity: throughOpacity
                                }
                            } else {
                                config.from = {
                                    left: 0,
                                    opacity: 0
                                }
                            }
                        }
                        return fx.createAnimation($element, config)
                    },
                    leave: function($element, configModifier) {
                        var width = $element.parent().width() * widthMultiplier,
                            direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.from = {
                            left: 0,
                            opacity: 1
                        };
                        if ("forward" === direction) {
                            config.to = {
                                left: -width,
                                opacity: throughOpacity
                            }
                        } else {
                            if ("backward" === direction) {
                                config.to = {
                                    left: width,
                                    opacity: throughOpacity
                                }
                            } else {
                                config.to = {
                                    left: 0,
                                    opacity: 0
                                }
                            }
                        }
                        return fx.createAnimation($element, config)
                    }
                }
            },
            _createOpenDoorConfig: function() {
                var that = this;
                var createBaseConfig = function(configModifier) {
                    return {
                        type: "css",
                        extraCssClasses: "dx-opendoor-animation",
                        delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                        duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                    }
                };
                return {
                    enter: function($element, configModifier) {
                        var direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.delay = "none" === direction ? config.delay : config.duration;
                        config.from = "dx-enter dx-opendoor-animation" + directionPostfixes[direction];
                        config.to = "dx-enter-active";
                        return fx.createAnimation($element, config)
                    },
                    leave: function($element, configModifier) {
                        var direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.from = "dx-leave dx-opendoor-animation" + directionPostfixes[direction];
                        config.to = "dx-leave-active";
                        return fx.createAnimation($element, config)
                    }
                }
            },
            _createWinPopConfig: function() {
                var that = this,
                    baseConfig = {
                        type: "css",
                        extraCssClasses: "dx-win-pop-animation",
                        duration: that.option("defaultAnimationDuration")
                    };
                return {
                    enter: function($element, configModifier) {
                        var config = baseConfig,
                            direction = configModifier.direction;
                        config.delay = "none" === direction ? that.option("defaultAnimationDelay") : that.option("defaultAnimationDuration") / 2;
                        config.from = "dx-enter dx-win-pop-animation" + directionPostfixes[direction];
                        config.to = "dx-enter-active";
                        return fx.createAnimation($element, config)
                    },
                    leave: function($element, configModifier) {
                        var config = baseConfig,
                            direction = configModifier.direction;
                        config.delay = that.option("defaultAnimationDelay");
                        config.from = "dx-leave dx-win-pop-animation" + directionPostfixes[direction];
                        config.to = "dx-leave-active";
                        return fx.createAnimation($element, config)
                    }
                }
            },
            resetToDefaults: function() {
                this.clear();
                this.registerDefaultPresets();
                this.applyChanges()
            },
            clear: function(name) {
                var that = this,
                    newRegisteredPresets = [];
                $.each(this._registeredPresets, function(index, preset) {
                    if (!name || name === preset.name) {
                        that.option(that._getPresetOptionName(preset.name), void 0)
                    } else {
                        newRegisteredPresets.push(preset)
                    }
                });
                this._registeredPresets = newRegisteredPresets;
                this.applyChanges()
            },
            registerPreset: function(name, config) {
                this._registeredPresets.push({
                    name: name,
                    config: config
                })
            },
            applyChanges: function() {
                var that = this;
                var customRules = [];
                $.each(this._registeredPresets, function(index, preset) {
                    var rule = {
                        device: preset.config.device,
                        options: {}
                    };
                    rule.options[that._getPresetOptionName(preset.name)] = preset.config.animation;
                    customRules.push(rule)
                });
                this._setOptionsByDevice(customRules)
            },
            getPreset: function(name) {
                var result = name;
                while ("string" === typeof result) {
                    result = this.option(this._getPresetOptionName(result))
                }
                return result
            },
            registerDefaultPresets: function() {
                this.registerPreset("pop", {
                    animation: {
                        extraCssClasses: "dx-android-pop-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("openDoor", {
                    animation: this._createOpenDoorConfig()
                });
                this.registerPreset("win-pop", {
                    animation: this._createWinPopConfig()
                });
                this.registerPreset("fade", {
                    animation: {
                        extraCssClasses: "dx-fade-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("slide", {
                    device: function() {
                        return devices.current().android || devices.real.android
                    },
                    animation: this._createAndroidSlideAnimationConfig(1, 1)
                });
                this.registerPreset("slide", {
                    device: function() {
                        return !devices.current().android && !devices.real.android
                    },
                    animation: {
                        extraCssClasses: "dx-slide-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("ios7-slide", {
                    animation: {
                        extraCssClasses: "dx-ios7-slide-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("overflow", {
                    animation: {
                        extraCssClasses: "dx-overflow-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("ios7-toolbar", {
                    device: function() {
                        return !devices.current().android && !devices.real.android
                    },
                    animation: {
                        extraCssClasses: "dx-ios7-toolbar-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("ios7-toolbar", {
                    device: function() {
                        return devices.current().android || devices.real.android
                    },
                    animation: this._createAndroidSlideAnimationConfig(0, .4)
                });
                this.registerPreset("stagger-fade", {
                    animation: {
                        extraCssClasses: "dx-fade-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-slide", {
                    animation: {
                        extraCssClasses: "dx-slide-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-slide", {
                    animation: {
                        extraCssClasses: "dx-fade-slide-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-drop", {
                    animation: {
                        extraCssClasses: "dx-drop-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-drop", {
                    animation: {
                        extraCssClasses: "dx-fade-drop-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-rise", {
                    animation: {
                        extraCssClasses: "dx-fade-rise-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-3d-drop", {
                    animation: {
                        extraCssClasses: "dx-3d-drop-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-zoom", {
                    animation: {
                        extraCssClasses: "dx-fade-zoom-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                })
            }
        });
        exports.PresetCollection = AnimationPresetCollection;
        var animationPresets = new AnimationPresetCollection;
        exports.presets = animationPresets
    },
    /*!****************************!*\
      !*** ./js/animation/fx.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            errors = __webpack_require__( /*! ../core/errors */ 7),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 12),
            translator = __webpack_require__( /*! ./translator */ 69),
            animationFrame = __webpack_require__( /*! ./frame */ 59),
            support = __webpack_require__( /*! ../core/utils/support */ 61),
            positionUtils = __webpack_require__( /*! ./position */ 70),
            removeEvent = __webpack_require__( /*! ../core/remove_event */ 47),
            eventUtils = __webpack_require__( /*! ../events/utils */ 71),
            when = __webpack_require__( /*! ../integration/jquery/deferred */ 16).when,
            transitionEndEventName = support.transitionEndEventName + ".dxFX",
            removeEventName = eventUtils.addNamespace(removeEvent, "dxFX"),
            isFunction = commonUtils.isFunction,
            isPlainObject = typeUtils.isPlainObject,
            noop = commonUtils.noop;
        var CSS_TRANSITION_EASING_REGEX = /cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/,
            RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i,
            ANIM_DATA_KEY = "dxAnimData",
            ANIM_QUEUE_KEY = "dxAnimQueue",
            TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this,
                    deferred = $.Deferred(),
                    cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            when(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var simulatedEndEventTimer, waitForJSCompleteTimer, that = this,
                    startTime = $.now() + config.delay,
                    deferred = $.Deferred(),
                    transitionEndFired = $.Deferred(),
                    simulatedTransitionEndFired = $.Deferred();
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    $element.off(transitionEndEventName);
                    $element.off(removeEventName)
                };
                $element.one(transitionEndEventName, function() {
                    if ($.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                }).off(removeEventName).on(removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    when(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if (isPlainObject(config.to)) {
                        $.each(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = $.Deferred(),
                    that = this;
                if (!config) {
                    return deferred.reject().promise()
                }
                $.each(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: convertTransitionTimingFuncToJQueryEasing(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = extend({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = $.map(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return translator.getTranslateCss(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.off(removeEventName).on(removeEventName, function() {
                    if (config.frameAnimation) {
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                $.each(transformString.match(/(\w|\d)+\([^\)]*\)\s*/g), function(i, part) {
                    var translateData = translator.parseTranslate(part),
                        scaleData = part.match(/scale\((.+?)\)/),
                        rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                animationFrame.cancelAnimationFrame(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = animationFrame.requestAnimationFrame(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration,
                            t = currentDuration,
                            b = 1 * from[propName],
                            c = to[propName] - from[propName],
                            d = frameAnimation.duration;
                        return $.easing[frameAnimation.easing](x, t, b, c, d)
                    };
                    $.each(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === typeof endPropValue ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return $.Deferred().resolve().promise()
            },
            stop: noop,
            isSynchronous: true
        };
        var animationStrategies = {
            transition: support.transition ? TransitionAnimationStrategy : FrameAnimationStrategy,
            frame: FrameAnimationStrategy,
            noAnimation: FallbackToNoAnimationStrategy
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !support.transition) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var TransitionTimingFuncMap = {
            linear: "cubic-bezier(0, 0, 1, 1)",
            ease: "cubic-bezier(0.25, 0.1, 0.25, 1)",
            "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
            "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
            "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)"
        };
        var convertTransitionTimingFuncToJQueryEasing = function(cssTransitionEasing) {
            cssTransitionEasing = TransitionTimingFuncMap[cssTransitionEasing] || cssTransitionEasing;
            var coeffs = cssTransitionEasing.match(CSS_TRANSITION_EASING_REGEX);
            if (!coeffs) {
                return "linear"
            }
            coeffs = coeffs.slice(1, 5);
            $.each(coeffs, function(index, value) {
                coeffs[index] = parseFloat(value)
            });
            var easingName = "cubicbezier_" + coeffs.join("_").replace(/\./g, "p");
            if (!isFunction($.easing[easingName])) {
                var polynomBezier = function(x1, y1, x2, y2) {
                    var Cx = 3 * x1,
                        Bx = 3 * (x2 - x1) - Cx,
                        Ax = 1 - Cx - Bx,
                        Cy = 3 * y1,
                        By = 3 * (y2 - y1) - Cy,
                        Ay = 1 - Cy - By;
                    var bezierX = function(t) {
                        return t * (Cx + t * (Bx + t * Ax))
                    };
                    var bezierY = function(t) {
                        return t * (Cy + t * (By + t * Ay))
                    };
                    var findXFor = function(t) {
                        var z, x = t,
                            i = 0;
                        while (i < 14) {
                            z = bezierX(x) - t;
                            if (Math.abs(z) < .001) {
                                break
                            }
                            x -= z / derivativeX(x);
                            i++
                        }
                        return x
                    };
                    var derivativeX = function(t) {
                        return Cx + t * (2 * Bx + 3 * t * Ax)
                    };
                    return function(t) {
                        return bezierY(findXFor(t))
                    }
                };
                $.easing[easingName] = function(x, t, b, c, d) {
                    return c * polynomBezier(coeffs[0], coeffs[1], coeffs[2], coeffs[3])(t / d) + b
                }
            }
            return easingName
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            $.each(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw errors.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return isPlainObject(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = translator.locate($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = extend({ of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                translator.clearCache($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = translator.getTranslateCss({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var toOpacity, from = config.from,
                    fromOpacity = isPlainObject(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from,
                    to = config.to,
                    fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity"),
                    toOpacity = "opacity" in to ? to.opacity : 1,
                    fromScale = "scale" in from ? from.scale : 0,
                    toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = translator.getTranslate($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return translator.getTranslateCss(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw errors.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
                type: "custom",
                from: {},
                to: {},
                duration: 400,
                start: noop,
                complete: noop,
                easing: "ease",
                delay: 0
            },
            defaultCssConfig = {
                duration: 400,
                easing: "ease",
                delay: 0
            };
        var setupAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                config.start.apply(this, [$element, config])
            }
        };
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element,
                config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                config.complete.apply(this, [$element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = eventUtils.addNamespace(removeEvent, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            animation.element.off(scopedRemoveEvent).on(scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                animation.element.off(scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig,
                config = extend(true, {}, defaultConfig, initialConfig),
                configurator = getAnimationConfigurator(config),
                strategy = getAnimationStrategy(config),
                animation = {
                    element: $(element),
                    config: config,
                    configurator: configurator,
                    strategy: strategy,
                    isSynchronous: strategy.isSynchronous,
                    setup: setupAnimationOnElement,
                    start: startAnimationOnElement,
                    stop: stopAnimationOnElement,
                    deferred: $.Deferred()
                };
            if (isFunction(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = $(element);
            if (!$element.length) {
                return $.Deferred().resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };
        var pushInAnimationQueue = function($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        };
        var getAnimQueueData = function($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        };
        var writeAnimQueueData = function($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        };
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };
        var isAnimating = function($element) {
            return !!$element.data(ANIM_DATA_KEY)
        };
        var shiftFromAnimationQueue = function($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        };
        var executeAnimation = function(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        };
        var setupPosition = function($element, config) {
            if (!config || !config.position) {
                return
            }
            var position = positionUtils.calculate($element, config.position),
                offset = $element.offset(),
                currentPosition = $element.position();
            extend(config, {
                left: position.h.location - offset.left + currentPosition.left,
                top: position.v.location - offset.top + currentPosition.top
            });
            delete config.position
        };
        var setProps = function($element, props) {
            $.each(props, function(key, value) {
                try {
                    $element.css(key, value)
                } catch (e) {}
            })
        };
        var stop = function(element, jumpToEnd) {
            var $element = $(element),
                queueData = getAnimQueueData($element);
            $.each(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        fx.__internals = {
            convertTransitionTimingFuncToJQueryEasing: convertTransitionTimingFuncToJQueryEasing
        };
        module.exports = fx
    },
    /*!************************************!*\
      !*** ./js/animation/translator.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            type = __webpack_require__( /*! ../core/utils/common */ 14).type;
        var TRANSLATOR_DATA_KEY = "dxTranslator",
            TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/,
            TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };
        var move = function($element, position) {
            var translate, left = position.left,
                top = position.top;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        var isPercentValue = function(value) {
            return "string" === type(value) && "%" === value[value.length - 1]
        };
        var getTranslate = function($element) {
            var result = $element.length ? $.data($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                        x: 0,
                        y: 0
                    }),
                    matrix = transformValue.match(TRANSFORM_MATRIX_REGEX),
                    is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        var cacheTranslate = function($element, translate) {
            if ($element.length) {
                $.data($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        };
        var clearCache = function($element) {
            if ($element.length) {
                $.removeData($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        var resetPosition = function($element) {
            $element.css({
                left: 0,
                top: 0,
                transform: "none"
            });
            clearCache($element)
        };
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        exports.move = move;
        exports.locate = locate;
        exports.clearCache = clearCache;
        exports.parseTranslate = parseTranslate;
        exports.getTranslate = getTranslate;
        exports.getTranslateCss = getTranslateCss;
        exports.resetPosition = resetPosition
    },
    /*!**********************************!*\
      !*** ./js/animation/position.js ***!
      \**********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            stringUtils = __webpack_require__( /*! ../core/utils/string */ 18),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            translator = __webpack_require__( /*! ./translator */ 69),
            support = __webpack_require__( /*! ../core/utils/support */ 61);
        var horzRe = /left|right/,
            vertRe = /top|bottom/,
            collisionRe = /fit|flip|none/;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = commonUtils.splitPair(raw);
            if (pair) {
                $.each(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return stringUtils.pairToObject(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = commonUtils.splitPair(raw),
                h = String(pair && pair[0]).toLowerCase(),
                v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = extend({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = $("<div>").css({
                    width: 100,
                    height: 100,
                    overflow: "scroll",
                    position: "absolute",
                    top: -9999
                }).appendTo($("body")),
                result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = $(what),
                currentOffset = $what.offset(),
                result = extend(true, {}, defaultPositionResult, {
                    h: {
                        location: currentOffset.left
                    },
                    v: {
                        location: currentOffset.top
                    }
                });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my),
                at = normalizeAlign(options.at),
                of = options.of || window,
                offset = normalizeOffset(options.offset),
                collision = normalizeCollision(options.collision),
                boundary = options.boundary,
                boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else { of = $( of );
                if (commonUtils.isWindow( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    h.atSize = of [0].innerWidth > of [0].outerWidth ? of [0].innerWidth : of .width();
                    v.atSize = of [0].innerHeight > of [0].outerHeight ? of [0].innerHeight : of .height()
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var o = of .offset();
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = of .outerWidth();
                        v.atSize = of .outerHeight()
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = $(window),
                    windowWidth = win.width(),
                    windowHeight = win.height(),
                    left = win.scrollLeft(),
                    top = win.scrollTop(),
                    hScrollbar = document.width > document.documentElement.clientWidth,
                    vScrollbar = document.height > document.documentElement.clientHeight,
                    hZoomLevel = support.touch ? document.documentElement.clientWidth / (vScrollbar ? windowWidth - scrollbarWidth : windowWidth) : 1,
                    vZoomLevel = support.touch ? document.documentElement.clientHeight / (hScrollbar ? windowHeight - scrollbarWidth : windowHeight) : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth,
                    boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = $(boundary),
                        boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            extend(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var position = function(what, options) {
            var $what = $(what);
            if (!options) {
                return $what.offset()
            }
            translator.resetPosition($what);
            var offset = $what.offset(),
                targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            translator.move($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = $(element).get(0);
            if (commonUtils.isWindow(element)) {
                return null
            } else {
                if (element instanceof $.Event) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return $(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        module.exports = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        }
    },
    /*!****************************!*\
      !*** ./js/events/utils.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            errors = __webpack_require__( /*! ../core/errors */ 7),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            copyEvent = __webpack_require__( /*! ./core/hooks */ 72).copy;
        var eventSource = function() {
            var EVENT_SOURCES_REGEX = {
                dx: /^dx/i,
                mouse: /(mouse|wheel)/i,
                touch: /^touch/i,
                keyboard: /^key/i,
                pointer: /^(ms)?pointer/i
            };
            return function(e) {
                var result = "other";
                $.each(EVENT_SOURCES_REGEX, function(key) {
                    if (this.test(e.type)) {
                        result = key;
                        return false
                    }
                });
                return result
            }
        }();
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        var isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        var isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        var isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        var isFakeClickEvent = function(e) {
            return 0 === e.screenX && !e.offsetX && 0 === e.pageX
        };
        var eventData = function(e) {
            return {
                x: e.pageX,
                y: e.pageY,
                time: e.timeStamp
            }
        };
        var eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        var hasTouches = function(e) {
            if (isNativeTouchEvent(e)) {
                return (e.originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (e.pointers || []).length
            }
            return 0
        };
        var needSkipEvent = function(e) {
            var $target = $(e.target),
                touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if ("dxmousewheel" === e.type) {
                return $target.is("input[type='number'], textarea, select") && $target.is(":focus")
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && $target.is(":focus")
            }
        };
        var createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            if (args) {
                extend(event, args)
            }
            return event
        };
        var fireEvent = function(props) {
            var event = createEvent(props.originalEvent, props);
            $.event.trigger(event, null, props.delegateTarget || event.target);
            return event
        };
        var addNamespace = function(eventNames, namespace) {
            if (!namespace) {
                throw errors.Error("E0017")
            }
            if ("string" === typeof eventNames) {
                if (eventNames.indexOf(" ") === -1) {
                    return eventNames + "." + namespace
                }
                return addNamespace(eventNames.split(/\s+/g), namespace)
            }
            $.each(eventNames, function(index, eventName) {
                eventNames[index] = eventName + "." + namespace
            });
            return eventNames.join(" ")
        };
        module.exports = {
            eventSource: eventSource,
            isPointerEvent: isPointerEvent,
            isMouseEvent: isMouseEvent,
            isTouchEvent: isTouchEvent,
            isKeyboardEvent: isKeyboardEvent,
            isFakeClickEvent: isFakeClickEvent,
            hasTouches: hasTouches,
            eventData: eventData,
            eventDelta: eventDelta,
            needSkipEvent: needSkipEvent,
            createEvent: createEvent,
            fireEvent: fireEvent,
            addNamespace: addNamespace
        }
    },
    /*!*********************************!*\
      !*** ./js/events/core/hooks.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            compareVersion = __webpack_require__( /*! ../../core/utils/version */ 17).compare,
            isNumeric = __webpack_require__( /*! ../../core/utils/common */ 14).isNumeric,
            registerEvent = __webpack_require__( /*! ./event_registrator */ 73);
        var touchPropsToHook = ["pageX", "pageY", "screenX", "screenY", "clientX", "clientY"];
        var touchPropHook = function(name, event) {
            if (event[name] || !event.touches) {
                return event[name]
            }
            var touches = event.touches.length ? event.touches : event.changedTouches;
            if (!touches.length) {
                return
            }
            return touches[0][name]
        };
        if (compareVersion($.fn.jquery, [3]) < 0) {
            var POINTER_TYPE_MAP = {
                2: "touch",
                3: "pen",
                4: "mouse"
            };
            $.each(["MSPointerDown", "MSPointerMove", "MSPointerUp", "MSPointerCancel", "MSPointerOver", "MSPointerOut", "mouseenter", "mouseleave", "pointerdown", "pointermove", "pointerup", "pointercancel", "pointerover", "pointerout", "pointerenter", "pointerleave"], function() {
                $.event.fixHooks[this] = {
                    filter: function(event, originalEvent) {
                        var pointerType = originalEvent.pointerType;
                        if (isNumeric(pointerType)) {
                            event.pointerType = POINTER_TYPE_MAP[pointerType]
                        }
                        return event
                    },
                    props: $.event.mouseHooks.props.concat(["pointerId", "pointerType", "originalTarget", "width", "height", "pressure", "result", "tiltX", "charCode", "tiltY", "detail", "isPrimary", "prevValue"])
                }
            });
            $.each(["touchstart", "touchmove", "touchend", "touchcancel"], function() {
                $.event.fixHooks[this] = {
                    filter: function(event, originalEvent) {
                        $.each(touchPropsToHook, function(_, name) {
                            event[name] = touchPropHook(name, originalEvent)
                        });
                        return event
                    },
                    props: $.event.mouseHooks.props.concat(["touches", "changedTouches", "targetTouches", "detail", "result", "originalTarget", "charCode", "prevValue"])
                }
            });
            $.event.fixHooks.wheel = $.event.mouseHooks;
            var DX_EVENT_HOOKS = {
                props: $.event.mouseHooks.props.concat(["pointerType", "pointerId", "pointers"])
            };
            registerEvent.callbacks.add(function(name) {
                $.event.fixHooks[name] = DX_EVENT_HOOKS
            });
            var fix = function(event, originalEvent) {
                var fixHook = $.event.fixHooks[originalEvent.type] || $.event.mouseHooks;
                var props = fixHook.props ? $.event.props.concat(fixHook.props) : $.event.props,
                    propIndex = props.length;
                while (propIndex--) {
                    var prop = props[propIndex];
                    event[prop] = originalEvent[prop]
                }
                return fixHook.filter ? fixHook.filter(event, originalEvent) : event
            };
            exports.copy = function(originalEvent) {
                return fix($.Event(originalEvent.type, originalEvent), originalEvent)
            }
        } else {
            $.each(touchPropsToHook, function(_, name) {
                $.event.addProp(name, function(event) {
                    return touchPropHook(name, event)
                })
            });
            exports.copy = function(originalEvent) {
                return $.Event(originalEvent, originalEvent)
            }
        }
    },
    /*!*********************************************!*\
      !*** ./js/events/core/event_registrator.js ***!
      \*********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            MemorizedCallbacks = __webpack_require__( /*! ../../core/memorized_callbacks */ 58);
        var callbacks = new MemorizedCallbacks;
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }
            $.each(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = $.makeArray(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            callbacks.fire(name, strategy)
        };
        registerEvent.callbacks = callbacks;
        var registerJQueryEvent = function(name, eventObject) {
            $.event.special[name] = eventObject
        };
        callbacks.add(registerJQueryEvent);
        module.exports = registerEvent
    },
    /*!*****************************************************************!*\
      !*** ./js/animation/transition_executor/transition_executor.js ***!
      \*****************************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 12),
            fx = __webpack_require__( /*! ../fx */ 68),
            animationPresetsModule = __webpack_require__( /*! ../presets/presets */ 67),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when;
        var directionPostfixes = {
                forward: " dx-forward",
                backward: " dx-backward",
                none: " dx-no-direction",
                undefined: " dx-no-direction"
            },
            DX_ANIMATING_CLASS = "dx-animating";
        var TransitionExecutor = Class.inherit({
            ctor: function() {
                this._accumulatedDelays = {
                    enter: 0,
                    leave: 0
                };
                this._animations = [];
                this.reset()
            },
            _createAnimations: function($elements, initialConfig, configModifier, type) {
                var animationConfig, that = this,
                    result = [];
                configModifier = configModifier || {};
                animationConfig = this._prepareElementAnimationConfig(initialConfig, configModifier, type);
                if (animationConfig) {
                    $elements.each(function() {
                        var animation = that._createAnimation($(this), animationConfig, configModifier);
                        if (animation) {
                            animation.element.addClass(DX_ANIMATING_CLASS);
                            animation.setup();
                            result.push(animation)
                        }
                    })
                }
                return result
            },
            _prepareElementAnimationConfig: function(config, configModifier, type) {
                var result;
                if ("string" === typeof config) {
                    var presetName = config;
                    config = animationPresetsModule.presets.getPreset(presetName)
                }
                if (!config) {
                    result = void 0
                } else {
                    if (commonUtils.isFunction(config[type])) {
                        result = config[type]
                    } else {
                        result = extend({
                            skipElementInitialStyles: true,
                            cleanupWhen: this._completePromise
                        }, config, configModifier);
                        if (!result.type || "css" === result.type) {
                            var cssClass = "dx-" + type,
                                extraCssClasses = (result.extraCssClasses ? " " + result.extraCssClasses : "") + directionPostfixes[result.direction];
                            result.type = "css";
                            result.from = (result.from || cssClass) + extraCssClasses;
                            result.to = result.to || cssClass + "-active"
                        }
                        result.staggerDelay = result.staggerDelay || 0;
                        result.delay = result.delay || 0;
                        if (result.staggerDelay) {
                            result.delay += this._accumulatedDelays[type];
                            this._accumulatedDelays[type] += result.staggerDelay
                        }
                    }
                }
                return result
            },
            _createAnimation: function($element, animationConfig, configModifier) {
                var result;
                if (typeUtils.isPlainObject(animationConfig)) {
                    result = fx.createAnimation($element, animationConfig)
                } else {
                    if (commonUtils.isFunction(animationConfig)) {
                        result = animationConfig($element, configModifier)
                    }
                }
                return result
            },
            _startAnimations: function() {
                var animations = this._animations;
                for (var i = 0; i < animations.length; i++) {
                    animations[i].start()
                }
            },
            _stopAnimations: function(jumpToEnd) {
                var animations = this._animations;
                for (var i = 0; i < animations.length; i++) {
                    animations[i].stop(jumpToEnd)
                }
            },
            _clearAnimations: function() {
                var animations = this._animations;
                for (var i = 0; i < animations.length; i++) {
                    animations[i].element.removeClass(DX_ANIMATING_CLASS)
                }
                this._animations.length = 0
            },
            reset: function() {
                this._accumulatedDelays.enter = 0;
                this._accumulatedDelays.leave = 0;
                this._clearAnimations();
                this._completeDeferred = $.Deferred();
                this._completePromise = this._completeDeferred.promise()
            },
            enter: function($elements, animationConfig, configModifier) {
                var animations = this._createAnimations($elements, animationConfig, configModifier, "enter");
                this._animations.push.apply(this._animations, animations)
            },
            leave: function($elements, animationConfig, configModifier) {
                var animations = this._createAnimations($elements, animationConfig, configModifier, "leave");
                this._animations.push.apply(this._animations, animations)
            },
            start: function() {
                var result, that = this;
                if (!this._animations.length) {
                    that.reset();
                    result = $.Deferred().resolve().promise()
                } else {
                    var animationDeferreds = $.map(this._animations, function(animation) {
                        var result = $.Deferred();
                        animation.deferred.always(function() {
                            result.resolve()
                        });
                        return result.promise()
                    });
                    result = when.apply($, animationDeferreds).always(function() {
                        that._completeDeferred.resolve();
                        that.reset()
                    });
                    commonUtils.executeAsync(function() {
                        that._startAnimations()
                    })
                }
                return result
            },
            stop: function(jumpToEnd) {
                this._stopAnimations(jumpToEnd)
            }
        });
        exports.TransitionExecutor = TransitionExecutor
    },
    /*!****************************!*\
      !*** ./js/events/click.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            devices = __webpack_require__( /*! ../core/devices */ 53),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 56),
            animationFrame = __webpack_require__( /*! ../animation/frame */ 59),
            eventUtils = __webpack_require__( /*! ./utils */ 71),
            pointerEvents = __webpack_require__( /*! ./pointer */ 76),
            Emitter = __webpack_require__( /*! ./core/emitter */ 83),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 84),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 17).compare;
        var CLICK_EVENT_NAME = "dxclick",
            TOUCH_BOUNDARY = 10,
            abs = Math.abs;
        var isInput = function(element) {
            return $(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: animationFrame.requestAnimationFrame,
            cancelAnimationFrame: animationFrame.cancelAnimationFrame
        };
        var ClickEmitter = Emitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable($(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = eventUtils.eventData(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === pointerEvents.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    domUtils.resetActiveElement()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target,
                    targetChanged = !$.contains(element, target) && element !== target,
                    gestureDelta = eventUtils.eventDelta(eventUtils.eventData(e), this._startEventData),
                    boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: domUtils.closestCommonParent(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var realDevice = devices.real(),
                useNativeClick = realDevice.generic || realDevice.ios && compareVersions(realDevice.version, [9, 3]) >= 0 || realDevice.android && compareVersions(realDevice.version, [5]) >= 0;
            var isNativeClickEvent = function(target) {
                return useNativeClick || $(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null,
                lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent,
                    eventAlreadyFired = lastFiredEvent !== originalEvent,
                    leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && eventAlreadyFired) {
                    lastFiredEvent = originalEvent;
                    eventUtils.fireEvent({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    $element.on("click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    this.getElement().off("click", clickHandler)
                }
            });
            exports.useNativeClick = useNativeClick
        }();
        ! function() {
            var desktopDevice = devices.real().generic;
            if (!desktopDevice) {
                var startTarget = null,
                    blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = $(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !$(startTarget).is("label") && isInput($target)) {
                        domUtils.resetActiveElement()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER";
                $(document).on(eventUtils.addNamespace(pointerEvents.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler).on(eventUtils.addNamespace("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        registerEmitter({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        });
        exports.name = CLICK_EVENT_NAME;
        exports.misc = misc
    },
    /*!******************************!*\
      !*** ./js/events/pointer.js ***!
      \******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            support = __webpack_require__( /*! ../core/utils/support */ 61),
            devices = __webpack_require__( /*! ../core/devices */ 53),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 73),
            TouchStrategy = __webpack_require__( /*! ./pointer/touch */ 77),
            MsPointerStrategy = __webpack_require__( /*! ./pointer/mspointer */ 79),
            MouseStrategy = __webpack_require__( /*! ./pointer/mouse */ 81),
            MouseAndTouchStrategy = __webpack_require__( /*! ./pointer/mouse_and_touch */ 82);
        var EventStrategy = function() {
            if (support.pointerEvents) {
                return MsPointerStrategy
            }
            var device = devices.real();
            if (support.touch && !(device.tablet || device.phone)) {
                return MouseAndTouchStrategy
            }
            if (support.touch) {
                return TouchStrategy
            }
            return MouseStrategy
        }();
        $.each(EventStrategy.map, function(pointerEvent, originalEvents) {
            registerEvent(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
        });
        module.exports = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        }
    },
    /*!************************************!*\
      !*** ./js/events/pointer/touch.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            devices = __webpack_require__( /*! ../../core/devices */ 53),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            BaseStrategy = __webpack_require__( /*! ./base */ 78);
        var eventMap = {
            dxpointerdown: "touchstart",
            dxpointermove: "touchmove",
            dxpointerup: "touchend",
            dxpointercancel: "touchcancel",
            dxpointerover: "",
            dxpointerout: "",
            dxpointerenter: "",
            dxpointerleave: ""
        };
        var normalizeTouchEvent = function(e) {
            var pointers = [];
            $.each(e.touches, function(_, touch) {
                pointers.push(extend({
                    pointerId: touch.identifier
                }, touch))
            });
            return {
                pointers: pointers,
                pointerId: e.changedTouches[0].identifier
            }
        };
        var skipTouchWithSameIdentifier = function(pointerEvent) {
            return "ios" === devices.real().platform && ("dxpointerdown" === pointerEvent || "dxpointerup" === pointerEvent)
        };
        var TouchStrategy = BaseStrategy.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._pointerId = 0
            },
            _handler: function(e) {
                if (skipTouchWithSameIdentifier(this._eventName)) {
                    var touch = e.changedTouches[0];
                    if (this._pointerId === touch.identifier && 0 !== this._pointerId) {
                        return
                    }
                    this._pointerId = touch.identifier
                }
                return this.callBase.apply(this, arguments)
            },
            _fireEvent: function(args) {
                return this.callBase(extend(normalizeTouchEvent(args.originalEvent), args))
            }
        });
        TouchStrategy.map = eventMap;
        TouchStrategy.normalize = normalizeTouchEvent;
        module.exports = TouchStrategy
    },
    /*!***********************************!*\
      !*** ./js/events/pointer/base.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 23),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            eventUtils = __webpack_require__( /*! ../utils */ 71);
        var POINTER_EVENTS_NAMESPACE = "dxPointerEvents";
        var BaseStrategy = Class.inherit({
            ctor: function(eventName, originalEvents) {
                this._eventName = eventName;
                this._originalEvents = eventUtils.addNamespace(originalEvents, POINTER_EVENTS_NAMESPACE);
                this._handlerCount = 0;
                this.noBubble = this._isNoBubble()
            },
            _isNoBubble: function() {
                var eventName = this._eventName;
                return "dxpointerenter" === eventName || "dxpointerleave" === eventName
            },
            _handler: function(e) {
                var delegateTarget = this._getDelegateTarget(e);
                return this._fireEvent({
                    type: this._eventName,
                    pointerType: e.pointerType || eventUtils.eventSource(e),
                    originalEvent: e,
                    delegateTarget: delegateTarget,
                    timeStamp: browser.mozilla ? (new Date).getTime() : e.timeStamp
                })
            },
            _getDelegateTarget: function(e) {
                var delegateTarget;
                if (this.noBubble) {
                    delegateTarget = e.delegateTarget
                }
                return delegateTarget
            },
            _fireEvent: function(args) {
                return eventUtils.fireEvent(args)
            },
            setup: function() {
                return true
            },
            add: function(element, handleObj) {
                if (this._handlerCount <= 0 || this.noBubble) {
                    this._selector = handleObj.selector;
                    element = this.noBubble ? element : document;
                    var that = this;
                    $(element).on(this._originalEvents, this._selector, function(e) {
                        that._handler(e)
                    })
                }
                if (!this.noBubble) {
                    this._handlerCount++
                }
            },
            remove: function() {
                if (!this.noBubble) {
                    this._handlerCount--
                }
            },
            teardown: function(element) {
                if (this._handlerCount && !this.noBubble) {
                    return
                }
                element = this.noBubble ? element : document;
                if (this._originalEvents !== "." + POINTER_EVENTS_NAMESPACE) {
                    $(element).off(this._originalEvents, this._selector)
                }
            },
            dispose: function(element) {
                element = this.noBubble ? element : document;
                $(element).off(this._originalEvents)
            }
        });
        module.exports = BaseStrategy
    },
    /*!****************************************!*\
      !*** ./js/events/pointer/mspointer.js ***!
      \****************************************/
    function(module, exports, __webpack_require__) {
        var BaseStrategy = __webpack_require__( /*! ./base */ 78),
            Observer = __webpack_require__( /*! ./observer */ 80),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            onlyMSPointerSupport = !window.PointerEvent && window.MSPointerEvent;
        var eventMap = {
            dxpointerdown: onlyMSPointerSupport ? "MSPointerDown" : "pointerdown",
            dxpointermove: onlyMSPointerSupport ? "MSPointerMove" : "pointermove",
            dxpointerup: onlyMSPointerSupport ? "MSPointerUp" : "pointerup",
            dxpointercancel: onlyMSPointerSupport ? "MSPointerCancel" : "pointercancel",
            dxpointerover: onlyMSPointerSupport ? "MSPointerOver" : "pointerover",
            dxpointerout: onlyMSPointerSupport ? "MSPointerOut" : "pointerout",
            dxpointerenter: onlyMSPointerSupport ? "mouseenter" : "pointerenter",
            dxpointerleave: onlyMSPointerSupport ? "mouseleave" : "pointerleave"
        };
        var observer;
        var activated = false;
        var activateStrategy = function() {
            if (activated) {
                return
            }
            observer = new Observer(eventMap, function(a, b) {
                return a.pointerId === b.pointerId
            }, function(e) {
                if (e.isPrimary) {
                    observer.reset()
                }
            });
            activated = true
        };
        var MsPointerStrategy = BaseStrategy.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                activateStrategy()
            },
            _fireEvent: function(args) {
                return this.callBase(extend({
                    pointers: observer.pointers(),
                    pointerId: args.originalEvent.pointerId
                }, args))
            }
        });
        MsPointerStrategy.map = eventMap;
        MsPointerStrategy.resetObserver = function() {
            observer.reset()
        };
        module.exports = MsPointerStrategy
    },
    /*!***************************************!*\
      !*** ./js/events/pointer/observer.js ***!
      \***************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9);
        var addEventsListener = function(events, handler) {
            events.split(" ").forEach(function(event) {
                document.addEventListener(event, handler, true)
            })
        };
        var Observer = function(eventMap, pointerEquals, onPointerAdding) {
            onPointerAdding = onPointerAdding || function() {};
            var pointers = [];
            var getPointerIndex = function(e) {
                var index = -1;
                $.each(pointers, function(i, pointer) {
                    if (!pointerEquals(e, pointer)) {
                        return true
                    }
                    index = i;
                    return false
                });
                return index
            };
            var addPointer = function(e) {
                if (getPointerIndex(e) === -1) {
                    onPointerAdding(e);
                    pointers.push(e)
                }
            };
            var removePointer = function(e) {
                var index = getPointerIndex(e);
                if (index > -1) {
                    pointers.splice(index, 1)
                }
            };
            var updatePointer = function(e) {
                pointers[getPointerIndex(e)] = e
            };
            addEventsListener(eventMap.dxpointerdown, addPointer);
            addEventsListener(eventMap.dxpointermove, updatePointer);
            addEventsListener(eventMap.dxpointerup, removePointer);
            addEventsListener(eventMap.dxpointercancel, removePointer);
            this.pointers = function() {
                return pointers
            };
            this.reset = function() {
                pointers = []
            }
        };
        module.exports = Observer
    },
    /*!************************************!*\
      !*** ./js/events/pointer/mouse.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            BaseStrategy = __webpack_require__( /*! ./base */ 78),
            Observer = __webpack_require__( /*! ./observer */ 80);
        var eventMap = {
            dxpointerdown: "mousedown",
            dxpointermove: "mousemove",
            dxpointerup: "mouseup",
            dxpointercancel: "",
            dxpointerover: "mouseover",
            dxpointerout: "mouseout",
            dxpointerenter: "mouseenter",
            dxpointerleave: "mouseleave"
        };
        var normalizeMouseEvent = function(e) {
            e.pointerId = 1;
            return {
                pointers: observer.pointers(),
                pointerId: 1
            }
        };
        var observer;
        var activated = false;
        var activateStrategy = function() {
            if (activated) {
                return
            }
            observer = new Observer(eventMap, function() {
                return true
            });
            activated = true
        };
        var MouseStrategy = BaseStrategy.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                activateStrategy()
            },
            _fireEvent: function(args) {
                return this.callBase(extend(normalizeMouseEvent(args.originalEvent), args))
            }
        });
        MouseStrategy.map = eventMap;
        MouseStrategy.normalize = normalizeMouseEvent;
        MouseStrategy.activate = activateStrategy;
        MouseStrategy.resetObserver = function() {
            observer.reset()
        };
        module.exports = MouseStrategy
    },
    /*!**********************************************!*\
      !*** ./js/events/pointer/mouse_and_touch.js ***!
      \**********************************************/
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            BaseStrategy = __webpack_require__( /*! ./base */ 78),
            MouseStrategy = __webpack_require__( /*! ./mouse */ 81),
            TouchStrategy = __webpack_require__( /*! ./touch */ 77),
            eventUtils = __webpack_require__( /*! ../utils */ 71);
        var eventMap = {
            dxpointerdown: "touchstart mousedown",
            dxpointermove: "touchmove mousemove",
            dxpointerup: "touchend mouseup",
            dxpointercancel: "touchcancel",
            dxpointerover: "mouseover",
            dxpointerout: "mouseout",
            dxpointerenter: "mouseenter",
            dxpointerleave: "mouseleave"
        };
        var activated = false;
        var activateStrategy = function() {
            if (activated) {
                return
            }
            MouseStrategy.activate();
            activated = true
        };
        var MouseAndTouchStrategy = BaseStrategy.inherit({
            EVENT_LOCK_TIMEOUT: 100,
            ctor: function() {
                this.callBase.apply(this, arguments);
                activateStrategy()
            },
            _handler: function(e) {
                var isMouseEvent = eventUtils.isMouseEvent(e);
                if (!isMouseEvent) {
                    this._skipNextEvents = true
                }
                if (isMouseEvent && this._mouseLocked) {
                    return
                }
                if (isMouseEvent && this._skipNextEvents) {
                    this._skipNextEvents = false;
                    this._mouseLocked = true;
                    clearTimeout(this._unlockMouseTimer);
                    var that = this;
                    this._unlockMouseTimer = setTimeout(function() {
                        that._mouseLocked = false
                    }, this.EVENT_LOCK_TIMEOUT);
                    return
                }
                return this.callBase(e)
            },
            _fireEvent: function(args) {
                var isMouseEvent = eventUtils.isMouseEvent(args.originalEvent),
                    normalizer = isMouseEvent ? MouseStrategy.normalize : TouchStrategy.normalize;
                return this.callBase(extend(normalizer(args.originalEvent), args))
            },
            dispose: function() {
                this.callBase();
                this._skipNextEvents = false;
                this._mouseLocked = false;
                clearTimeout(this._unlockMouseTimer)
            }
        });
        MouseAndTouchStrategy.map = eventMap;
        MouseAndTouchStrategy.resetObserver = MouseStrategy.resetObserver;
        module.exports = MouseAndTouchStrategy
    },
    /*!***********************************!*\
      !*** ./js/events/core/emitter.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            noop = __webpack_require__( /*! ../../core/utils/common */ 14).noop,
            Class = __webpack_require__( /*! ../../core/class */ 25),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            eventUtils = __webpack_require__( /*! ../utils */ 71);
        var Emitter = Class.inherit({
            ctor: function(element) {
                this._$element = $(element);
                this._cancelCallback = $.Callbacks();
                this._acceptCallback = $.Callbacks()
            },
            getElement: function() {
                return this._$element
            },
            validate: function(e) {
                return "dxmousewheel" !== e.type
            },
            validatePointers: function(e) {
                return 1 === eventUtils.hasTouches(e)
            },
            allowInterruptionByMouseWheel: function() {
                return true
            },
            configure: function(data) {
                extend(this, data)
            },
            addCancelCallback: function(callback) {
                this._cancelCallback.add(callback)
            },
            removeCancelCallback: function() {
                this._cancelCallback.empty()
            },
            _cancel: function(e) {
                this._cancelCallback.fire(this, e)
            },
            addAcceptCallback: function(callback) {
                this._acceptCallback.add(callback)
            },
            removeAcceptCallback: function() {
                this._acceptCallback.empty()
            },
            _accept: function(e) {
                this._acceptCallback.fire(this, e)
            },
            _requestAccept: function(e) {
                this._acceptRequestEvent = e
            },
            _forgetAccept: function() {
                this._accept(this._acceptRequestEvent);
                this._acceptRequestEvent = null
            },
            start: noop,
            move: noop,
            end: noop,
            cancel: noop,
            reset: function() {
                if (this._acceptRequestEvent) {
                    this._accept(this._acceptRequestEvent)
                }
            },
            _fireEvent: function(eventName, e, params) {
                var eventData = extend({
                    type: eventName,
                    originalEvent: e,
                    target: this._getEmitterTarget(e),
                    delegateTarget: this.getElement().get(0)
                }, params);
                e = eventUtils.fireEvent(eventData);
                if (e.cancel) {
                    this._cancel(e)
                }
                return e
            },
            _getEmitterTarget: function(e) {
                return (this.delegateSelector ? $(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
            },
            dispose: noop
        });
        module.exports = Emitter
    },
    /*!***********************************************!*\
      !*** ./js/events/core/emitter_registrator.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            registerEvent = __webpack_require__( /*! ./event_registrator */ 73),
            eventUtils = __webpack_require__( /*! ../utils */ 71),
            pointerEvents = __webpack_require__( /*! ../pointer */ 76),
            wheelEvent = __webpack_require__( /*! ./wheel */ 85);
        var MANAGER_EVENT = "dxEventManager",
            EMITTER_DATA = "dxEmitter";
        var EventManager = Class.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                $(document).on(eventUtils.addNamespace(pointerEvents.down, MANAGER_EVENT), this._pointerDownHandler.bind(this)).on(eventUtils.addNamespace(pointerEvents.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this)).on(eventUtils.addNamespace([pointerEvents.up, pointerEvents.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this)).on(eventUtils.addNamespace(wheelEvent.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if (eventUtils.isMouseEvent(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                $.each(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this,
                    result = [],
                    $element = $(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = $.data($element.get(0), EMITTER_DATA) || [];
                    $.each(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = inArray(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e),
                    verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction,
                    prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter,
                emitterName = emitterConfig.events[0],
                emitterEvents = emitterConfig.events;
            $.each(emitterEvents, function(_, eventName) {
                registerEvent(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = $.data(element, EMITTER_SUBSCRIPTION_DATA) || {},
                            emitters = $.data(element, EMITTER_DATA) || {},
                            emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        $.data(element, EMITTER_DATA, emitters);
                        $.data(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = $.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        emitter.configure(extend({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = $.data(element, EMITTER_SUBSCRIPTION_DATA),
                            emitters = $.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        $.each(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        module.exports = registerEmitter
    },
    /*!*********************************!*\
      !*** ./js/events/core/wheel.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            registerEvent = __webpack_require__( /*! ./event_registrator */ 73),
            eventUtils = __webpack_require__( /*! ../utils */ 71);
        var EVENT_NAME = "dxmousewheel",
            EVENT_NAMESPACE = "dxWheel";
        var wheelEvent = void 0 !== document.onwheel ? "wheel" : "mousewheel";
        var wheel = {
            setup: function(element) {
                var $element = $(element);
                $element.on(eventUtils.addNamespace(wheelEvent, EVENT_NAMESPACE), wheel._wheelHandler.bind(wheel))
            },
            teardown: function(element) {
                var $element = $(element);
                $element.off("." + EVENT_NAMESPACE)
            },
            _wheelHandler: function(e) {
                var delta = this._getWheelDelta(e.originalEvent);
                eventUtils.fireEvent({
                    type: EVENT_NAME,
                    originalEvent: e,
                    delta: delta,
                    pointerType: "mouse"
                });
                e.stopPropagation()
            },
            _getWheelDelta: function(event) {
                return event.wheelDelta ? event.wheelDelta : 30 * -event.deltaY
            }
        };
        registerEvent(EVENT_NAME, wheel);
        exports.name = EVENT_NAME
    },
    /*!**********************************************!*\
      !*** ./js/events/gesture/emitter.gesture.js ***!
      \**********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            devices = __webpack_require__( /*! ../../core/devices */ 53),
            support = __webpack_require__( /*! ../../core/utils/support */ 61),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 23),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56),
            mathUtils = __webpack_require__( /*! ../../core/utils/math */ 87),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            eventUtils = __webpack_require__( /*! ../utils */ 71),
            Emitter = __webpack_require__( /*! ../core/emitter */ 83),
            sign = mathUtils.sign,
            abs = Math.abs;
        var SLEEP = 0,
            INITED = 1,
            STARTED = 2,
            TOUCH_BOUNDARY = 10,
            IMMEDIATE_TOUCH_BOUNDARY = 0,
            IMMEDIATE_TIMEOUT = 180;
        var isMouseWheelEvent = function(e) {
            return e && "dxmousewheel" === e.type
        };
        var supportPointerEvents = function() {
            var cssSupport = support.styleProp("pointer-events");
            var msieLess11 = browser.msie && parseInt(browser.version, 10) < 11;
            return cssSupport && !msieLess11
        };
        var gestureCover = function() {
            var GESTURE_COVER_CLASS = "dx-gesture-cover";
            var isDesktop = "generic" === devices.real().platform;
            if (!supportPointerEvents() || !isDesktop) {
                return commonUtils.noop
            }
            var $cover = $("<div>").addClass(GESTURE_COVER_CLASS).css("pointerEvents", "none");
            $cover.on("dxmousewheel", function(e) {
                e.preventDefault()
            });
            domUtils.ready(function() {
                $cover.appendTo("body")
            });
            return function(toggle, cursor) {
                $cover.css("pointerEvents", toggle ? "all" : "none");
                toggle && $cover.css("cursor", cursor)
            }
        }();
        var GestureEmitter = Emitter.inherit({
            gesture: true,
            configure: function(data) {
                this.getElement().css("msTouchAction", data.immediate ? "pinch-zoom" : "");
                this.callBase(data)
            },
            allowInterruptionByMouseWheel: function() {
                return this._stage !== STARTED
            },
            getDirection: function() {
                return this.direction
            },
            _cancel: function() {
                this.callBase.apply(this, arguments);
                this._toggleGestureCover(false);
                this._stage = SLEEP
            },
            start: function(e) {
                if (eventUtils.needSkipEvent(e)) {
                    this._cancel(e);
                    return
                }
                this._startEvent = eventUtils.createEvent(e);
                this._startEventData = eventUtils.eventData(e);
                this._stage = INITED;
                this._init(e);
                this._setupImmediateTimer()
            },
            _setupImmediateTimer: function() {
                clearTimeout(this._immediateTimer);
                this._immediateAccepted = false;
                if (!this.immediate) {
                    return
                }
                this._immediateTimer = setTimeout(function() {
                    this._immediateAccepted = true
                }.bind(this), IMMEDIATE_TIMEOUT)
            },
            move: function(e) {
                if (this._stage === INITED && this._directionConfirmed(e)) {
                    this._stage = STARTED;
                    this._resetActiveElement();
                    this._toggleGestureCover(true);
                    this._clearSelection(e);
                    this._adjustStartEvent(e);
                    this._start(this._startEvent);
                    if (this._stage === SLEEP) {
                        return
                    }
                    this._requestAccept(e);
                    this._move(e);
                    this._forgetAccept()
                } else {
                    if (this._stage === STARTED) {
                        this._clearSelection(e);
                        this._move(e)
                    }
                }
            },
            _directionConfirmed: function(e) {
                var touchBoundary = this._getTouchBoundary(e),
                    delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e)),
                    deltaX = abs(delta.x),
                    deltaY = abs(delta.y);
                var horizontalMove = this._validateMove(touchBoundary, deltaX, deltaY),
                    verticalMove = this._validateMove(touchBoundary, deltaY, deltaX);
                var direction = this.getDirection(e),
                    bothAccepted = "both" === direction && (horizontalMove || verticalMove),
                    horizontalAccepted = "horizontal" === direction && horizontalMove,
                    verticalAccepted = "vertical" === direction && verticalMove;
                return bothAccepted || horizontalAccepted || verticalAccepted || this._immediateAccepted
            },
            _validateMove: function(touchBoundary, mainAxis, crossAxis) {
                return mainAxis && mainAxis >= touchBoundary && (this.immediate ? mainAxis >= crossAxis : true)
            },
            _getTouchBoundary: function(e) {
                return this.immediate || isMouseWheelEvent(e) ? IMMEDIATE_TOUCH_BOUNDARY : TOUCH_BOUNDARY
            },
            _adjustStartEvent: function(e) {
                var touchBoundary = this._getTouchBoundary(e),
                    delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e));
                this._startEvent.pageX += sign(delta.x) * touchBoundary;
                this._startEvent.pageY += sign(delta.y) * touchBoundary
            },
            _resetActiveElement: function() {
                if ("ios" === devices.real().platform && $(":focus", this.getElement()).length) {
                    domUtils.resetActiveElement()
                }
            },
            _toggleGestureCover: function(toggle) {
                var isStarted = this._stage === STARTED;
                if (isStarted) {
                    gestureCover(toggle, this.getElement().css("cursor"))
                }
            },
            _clearSelection: function(e) {
                if (isMouseWheelEvent(e) || eventUtils.isTouchEvent(e)) {
                    return
                }
                domUtils.clearSelection()
            },
            end: function(e) {
                this._toggleGestureCover(false);
                if (this._stage === STARTED) {
                    this._end(e)
                } else {
                    if (this._stage === INITED) {
                        this._stop(e)
                    }
                }
                this._stage = SLEEP
            },
            dispose: function() {
                clearTimeout(this._immediateTimer);
                this.callBase.apply(this, arguments);
                this._toggleGestureCover(false)
            },
            _init: commonUtils.noop,
            _start: commonUtils.noop,
            _move: commonUtils.noop,
            _stop: commonUtils.noop,
            _end: commonUtils.noop
        });
        GestureEmitter.initialTouchBoundary = TOUCH_BOUNDARY;
        GestureEmitter.touchBoundary = function(newBoundary) {
            if (commonUtils.isDefined(newBoundary)) {
                TOUCH_BOUNDARY = newBoundary;
                return
            }
            return TOUCH_BOUNDARY
        };
        module.exports = GestureEmitter
    },
    /*!*******************************!*\
      !*** ./js/core/utils/math.js ***!
      \*******************************/
    function(module, exports) {
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue,
                isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };
        exports.sign = sign;
        exports.fitIntoRange = fitIntoRange;
        exports.inRange = inRange
    },
    /*!****************************!*\
      !*** ./js/localization.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        exports.locale = __webpack_require__( /*! ./localization/core */ 34).locale;
        exports.loadMessages = __webpack_require__( /*! ./localization/message */ 89).load;
        exports.message = __webpack_require__( /*! ./localization/message */ 89);
        exports.number = __webpack_require__( /*! ./localization/number */ 32);
        exports.date = __webpack_require__( /*! ./localization/date */ 33);
        exports.currency = __webpack_require__( /*! ./localization/currency */ 36)
    },
    /*!************************************!*\
      !*** ./js/localization/message.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 29),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            stringFormat = __webpack_require__( /*! ../core/utils/string */ 18).format,
            humanize = __webpack_require__( /*! ../core/utils/inflector */ 39).humanize,
            coreLocalization = __webpack_require__( /*! ./core */ 34);
        __webpack_require__( /*! ./core */ 34);
        var baseDictionary = extend(true, {}, __webpack_require__( /*! ./default_messages */ 90));
        var newMessages = {};
        var messageLocalization = dependencyInjector({
            _dictionary: baseDictionary,
            load: function(messages) {
                extend(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this,
                    regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g"),
                    escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var result, defaultResult = that._localizablePrefix + localizationKey;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = humanize(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            _messageLoaded: function(key, locale) {
                return void 0 !== this._dictionary[locale || coreLocalization.locale()][key]
            },
            localizeNode: function(node) {
                var that = this;
                $(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!$(nodeItem).is("iframe")) {
                            $.each(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            $(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return extend({}, newMessages, this.getMessagesByLocales()[coreLocalization.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var localeMessages = this._dictionary[locale || coreLocalization.locale()],
                    message = localeMessages && localeMessages[key];
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return stringFormat.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                return formatter && formatter() || ""
            }
        });
        module.exports = messageLocalization
    },
    /*!*********************************************!*\
      !*** ./js/localization/default_messages.js ***!
      \*********************************************/
    function(module, exports) {
        module.exports = {
            en: {
                Yes: "Yes",
                No: "No",
                Cancel: "Cancel",
                Clear: "Clear",
                Done: "Done",
                Loading: "Loading...",
                Select: "Select...",
                Search: "Search",
                Back: "Back",
                OK: "OK",
                "dxCollectionWidget-noDataText": "No data to display",
                "validation-required": "Required",
                "validation-required-formatted": "{0} is required",
                "validation-numeric": "Value must be a number",
                "validation-numeric-formatted": "{0} must be a number",
                "validation-range": "Value is out of range",
                "validation-range-formatted": "{0} is out of range",
                "validation-stringLength": "The length of the value is not correct",
                "validation-stringLength-formatted": "The length of {0} is not correct",
                "validation-custom": "Value is invalid",
                "validation-custom-formatted": "{0} is invalid",
                "validation-compare": "Values do not match",
                "validation-compare-formatted": "{0} does not match",
                "validation-pattern": "Value does not match pattern",
                "validation-pattern-formatted": "{0} does not match pattern",
                "validation-email": "Email is invalid",
                "validation-email-formatted": "{0} is invalid",
                "validation-mask": "Value is invalid",
                "dxLookup-searchPlaceholder": "Minimum character number: {0}",
                "dxList-pullingDownText": "Pull down to refresh...",
                "dxList-pulledDownText": "Release to refresh...",
                "dxList-refreshingText": "Refreshing...",
                "dxList-pageLoadingText": "Loading...",
                "dxList-nextButtonText": "More",
                "dxList-selectAll": "Select All",
                "dxListEditDecorator-delete": "Delete",
                "dxListEditDecorator-more": "More",
                "dxScrollView-pullingDownText": "Pull down to refresh...",
                "dxScrollView-pulledDownText": "Release to refresh...",
                "dxScrollView-refreshingText": "Refreshing...",
                "dxScrollView-reachBottomText": "Loading...",
                "dxDateBox-simulatedDataPickerTitleTime": "Select time",
                "dxDateBox-simulatedDataPickerTitleDate": "Select date",
                "dxDateBox-simulatedDataPickerTitleDateTime": "Select date and time",
                "dxDateBox-validation-datetime": "Value must be a date or time",
                "dxFileUploader-selectFile": "Select file",
                "dxFileUploader-dropFile": "or Drop file here",
                "dxFileUploader-bytes": "bytes",
                "dxFileUploader-kb": "kb",
                "dxFileUploader-Mb": "Mb",
                "dxFileUploader-Gb": "Gb",
                "dxFileUploader-upload": "Upload",
                "dxFileUploader-uploaded": "Uploaded",
                "dxFileUploader-readyToUpload": "Ready to upload",
                "dxFileUploader-uploadFailedMessage": "Upload failed",
                "dxRangeSlider-ariaFrom": "From",
                "dxRangeSlider-ariaTill": "Till",
                "dxSwitch-onText": "ON",
                "dxSwitch-offText": "OFF",
                "dxForm-optionalMark": "optional",
                "dxForm-requiredMessage": "{0} is required",
                "dxNumberBox-invalidValueMessage": "Value must be a number",
                "dxDataGrid-columnChooserTitle": "Column Chooser",
                "dxDataGrid-columnChooserEmptyText": "Drag a column here to hide it",
                "dxDataGrid-groupContinuesMessage": "Continues on the next page",
                "dxDataGrid-groupContinuedMessage": "Continued from the previous page",
                "dxDataGrid-groupHeaderText": "Group by This Column",
                "dxDataGrid-ungroupHeaderText": "Ungroup",
                "dxDataGrid-ungroupAllText": "Ungroup All",
                "dxDataGrid-editingEditRow": "Edit",
                "dxDataGrid-editingSaveRowChanges": "Save",
                "dxDataGrid-editingCancelRowChanges": "Cancel",
                "dxDataGrid-editingDeleteRow": "Delete",
                "dxDataGrid-editingUndeleteRow": "Undelete",
                "dxDataGrid-editingConfirmDeleteMessage": "Are you sure you want to delete this record?",
                "dxDataGrid-validationCancelChanges": "Cancel changes",
                "dxDataGrid-groupPanelEmptyText": "Drag a column header here to group by that column",
                "dxDataGrid-noDataText": "No data",
                "dxDataGrid-searchPanelPlaceholder": "Search...",
                "dxDataGrid-filterRowShowAllText": "(All)",
                "dxDataGrid-filterRowResetOperationText": "Reset",
                "dxDataGrid-filterRowOperationEquals": "Equals",
                "dxDataGrid-filterRowOperationNotEquals": "Does not equal",
                "dxDataGrid-filterRowOperationLess": "Less than",
                "dxDataGrid-filterRowOperationLessOrEquals": "Less than or equal to",
                "dxDataGrid-filterRowOperationGreater": "Greater than",
                "dxDataGrid-filterRowOperationGreaterOrEquals": "Greater than or equal to",
                "dxDataGrid-filterRowOperationStartsWith": "Starts with",
                "dxDataGrid-filterRowOperationContains": "Contains",
                "dxDataGrid-filterRowOperationNotContains": "Does not contain",
                "dxDataGrid-filterRowOperationEndsWith": "Ends with",
                "dxDataGrid-filterRowOperationBetween": "Between",
                "dxDataGrid-filterRowOperationBetweenStartText": "Start",
                "dxDataGrid-filterRowOperationBetweenEndText": "End",
                "dxDataGrid-applyFilterText": "Apply filter",
                "dxDataGrid-trueText": "true",
                "dxDataGrid-falseText": "false",
                "dxDataGrid-sortingAscendingText": "Sort Ascending",
                "dxDataGrid-sortingDescendingText": "Sort Descending",
                "dxDataGrid-sortingClearText": "Clear Sorting",
                "dxDataGrid-editingSaveAllChanges": "Save changes",
                "dxDataGrid-editingCancelAllChanges": "Discard changes",
                "dxDataGrid-editingAddRow": "Add a row",
                "dxDataGrid-summaryMin": "Min: {0}",
                "dxDataGrid-summaryMinOtherColumn": "Min of {1} is {0}",
                "dxDataGrid-summaryMax": "Max: {0}",
                "dxDataGrid-summaryMaxOtherColumn": "Max of {1} is {0}",
                "dxDataGrid-summaryAvg": "Avg: {0}",
                "dxDataGrid-summaryAvgOtherColumn": "Avg of {1} is {0}",
                "dxDataGrid-summarySum": "Sum: {0}",
                "dxDataGrid-summarySumOtherColumn": "Sum of {1} is {0}",
                "dxDataGrid-summaryCount": "Count: {0}",
                "dxDataGrid-columnFixingFix": "Fix",
                "dxDataGrid-columnFixingUnfix": "Unfix",
                "dxDataGrid-columnFixingLeftPosition": "To the left",
                "dxDataGrid-columnFixingRightPosition": "To the right",
                "dxDataGrid-exportTo": "Export",
                "dxDataGrid-exportToExcel": "Export to Excel file",
                "dxDataGrid-excelFormat": "Excel file",
                "dxDataGrid-selectedRows": "Selected rows",
                "dxDataGrid-exportSelectedRows": "Export selected rows",
                "dxDataGrid-exportAll": "Export all data",
                "dxDataGrid-headerFilterEmptyValue": "(Blanks)",
                "dxDataGrid-headerFilterOK": "OK",
                "dxDataGrid-headerFilterCancel": "Cancel",
                "dxDataGrid-ariaColumn": "Column",
                "dxDataGrid-ariaValue": "Value",
                "dxDataGrid-ariaFilterCell": "Filter cell",
                "dxDataGrid-ariaCollapse": "Collapse",
                "dxDataGrid-ariaExpand": "Expand",
                "dxDataGrid-ariaDataGrid": "Data grid",
                "dxDataGrid-ariaSearchInGrid": "Search in data grid",
                "dxDataGrid-ariaSelectAll": "Select all",
                "dxDataGrid-ariaSelectRow": "Select row",
                "dxTreeList-ariaTreeList": "Tree list",
                "dxTreeList-editingAddRowToNode": "Add",
                "dxPager-infoText": "Page {0} of {1} ({2} items)",
                "dxPager-pagesCountText": "of",
                "dxPivotGrid-grandTotal": "Grand Total",
                "dxPivotGrid-total": "{0} Total",
                "dxPivotGrid-fieldChooserTitle": "Field Chooser",
                "dxPivotGrid-showFieldChooser": "Show Field Chooser",
                "dxPivotGrid-expandAll": "Expand All",
                "dxPivotGrid-collapseAll": "Collapse All",
                "dxPivotGrid-sortColumnBySummary": 'Sort "{0}" by This Column',
                "dxPivotGrid-sortRowBySummary": 'Sort "{0}" by This Row',
                "dxPivotGrid-removeAllSorting": "Remove All Sorting",
                "dxPivotGrid-dataNotAvailable": "N/A",
                "dxPivotGrid-rowFields": "Row Fields",
                "dxPivotGrid-columnFields": "Column Fields",
                "dxPivotGrid-dataFields": "Data Fields",
                "dxPivotGrid-filterFields": "Filter Fields",
                "dxPivotGrid-allFields": "All Fields",
                "dxPivotGrid-columnFieldArea": "Drop Column Fields Here",
                "dxPivotGrid-dataFieldArea": "Drop Data Fields Here",
                "dxPivotGrid-rowFieldArea": "Drop Row Fields Here",
                "dxPivotGrid-filterFieldArea": "Drop Filter Fields Here",
                "dxScheduler-editorLabelTitle": "Subject",
                "dxScheduler-editorLabelStartDate": "Start Date",
                "dxScheduler-editorLabelEndDate": "End Date",
                "dxScheduler-editorLabelDescription": "Description",
                "dxScheduler-editorLabelRecurrence": "Repeat",
                "dxScheduler-openAppointment": "Open appointment",
                "dxScheduler-recurrenceNever": "Never",
                "dxScheduler-recurrenceDaily": "Daily",
                "dxScheduler-recurrenceWeekly": "Weekly",
                "dxScheduler-recurrenceMonthly": "Monthly",
                "dxScheduler-recurrenceYearly": "Yearly",
                "dxScheduler-recurrenceEvery": "Every",
                "dxScheduler-recurrenceEnd": "End repeat",
                "dxScheduler-recurrenceAfter": "After",
                "dxScheduler-recurrenceOn": "On",
                "dxScheduler-recurrenceRepeatDaily": "day(s)",
                "dxScheduler-recurrenceRepeatWeekly": "week(s)",
                "dxScheduler-recurrenceRepeatMonthly": "month(s)",
                "dxScheduler-recurrenceRepeatYearly": "year(s)",
                "dxScheduler-switcherDay": "Day",
                "dxScheduler-switcherWeek": "Week",
                "dxScheduler-switcherWorkWeek": "Work Week",
                "dxScheduler-switcherMonth": "Month",
                "dxScheduler-switcherAgenda": "Agenda",
                "dxScheduler-switcherTimelineDay": "Timeline Day",
                "dxScheduler-switcherTimelineWeek": "Timeline Week",
                "dxScheduler-switcherTimelineWorkWeek": "Timeline Work Week",
                "dxScheduler-switcherTimelineMonth": "Timeline Month",
                "dxScheduler-recurrenceRepeatOnDate": "on date",
                "dxScheduler-recurrenceRepeatCount": "occurrence(s)",
                "dxScheduler-allDay": "All day",
                "dxScheduler-confirmRecurrenceEditMessage": "Do you want to edit only this appointment or the whole series?",
                "dxScheduler-confirmRecurrenceDeleteMessage": "Do you want to delete only this appointment or the whole series?",
                "dxScheduler-confirmRecurrenceEditSeries": "Edit series",
                "dxScheduler-confirmRecurrenceDeleteSeries": "Delete series",
                "dxScheduler-confirmRecurrenceEditOccurrence": "Edit appointment",
                "dxScheduler-confirmRecurrenceDeleteOccurrence": "Delete appointment",
                "dxScheduler-noTimezoneTitle": "No timezone",
                "dxCalendar-todayButtonText": "Today",
                "dxCalendar-ariaWidgetName": "Calendar",
                "dxColorView-ariaRed": "Red",
                "dxColorView-ariaGreen": "Green",
                "dxColorView-ariaBlue": "Blue",
                "dxColorView-ariaAlpha": "Transparency",
                "dxColorView-ariaHex": "Color code",
                "vizExport-printingButtonText": "Print",
                "vizExport-titleMenuText": "Exporting/Printing",
                "vizExport-exportButtonText": "{0} file"
            }
        }
    },
    /*!*****************************************!*\
      !*** ./js/bundles/modules/framework.js ***!
      \*****************************************/
    function(module, exports, __webpack_require__) {
        __webpack_require__( /*! ./core */ 6);
        __webpack_require__( /*! ../../integration/knockout */ 92);
        module.exports = DevExpress.framework = {};
        DevExpress.framework.dxCommand = __webpack_require__( /*! ../../framework/command */ 121);
        DevExpress.framework.Router = __webpack_require__( /*! ../../framework/router */ 123);
        DevExpress.framework.StateManager = __webpack_require__( /*! ../../framework/state_manager */ 124);
        DevExpress.framework.ViewCache = __webpack_require__( /*! ../../framework/view_cache */ 125);
        DevExpress.framework.NullViewCache = __webpack_require__( /*! ../../framework/view_cache */ 125).NullViewCache;
        DevExpress.framework.ConditionalViewCacheDecorator = __webpack_require__( /*! ../../framework/view_cache */ 125).ConditionalViewCacheDecorator;
        DevExpress.framework.CapacityViewCacheDecorator = __webpack_require__( /*! ../../framework/view_cache */ 125).CapacityViewCacheDecorator;
        DevExpress.framework.HistoryDependentViewCacheDecorator = __webpack_require__( /*! ../../framework/view_cache */ 125).HistoryDependentViewCacheDecorator;
        DevExpress.framework.dxCommandContainer = __webpack_require__( /*! ../../framework/html/command_container */ 126);
        DevExpress.framework.dxView = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128).dxView;
        DevExpress.framework.dxLayout = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128).dxLayout;
        DevExpress.framework.dxViewPlaceholder = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128).dxViewPlaceholder;
        DevExpress.framework.dxContentPlaceholder = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128).dxContentPlaceholder;
        DevExpress.framework.dxTransition = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128).dxTransition;
        DevExpress.framework.dxContent = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128).dxContent;
        DevExpress.framework.html = {};
        DevExpress.framework.html.HtmlApplication = __webpack_require__( /*! ../../framework/html/html_application */ 129);
        DevExpress.framework.Route = __webpack_require__( /*! ../../framework/router */ 123).Route;
        DevExpress.framework.MemoryKeyValueStorage = __webpack_require__( /*! ../../framework/state_manager */ 124).MemoryKeyValueStorage;
        DevExpress.framework.NavigationDevices = __webpack_require__( /*! ../../framework/navigation_devices */ 134);
        DevExpress.framework.NavigationManager = __webpack_require__( /*! ../../framework/navigation_manager */ 133);
        DevExpress.framework.createActionExecutors = __webpack_require__( /*! ../../framework/action_executors */ 132).createActionExecutors;
        DevExpress.framework.Application = __webpack_require__( /*! ../../framework/application */ 130).Application;
        var browserAdapters = __webpack_require__( /*! ../../framework/browser_adapters */ 135);
        DevExpress.framework.DefaultBrowserAdapter = browserAdapters.DefaultBrowserAdapter;
        DevExpress.framework.OldBrowserAdapter = browserAdapters.OldBrowserAdapter;
        DevExpress.framework.BuggyAndroidBrowserAdapter = browserAdapters.BuggyAndroidBrowserAdapter;
        DevExpress.framework.HistorylessBrowserAdapter = browserAdapters.HistorylessBrowserAdapter;
        DevExpress.framework.BuggyCordovaWP81BrowserAdapter = browserAdapters.BuggyCordovaWP81BrowserAdapter;
        DevExpress.framework.CommandMapping = __webpack_require__( /*! ../../framework/command_mapping */ 136);
        DevExpress.framework.HistoryBasedNavigationDevice = __webpack_require__( /*! ../../framework/navigation_devices */ 134).HistoryBasedNavigationDevice;
        DevExpress.framework.StackBasedNavigationDevice = __webpack_require__( /*! ../../framework/navigation_devices */ 134).StackBasedNavigationDevice;
        DevExpress.framework.HistoryBasedNavigationManager = __webpack_require__( /*! ../../framework/navigation_manager */ 133).HistoryBasedNavigationManager;
        DevExpress.framework.StackBasedNavigationManager = __webpack_require__( /*! ../../framework/navigation_manager */ 133).StackBasedNavigationManager;
        DevExpress.framework.NavigationStack = __webpack_require__( /*! ../../framework/navigation_manager */ 133).NavigationStack;
        DevExpress.framework.utils = __webpack_require__( /*! ../../framework/utils */ 131).utils;
        DevExpress.framework.templateProvider = __webpack_require__( /*! ../../framework/utils */ 131).templateProvider;
        DevExpress.framework.html.CommandManager = __webpack_require__( /*! ../../framework/html/command_manager */ 139);
        DevExpress.framework.html.HtmlApplication = __webpack_require__( /*! ../../framework/html/html_application */ 129);
        DevExpress.framework.html.layoutSets = __webpack_require__( /*! ../../framework/html/presets */ 138).layoutSets;
        DevExpress.framework.html.animationSets = __webpack_require__( /*! ../../framework/html/presets */ 138).animationSets;
        DevExpress.framework.html.DefaultLayoutController = __webpack_require__( /*! ../../framework/html/layout_controller */ 142).DefaultLayoutController;
        DevExpress.framework.html.layoutSets = __webpack_require__( /*! ../../framework/html/layout_controller */ 142).layoutSets;
        DevExpress.framework.html.MarkupComponent = __webpack_require__( /*! ../../framework/html/markup_component */ 127).MarkupComponent;
        DevExpress.framework.html.ViewEngine = __webpack_require__( /*! ../../framework/html/view_engine */ 141).ViewEngine;
        DevExpress.framework.html.ViewEngineComponents = __webpack_require__( /*! ../../framework/html/view_engine_components */ 128);
        var widgetCommandAdaptersModule = __webpack_require__( /*! ../../framework/html/widget_command_adapters */ 140);
        DevExpress.framework.html.commandToDXWidgetAdapters = {
            dxToolbar: widgetCommandAdaptersModule.dxToolbar,
            dxList: widgetCommandAdaptersModule.dxList,
            dxNavBar: widgetCommandAdaptersModule.dxNavBar,
            dxPivot: widgetCommandAdaptersModule.dxPivot,
            dxSlideOut: widgetCommandAdaptersModule.dxSlideOut
        }
    },
    /*!************************************!*\
      !*** ./js/integration/knockout.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var ko = __webpack_require__( /*! knockout */ 93);
        if (ko) {
            var errors = __webpack_require__( /*! ../core/errors */ 7),
                compareVersion = __webpack_require__( /*! ../core/utils/version */ 17).compare;
            if (compareVersion(ko.version, [2, 3]) < 0) {
                throw errors.Error("E0013")
            }
            __webpack_require__( /*! ./knockout/component_registrator */ 94);
            __webpack_require__( /*! ./knockout/event_registrator */ 113);
            __webpack_require__( /*! ./knockout/components */ 114);
            __webpack_require__( /*! ./knockout/validation */ 116);
            __webpack_require__( /*! ./knockout/variable_wrapper_utils */ 118);
            __webpack_require__( /*! ./knockout/clean_node */ 119);
            __webpack_require__( /*! ./knockout/clean_node_old */ 120)
        }
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    function(module, exports) {
        module.exports = window.ko
    },
    /*!**********************************************************!*\
      !*** ./js/integration/knockout/component_registrator.js ***!
      \**********************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            ko = __webpack_require__( /*! knockout */ 93),
            errors = __webpack_require__( /*! ../../core/errors */ 7),
            inflector = __webpack_require__( /*! ../../core/utils/inflector */ 39),
            isPlainObject = __webpack_require__( /*! ../../core/utils/type */ 12).isPlainObject,
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 57),
            Widget = __webpack_require__( /*! ../../ui/widget/ui.widget */ 95),
            KoTemplate = __webpack_require__( /*! ./template */ 105),
            Editor = __webpack_require__( /*! ../../ui/editor/editor */ 106),
            Locker = __webpack_require__( /*! ../../core/utils/locker */ 112),
            config = __webpack_require__( /*! ../../core/config */ 15);
        var LOCKS_DATA_KEY = "dxKoLocks",
            CREATED_WITH_KO_DATA_KEY = "dxKoCreation";
        var editorsBindingHandlers = [];
        var registerComponentKoBinding = function(componentName, componentClass) {
            if (componentClass.subclassOf(Editor)) {
                editorsBindingHandlers.push(componentName)
            }
            ko.bindingHandlers[componentName] = {
                init: function(domNode, valueAccessor) {
                    var component, isBindingPropertyPredicate, $element = $(domNode),
                        optionChangedCallbacks = $.Callbacks(),
                        optionsByReference = {},
                        knockoutConfig = config().knockout,
                        isBindingPropertyPredicateName = knockoutConfig && knockoutConfig.isBindingPropertyPredicateName,
                        ctorOptions = {
                            onInitializing: function() {
                                optionsByReference = this._getOptionsByReference();
                                ko.computed(function() {
                                    var model = ko.unwrap(valueAccessor());
                                    if (component) {
                                        component.beginUpdate()
                                    }
                                    isBindingPropertyPredicate = isBindingPropertyPredicateName && model && model[isBindingPropertyPredicateName];
                                    unwrapModel(model);
                                    if (component) {
                                        component.endUpdate()
                                    }
                                }, null, {
                                    disposeWhenNodeIsRemoved: domNode
                                });
                                component = this
                            },
                            modelByElement: function($element) {
                                if ($element.length) {
                                    return ko.dataFor($element.get(0))
                                }
                            },
                            nestedComponentOptions: function(component) {
                                return {
                                    modelByElement: component.option("modelByElement"),
                                    nestedComponentOptions: component.option("nestedComponentOptions")
                                }
                            },
                            _optionChangedCallbacks: optionChangedCallbacks,
                            integrationOptions: {
                                watchMethod: function(fn, callback, options) {
                                    options = options || {};
                                    var skipCallback = options.skipImmediate;
                                    var watcher = ko.computed(function() {
                                        var newValue = ko.unwrap(fn());
                                        if (!skipCallback) {
                                            callback(newValue)
                                        }
                                        skipCallback = false
                                    });
                                    return function() {
                                        watcher.dispose()
                                    }
                                },
                                templates: {
                                    "dx-polymorph-widget": {
                                        render: function(options) {
                                            var widgetName = ko.utils.unwrapObservable(options.model.widget);
                                            if (!widgetName) {
                                                return
                                            }
                                            if ("button" === widgetName || "tabs" === widgetName || "dropDownMenu" === widgetName) {
                                                var deprecatedName = widgetName;
                                                widgetName = inflector.camelize("dx-" + widgetName);
                                                errors.log("W0001", "dxToolbar - 'widget' item field", deprecatedName, "16.1", "Use: '" + widgetName + "' instead")
                                            }
                                            var markup = $('<div data-bind="' + widgetName + ': options">').get(0);
                                            options.container.append(markup);
                                            ko.applyBindings(options.model, markup)
                                        }
                                    }
                                },
                                createTemplate: function(element) {
                                    return new KoTemplate(element)
                                }
                            }
                        },
                        optionNameToModelMap = {};
                    var applyModelValueToOption = function(optionName, modelValue, unwrap) {
                        var locks = $element.data(LOCKS_DATA_KEY),
                            optionValue = unwrap ? ko.unwrap(modelValue) : modelValue;
                        if (ko.isWriteableObservable(modelValue)) {
                            optionNameToModelMap[optionName] = modelValue
                        }
                        if (component) {
                            if (locks.locked(optionName)) {
                                return
                            }
                            locks.obtain(optionName);
                            try {
                                if (ko.ignoreDependencies) {
                                    ko.ignoreDependencies(component.option, component, [optionName, optionValue])
                                } else {
                                    component.option(optionName, optionValue)
                                }
                            } finally {
                                locks.release(optionName)
                            }
                        } else {
                            ctorOptions[optionName] = optionValue
                        }
                    };
                    var handleOptionChanged = function(args) {
                        var optionName = args.fullName,
                            optionValue = args.value;
                        if (!(optionName in optionNameToModelMap)) {
                            return
                        }
                        var $element = this._$element,
                            locks = $element.data(LOCKS_DATA_KEY);
                        if (locks.locked(optionName)) {
                            return
                        }
                        locks.obtain(optionName);
                        try {
                            optionNameToModelMap[optionName](optionValue)
                        } finally {
                            locks.release(optionName)
                        }
                    };
                    var createComponent = function() {
                        optionChangedCallbacks.add(handleOptionChanged);
                        $element.data(CREATED_WITH_KO_DATA_KEY, true).data(LOCKS_DATA_KEY, new Locker)[componentName](ctorOptions);
                        ctorOptions = null
                    };
                    var unwrapModelValue = function(currentModel, propertyName, propertyPath) {
                        if (propertyPath === isBindingPropertyPredicateName) {
                            return
                        }
                        if (!isBindingPropertyPredicate || isBindingPropertyPredicate(propertyPath, propertyName, currentModel)) {
                            var unwrappedPropertyValue;
                            ko.computed(function() {
                                var propertyValue = currentModel[propertyName];
                                applyModelValueToOption(propertyPath, propertyValue, true);
                                unwrappedPropertyValue = ko.unwrap(propertyValue)
                            }, null, {
                                disposeWhenNodeIsRemoved: domNode
                            });
                            if (isPlainObject(unwrappedPropertyValue)) {
                                if (!optionsByReference[propertyPath]) {
                                    unwrapModel(unwrappedPropertyValue, propertyPath)
                                }
                            }
                        } else {
                            applyModelValueToOption(propertyPath, currentModel[propertyName], false)
                        }
                    };
                    var unwrapModel = function(model, propertyPath) {
                        for (var propertyName in model) {
                            if (model.hasOwnProperty(propertyName)) {
                                unwrapModelValue(model, propertyName, propertyPath ? [propertyPath, propertyName].join(".") : propertyName)
                            }
                        }
                    };
                    createComponent();
                    return {
                        controlsDescendantBindings: componentClass.subclassOf(Widget)
                    }
                }
            };
            if ("dxValidator" === componentName) {
                ko.bindingHandlers.dxValidator.after = editorsBindingHandlers
            }
        };
        registerComponent.callbacks.add(function(name, componentClass) {
            registerComponentKoBinding(name, componentClass)
        })
    },
    /*!***********************************!*\
      !*** ./js/ui/widget/ui.widget.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            errors = __webpack_require__( /*! ./ui.errors */ 22),
            Action = __webpack_require__( /*! ../../core/action */ 49),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 12),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56),
            devices = __webpack_require__( /*! ../../core/devices */ 53),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 43),
            Template = __webpack_require__( /*! ./jquery.template */ 96),
            FunctionTemplate = __webpack_require__( /*! ./function_template */ 98),
            EmptyTemplate = __webpack_require__( /*! ./empty_template */ 99),
            ChildDefaultTemplate = __webpack_require__( /*! ./child_default_template */ 100),
            KeyboardProcessor = __webpack_require__( /*! ./ui.keyboard_processor */ 101),
            selectors = __webpack_require__( /*! ./jquery.selectors */ 102),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 71),
            hoverEvents = __webpack_require__( /*! ../../events/hover */ 103),
            feedbackEvents = __webpack_require__( /*! ../../events/core/emitter.feedback */ 104),
            clickEvent = __webpack_require__( /*! ../../events/click */ 75),
            inflector = __webpack_require__( /*! ../../core/utils/inflector */ 39);
        var UI_FEEDBACK = "UIFeedback",
            WIDGET_CLASS = "dx-widget",
            ACTIVE_STATE_CLASS = "dx-state-active",
            DISABLED_STATE_CLASS = "dx-state-disabled",
            INVISIBLE_STATE_CLASS = "dx-state-invisible",
            HOVER_STATE_CLASS = "dx-state-hover",
            FOCUSED_STATE_CLASS = "dx-state-focused",
            FEEDBACK_SHOW_TIMEOUT = 30,
            FEEDBACK_HIDE_TIMEOUT = 400,
            FOCUS_NAMESPACE = "Focus",
            ANONYMOUS_TEMPLATE_NAME = "template",
            TEXT_NODE = 3,
            TEMPLATE_SELECTOR = "[data-options*='dxTemplate']",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper";
        var DX_POLYMORPH_WIDGET_TEMPLATE = new FunctionTemplate(function(options) {
            var widgetName = options.model.widget;
            if (widgetName) {
                var widgetElement = $("<div>"),
                    widgetOptions = options.model.options || {};
                if ("button" === widgetName || "tabs" === widgetName || "dropDownMenu" === widgetName) {
                    var deprecatedName = widgetName;
                    widgetName = inflector.camelize("dx-" + widgetName);
                    errors.log("W0001", "dxToolbar - 'widget' item field", deprecatedName, "16.1", "Use: '" + widgetName + "' instead")
                }
                widgetElement[widgetName](widgetOptions);
                return widgetElement
            }
            return $()
        });
        var beforeActivateExists = void 0 !== document.onbeforeactivate;
        var Widget = DOMComponent.inherit({
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    integrationOptions: {
                        watchMethod: function(fn, callback, options) {
                            options = options || {};
                            if (!options.skipImmediate) {
                                callback(fn())
                            }
                            return commonUtils.noop
                        },
                        templates: {
                            "dx-polymorph-widget": DX_POLYMORPH_WIDGET_TEMPLATE
                        },
                        createTemplate: function(element) {
                            return new Template(element)
                        }
                    },
                    _keyboardProcessor: void 0
                })
            },
            _feedbackShowTimeout: FEEDBACK_SHOW_TIMEOUT,
            _feedbackHideTimeout: FEEDBACK_HIDE_TIMEOUT,
            _init: function() {
                this.callBase();
                this._tempTemplates = [];
                this._defaultTemplates = {};
                this._initTemplates();
                this._initContentReadyAction()
            },
            _initTemplates: function() {
                this._extractTemplates();
                this._extractAnonymousTemplate()
            },
            _extractTemplates: function() {
                var templates = this.option("integrationOptions.templates"),
                    templateElements = this.element().contents().filter(TEMPLATE_SELECTOR);
                var templatesMap = {};
                templateElements.each(function(_, template) {
                    var templateOptions = domUtils.getElementOptions(template).dxTemplate;
                    if (!templateOptions) {
                        return
                    }
                    if (!templateOptions.name) {
                        throw errors.Error("E0023")
                    }
                    $(template).addClass(TEMPLATE_WRAPPER_CLASS).detach();
                    templatesMap[templateOptions.name] = templatesMap[templateOptions.name] || [];
                    templatesMap[templateOptions.name].push(template)
                });
                $.each(templatesMap, function(templateName, value) {
                    var deviceTemplate = this._findTemplateByDevice(value);
                    if (deviceTemplate) {
                        templates[templateName] = this._createTemplate(deviceTemplate)
                    }
                }.bind(this))
            },
            _findTemplateByDevice: function(templates) {
                var suitableTemplate = commonUtils.findBestMatches(devices.current(), templates, function(template) {
                    return domUtils.getElementOptions(template).dxTemplate
                })[0];
                $.each(templates, function(index, template) {
                    if (template !== suitableTemplate) {
                        $(template).remove()
                    }
                });
                return suitableTemplate
            },
            _extractAnonymousTemplate: function() {
                var templates = this.option("integrationOptions.templates"),
                    anonymousTemplateName = this._getAnonymousTemplateName(),
                    $anonymousTemplate = this.element().contents().detach();
                var $notJunkTemplateContent = $anonymousTemplate.filter(function(_, element) {
                        var isTextNode = element.nodeType === TEXT_NODE,
                            isEmptyText = $.trim($(element).text()).length < 1;
                        return !(isTextNode && isEmptyText)
                    }),
                    onlyJunkTemplateContent = $notJunkTemplateContent.length < 1;
                if (!templates[anonymousTemplateName] && !onlyJunkTemplateContent) {
                    templates[anonymousTemplateName] = this._createTemplate($anonymousTemplate)
                }
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _getTemplateByOption: function(optionName) {
                return this._getTemplate(this.option(optionName))
            },
            _getTemplate: function(templateSource) {
                if (commonUtils.isFunction(templateSource)) {
                    return new FunctionTemplate(function(options) {
                        var templateSourceResult = templateSource.apply(this, this._getNormalizedTemplateArgs(options));
                        if (!commonUtils.isDefined(templateSourceResult)) {
                            return new EmptyTemplate
                        }
                        var dispose = false;
                        var template = this._acquireTemplate(templateSourceResult, function(templateSource) {
                            if (templateSource.nodeType || templateSource.jquery && !$(templateSource).is("script")) {
                                return new FunctionTemplate(function() {
                                    return templateSource
                                })
                            }
                            dispose = true;
                            return this._createTemplate(templateSource)
                        }.bind(this));
                        var result = template.render(options);
                        dispose && template.dispose && template.dispose();
                        return result
                    }.bind(this))
                }
                return this._acquireTemplate(templateSource, this._createTemplateIfNeeded.bind(this))
            },
            _acquireTemplate: function(templateSource, createTemplate) {
                if (null == templateSource) {
                    return new EmptyTemplate
                }
                if (templateSource instanceof ChildDefaultTemplate) {
                    return this._defaultTemplates[templateSource.name]
                }
                if (commonUtils.isFunction(templateSource.render) && !templateSource.jquery) {
                    return templateSource
                }
                if (templateSource.nodeType || templateSource.jquery) {
                    templateSource = $(templateSource);
                    return createTemplate(templateSource)
                }
                if ("string" === typeof templateSource) {
                    var userTemplate = this.option("integrationOptions.templates")[templateSource];
                    if (userTemplate) {
                        return userTemplate
                    }
                    var dynamicTemplate = this._defaultTemplates[templateSource];
                    if (dynamicTemplate) {
                        return dynamicTemplate
                    }
                    return createTemplate(templateSource)
                }
                return this._acquireTemplate(templateSource.toString(), createTemplate)
            },
            _createTemplateIfNeeded: function(templateSource) {
                var templateKey = function(templateSource) {
                    return templateSource.jquery && templateSource[0] || templateSource
                };
                var cachedTemplate = this._tempTemplates.filter(function(t) {
                    templateSource = templateKey(templateSource);
                    return t.source === templateSource
                })[0];
                if (cachedTemplate) {
                    return cachedTemplate.template
                }
                var template = this._createTemplate(templateSource);
                this._tempTemplates.push({
                    template: template,
                    source: templateKey(templateSource)
                });
                return template
            },
            _createTemplate: function(templateSource) {
                templateSource = "string" === typeof templateSource ? domUtils.normalizeTemplateElement(templateSource) : templateSource;
                return this.option("integrationOptions.createTemplate")(templateSource)
            },
            _getNormalizedTemplateArgs: function(options) {
                var args = [];
                if ("model" in options) {
                    args.push(options.model)
                }
                if ("index" in options) {
                    args.push(options.index)
                }
                args.push(options.container);
                return args
            },
            _cleanTemplates: function() {
                this._tempTemplates.forEach(function(t) {
                    t.template.dispose && t.template.dispose()
                });
                this._tempTemplates = []
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["designMode", "disabled", "readOnly"]
                })
            },
            _render: function() {
                this.element().addClass(WIDGET_CLASS);
                this.callBase();
                this._toggleDisabledState(this.option("disabled"));
                this._toggleVisibility(this.option("visible"));
                this._renderHint();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents()
            },
            _renderHint: function() {
                domUtils.toggleAttr(this.element(), "title", this.option("hint"))
            },
            _renderContent: function() {
                var that = this;
                commonUtils.deferRender(function() {
                    that._renderContentImpl()
                });
                that._fireContentReadyAction()
            },
            _renderContentImpl: commonUtils.noop,
            _fireContentReadyAction: function() {
                this._contentReadyAction()
            },
            _dispose: function() {
                this._cleanTemplates();
                this._contentReadyAction = null;
                this.callBase()
            },
            _clean: function() {
                this._cleanFocusState();
                this.callBase();
                this.element().empty()
            },
            _toggleVisibility: function(visible) {
                this.element().toggleClass(INVISIBLE_STATE_CLASS, !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (!this.option("focusStateEnabled") || this.option("disabled")) {
                    return
                }
                this._renderFocusTarget();
                this._attachFocusEvents();
                this._renderAccessKey()
            },
            _renderAccessKey: function() {
                var focusTarget = this._focusTarget();
                focusTarget.attr("accesskey", this.option("accessKey"));
                var clickNamespace = eventUtils.addNamespace(clickEvent.name, UI_FEEDBACK);
                focusTarget.off(clickNamespace);
                this.option("accessKey") && focusTarget.on(clickNamespace, function(e) {
                    if (eventUtils.isFakeClickEvent(e)) {
                        e.stopImmediatePropagation();
                        this.focus()
                    }
                }.bind(this))
            },
            _eventBindingTarget: function() {
                return this.element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    activeElement = activeElement.find(this._activeStateUnit).not("." + DISABLED_STATE_CLASS)
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                this._focusTarget().attr("tabindex", this.option("tabIndex"))
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _detachFocusEvents: function() {
                var $element = this._focusTarget(),
                    namespace = this.NAME + FOCUS_NAMESPACE,
                    focusEvents = eventUtils.addNamespace("focusin", namespace);
                focusEvents = focusEvents + " " + eventUtils.addNamespace("focusout", namespace);
                if (beforeActivateExists) {
                    focusEvents = focusEvents + " " + eventUtils.addNamespace("beforeactivate", namespace)
                }
                $element.off(focusEvents)
            },
            _attachFocusEvents: function() {
                var namespace = this.NAME + FOCUS_NAMESPACE,
                    focusInEvent = eventUtils.addNamespace("focusin", namespace),
                    focusOutEvent = eventUtils.addNamespace("focusout", namespace);
                this._focusTarget().on(focusInEvent, this._focusInHandler.bind(this)).on(focusOutEvent, this._focusOutHandler.bind(this));
                if (beforeActivateExists) {
                    var beforeActivateEvent = eventUtils.addNamespace("beforeactivate", namespace);
                    this._focusTarget().on(beforeActivateEvent, function(e) {
                        if (!$(e.target).is(selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusInHandler: function(e) {
                var that = this;
                that._createActionByOption("onFocusIn", {
                    beforeExecute: function() {
                        that._updateFocusState(e, true)
                    },
                    excludeValidators: ["readOnly"]
                })({
                    jQueryEvent: e
                })
            },
            _focusOutHandler: function(e) {
                var that = this;
                that._createActionByOption("onFocusOut", {
                    beforeExecute: function() {
                        that._updateFocusState(e, false)
                    },
                    excludeValidators: ["readOnly", "disabled"]
                })({
                    jQueryEvent: e
                })
            },
            _updateFocusState: function(e, isFocused) {
                var target = e.target;
                if (inArray(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, $(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass(FOCUSED_STATE_CLASS, isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = $(element || this._focusTarget());
                return $focusTarget.hasClass(FOCUSED_STATE_CLASS)
            },
            _attachKeyboardEvents: function() {
                var processor = this.option("_keyboardProcessor");
                if (processor) {
                    this._keyboardProcessor = processor.reinitialize(this._keyboardHandler, this)
                } else {
                    if (this.option("focusStateEnabled")) {
                        this._keyboardProcessor = new KeyboardProcessor({
                            element: this._keyboardEventBindingTarget(),
                            handler: this._keyboardHandler,
                            focusTarget: this._focusTarget(),
                            context: this
                        })
                    }
                }
            },
            _keyboardHandler: function(options) {
                var e = options.originalEvent,
                    key = options.key;
                var keys = this._supportedKeys(),
                    func = keys[key];
                if (void 0 !== func) {
                    var handler = func.bind(this);
                    return handler(e) || false
                } else {
                    return true
                }
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                this._detachFocusEvents();
                this._toggleFocusClass(false);
                $element.removeAttr("tabindex");
                if (this._keyboardProcessor) {
                    this._keyboardProcessor.dispose();
                    delete this._keyboardProcessor
                }
            },
            _attachHoverEvents: function() {
                var that = this,
                    hoverableSelector = that._activeStateUnit,
                    nameStart = eventUtils.addNamespace(hoverEvents.start, UI_FEEDBACK),
                    nameEnd = eventUtils.addNamespace(hoverEvents.end, UI_FEEDBACK);
                that._eventBindingTarget().off(nameStart, hoverableSelector).off(nameEnd, hoverableSelector);
                if (that.option("hoverStateEnabled")) {
                    var startAction = new Action(function(args) {
                        that._hoverStartHandler(args.event);
                        var $target = args.element;
                        that._refreshHoveredElement($target)
                    }, {
                        excludeValidators: ["readOnly"]
                    });
                    that._eventBindingTarget().on(nameStart, hoverableSelector, function(e) {
                        startAction.execute({
                            element: $(e.target),
                            event: e
                        })
                    }).on(nameEnd, hoverableSelector, function(e) {
                        that._hoverEndHandler(e);
                        that._forgetHoveredElement()
                    })
                } else {
                    that._toggleHoverClass(false)
                }
            },
            _hoverStartHandler: commonUtils.noop,
            _hoverEndHandler: commonUtils.noop,
            _attachFeedbackEvents: function() {
                var feedbackAction, feedbackActionDisabled, that = this,
                    feedbackSelector = that._activeStateUnit,
                    activeEventName = eventUtils.addNamespace(feedbackEvents.active, UI_FEEDBACK),
                    inactiveEventName = eventUtils.addNamespace(feedbackEvents.inactive, UI_FEEDBACK);
                that._eventBindingTarget().off(activeEventName, feedbackSelector).off(inactiveEventName, feedbackSelector);
                if (that.option("activeStateEnabled")) {
                    var feedbackActionHandler = function(args) {
                        var $element = args.element,
                            value = args.value,
                            jQueryEvent = args.jQueryEvent;
                        that._toggleActiveState($element, value, jQueryEvent)
                    };
                    that._eventBindingTarget().on(activeEventName, feedbackSelector, {
                        timeout: that._feedbackShowTimeout
                    }, function(e) {
                        feedbackAction = feedbackAction || new Action(feedbackActionHandler);
                        feedbackAction.execute({
                            element: $(e.currentTarget),
                            value: true,
                            jQueryEvent: e
                        })
                    }).on(inactiveEventName, feedbackSelector, {
                        timeout: that._feedbackHideTimeout
                    }, function(e) {
                        feedbackActionDisabled = feedbackActionDisabled || new Action(feedbackActionHandler, {
                            excludeValidators: ["disabled", "readOnly"]
                        });
                        feedbackActionDisabled.execute({
                            element: $(e.currentTarget),
                            value: false,
                            jQueryEvent: e
                        })
                    })
                }
            },
            _toggleActiveState: function($element, value) {
                this._toggleHoverClass(!value);
                $element.toggleClass(ACTIVE_STATE_CLASS, value)
            },
            _refreshHoveredElement: function(hoveredElement) {
                var selector = this._activeStateUnit || this._eventBindingTarget();
                this._forgetHoveredElement();
                this._hoveredElement = hoveredElement.closest(selector);
                this._toggleHoverClass(true)
            },
            _forgetHoveredElement: function() {
                this._toggleHoverClass(false);
                delete this._hoveredElement
            },
            _toggleHoverClass: function(value) {
                if (this._hoveredElement) {
                    this._hoveredElement.toggleClass(HOVER_STATE_CLASS, value && this.option("hoverStateEnabled"))
                }
            },
            _toggleDisabledState: function(value) {
                this.element().toggleClass(DISABLED_STATE_CLASS, Boolean(value));
                this._toggleHoverClass(!value);
                this.setAria("disabled", value || void 0)
            },
            _setWidgetOption: function(widgetName, args) {
                if (!this[widgetName]) {
                    return
                }
                if (typeUtils.isPlainObject(args[0])) {
                    $.each(args[0], function(option, value) {
                        this._setWidgetOption(widgetName, [option, value])
                    }.bind(this));
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this[widgetName + "OptionMap"];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                        this._toggleDisabledState(args.value);
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        break;
                    case "tabIndex":
                    case "_keyboardProcessor":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "visible":
                        var visible = args.value;
                        this._toggleVisibility(visible);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(args.value ? "shown" : "hiding")
                        }
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                return this.callBase() && this.option("visible")
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                var setAttribute = function(option) {
                    var attrName = "role" === option.name || "id" === option.name ? option.name : "aria-" + option.name,
                        attrValue = option.value;
                    if (null === attrValue || void 0 === attrValue) {
                        attrValue = void 0
                    } else {
                        attrValue = attrValue.toString()
                    }
                    domUtils.toggleAttr(option.target, attrName, attrValue)
                };
                if (!typeUtils.isPlainObject(arguments[0])) {
                    setAttribute({
                        name: arguments[0],
                        value: arguments[1],
                        target: arguments[2] || this._getAriaTarget()
                    })
                } else {
                    var $target = arguments[1] || this._getAriaTarget();
                    $.each(arguments[0], function(key, value) {
                        setAttribute({
                            name: key,
                            value: value,
                            target: $target
                        })
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                this._focusTarget().focus()
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys(),
                    addingKeys = {};
                addingKeys[key] = handler;
                this._supportedKeys = function() {
                    return extend(currentKeys, addingKeys)
                }
            }
        });
        module.exports = Widget
    },
    /*!*****************************************!*\
      !*** ./js/ui/widget/jquery.template.js ***!
      \*****************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            errors = __webpack_require__( /*! ../../core/errors */ 7),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 97),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56);
        var templateEngines = {};
        var registerTemplateEngine = function(name, templateEngine) {
            templateEngines[name] = templateEngine
        };
        var outerHtml = function(element) {
            element = $(element);
            var templateTag = element.length && element[0].nodeName.toLowerCase();
            if ("script" === templateTag) {
                return element.html()
            } else {
                element = $("<div>").append(element);
                return element.html()
            }
        };
        registerTemplateEngine("default", {
            compile: function(element) {
                return domUtils.normalizeTemplateElement(element)
            },
            render: function(template) {
                return template.clone()
            }
        });
        registerTemplateEngine("jquery-tmpl", {
            compile: function(element) {
                return outerHtml(element)
            },
            render: function(template, data) {
                return $.tmpl(template, data)
            }
        });
        registerTemplateEngine("jsrender", {
            compile: function(element) {
                return $.templates(outerHtml(element))
            },
            render: function(template, data) {
                return template.render(data)
            }
        });
        registerTemplateEngine("mustache", {
            compile: function(element) {
                return outerHtml(element)
            },
            render: function(template, data) {
                return Mustache.render(template, data)
            }
        });
        registerTemplateEngine("hogan", {
            compile: function(element) {
                return Hogan.compile(outerHtml(element))
            },
            render: function(template, data) {
                return template.render(data)
            }
        });
        registerTemplateEngine("underscore", {
            compile: function(element) {
                return _.template(outerHtml(element))
            },
            render: function(template, data) {
                return template(data)
            }
        });
        registerTemplateEngine("handlebars", {
            compile: function(element) {
                return Handlebars.compile(outerHtml(element))
            },
            render: function(template, data) {
                return template(data)
            }
        });
        registerTemplateEngine("doT", {
            compile: function(element) {
                return doT.template(outerHtml(element))
            },
            render: function(template, data) {
                return template(data)
            }
        });
        var currentTemplateEngine;
        var setTemplateEngine = function(templateEngine) {
            if (commonUtils.isString(templateEngine)) {
                currentTemplateEngine = templateEngines[templateEngine];
                if (!currentTemplateEngine) {
                    throw errors.Error("E0020", templateEngine)
                }
            } else {
                currentTemplateEngine = templateEngine
            }
        };
        setTemplateEngine("default");
        var Template = TemplateBase.inherit({
            ctor: function(element) {
                this._element = element;
                this._compiledTemplate = currentTemplateEngine.compile(element)
            },
            _renderCore: function(options) {
                return $("<div>").append(currentTemplateEngine.render(this._compiledTemplate, options.model, options.index)).contents()
            },
            source: function() {
                return $(this._element).clone()
            }
        });
        module.exports = Template;
        module.exports.setTemplateEngine = setTemplateEngine
    },
    /*!******************************************!*\
      !*** ./js/ui/widget/ui.template_base.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            triggerShownEvent = __webpack_require__( /*! ../../core/utils/dom */ 56).triggerShownEvent,
            Class = __webpack_require__( /*! ../../core/class */ 25),
            abstract = Class.abstract;
        var renderedCallbacks = $.Callbacks();
        var TemplateBase = Class.inherit({
            render: function(options) {
                options = options || {};
                var $result = this._renderCore(options);
                this._ensureResultInContainer($result, options.container);
                renderedCallbacks.fire($result, options.container);
                return $result
            },
            _ensureResultInContainer: function($result, $container) {
                if (!$container) {
                    return
                }
                var resultInContainer = $.contains($container.get(0), $result.get(0));
                $container.append($result);
                if (resultInContainer) {
                    return
                }
                var resultInBody = $.contains(document.body, $container.get(0));
                if (!resultInBody) {
                    return
                }
                triggerShownEvent($result)
            },
            _renderCore: abstract
        });
        module.exports = TemplateBase;
        module.exports.renderedCallbacks = renderedCallbacks
    },
    /*!*******************************************!*\
      !*** ./js/ui/widget/function_template.js ***!
      \*******************************************/
    function(module, exports, __webpack_require__) {
        var TemplateBase = __webpack_require__( /*! ./ui.template_base */ 97),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56);
        var FunctionTemplate = TemplateBase.inherit({
            ctor: function(render) {
                this._render = render
            },
            _renderCore: function(options) {
                return domUtils.normalizeTemplateElement(this._render(options))
            }
        });
        module.exports = FunctionTemplate
    },
    /*!****************************************!*\
      !*** ./js/ui/widget/empty_template.js ***!
      \****************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 97);
        var EmptyTemplate = TemplateBase.inherit({
            _renderCore: function() {
                return $()
            }
        });
        module.exports = EmptyTemplate
    },
    /*!************************************************!*\
      !*** ./js/ui/widget/child_default_template.js ***!
      \************************************************/
    function(module, exports, __webpack_require__) {
        var TemplateBase = __webpack_require__( /*! ./ui.template_base */ 97);
        module.exports = TemplateBase.inherit({
            ctor: function(name) {
                this.name = name
            }
        })
    },
    /*!***********************************************!*\
      !*** ./js/ui/widget/ui.keyboard_processor.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            eventUtils = __webpack_require__( /*! ../../events/utils */ 71);
        var KeyboardProcessor = Class.inherit({
            _keydown: eventUtils.addNamespace("keydown", "KeyboardProcessor"),
            codes: {
                8: "backspace",
                9: "tab",
                13: "enter",
                27: "escape",
                33: "pageUp",
                34: "pageDown",
                35: "end",
                36: "home",
                37: "leftArrow",
                38: "upArrow",
                39: "rightArrow",
                40: "downArrow",
                46: "del",
                32: "space",
                70: "F",
                65: "A",
                106: "asterisk",
                109: "minus"
            },
            ctor: function(options) {
                var _this = this;
                options = options || {};
                if (options.element) {
                    this._element = $(options.element)
                }
                if (options.focusTarget) {
                    this._focusTarget = options.focusTarget
                }
                this._handler = options.handler;
                this._context = options.context;
                this._childProcessors = [];
                if (this._element) {
                    this._processFunction = function(e) {
                        _this.process(e)
                    };
                    this._element.on(this._keydown, this._processFunction)
                }
            },
            dispose: function() {
                if (this._element) {
                    this._element.off(this._keydown, this._processFunction)
                }
                this._element = void 0;
                this._handler = void 0;
                this._context = void 0;
                this._childProcessors = void 0
            },
            clearChildren: function() {
                this._childProcessors = []
            },
            push: function(child) {
                if (!this._childProcessors) {
                    this.clearChildren()
                }
                this._childProcessors.push(child);
                return child
            },
            attachChildProcessor: function() {
                var childProcessor = new KeyboardProcessor;
                this._childProcessors.push(childProcessor);
                return childProcessor
            },
            reinitialize: function(childHandler, childContext) {
                this._context = childContext;
                this._handler = childHandler;
                return this
            },
            process: function(e) {
                if (this._focusTarget && this._focusTarget !== e.target && inArray(e.target, this._focusTarget) < 0) {
                    return false
                }
                var args = {
                    key: this.codes[e.which] || e.which,
                    ctrl: e.ctrlKey,
                    shift: e.shiftKey,
                    alt: e.altKey,
                    originalEvent: e
                };
                var handlerResult = this._handler && this._handler.call(this._context, args);
                if (handlerResult && this._childProcessors) {
                    $.each(this._childProcessors, function(index, childProcessor) {
                        childProcessor.process(e)
                    })
                }
            }
        });
        module.exports = KeyboardProcessor
    },
    /*!******************************************!*\
      !*** ./js/ui/widget/jquery.selectors.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9);
        var focusable = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase(),
                isTabIndexNotNaN = !isNaN(tabIndex),
                isDisabled = element.disabled,
                isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName),
                isHyperlink = "a" === nodeName,
                isFocusable = true;
            if (isDefaultFocus) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };
        var visible = function(element) {
            var $element = $(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        };
        module.exports = {
            focusable: function(index, element) {
                return focusable(element, $(element).attr("tabindex"))
            },
            tabbable: function(index, element) {
                var tabIndex = $(element).attr("tabindex");
                return (isNaN(tabIndex) || tabIndex >= 0) && focusable(element, tabIndex)
            }
        }
    },
    /*!****************************!*\
      !*** ./js/events/hover.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            Class = __webpack_require__( /*! ../core/class */ 25),
            devices = __webpack_require__( /*! ../core/devices */ 53),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 73),
            eventUtils = __webpack_require__( /*! ./utils */ 71),
            pointerEvents = __webpack_require__( /*! ./pointer */ 76);
        var HOVERSTART_NAMESPACE = "dxHoverStart",
            HOVERSTART = "dxhoverstart",
            POINTERENTER_NAMESPACED_EVENT_NAME = eventUtils.addNamespace(pointerEvents.enter, HOVERSTART_NAMESPACE),
            HOVEREND_NAMESPACE = "dxHoverEnd",
            HOVEREND = "dxhoverend",
            POINTERLEAVE_NAMESPACED_EVENT_NAME = eventUtils.addNamespace(pointerEvents.leave, HOVEREND_NAMESPACE);
        var Hover = Class.inherit({
            noBubble: true,
            ctor: function() {
                this._handlerArrayKeyPath = this._eventNamespace + "_HandlerStore"
            },
            setup: function(element) {
                $.data(element, this._handlerArrayKeyPath, {})
            },
            add: function(element, handleObj) {
                var that = this,
                    $element = $(element),
                    handler = function(e) {
                        that._handler(e)
                    };
                $element.on(this._originalEventName, handleObj.selector, handler);
                $.data(element, this._handlerArrayKeyPath)[handleObj.guid] = handler
            },
            _handler: function(e) {
                if (eventUtils.isTouchEvent(e) || devices.isSimulator()) {
                    return
                }
                eventUtils.fireEvent({
                    type: this._eventName,
                    originalEvent: e,
                    delegateTarget: e.delegateTarget
                })
            },
            remove: function(element, handleObj) {
                var handler = $.data(element, this._handlerArrayKeyPath)[handleObj.guid];
                $(element).off(this._originalEventName, handleObj.selector, handler)
            },
            teardown: function(element) {
                $.removeData(element, this._handlerArrayKeyPath)
            }
        });
        var HoverStart = Hover.inherit({
            ctor: function() {
                this._eventNamespace = HOVERSTART_NAMESPACE;
                this._eventName = HOVERSTART;
                this._originalEventName = POINTERENTER_NAMESPACED_EVENT_NAME;
                this.callBase()
            },
            _handler: function(e) {
                var pointers = e.pointers || [];
                if (!pointers.length) {
                    this.callBase(e)
                }
            }
        });
        var HoverEnd = Hover.inherit({
            ctor: function() {
                this._eventNamespace = HOVEREND_NAMESPACE;
                this._eventName = HOVEREND;
                this._originalEventName = POINTERLEAVE_NAMESPACED_EVENT_NAME;
                this.callBase()
            }
        });
        registerEvent(HOVERSTART, new HoverStart);
        registerEvent(HOVEREND, new HoverEnd);
        exports.start = HOVERSTART;
        exports.end = HOVEREND
    },
    /*!********************************************!*\
      !*** ./js/events/core/emitter.feedback.js ***!
      \********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            devices = __webpack_require__( /*! ../../core/devices */ 53),
            eventUtils = __webpack_require__( /*! ../utils */ 71),
            pointerEvents = __webpack_require__( /*! ../pointer */ 76),
            Emitter = __webpack_require__( /*! ./emitter */ 83),
            registerEmitter = __webpack_require__( /*! ./emitter_registrator */ 84);
        var ACTIVE_EVENT_NAME = "dxactive",
            INACTIVE_EVENT_NAME = "dxinactive",
            ACTIVE_TIMEOUT = 30,
            INACTIVE_TIMEOUT = 400;
        var FeedbackEvent = Class.inherit({
            ctor: function(timeout, fire) {
                this._timeout = timeout;
                this._fire = fire
            },
            start: function() {
                var that = this;
                this._schedule(function() {
                    that.force()
                })
            },
            _schedule: function(fn) {
                this.stop();
                this._timer = window.setTimeout(fn, this._timeout)
            },
            stop: function() {
                clearTimeout(this._timer)
            },
            force: function() {
                if (this._fired) {
                    return
                }
                this.stop();
                this._fire();
                this._fired = true
            },
            fired: function() {
                return this._fired
            }
        });
        var activeFeedback;
        var FeedbackEmitter = Emitter.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._active = new FeedbackEvent(0, commonUtils.noop);
                this._inactive = new FeedbackEvent(0, commonUtils.noop)
            },
            configure: function(data, eventName) {
                switch (eventName) {
                    case ACTIVE_EVENT_NAME:
                        data.activeTimeout = data.timeout;
                        break;
                    case INACTIVE_EVENT_NAME:
                        data.inactiveTimeout = data.timeout
                }
                this.callBase(data)
            },
            start: function(e) {
                if (activeFeedback) {
                    var activeChildExists = $.contains(this.getElement().get(0), activeFeedback.getElement().get(0));
                    var childJustActivated = !activeFeedback._active.fired();
                    if (activeChildExists && childJustActivated) {
                        this._cancel();
                        return
                    }
                    activeFeedback._inactive.force()
                }
                activeFeedback = this;
                this._initEvents(e);
                this._active.start()
            },
            _initEvents: function(e) {
                var that = this,
                    eventTarget = this._getEmitterTarget(e),
                    mouseEvent = eventUtils.isMouseEvent(e),
                    isSimulator = devices.isSimulator(),
                    deferFeedback = isSimulator || !mouseEvent,
                    activeTimeout = commonUtils.ensureDefined(this.activeTimeout, ACTIVE_TIMEOUT),
                    inactiveTimeout = commonUtils.ensureDefined(this.inactiveTimeout, INACTIVE_TIMEOUT);
                this._active = new FeedbackEvent(deferFeedback ? activeTimeout : 0, function() {
                    that._fireEvent(ACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    })
                });
                this._inactive = new FeedbackEvent(deferFeedback ? inactiveTimeout : 0, function() {
                    that._fireEvent(INACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    });
                    activeFeedback = null
                })
            },
            cancel: function(e) {
                this.end(e)
            },
            end: function(e) {
                var skipTimers = e.type !== pointerEvents.up;
                if (skipTimers) {
                    this._active.stop()
                } else {
                    this._active.force()
                }
                this._inactive.start();
                if (skipTimers) {
                    this._inactive.force()
                }
            },
            dispose: function() {
                this._active.stop();
                this._inactive.stop();
                this.callBase()
            },
            lockInactive: function() {
                this._active.force();
                this._inactive.stop();
                activeFeedback = null;
                this._cancel();
                return this._inactive.force.bind(this._inactive)
            }
        });
        FeedbackEmitter.lock = function(deferred) {
            var lockInactive = activeFeedback ? activeFeedback.lockInactive() : commonUtils.noop;
            deferred.done(lockInactive)
        };
        registerEmitter({
            emitter: FeedbackEmitter,
            events: [ACTIVE_EVENT_NAME, INACTIVE_EVENT_NAME]
        });
        exports.lock = FeedbackEmitter.lock;
        exports.active = ACTIVE_EVENT_NAME;
        exports.inactive = INACTIVE_EVENT_NAME
    },
    /*!*********************************************!*\
      !*** ./js/integration/knockout/template.js ***!
      \*********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            ko = __webpack_require__( /*! knockout */ 93),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            TemplateBase = __webpack_require__( /*! ../../ui/widget/ui.template_base */ 97),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56);
        var getParentContext = function() {
            var parentNode = $("<div>")[0];
            ko.applyBindingsToNode(parentNode);
            var parentContext = ko.contextFor(parentNode);
            getParentContext = function() {
                return parentContext
            };
            return parentContext
        };
        var KoTemplate = TemplateBase.inherit({
            ctor: function(element) {
                this._element = element;
                this._template = $("<div>").append(domUtils.normalizeTemplateElement(element));
                this._registerKoTemplate()
            },
            _registerKoTemplate: function() {
                var template = this._template.get(0);
                new ko.templateSources.anonymousTemplate(template).nodes(template)
            },
            _prepareDataForContainer: function(data, container) {
                if (container && container.length) {
                    var containerElement = container.get(0);
                    var containerContext = ko.contextFor(containerElement);
                    data = void 0 !== data ? data : ko.dataFor(containerElement) || {};
                    if (containerContext) {
                        return data === containerContext.$data ? containerContext : containerContext.createChildContext(data)
                    }
                }
                return getParentContext().createChildContext(data)
            },
            _renderCore: function(options) {
                var model = this._prepareDataForContainer(options.model, options.container);
                if (commonUtils.isDefined(options.index)) {
                    model.$index = options.index
                }
                var $placeholder = $("<div>").appendTo(options.container);
                var $result;
                ko.renderTemplate(this._template.get(0), model, {
                    afterRender: function(nodes) {
                        $result = $(nodes)
                    }
                }, $placeholder.get(0), "replaceNode");
                return $result
            },
            source: function() {
                return $(this._element).clone()
            },
            dispose: function() {
                this._template.remove()
            }
        });
        module.exports = KoTemplate
    },
    /*!********************************!*\
      !*** ./js/ui/editor/editor.js ***!
      \********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            getDefaultAlignment = __webpack_require__( /*! ../../core/utils/position */ 107).getDefaultAlignment,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            Widget = __webpack_require__( /*! ../widget/ui.widget */ 95),
            ValidationMixin = __webpack_require__( /*! ../validation/validation_mixin */ 108),
            Overlay = __webpack_require__( /*! ../overlay */ 109);
        var READONLY_STATE_CLASS = "dx-state-readonly",
            INVALID_CLASS = "dx-invalid",
            INVALID_MESSAGE = "dx-invalid-message",
            INVALID_MESSAGE_AUTO = "dx-invalid-message-auto",
            INVALID_MESSAGE_ALWAYS = "dx-invalid-message-always",
            VALIDATION_TARGET = "dx-validation-target",
            VALIDATION_MESSAGE_MIN_WIDTH = 100;
        var Editor = Widget.inherit({
            _init: function() {
                this.callBase();
                this.validationRequest = $.Callbacks();
                var $element = this.element();
                if ($element) {
                    $.data($element[0], VALIDATION_TARGET, this)
                }
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    }
                })
            },
            _attachKeyboardEvents: function() {
                if (this.option("readOnly")) {
                    return
                }
                this.callBase();
                if (this._keyboardProcessor) {
                    this._attachChildKeyboardEvents()
                }
            },
            _attachChildKeyboardEvents: commonUtils.noop,
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _render: function() {
                this.callBase();
                this._renderValidationState();
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"))
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    jQueryEvent: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid"),
                    validationError = this.option("validationError"),
                    validationMessageMode = this.option("validationMessageMode"),
                    $element = this.element();
                $element.toggleClass(INVALID_CLASS, !isValid);
                this.setAria("invalid", !isValid || void 0);
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this._$validationMessage = null
                }
                if (!isValid && validationError && validationError.message) {
                    this._$validationMessage = $("<div/>", {
                        "class": INVALID_MESSAGE
                    }).html(validationError.message).appendTo($element);
                    this._validationMessage = this._createComponent(this._$validationMessage, Overlay, {
                        integrationOptions: {},
                        templatesRenderAsynchronously: false,
                        target: this._getValidationMessageTarget(),
                        shading: false,
                        width: "auto",
                        height: "auto",
                        container: $element,
                        position: this._getValidationMessagePosition("below"),
                        closeOnOutsideClick: false,
                        closeOnTargetScroll: false,
                        animation: null,
                        visible: true,
                        propagateOutsideClick: true,
                        _checkParentVisibility: false
                    });
                    this._$validationMessage.toggleClass(INVALID_MESSAGE_AUTO, "auto" === validationMessageMode).toggleClass(INVALID_MESSAGE_ALWAYS, "always" === validationMessageMode);
                    this._setValidationMessageMaxWidth()
                }
            },
            _setValidationMessageMaxWidth: function() {
                if (!this._validationMessage) {
                    return
                }
                if (0 === this._getValidationMessageTarget().outerWidth()) {
                    this._validationMessage.option("maxWidth", "100%");
                    return
                }
                var validationMessageMaxWidth = Math.max(VALIDATION_MESSAGE_MIN_WIDTH, this._getValidationMessageTarget().outerWidth());
                this._validationMessage.option("maxWidth", validationMessageMaxWidth)
            },
            _getValidationMessageTarget: function() {
                return this.element()
            },
            _getValidationMessagePosition: function(positionRequest) {
                var rtlEnabled = this.option("rtlEnabled"),
                    messagePositionSide = getDefaultAlignment(rtlEnabled),
                    messageOriginalOffset = this.option("validationMessageOffset"),
                    messageOffset = {
                        h: messageOriginalOffset.h,
                        v: messageOriginalOffset.v
                    },
                    verticalPositions = "below" === positionRequest ? [" top", " bottom"] : [" bottom", " top"];
                if (rtlEnabled) {
                    messageOffset.h = -messageOffset.h
                }
                if ("below" !== positionRequest) {
                    messageOffset.v = -messageOffset.v
                }
                return {
                    offset: messageOffset,
                    boundary: this.option("validationBoundary"),
                    my: messagePositionSide + verticalPositions[0],
                    at: messagePositionSide + verticalPositions[1],
                    collision: "none flip"
                }
            },
            _toggleReadOnlyState: function() {
                this.element().toggleClass(READONLY_STATE_CLASS, !!this.option("readOnly"));
                this.setAria("readonly", this.option("readOnly") || void 0)
            },
            _dispose: function() {
                var element = this.element()[0];
                $.data(element, VALIDATION_TARGET, null);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "isValid":
                    case "validationError":
                    case "validationBoundary":
                    case "validationMessageMode":
                        this._renderValidationState();
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        this._setValidationMessageMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                this.option("value", null)
            }
        }).include(ValidationMixin);
        module.exports = Editor
    },
    /*!***********************************!*\
      !*** ./js/core/utils/position.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 15);
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = isRtlEnabled || config().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        exports.getDefaultAlignment = getDefaultAlignment
    },
    /*!**********************************************!*\
      !*** ./js/ui/validation/validation_mixin.js ***!
      \**********************************************/
    function(module, exports) {
        var ValidationMixin = {
            _findGroup: function() {
                var $dxGroup, group = this.option("validationGroup");
                if (!group) {
                    $dxGroup = this.element().parents(".dx-validationgroup").first();
                    if ($dxGroup.length) {
                        group = $dxGroup.dxValidationGroup("instance")
                    } else {
                        group = this._modelByElement(this.element())
                    }
                }
                return group
            }
        };
        module.exports = ValidationMixin
    },
    /*!**************************!*\
      !*** ./js/ui/overlay.js ***!
      \**************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            fx = __webpack_require__( /*! ../animation/fx */ 68),
            translator = __webpack_require__( /*! ../animation/translator */ 69),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 17).compare,
            viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 55),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            viewPortChanged = viewPortUtils.changeCallback,
            hideTopOverlayCallback = __webpack_require__( /*! ../mobile/hide_top_overlay */ 65).hideCallback,
            positionUtils = __webpack_require__( /*! ../animation/position */ 70),
            fitIntoRange = __webpack_require__( /*! ../core/utils/math */ 87).fitIntoRange,
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 56),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 12),
            devices = __webpack_require__( /*! ../core/devices */ 53),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 57),
            Widget = __webpack_require__( /*! ./widget/ui.widget */ 95),
            KeyboardProcessor = __webpack_require__( /*! ./widget/ui.keyboard_processor */ 101),
            selectors = __webpack_require__( /*! ./widget/jquery.selectors */ 102),
            dragEvents = __webpack_require__( /*! ../events/drag */ 110),
            eventUtils = __webpack_require__( /*! ../events/utils */ 71),
            pointerEvents = __webpack_require__( /*! ../events/pointer */ 76),
            Resizable = __webpack_require__( /*! ./resizable */ 111),
            EmptyTemplate = __webpack_require__( /*! ./widget/empty_template */ 99);
        var OVERLAY_CLASS = "dx-overlay",
            OVERLAY_WRAPPER_CLASS = "dx-overlay-wrapper",
            OVERLAY_CONTENT_CLASS = "dx-overlay-content",
            OVERLAY_SHADER_CLASS = "dx-overlay-shader",
            OVERLAY_MODAL_CLASS = "dx-overlay-modal",
            INVISIBLE_STATE_CLASS = "dx-state-invisible",
            ANONYMOUS_TEMPLATE_NAME = "content",
            RTL_DIRECTION_CLASS = "dx-rtl",
            ACTIONS = ["onShowing", "onShown", "onHiding", "onHidden", "onPositioning", "onPositioned", "onResizeStart", "onResize", "onResizeEnd"],
            FIRST_Z_INDEX = 1500,
            OVERLAY_STACK = [],
            DISABLED_STATE_CLASS = "dx-state-disabled",
            TAB_KEY = 9;
        var realDevice = devices.real(),
            realVersion = realDevice.version,
            iOS = "ios" === realDevice.platform,
            iOS7_0andBelow = iOS && compareVersions(realVersion, [7, 1]) < 0,
            android4_0nativeBrowser = "android" === realDevice.platform && 0 === compareVersions(realVersion, [4, 0], 2) && navigator.userAgent.indexOf("Chrome") === -1;
        var forceRepaint = function($element) {
            if (iOS7_0andBelow) {
                $element.width()
            }
            if (android4_0nativeBrowser) {
                var $parents = $element.parents(),
                    inScrollView = $parents.is(".dx-scrollable-native");
                if (!inScrollView) {
                    $parents.css("backface-visibility", "hidden");
                    $parents.css("backface-visibility");
                    $parents.css("backface-visibility", "visible")
                }
            }
        };
        var getElement = function(value) {
            return value && $(value instanceof $.Event ? value.target : value)
        };
        $(document).on(pointerEvents.down, function(e) {
            for (var i = OVERLAY_STACK.length - 1; i >= 0; i--) {
                if (!OVERLAY_STACK[i]._proxiedDocumentDownHandler(e)) {
                    return
                }
            }
        });
        var Overlay = Widget.inherit({
            _supportedKeys: function() {
                var offsetSize = 5,
                    move = function(top, left, e) {
                        if (!this.option("dragEnabled")) {
                            return
                        }
                        e.preventDefault();
                        e.stopPropagation();
                        var allowedOffsets = this._allowedOffsets();
                        var offset = {
                            top: fitIntoRange(top, -allowedOffsets.top, allowedOffsets.bottom),
                            left: fitIntoRange(left, -allowedOffsets.left, allowedOffsets.right)
                        };
                        this._changePosition(offset)
                    };
                return extend(this.callBase(), {
                    escape: function() {
                        this.hide()
                    },
                    upArrow: move.bind(this, -offsetSize, 0),
                    downArrow: move.bind(this, offsetSize, 0),
                    leftArrow: move.bind(this, 0, -offsetSize),
                    rightArrow: move.bind(this, 0, offsetSize)
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    activeStateEnabled: false,
                    visible: false,
                    deferRendering: true,
                    shading: true,
                    shadingColor: "",
                    position: {
                        my: "center",
                        at: "center"
                    },
                    width: function() {
                        return .8 * $(window).width()
                    },
                    minWidth: null,
                    maxWidth: null,
                    height: function() {
                        return .8 * $(window).height()
                    },
                    minHeight: null,
                    maxHeight: null,
                    animation: {
                        show: {
                            type: "pop",
                            duration: 300,
                            from: {
                                scale: .55
                            }
                        },
                        hide: {
                            type: "pop",
                            duration: 300,
                            to: {
                                opacity: 0,
                                scale: .55
                            },
                            from: {
                                opacity: 1,
                                scale: 1
                            }
                        }
                    },
                    closeOnOutsideClick: false,
                    closeOnBackButton: true,
                    onShowing: null,
                    onShown: null,
                    onHiding: null,
                    onHidden: null,
                    contentTemplate: "content",
                    dragEnabled: false,
                    resizeEnabled: false,
                    onResizeStart: null,
                    onResize: null,
                    onResizeEnd: null,
                    onContentReady: null,
                    target: void 0,
                    container: void 0,
                    hideTopOverlayHandler: void 0,
                    closeOnTargetScroll: false,
                    onPositioned: null,
                    boundaryOffset: {
                        h: 0,
                        v: 0
                    },
                    propagateOutsideClick: false,
                    _checkParentVisibility: true
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        var realDevice = devices.real(),
                            realPlatform = realDevice.platform,
                            realVersion = realDevice.version;
                        return "android" === realPlatform && compareVersions(realVersion, [4, 2]) < 0
                    },
                    options: {
                        animation: {
                            show: {
                                type: "fade",
                                duration: 400
                            },
                            hide: {
                                type: "fade",
                                duration: 400,
                                to: {
                                    opacity: 0
                                },
                                from: {
                                    opacity: 1
                                }
                            }
                        }
                    }
                }])
            },
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    animation: true
                })
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _wrapper: function() {
                return this._$wrapper
            },
            _container: function() {
                return this._$content
            },
            _eventBindingTarget: function() {
                return this._$content
            },
            _init: function() {
                this.callBase();
                this._initActions();
                this._initCloseOnOutsideClickHandler();
                this._initTabTerminatorHandler();
                this._$wrapper = $("<div>").addClass(OVERLAY_WRAPPER_CLASS);
                this._$content = $("<div>").addClass(OVERLAY_CONTENT_CLASS);
                var $element = this.element();
                this._$wrapper.addClass($element.attr("class"));
                $element.addClass(OVERLAY_CLASS);
                this._$wrapper.attr("data-bind", "dxControlsDescendantBindings: true");
                this._$wrapper.on("MSPointerDown", commonUtils.noop);
                this._$wrapper.on("focusin", function(e) {
                    e.stopPropagation()
                });
                this._toggleViewPortSubscription(true)
            },
            _initOptions: function(options) {
                this._initTarget(options.target);
                this._initContainer(options.container);
                this._initHideTopOverlayHandler(options.hideTopOverlayHandler);
                this.callBase(options)
            },
            _initTarget: function(target) {
                if (!commonUtils.isDefined(target)) {
                    return
                }
                var options = this.option();
                $.each(["position.of", "animation.show.from.position.of", "animation.show.to.position.of", "animation.hide.from.position.of", "animation.hide.to.position.of"], function(_, path) {
                    var pathParts = path.split(".");
                    var option = options;
                    while (option) {
                        if (1 === pathParts.length) {
                            if (typeUtils.isPlainObject(option)) {
                                option[pathParts.shift()] = target
                            }
                            break
                        } else {
                            option = option[pathParts.shift()]
                        }
                    }
                })
            },
            _initContainer: function(container) {
                container = void 0 === container ? viewPortUtils.value() : container;
                var $element = this.element(),
                    $container = $element.closest(container);
                if (!$container.length) {
                    $container = $(container).first()
                }
                this._$container = $container.length ? $container : $element.parent()
            },
            _initHideTopOverlayHandler: function(handler) {
                this._hideTopOverlayHandler = void 0 !== handler ? handler : this._defaultHideTopOverlayHandler.bind(this)
            },
            _defaultHideTopOverlayHandler: function() {
                this.hide()
            },
            _initActions: function() {
                this._actions = {};
                $.each(ACTIONS, function(_, action) {
                    this._actions[action] = this._createActionByOption(action, {
                        excludeValidators: ["disabled", "readOnly"]
                    }) || commonUtils.noop
                }.bind(this))
            },
            _initCloseOnOutsideClickHandler: function() {
                var that = this;
                this._proxiedDocumentDownHandler = function() {
                    return that._documentDownHandler.apply(that, arguments)
                }
            },
            _documentDownHandler: function(e) {
                if (this._showAnimationProcessing) {
                    this._stopAnimation()
                }
                var closeOnOutsideClick = this.option("closeOnOutsideClick");
                if (commonUtils.isFunction(closeOnOutsideClick)) {
                    closeOnOutsideClick = closeOnOutsideClick(e)
                }
                if (closeOnOutsideClick) {
                    var $container = this._$content,
                        outsideClick = !$container.is(e.target) && !$.contains($container.get(0), e.target) && $(e.target).closest(document).length;
                    if (outsideClick) {
                        if (this.option("shading")) {
                            e.preventDefault()
                        }
                        this.hide()
                    }
                }
                return this.option("propagateOutsideClick")
            },
            _initTemplates: function() {
                this.callBase();
                this._defaultTemplates.content = new EmptyTemplate(this)
            },
            _isTopOverlay: function() {
                var overlayStack = this._overlayStack();
                for (var i = overlayStack.length - 1; i >= 0; i--) {
                    var $tabbableElements = overlayStack[i]._findTabbableElements();
                    if ($tabbableElements.length) {
                        return overlayStack[i] === this
                    }
                }
                return false
            },
            _overlayStack: function() {
                return OVERLAY_STACK
            },
            _zIndexInitValue: function() {
                return FIRST_Z_INDEX
            },
            _toggleViewPortSubscription: function(toggle) {
                viewPortChanged.remove(this._viewPortChangeHandle);
                if (toggle) {
                    this._viewPortChangeHandle = this._viewPortChangeHandler.bind(this);
                    viewPortChanged.add(this._viewPortChangeHandle)
                }
            },
            _viewPortChangeHandler: function() {
                this._initContainer(this.option("container"));
                this._refresh()
            },
            _renderVisibilityAnimate: function(visible) {
                this._stopAnimation();
                return visible ? this._show() : this._hide()
            },
            _normalizePosition: function() {
                this._position = this.option("position")
            },
            _getAnimationConfig: function() {
                var animation = this.option("animation");
                if (commonUtils.isFunction(animation)) {
                    animation = animation.call(this)
                }
                return animation
            },
            _show: function() {
                var that = this,
                    deferred = $.Deferred();
                this._parentHidden = this._isParentHidden();
                deferred.done(function() {
                    delete that._parentHidden
                });
                if (this._parentHidden) {
                    return deferred.resolve()
                }
                if (this._currentVisible) {
                    return $.Deferred().resolve().promise()
                }
                this._currentVisible = true;
                this._normalizePosition();
                var animation = that._getAnimationConfig() || {},
                    showAnimation = this._normalizeAnimation(animation.show, "to"),
                    startShowAnimation = showAnimation && showAnimation.start || commonUtils.noop,
                    completeShowAnimation = showAnimation && showAnimation.complete || commonUtils.noop;
                if (this._isHidingActionCanceled) {
                    delete this._isHidingActionCanceled;
                    deferred.resolve()
                } else {
                    var show = function() {
                        this._renderVisibility(true);
                        this._animate(showAnimation, function() {
                            if (that.option("focusStateEnabled")) {
                                that._focusTarget().focus()
                            }
                            completeShowAnimation.apply(this, arguments);
                            that._showAnimationProcessing = false;
                            that._actions.onShown();
                            deferred.resolve()
                        }, function() {
                            startShowAnimation.apply(this, arguments);
                            that._showAnimationProcessing = true
                        })
                    }.bind(this);
                    if (this.option("templatesRenderAsynchronously")) {
                        this._asyncShowTimeout = setTimeout(show)
                    } else {
                        show()
                    }
                }
                return deferred.promise()
            },
            _normalizeAnimation: function(animation, prop) {
                if (animation) {
                    animation = extend({
                        type: "slide"
                    }, animation);
                    if (animation[prop] && "object" === typeof animation[prop]) {
                        extend(animation[prop], {
                            position: this._position
                        })
                    }
                }
                return animation
            },
            _hide: function() {
                if (!this._currentVisible) {
                    return $.Deferred().resolve().promise()
                }
                this._currentVisible = false;
                var that = this,
                    deferred = $.Deferred(),
                    animation = that._getAnimationConfig() || {},
                    hideAnimation = this._normalizeAnimation(animation.hide, "from"),
                    startHideAnimation = hideAnimation && hideAnimation.start || commonUtils.noop,
                    completeHideAnimation = hideAnimation && hideAnimation.complete || commonUtils.noop,
                    hidingArgs = {
                        cancel: false
                    };
                this._actions.onHiding(hidingArgs);
                if (hidingArgs.cancel) {
                    this._isHidingActionCanceled = true;
                    this.option("visible", true);
                    deferred.resolve()
                } else {
                    this._forceFocusLost();
                    this._toggleShading(false);
                    this._toggleSubscriptions(false);
                    this._animate(hideAnimation, function() {
                        that._$content.css("pointer-events", "");
                        that._renderVisibility(false);
                        completeHideAnimation.apply(this, arguments);
                        that._actions.onHidden();
                        deferred.resolve()
                    }, function() {
                        that._$content.css("pointer-events", "none");
                        startHideAnimation.apply(this, arguments)
                    })
                }
                return deferred.promise()
            },
            _forceFocusLost: function() {
                document.activeElement && this._$content.find(document.activeElement).length && document.activeElement.blur()
            },
            _animate: function(animation, completeCallback, startCallback) {
                if (animation) {
                    startCallback = startCallback || animation.start || commonUtils.noop;
                    fx.animate(this._$content, extend({}, animation, {
                        start: startCallback,
                        complete: completeCallback
                    }))
                } else {
                    completeCallback()
                }
            },
            _stopAnimation: function() {
                fx.stop(this._$content, true)
            },
            _renderVisibility: function(visible) {
                if (visible && this._isParentHidden()) {
                    return
                }
                this._currentVisible = visible;
                this._stopAnimation();
                clearTimeout(this._asyncShowTimeout);
                if (!visible) {
                    domUtils.triggerHidingEvent(this._$content)
                }
                this._toggleVisibility(visible);
                this._$content.toggleClass(INVISIBLE_STATE_CLASS, !visible);
                this._updateZIndexStackPosition(visible);
                if (visible) {
                    this._renderContent();
                    this._actions.onShowing();
                    this._moveToContainer();
                    this._renderGeometry();
                    domUtils.triggerShownEvent(this._$content);
                    domUtils.triggerResizeEvent(this._$content)
                } else {
                    this._moveFromContainer()
                }
                this._toggleShading(visible);
                this._toggleSubscriptions(visible)
            },
            _updateZIndexStackPosition: function(pushToStack) {
                var overlayStack = this._overlayStack(),
                    index = inArray(this, overlayStack);
                if (pushToStack) {
                    if (index === -1) {
                        var length = overlayStack.length;
                        this._zIndex = (length ? overlayStack[length - 1]._zIndex : this._zIndexInitValue()) + 1;
                        overlayStack.push(this)
                    }
                    this._$wrapper.css("z-index", this._zIndex);
                    this._$content.css("z-index", this._zIndex)
                } else {
                    if (index !== -1) {
                        overlayStack.splice(index, 1)
                    }
                }
            },
            _toggleShading: function(visible) {
                this._$wrapper.toggleClass(OVERLAY_MODAL_CLASS, this.option("shading") && !this.option("container"));
                this._$wrapper.toggleClass(OVERLAY_SHADER_CLASS, visible && this.option("shading"));
                this._$wrapper.css("background-color", this.option("shading") ? this.option("shadingColor") : "");
                this._toggleTabTerminator(visible && this.option("shading"))
            },
            _initTabTerminatorHandler: function() {
                var that = this;
                this._proxiedTabTerminatorHandler = function() {
                    that._tabKeyHandler.apply(that, arguments)
                }
            },
            _toggleTabTerminator: function(enabled) {
                var eventName = eventUtils.addNamespace("keydown", this.NAME);
                if (enabled) {
                    $(document).on(eventName, this._proxiedTabTerminatorHandler)
                } else {
                    $(document).off(eventName, this._proxiedTabTerminatorHandler)
                }
            },
            _findTabbableElements: function() {
                return this._$wrapper.find("*").filter(selectors.tabbable)
            },
            _tabKeyHandler: function(e) {
                if (e.keyCode !== TAB_KEY || !this._isTopOverlay()) {
                    return
                }
                var tabbableElements = this._findTabbableElements(),
                    $firstTabbable = tabbableElements.first(),
                    $lastTabbable = tabbableElements.last(),
                    isTabOnLast = !e.shiftKey && e.target === $lastTabbable.get(0),
                    isShiftTabOnFirst = e.shiftKey && e.target === $firstTabbable.get(0),
                    isEmptyTabList = 0 === tabbableElements.length,
                    isOutsideTarget = inArray(e.target, tabbableElements) === -1;
                if (isTabOnLast || isShiftTabOnFirst || isEmptyTabList || isOutsideTarget) {
                    e.preventDefault();
                    (e.shiftKey ? $lastTabbable : $firstTabbable).focusin().focus()
                }
            },
            _toggleSubscriptions: function(enabled) {
                this._toggleHideTopOverlayCallback(enabled);
                this._toggleParentsScrollSubscription(enabled)
            },
            _toggleHideTopOverlayCallback: function(subscribe) {
                if (!this._hideTopOverlayHandler) {
                    return
                }
                if (subscribe && this.option("closeOnBackButton")) {
                    hideTopOverlayCallback.add(this._hideTopOverlayHandler)
                } else {
                    hideTopOverlayCallback.remove(this._hideTopOverlayHandler)
                }
            },
            _toggleParentsScrollSubscription: function(subscribe) {
                if (!this._position) {
                    return
                }
                var target = this._position.of || $(),
                    closeOnScroll = this.option("closeOnTargetScroll"),
                    $parents = getElement(target).parents(),
                    scrollEvent = eventUtils.addNamespace("scroll", this.NAME);
                if ("generic" === devices.real().platform) {
                    $parents = $parents.add(window)
                }
                this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function(e) {
                    this._targetParentsScrollHandler(e)
                }.bind(this);
                $().add(this._$prevTargetParents).off(scrollEvent, this._proxiedTargetParentsScrollHandler);
                if (subscribe && closeOnScroll) {
                    $parents.on(scrollEvent, this._proxiedTargetParentsScrollHandler);
                    this._$prevTargetParents = $parents
                }
            },
            _targetParentsScrollHandler: function(e) {
                var closeHandled = false,
                    closeOnScroll = this.option("closeOnTargetScroll");
                if (commonUtils.isFunction(closeOnScroll)) {
                    closeHandled = closeOnScroll(e)
                }
                if (!closeHandled && !this._showAnimationProcessing) {
                    this.hide()
                }
            },
            _render: function() {
                this.callBase();
                this._$content.appendTo(this.element());
                this._renderVisibilityAnimate(this.option("visible"))
            },
            _renderContent: function() {
                var shouldDeferRendering = !this._currentVisible && this.option("deferRendering");
                var isParentHidden = this.option("visible") && this._isParentHidden();
                if (isParentHidden) {
                    this._isHidden = true;
                    return
                }
                if (this._contentAlreadyRendered || shouldDeferRendering) {
                    return
                }
                this._contentAlreadyRendered = true;
                this.callBase()
            },
            _isParentHidden: function() {
                if (!this.option("_checkParentVisibility")) {
                    return false
                }
                if (void 0 !== this._parentHidden) {
                    return this._parentHidden
                }
                var $parent = this.element().parent();
                if ($parent.is(":visible")) {
                    return false
                }
                var isHidden = false;
                $parent.add($parent.parents()).each(function() {
                    var $element = $(this);
                    if ("none" === $element.css("display")) {
                        isHidden = true;
                        return false
                    }
                });
                return isHidden || !$.contains(document, $parent.get(0))
            },
            _renderContentImpl: function() {
                var $element = this.element();
                this._$content.appendTo($element);
                var contentTemplate = this._getTemplate(this.option("contentTemplate"));
                contentTemplate && contentTemplate.render({
                    container: this.content(),
                    noModel: true
                });
                this._renderDrag();
                this._renderResize();
                this._renderScrollTerminator()
            },
            _renderDrag: function() {
                var $dragTarget = this._getDragTarget();
                if (!$dragTarget) {
                    return
                }
                var startEventName = eventUtils.addNamespace(dragEvents.start, this.NAME),
                    updateEventName = eventUtils.addNamespace(dragEvents.move, this.NAME);
                $dragTarget.off(startEventName).off(updateEventName);
                if (!this.option("dragEnabled")) {
                    return
                }
                $dragTarget.on(startEventName, this._dragStartHandler.bind(this)).on(updateEventName, this._dragUpdateHandler.bind(this))
            },
            _renderResize: function() {
                this._resizable = this._createComponent(this._$content, Resizable, {
                    handles: this.option("resizeEnabled") ? "all" : "none",
                    onResizeEnd: this._resizeEndHandler.bind(this),
                    onResize: this._actions.onResize.bind(this),
                    onResizeStart: this._actions.onResizeStart.bind(this),
                    minHeight: 100,
                    minWidth: 100,
                    area: this._getDragResizeContainer()
                })
            },
            _resizeEndHandler: function() {
                this._positionChangeHandled = true;
                var width = this._resizable.option("width"),
                    height = this._resizable.option("height");
                width && this.option("width", width);
                height && this.option("height", height);
                this._actions.onResizeEnd()
            },
            _renderScrollTerminator: function() {
                var $scrollTerminator = this._wrapper();
                var terminatorEventName = eventUtils.addNamespace(dragEvents.move, this.NAME);
                $scrollTerminator.off(terminatorEventName).on(terminatorEventName, {
                    validate: function() {
                        return true
                    },
                    getDirection: function() {
                        return "both"
                    },
                    _toggleGestureCover: commonUtils.noop,
                    _clearSelection: commonUtils.noop,
                    isNative: true
                }, function(e) {
                    var originalEvent = e.originalEvent.originalEvent;
                    e._cancelPreventDefault = true;
                    if (originalEvent && "mousemove" !== originalEvent.type) {
                        e.preventDefault()
                    }
                })
            },
            _getDragTarget: function() {
                return this.content()
            },
            _dragStartHandler: function(e) {
                e.targetElements = [];
                this._prevOffset = {
                    x: 0,
                    y: 0
                };
                var allowedOffsets = this._allowedOffsets();
                e.maxTopOffset = allowedOffsets.top;
                e.maxBottomOffset = allowedOffsets.bottom;
                e.maxLeftOffset = allowedOffsets.left;
                e.maxRightOffset = allowedOffsets.right
            },
            _getDragResizeContainer: function() {
                var isContainerDefined = viewPortUtils.originalViewPort().get(0) || this.option("container"),
                    $container = !isContainerDefined ? $(window) : this._$container;
                return $container
            },
            _deltaSize: function() {
                var $content = this._$content,
                    $container = this._getDragResizeContainer();
                var contentWidth = $content.outerWidth(),
                    contentHeight = $content.outerHeight(),
                    containerWidth = $container.outerWidth(),
                    containerHeight = $container.outerHeight();
                if (this._isWindow($container)) {
                    var fullPageHeight = Math.max($(document).outerHeight(), containerHeight),
                        fullPageWidth = Math.max($(document).outerWidth(), containerWidth);
                    containerHeight = fullPageHeight;
                    containerWidth = fullPageWidth
                }
                return {
                    width: containerWidth - contentWidth,
                    height: containerHeight - contentHeight
                }
            },
            _dragUpdateHandler: function(e) {
                var offset = e.offset,
                    prevOffset = this._prevOffset,
                    targetOffset = {
                        top: offset.y - prevOffset.y,
                        left: offset.x - prevOffset.x
                    };
                this._changePosition(targetOffset);
                this._prevOffset = offset
            },
            _changePosition: function(offset) {
                var position = translator.locate(this._$content);
                translator.move(this._$content, {
                    left: position.left + offset.left,
                    top: position.top + offset.top
                });
                this._positionChangeHandled = true
            },
            _allowedOffsets: function() {
                var position = translator.locate(this._$content),
                    deltaSize = this._deltaSize(),
                    isAllowedDrag = deltaSize.height >= 0 && deltaSize.width >= 0,
                    shaderOffset = this.option("shading") && !this.option("container") && !this._isWindow(this._getContainer()) ? translator.locate(this._$wrapper) : {
                        top: 0,
                        left: 0
                    },
                    boundaryOffset = this.option("boundaryOffset");
                return {
                    top: isAllowedDrag ? position.top + shaderOffset.top + boundaryOffset.v : 0,
                    bottom: isAllowedDrag ? -position.top - shaderOffset.top + deltaSize.height - boundaryOffset.v : 0,
                    left: isAllowedDrag ? position.left + shaderOffset.left + boundaryOffset.h : 0,
                    right: isAllowedDrag ? -position.left - shaderOffset.left + deltaSize.width - boundaryOffset.h : 0
                }
            },
            _fireContentReadyAction: function() {
                if (this.option("visible")) {
                    this._moveToContainer()
                }
                this.callBase.apply(this, arguments)
            },
            _moveFromContainer: function() {
                this._$content.appendTo(this.element());
                this._detachWrapperToContainer()
            },
            _detachWrapperToContainer: function() {
                this._$wrapper.detach()
            },
            _moveToContainer: function() {
                this._attachWrapperToContainer();
                this._$content.appendTo(this._$wrapper)
            },
            _attachWrapperToContainer: function() {
                var $element = this.element();
                if (this._$container && this._$container[0] !== $element.parent()[0]) {
                    this._$wrapper.appendTo(this._$container)
                } else {
                    this._$wrapper.appendTo($element)
                }
            },
            _renderGeometry: function() {
                if (this.option("visible")) {
                    this._renderGeometryImpl()
                }
            },
            _renderGeometryImpl: function() {
                this._stopAnimation();
                this._normalizePosition();
                this._renderShading();
                this._renderDimensions();
                var resultPosition = this._renderPosition();
                this._actions.onPositioned({
                    position: resultPosition
                })
            },
            _renderShading: function() {
                var $wrapper = this._$wrapper,
                    $container = this._getContainer();
                $wrapper.css("position", this._isWindow($container) && !iOS ? "fixed" : "absolute");
                this._renderShadingDimensions();
                this._renderShadingPosition()
            },
            _renderShadingPosition: function() {
                if (this.option("shading")) {
                    var $container = this._getContainer();
                    positionUtils.setup(this._$wrapper, {
                        my: "top left",
                        at: "top left",
                        of: $container
                    })
                }
            },
            _renderShadingDimensions: function() {
                var wrapperWidth, wrapperHeight;
                if (this.option("shading")) {
                    var $container = this._getContainer();
                    wrapperWidth = this._isWindow($container) ? "100%" : $container.outerWidth(), wrapperHeight = this._isWindow($container) ? "100%" : $container.outerHeight()
                } else {
                    wrapperWidth = "";
                    wrapperHeight = ""
                }
                this._$wrapper.css({
                    width: wrapperWidth,
                    height: wrapperHeight
                })
            },
            _isWindow: function($element) {
                return !!$element && commonUtils.isWindow($element.get(0))
            },
            _getContainer: function() {
                var position = this._position,
                    container = this.option("container"),
                    positionOf = position ? position.of || window : null;
                return getElement(container || positionOf)
            },
            _renderDimensions: function() {
                this._$content.css({
                    minWidth: this.option("minWidth"),
                    maxWidth: this.option("maxWidth"),
                    minHeight: this.option("minHeight"),
                    maxHeight: this.option("maxHeight")
                });
                this._$content.outerWidth(this.option("width")).outerHeight(this.option("height"))
            },
            _renderPosition: function() {
                if (this._positionChangeHandled) {
                    var allowedOffsets = this._allowedOffsets();
                    this._changePosition({
                        top: fitIntoRange(0, -allowedOffsets.top, allowedOffsets.bottom),
                        left: fitIntoRange(0, -allowedOffsets.left, allowedOffsets.right)
                    })
                } else {
                    this._renderOverlayBoundaryOffset();
                    translator.resetPosition(this._$content);
                    var resultPosition = positionUtils.setup(this._$content, this._position);
                    forceRepaint(this._$content);
                    this._actions.onPositioning();
                    return resultPosition
                }
            },
            _renderOverlayBoundaryOffset: function() {
                var boundaryOffset = this.option("boundaryOffset");
                this._$content.css("margin", boundaryOffset.v + "px " + boundaryOffset.h + "px")
            },
            _focusTarget: function() {
                return this._$content
            },
            _attachKeyboardEvents: function() {
                this._keyboardProcessor = new KeyboardProcessor({
                    element: this._$content,
                    handler: this._keyboardHandler,
                    context: this
                })
            },
            _keyboardHandler: function(options) {
                var e = options.originalEvent,
                    $target = $(e.target);
                if ($target.is(this._$content)) {
                    this.callBase.apply(this, arguments)
                }
            },
            _isVisible: function() {
                return this.option("visible")
            },
            _visibilityChanged: function(visible) {
                if (visible) {
                    if (this.option("visible")) {
                        this._renderVisibilityAnimate(visible)
                    }
                } else {
                    this._renderVisibilityAnimate(visible)
                }
            },
            _dimensionChanged: function() {
                this._renderGeometry()
            },
            _clean: function() {
                if (!this._contentAlreadyRendered) {
                    this.content().empty()
                }
                this._renderVisibility(false);
                this._cleanFocusState()
            },
            _dispose: function() {
                fx.stop(this._$content, false);
                clearTimeout(this._deferShowTimer);
                this._toggleViewPortSubscription(false);
                this._toggleSubscriptions(false);
                this._updateZIndexStackPosition(false);
                this._toggleTabTerminator(false);
                this._actions = null;
                this.callBase();
                this._$wrapper.remove();
                this._$content.remove()
            },
            _toggleDisabledState: function(value) {
                this.callBase.apply(this, arguments);
                this._$content.toggleClass(DISABLED_STATE_CLASS, Boolean(value))
            },
            _toggleRTLDirection: function(rtl) {
                this._$content.toggleClass(RTL_DIRECTION_CLASS, rtl)
            },
            _optionChanged: function(args) {
                var value = args.value;
                if (inArray(args.name, ACTIONS) > -1) {
                    this._initActions();
                    return
                }
                switch (args.name) {
                    case "dragEnabled":
                        this._renderDrag();
                        this._renderGeometry();
                        break;
                    case "resizeEnabled":
                        this._renderResize();
                        this._renderGeometry();
                        break;
                    case "shading":
                    case "shadingColor":
                        this._toggleShading(this.option("visible"));
                        break;
                    case "width":
                    case "height":
                    case "minWidth":
                    case "maxWidth":
                    case "minHeight":
                    case "maxHeight":
                    case "position":
                    case "boundaryOffset":
                        this._renderGeometry();
                        break;
                    case "visible":
                        this._renderVisibilityAnimate(value).done(function() {
                            if (!this._animateDeferred) {
                                return
                            }
                            this._animateDeferred.resolveWith(this)
                        }.bind(this));
                        break;
                    case "target":
                        this._initTarget(value);
                        this._invalidate();
                        break;
                    case "container":
                        this._initContainer(value);
                        this._invalidate();
                        break;
                    case "deferRendering":
                    case "contentTemplate":
                        this._contentAlreadyRendered = false;
                        this._invalidate();
                        break;
                    case "closeOnBackButton":
                        this._toggleHideTopOverlayCallback(this.option("visible"));
                        break;
                    case "closeOnTargetScroll":
                        this._toggleParentsScrollSubscription(this.option("visible"));
                        break;
                    case "closeOnOutsideClick":
                    case "animation":
                    case "propagateOutsideClick":
                        break;
                    case "rtlEnabled":
                        this._contentAlreadyRendered = false;
                        this.option("visible", false);
                        this.callBase(args);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            toggle: function(showing) {
                showing = void 0 === showing ? !this.option("visible") : showing;
                if (showing === this.option("visible")) {
                    return $.Deferred().resolve().promise()
                }
                var animateDeferred = $.Deferred();
                this._animateDeferred = animateDeferred;
                this.option("visible", showing);
                return animateDeferred.promise().done(function() {
                    delete this._animateDeferred
                }.bind(this))
            },
            show: function() {
                return this.toggle(true)
            },
            hide: function() {
                return this.toggle(false)
            },
            content: function() {
                return this._$content
            },
            repaint: function() {
                this._renderGeometry()
            }
        });
        Overlay.baseZIndex = function(zIndex) {
            FIRST_Z_INDEX = zIndex
        };
        registerComponent("dxOverlay", Overlay);
        module.exports = Overlay
    },
    /*!***************************!*\
      !*** ./js/events/drag.js ***!
      \***************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            wrapToArray = __webpack_require__( /*! ../core/utils/array */ 26).wrapToArray,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 73),
            eventUtils = __webpack_require__( /*! ./utils */ 71),
            GestureEmitter = __webpack_require__( /*! ./gesture/emitter.gesture */ 86),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 84);
        var DRAG_START_EVENT = "dxdragstart",
            DRAG_EVENT = "dxdrag",
            DRAG_END_EVENT = "dxdragend",
            DRAG_ENTER_EVENT = "dxdragenter",
            DRAG_LEAVE_EVENT = "dxdragleave",
            DROP_EVENT = "dxdrop";
        var knownDropTargets = [],
            knownDropTargetSelectors = [],
            knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = inArray(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = inArray(element, knownDropTargets);
                var selector = handleObj.selector;
                if (inArray(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            teardown: function(element) {
                var elementEvents = $._data(element, "events"),
                    handlersCount = 0;
                $.each([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT], function(_, eventName) {
                    var eventHandlers = elementEvents[eventName];
                    if (eventHandlers) {
                        handlersCount += eventHandlers.length
                    }
                });
                if (!handlersCount) {
                    var index = inArray(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1)
                }
            }
        };
        registerEvent(DRAG_ENTER_EVENT, dropTargetRegistration);
        registerEvent(DRAG_LEAVE_EVENT, dropTargetRegistration);
        registerEvent(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets),
                dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex];
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if (inArray(void 0, dropTargetSelectors) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.width(),
                height: $element.height()
            }
        };
        var DragEmitter = GestureEmitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = wrapToArray(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = $.map(dropTargets, function(element) {
                    return $(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = eventUtils.eventData(e),
                    dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e),
                    sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                eventUtils.fireEvent(eventData)
            },
            _findDropTarget: function(e) {
                var result, that = this;
                $.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = $(target);
                    $.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = $(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                $.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || $.contains(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, e) {
                var isDraggingElement = $target.get(0) === this._$element.get(0);
                if (isDraggingElement) {
                    return false
                }
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = eventUtils.eventData(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        registerEmitter({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        });
        exports.dropTargets = knownDropTargets;
        exports.move = DRAG_EVENT;
        exports.start = DRAG_START_EVENT;
        exports.end = DRAG_END_EVENT;
        exports.enter = DRAG_ENTER_EVENT;
        exports.leave = DRAG_LEAVE_EVENT;
        exports.drop = DROP_EVENT
    },
    /*!****************************!*\
      !*** ./js/ui/resizable.js ***!
      \****************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 57),
            stringUtils = __webpack_require__( /*! ../core/utils/string */ 18),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 12),
            translator = __webpack_require__( /*! ../animation/translator */ 69),
            fitIntoRange = __webpack_require__( /*! ../core/utils/math */ 87).fitIntoRange,
            DOMComponent = __webpack_require__( /*! ../core/dom_component */ 43),
            eventUtils = __webpack_require__( /*! ../events/utils */ 71),
            dragEvents = __webpack_require__( /*! ../events/drag */ 110),
            isPlainObject = typeUtils.isPlainObject,
            isFunction = commonUtils.isFunction;
        var RESIZABLE = "dxResizable",
            RESIZABLE_CLASS = "dx-resizable",
            RESIZABLE_RESIZING_CLASS = "dx-resizable-resizing",
            RESIZABLE_HANDLE_CLASS = "dx-resizable-handle",
            RESIZABLE_HANDLE_TOP_CLASS = "dx-resizable-handle-top",
            RESIZABLE_HANDLE_BOTTOM_CLASS = "dx-resizable-handle-bottom",
            RESIZABLE_HANDLE_LEFT_CLASS = "dx-resizable-handle-left",
            RESIZABLE_HANDLE_RIGHT_CLASS = "dx-resizable-handle-right",
            RESIZABLE_HANDLE_CORNER_CLASS = "dx-resizable-handle-corner",
            DRAGSTART_START_EVENT_NAME = eventUtils.addNamespace(dragEvents.start, RESIZABLE),
            DRAGSTART_EVENT_NAME = eventUtils.addNamespace(dragEvents.move, RESIZABLE),
            DRAGSTART_END_EVENT_NAME = eventUtils.addNamespace(dragEvents.end, RESIZABLE);
        var Resizable = DOMComponent.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    handles: "all",
                    step: "1",
                    stepPrecision: "simple",
                    area: void 0,
                    minWidth: 30,
                    maxWidth: 1 / 0,
                    minHeight: 30,
                    maxHeight: 1 / 0,
                    onResizeStart: null,
                    onResize: null,
                    onResizeEnd: null
                })
            },
            _init: function() {
                this.callBase();
                this.element().addClass(RESIZABLE_CLASS)
            },
            _render: function() {
                this.callBase();
                this._renderActions();
                this._renderHandles()
            },
            _renderActions: function() {
                this._resizeStartAction = this._createActionByOption("onResizeStart");
                this._resizeEndAction = this._createActionByOption("onResizeEnd");
                this._resizeAction = this._createActionByOption("onResize")
            },
            _renderHandles: function() {
                var handles = this.option("handles");
                if ("none" === handles) {
                    return
                }
                var directions = "all" === handles ? ["top", "bottom", "left", "right"] : handles.split(" ");
                $.each(directions, function(index, handleName) {
                    this._renderHandle(handleName)
                }.bind(this));
                inArray("bottom", directions) + 1 && inArray("right", directions) + 1 && this._renderHandle("corner-bottom-right");
                inArray("bottom", directions) + 1 && inArray("left", directions) + 1 && this._renderHandle("corner-bottom-left");
                inArray("top", directions) + 1 && inArray("right", directions) + 1 && this._renderHandle("corner-top-right");
                inArray("top", directions) + 1 && inArray("left", directions) + 1 && this._renderHandle("corner-top-left")
            },
            _renderHandle: function(handleName) {
                var $element = this.element(),
                    $handle = $("<div>");
                $handle.addClass(RESIZABLE_HANDLE_CLASS).addClass(RESIZABLE_HANDLE_CLASS + "-" + handleName).appendTo($element);
                this._attachEventHandlers($handle)
            },
            _attachEventHandlers: function($handle) {
                if (this.option("disabled")) {
                    return
                }
                var handlers = {};
                handlers[DRAGSTART_START_EVENT_NAME] = this._dragStartHandler.bind(this);
                handlers[DRAGSTART_EVENT_NAME] = this._dragHandler.bind(this);
                handlers[DRAGSTART_END_EVENT_NAME] = this._dragEndHandler.bind(this);
                $handle.on(handlers, {
                    direction: "both",
                    immediate: true
                })
            },
            _dragStartHandler: function(e) {
                var $element = this.element();
                if ($element.is(".dx-state-disabled, .dx-state-disabled *")) {
                    e.cancel = true;
                    return
                }
                this._toggleResizingClass(true);
                this._movingSides = this._getMovingSides(e);
                this._elementLocation = translator.locate($element);
                this._elementSize = {
                    width: $element.outerWidth(),
                    height: $element.outerHeight()
                };
                this._renderDragOffsets(e);
                this._resizeStartAction({
                    jQueryEvent: e,
                    width: this._elementSize.width,
                    height: this._elementSize.height,
                    handles: this._movingSides
                });
                e.targetElements = null
            },
            _toggleResizingClass: function(value) {
                this.element().toggleClass(RESIZABLE_RESIZING_CLASS, value)
            },
            _renderDragOffsets: function(e) {
                var area = this._getArea();
                if (!area) {
                    return
                }
                var $handle = $(e.target).closest("." + RESIZABLE_HANDLE_CLASS),
                    handleWidth = $handle.outerWidth(),
                    handleHeight = $handle.outerHeight(),
                    handleOffset = $handle.offset(),
                    areaOffset = area.offset;
                e.maxLeftOffset = handleOffset.left - areaOffset.left;
                e.maxRightOffset = areaOffset.left + area.width - handleOffset.left - handleWidth;
                e.maxTopOffset = handleOffset.top - areaOffset.top;
                e.maxBottomOffset = areaOffset.top + area.height - handleOffset.top - handleHeight
            },
            _getBorderWidth: function($element, direction) {
                if (commonUtils.isWindow($element.get(0))) {
                    return 0
                }
                var borderWidth = $element.css("border-" + direction + "-width");
                return parseInt(borderWidth) || 0
            },
            _dragHandler: function(e) {
                var $element = this.element(),
                    sides = this._movingSides;
                var location = this._elementLocation,
                    size = this._elementSize,
                    offset = this._getOffset(e);
                var width = size.width + offset.x * (sides.left ? -1 : 1),
                    height = size.height + offset.y * (sides.top ? -1 : 1);
                if (offset.x || "strict" === this.option("stepPrecision")) {
                    this._renderWidth(width)
                }
                if (offset.y || "strict" === this.option("stepPrecision")) {
                    this._renderHeight(height)
                }
                var offsetTop = offset.y - ((this.element().outerHeight() || height) - height),
                    offsetLeft = offset.x - ((this.element().outerWidth() || width) - width);
                translator.move($element, {
                    top: location.top + (sides.top ? offsetTop : 0),
                    left: location.left + (sides.left ? offsetLeft : 0)
                });
                this._resizeAction({
                    jQueryEvent: e,
                    width: this.option("width") || width,
                    height: this.option("height") || height,
                    handles: this._movingSides
                })
            },
            _getOffset: function(e) {
                var offset = e.offset,
                    steps = stringUtils.pairToObject(this.option("step")),
                    sides = this._getMovingSides(e),
                    strictPrecision = "strict" === this.option("stepPrecision");
                if (!sides.left && !sides.right) {
                    offset.x = 0
                }
                if (!sides.top && !sides.bottom) {
                    offset.y = 0
                }
                return strictPrecision ? this._getStrictOffset(offset, steps, sides) : this._getSimpleOffset(offset, steps)
            },
            _getSimpleOffset: function(offset, steps) {
                return {
                    x: offset.x - offset.x % steps.h,
                    y: offset.y - offset.y % steps.v
                }
            },
            _getStrictOffset: function(offset, steps, sides) {
                var location = this._elementLocation,
                    size = this._elementSize,
                    xPos = sides.left ? location.left : location.left + size.width,
                    yPos = sides.top ? location.top : location.top + size.height,
                    newXShift = (xPos + offset.x) % steps.h,
                    newYShift = (yPos + offset.y) % steps.v,
                    sign = Math.sign || function(x) {
                        x = +x;
                        if (0 === x || isNaN(x)) {
                            return x
                        }
                        return x > 0 ? 1 : -1
                    },
                    separatorOffset = function(steps, offset) {
                        return (1 + .2 * sign(offset)) % 1 * steps
                    },
                    isSmallOffset = function(offset, steps) {
                        return Math.abs(offset) < .2 * steps
                    };
                var newOffsetX = offset.x - newXShift,
                    newOffsetY = offset.y - newYShift;
                if (newXShift > separatorOffset(steps.h, offset.x)) {
                    newOffsetX += steps.h
                }
                if (newYShift > separatorOffset(steps.v, offset.y)) {
                    newOffsetY += steps.v
                }
                return {
                    x: (sides.left || sides.right) && !isSmallOffset(offset.x, steps.h) ? newOffsetX : 0,
                    y: (sides.top || sides.bottom) && !isSmallOffset(offset.y, steps.v) ? newOffsetY : 0
                }
            },
            _getMovingSides: function(e) {
                var $target = $(e.target),
                    hasCornerTopLeftClass = $target.hasClass(RESIZABLE_HANDLE_CORNER_CLASS + "-top-left"),
                    hasCornerTopRightClass = $target.hasClass(RESIZABLE_HANDLE_CORNER_CLASS + "-top-right"),
                    hasCornerBottomLeftClass = $target.hasClass(RESIZABLE_HANDLE_CORNER_CLASS + "-bottom-left"),
                    hasCornerBottomRightClass = $target.hasClass(RESIZABLE_HANDLE_CORNER_CLASS + "-bottom-right");
                return {
                    top: $target.hasClass(RESIZABLE_HANDLE_TOP_CLASS) || hasCornerTopLeftClass || hasCornerTopRightClass,
                    left: $target.hasClass(RESIZABLE_HANDLE_LEFT_CLASS) || hasCornerTopLeftClass || hasCornerBottomLeftClass,
                    bottom: $target.hasClass(RESIZABLE_HANDLE_BOTTOM_CLASS) || hasCornerBottomLeftClass || hasCornerBottomRightClass,
                    right: $target.hasClass(RESIZABLE_HANDLE_RIGHT_CLASS) || hasCornerTopRightClass || hasCornerBottomRightClass
                }
            },
            _getArea: function() {
                var area = this.option("area");
                if (isFunction(area)) {
                    area = area.call(this)
                }
                if (isPlainObject(area)) {
                    return this._getAreaFromObject(area)
                }
                return this._getAreaFromElement(area)
            },
            _getAreaFromObject: function(area) {
                var result = {
                    width: area.right - area.left,
                    height: area.bottom - area.top,
                    offset: {
                        left: area.left,
                        top: area.top
                    }
                };
                this._correctAreaGeometry(result);
                return result
            },
            _getAreaFromElement: function(area) {
                var result, $area = $(area);
                if ($area.length) {
                    result = {
                        width: $area.innerWidth(),
                        height: $area.innerHeight(),
                        offset: extend({
                            top: 0,
                            left: 0
                        }, commonUtils.isWindow($area[0]) ? {} : $area.offset())
                    };
                    this._correctAreaGeometry(result, $area)
                }
                return result
            },
            _correctAreaGeometry: function(result, $area) {
                var areaBorderLeft = $area ? this._getBorderWidth($area, "left") : 0,
                    areaBorderTop = $area ? this._getBorderWidth($area, "top") : 0;
                result.offset.left += areaBorderLeft + this._getBorderWidth(this.element(), "left");
                result.offset.top += areaBorderTop + this._getBorderWidth(this.element(), "top");
                result.width -= this.element().outerWidth() - this.element().innerWidth();
                result.height -= this.element().outerHeight() - this.element().innerHeight()
            },
            _dragEndHandler: function(e) {
                var $element = this.element();
                this._resizeEndAction({
                    jQueryEvent: e,
                    width: $element.outerWidth(),
                    height: $element.outerHeight(),
                    handles: this._movingSides
                });
                this._toggleResizingClass(false)
            },
            _renderWidth: function(width) {
                this.option("width", fitIntoRange(width, this.option("minWidth"), this.option("maxWidth")))
            },
            _renderHeight: function(height) {
                this.option("height", fitIntoRange(height, this.option("minHeight"), this.option("maxHeight")))
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                    case "handles":
                        this._invalidate();
                        break;
                    case "minWidth":
                    case "maxWidth":
                        this._renderWidth(this.element().outerWidth());
                        break;
                    case "minHeight":
                    case "maxHeight":
                        this._renderHeight(this.element().outerHeight());
                        break;
                    case "onResize":
                    case "onResizeStart":
                    case "onResizeEnd":
                        this._renderActions();
                        break;
                    case "area":
                    case "stepPrecision":
                    case "step":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                this.element().find("." + RESIZABLE_HANDLE_CLASS).remove()
            }
        });
        registerComponent(RESIZABLE, Resizable);
        module.exports = Resizable
    },
    /*!*********************************!*\
      !*** ./js/core/utils/locker.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 7);
        var Locker = function() {
            var info = {};
            var currentCount = function(lockName) {
                return info[lockName] || 0
            };
            return {
                obtain: function(lockName) {
                    info[lockName] = currentCount(lockName) + 1
                },
                release: function(lockName) {
                    var count = currentCount(lockName);
                    if (count < 1) {
                        throw errors.Error("E0014")
                    }
                    if (1 === count) {
                        delete info[lockName]
                    } else {
                        info[lockName] = count - 1
                    }
                },
                locked: function(lockName) {
                    return currentCount(lockName) > 0
                }
            }
        };
        module.exports = Locker
    },
    /*!******************************************************!*\
      !*** ./js/integration/knockout/event_registrator.js ***!
      \******************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            ko = __webpack_require__( /*! knockout */ 93),
            isPlainObject = __webpack_require__( /*! ../../core/utils/type */ 12).isPlainObject,
            eventRegistrator = __webpack_require__( /*! ../../events/core/event_registrator */ 73),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 71);
        eventRegistrator.callbacks.add(function(name) {
            var koBindingEventName = eventUtils.addNamespace(name, name + "Binding");
            ko.bindingHandlers[name] = {
                update: function(element, valueAccessor, allBindingsAccessor, viewModel) {
                    var $element = $(element),
                        unwrappedValue = ko.utils.unwrapObservable(valueAccessor()),
                        eventSource = unwrappedValue.execute ? unwrappedValue.execute : unwrappedValue;
                    $element.off(koBindingEventName).on(koBindingEventName, isPlainObject(unwrappedValue) ? unwrappedValue : {}, function(e) {
                        eventSource.call(viewModel, viewModel, e)
                    })
                }
            }
        })
    },
    /*!***********************************************!*\
      !*** ./js/integration/knockout/components.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Action = __webpack_require__( /*! ../../core/action */ 49),
            compileGetter = __webpack_require__( /*! ../../core/utils/data */ 50).compileGetter,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            ko = __webpack_require__( /*! knockout */ 93),
            iconUtils = __webpack_require__( /*! ../../core/utils/icon */ 115),
            clickEvent = __webpack_require__( /*! ../../events/click */ 75);
        ko.bindingHandlers.dxAction = {
            update: function(element, valueAccessor, allBindingsAccessor, viewModel) {
                var $element = $(element);
                var unwrappedValue = ko.utils.unwrapObservable(valueAccessor()),
                    actionSource = unwrappedValue,
                    actionOptions = {
                        context: element
                    };
                if (unwrappedValue.execute) {
                    actionSource = unwrappedValue.execute;
                    extend(actionOptions, unwrappedValue)
                }
                var action = new Action(actionSource, actionOptions);
                $element.off(".dxActionBinding").on(clickEvent.name + ".dxActionBinding", function(e) {
                    action.execute({
                        element: $element,
                        model: viewModel,
                        evaluate: function(expression) {
                            var context = viewModel;
                            if (expression.length > 0 && "$" === expression[0]) {
                                context = ko.contextFor(element)
                            }
                            var getter = compileGetter(expression);
                            return getter(context)
                        },
                        jQueryEvent: e
                    });
                    if (!actionOptions.bubbling) {
                        e.stopPropagation()
                    }
                })
            }
        };
        ko.bindingHandlers.dxControlsDescendantBindings = {
            init: function(_, valueAccessor) {
                return {
                    controlsDescendantBindings: ko.unwrap(valueAccessor())
                }
            }
        };
        ko.bindingHandlers.dxIcon = {
            init: function(element, valueAccessor) {
                var options = ko.utils.unwrapObservable(valueAccessor()) || {},
                    iconElement = iconUtils.getImageContainer(options);
                ko.virtualElements.emptyNode(element);
                if (iconElement) {
                    ko.virtualElements.prepend(element, iconElement.get(0))
                }
            },
            update: function(element, valueAccessor) {
                var options = ko.utils.unwrapObservable(valueAccessor()) || {},
                    iconElement = iconUtils.getImageContainer(options);
                ko.virtualElements.emptyNode(element);
                if (iconElement) {
                    ko.virtualElements.prepend(element, iconElement.get(0))
                }
            }
        };
        ko.virtualElements.allowedBindings.dxIcon = true
    },
    /*!*******************************!*\
      !*** ./js/core/utils/icon.js ***!
      \*******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9);
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/data:.*base64|\.|\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            return "fontIcon"
        };
        var getImageContainer = function(source) {
            var imageType = getImageSourceType(source),
                ICON_CLASS = "dx-icon";
            switch (imageType) {
                case "image":
                    return $("<img>", {
                        src: source
                    }).addClass(ICON_CLASS);
                case "fontIcon":
                    return $("<i>", {
                        "class": ICON_CLASS + " " + source
                    });
                case "dxIcon":
                    return $("<i>", {
                        "class": ICON_CLASS + " " + ICON_CLASS + "-" + source
                    });
                default:
                    return null
            }
        };
        exports.getImageSourceType = getImageSourceType;
        exports.getImageContainer = getImageContainer
    },
    /*!***********************************************!*\
      !*** ./js/integration/knockout/validation.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 51),
            ValidationEngine = __webpack_require__( /*! ../../ui/validation_engine */ 117),
            ko = __webpack_require__( /*! knockout */ 93);
        var koDxValidator = Class.inherit({
            ctor: function(target, option) {
                var that = this;
                that.target = target;
                that.validationRules = option.validationRules;
                that.name = option.name;
                that.isValid = ko.observable(true);
                that.validationError = ko.observable();
                $.each(this.validationRules, function(_, rule) {
                    rule.validator = that
                })
            },
            validate: function() {
                var result = ValidationEngine.validate(this.target(), this.validationRules, this.name);
                this._applyValidationResult(result);
                return result
            },
            reset: function() {
                this.target(null);
                var result = {
                    isValid: true,
                    brokenRule: null
                };
                this._applyValidationResult(result);
                return result
            },
            _applyValidationResult: function(result) {
                result.validator = this;
                this.target.dxValidator.isValid(result.isValid);
                this.target.dxValidator.validationError(result.brokenRule);
                this.fireEvent("validated", [result])
            }
        }).include(EventsMixin);
        ko.extenders.dxValidator = function(target, option) {
            target.dxValidator = new koDxValidator(target, option);
            target.subscribe(target.dxValidator.validate.bind(target.dxValidator));
            return target
        };
        ValidationEngine.registerModelForValidation = function(model) {
            $.each(model, function(name, member) {
                if (ko.isObservable(member) && member.dxValidator) {
                    ValidationEngine.registerValidatorInGroup(model, member.dxValidator)
                }
            })
        };
        ValidationEngine.unregisterModelForValidation = function(model) {
            $.each(model, function(name, member) {
                if (ko.isObservable(member) && member.dxValidator) {
                    ValidationEngine.removeRegisteredValidator(model, member.dxValidator)
                }
            })
        };
        ValidationEngine.validateModel = ValidationEngine.validateGroup
    },
    /*!************************************!*\
      !*** ./js/ui/validation_engine.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            Class = __webpack_require__( /*! ../core/class */ 25),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 51),
            errors = __webpack_require__( /*! ../core/errors */ 7),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            numberLocalization = __webpack_require__( /*! ../localization/number */ 32),
            messageLocalization = __webpack_require__( /*! ../localization/message */ 89);
        var BaseRuleValidator = Class.inherit({
            NAME: "base",
            defaultMessage: function(value) {
                return messageLocalization.getFormatter("validation-" + this.NAME)(value)
            },
            defaultFormattedMessage: function(value) {
                return messageLocalization.getFormatter("validation-" + this.NAME + "-formatted")(value)
            },
            validate: function(value, rule) {
                var valueArray = Array.isArray(value) ? value : [value],
                    result = true;
                if (valueArray.length) {
                    valueArray.every(function(itemValue) {
                        result = this._validate(itemValue, rule);
                        return result
                    }, this)
                } else {
                    result = this._validate(null, rule)
                }
                return result
            }
        });
        var RequiredRuleValidator = BaseRuleValidator.inherit({
            NAME: "required",
            _validate: function(value, rule) {
                if (!commonUtils.isDefined(value)) {
                    return false
                }
                if (false === value) {
                    return false
                }
                value = String(value);
                if (rule.trim || !commonUtils.isDefined(rule.trim)) {
                    value = $.trim(value)
                }
                return "" !== value
            }
        });
        var NumericRuleValidator = BaseRuleValidator.inherit({
            NAME: "numeric",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                if (rule.useCultureSettings && commonUtils.isString(value)) {
                    return !isNaN(numberLocalization.parse(value))
                } else {
                    return commonUtils.isNumeric(value)
                }
            }
        });
        var RangeRuleValidator = BaseRuleValidator.inherit({
            NAME: "range",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                var validNumber = rulesValidators.numeric.validate(value, rule),
                    validValue = commonUtils.isDefined(value),
                    number = validNumber ? parseFloat(value) : validValue && value.valueOf(),
                    min = rule.min,
                    max = rule.max;
                if (!(validNumber || commonUtils.isDate(value)) && !validValue) {
                    return false
                }
                if (commonUtils.isDefined(min)) {
                    if (commonUtils.isDefined(max)) {
                        return number >= min && number <= max
                    }
                    return number >= min
                } else {
                    if (commonUtils.isDefined(max)) {
                        return number <= max
                    } else {
                        throw errors.Error("E0101")
                    }
                }
            }
        });
        var StringLengthRuleValidator = BaseRuleValidator.inherit({
            NAME: "stringLength",
            _validate: function(value, rule) {
                value = commonUtils.isDefined(value) ? String(value) : "";
                if (rule.trim || !commonUtils.isDefined(rule.trim)) {
                    value = $.trim(value)
                }
                return rulesValidators.range.validate(value.length, extend({}, rule))
            }
        });
        var CustomRuleValidator = BaseRuleValidator.inherit({
            NAME: "custom",
            validate: function(value, rule) {
                return rule.validationCallback({
                    value: value,
                    validator: rule.validator,
                    rule: rule
                })
            }
        });
        var CompareRuleValidator = BaseRuleValidator.inherit({
            NAME: "compare",
            _validate: function(value, rule) {
                if (!rule.comparisonTarget) {
                    throw errors.Error("E0102")
                }
                extend(rule, {
                    reevaluate: true
                });
                var otherValue = rule.comparisonTarget(),
                    type = rule.comparisonType || "==";
                switch (type) {
                    case "==":
                        return value == otherValue;
                    case "!=":
                        return value != otherValue;
                    case "===":
                        return value === otherValue;
                    case "!==":
                        return value !== otherValue;
                    case ">":
                        return value > otherValue;
                    case ">=":
                        return value >= otherValue;
                    case "<":
                        return value < otherValue;
                    case "<=":
                        return value <= otherValue
                }
            }
        });
        var PatternRuleValidator = BaseRuleValidator.inherit({
            NAME: "pattern",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                var pattern = rule.pattern;
                if (commonUtils.isString(pattern)) {
                    pattern = new RegExp(pattern)
                }
                return pattern.test(value)
            }
        });
        var EmailRuleValidator = BaseRuleValidator.inherit({
            NAME: "email",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                return rulesValidators.pattern.validate(value, extend({}, rule, {
                    pattern: /^[\d\w\._\-]+@([\d\w\._\-]+\.)+[\w]+$/i
                }))
            }
        });
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = Class.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = []
            },
            validate: function() {
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: []
                };
                $.each(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRule) {
                        result.brokenRules.push(validatorResult.brokenRule)
                    }
                    result.validators.push(validator)
                });
                this.fireEvent("validated", [{
                    validators: result.validators,
                    brokenRules: result.brokenRules,
                    isValid: result.isValid
                }]);
                return result
            },
            reset: function() {
                $.each(this.validators, function(_, validator) {
                    validator.reset()
                })
            }
        }).include(EventsMixin);
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = commonUtils.grep(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group),
                    index = inArray(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(rule, validator, name) {
                if (!commonUtils.isDefined(rule.message)) {
                    if (validator.defaultFormattedMessage && commonUtils.isDefined(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            validate: function(value, rules, name) {
                var result = {
                        name: name,
                        value: value,
                        brokenRule: null,
                        isValid: true,
                        validationRules: rules
                    },
                    that = this;
                $.each(rules || [], function(_, rule) {
                    var ruleValidationResult, ruleValidator = rulesValidators[rule.type];
                    if (ruleValidator) {
                        if (commonUtils.isDefined(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                result.brokenRule = rule;
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            that._setDefaultMessage(rule, ruleValidator, name);
                            result.brokenRule = rule
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw errors.Error("E0100")
                    }
                });
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                if (inArray(validator, groupConfig.validators) < 0) {
                    groupConfig.validators.push(validator)
                }
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group,
                    isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group),
                    validatorsInGroup = config && config.validators;
                var index = inArray(validator, validatorsInGroup);
                if (index > -1) {
                    validatorsInGroup.splice(index, 1);
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw errors.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw errors.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        module.exports = ValidationEngine
    },
    /*!***********************************************************!*\
      !*** ./js/integration/knockout/variable_wrapper_utils.js ***!
      \***********************************************************/
    function(module, exports, __webpack_require__) {
        var ko = __webpack_require__( /*! knockout */ 93),
            variableWrapper = __webpack_require__( /*! ../../core/utils/variable_wrapper */ 28);
        variableWrapper.inject({
            isWrapped: ko.isObservable,
            isWritableWrapped: ko.isWritableObservable,
            wrap: ko.observable,
            unwrap: function(value) {
                if (ko.isObservable(value)) {
                    return ko.utils.unwrapObservable(value)
                }
                return this.callBase(value)
            },
            assign: function(variable, value) {
                if (ko.isObservable(variable)) {
                    variable(value)
                } else {
                    this.callBase(variable, value)
                }
            }
        })
    },
    /*!***********************************************!*\
      !*** ./js/integration/knockout/clean_node.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! jquery */ 10),
            ko = __webpack_require__( /*! knockout */ 93),
            cleanData = $.cleanData,
            compareVersion = __webpack_require__( /*! ../../core/utils/version */ 17).compare;
        if (compareVersion($.fn.jquery, [2, 0]) >= 0) {
            $.cleanData = function(nodes) {
                var result = cleanData(nodes);
                for (var i = 0; i < nodes.length; i++) {
                    nodes[i].cleanedByJquery = true
                }
                for (i = 0; i < nodes.length; i++) {
                    if (!nodes[i].cleanedByKo) {
                        ko.cleanNode(nodes[i])
                    }
                    delete nodes[i].cleanedByKo
                }
                for (i = 0; i < nodes.length; i++) {
                    delete nodes[i].cleanedByJquery
                }
                return result
            };
            ko.utils.domNodeDisposal.cleanExternalData = function(node) {
                node.cleanedByKo = true;
                if (!node.cleanedByJquery) {
                    $.cleanData([node])
                }
            }
        }
    },
    /*!***************************************************!*\
      !*** ./js/integration/knockout/clean_node_old.js ***!
      \***************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            ko = __webpack_require__( /*! knockout */ 93),
            compareVersion = __webpack_require__( /*! ../../core/utils/version */ 17).compare;
        if (compareVersion($.fn.jquery, [2, 0]) < 0) {
            var cleanKoData = function(element, andSelf) {
                var cleanNode = function() {
                    ko.cleanNode(this)
                };
                if (andSelf) {
                    element.each(cleanNode)
                } else {
                    element.find("*").each(cleanNode)
                }
            };
            var originalEmpty = $.fn.empty;
            $.fn.empty = function() {
                cleanKoData(this, false);
                return originalEmpty.apply(this, arguments)
            };
            var originalRemove = $.fn.remove;
            $.fn.remove = function(selector, keepData) {
                if (!keepData) {
                    var subject = this;
                    if (selector) {
                        subject = subject.filter(selector)
                    }
                    cleanKoData(subject, true)
                }
                return originalRemove.call(this, selector, keepData)
            };
            var originalHtml = $.fn.html;
            $.fn.html = function(value) {
                if ("string" === typeof value) {
                    cleanKoData(this, false)
                }
                return originalHtml.apply(this, arguments)
            };
            var originalReplaceWith = $.fn.replaceWith;
            $.fn.replaceWith = function() {
                var result = originalReplaceWith.apply(this, arguments);
                if (!this.parent().length) {
                    cleanKoData(this, true)
                }
                return result
            }
        }
    },
    /*!*********************************!*\
      !*** ./js/framework/command.js ***!
      \*********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            errors = __webpack_require__( /*! ./errors */ 122),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 12),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 57),
            DOMComponent = __webpack_require__( /*! ../core/dom_component */ 43),
            isFunction = commonUtils.isFunction,
            isPlainObject = typeUtils.isPlainObject,
            noop = commonUtils.noop;
        __webpack_require__( /*! ../integration/knockout */ 92);
        var Command = DOMComponent.inherit({
            ctor: function(element, options) {
                if (isPlainObject(element)) {
                    options = element;
                    element = $("<div />")
                }
                this.callBase(element, options)
            },
            _setDeprecatedOptions: function() {
                this.callBase();
                extend(this._deprecatedOptions, {
                    iconSrc: {
                        since: "15.1",
                        alias: "icon"
                    }
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    onExecute: null,
                    id: null,
                    title: "",
                    icon: "",
                    visible: true,
                    disabled: false,
                    renderStage: "onViewShown"
                })
            },
            execute: function() {
                var isDisabled = this._options.disabled;
                if (isFunction(isDisabled)) {
                    isDisabled = !!isDisabled.apply(this, arguments)
                }
                if (isDisabled) {
                    throw errors.Error("E3004", this._options.id)
                }
                this.fireEvent("beforeExecute", arguments);
                this._createActionByOption("onExecute").apply(this, arguments);
                this.fireEvent("afterExecute", arguments)
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-command")
            },
            _renderDisabledState: noop,
            _dispose: function() {
                this.callBase();
                this.element().removeData(this.NAME)
            }
        });
        registerComponent("dxCommand", Command);
        module.exports = Command
    },
    /*!********************************!*\
      !*** ./js/framework/errors.js ***!
      \********************************/
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../core/utils/error */ 8),
            errors = __webpack_require__( /*! ../core/errors */ 7);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E3001: "Routing rule is not found for the '{0}' URI.",
            E3002: "The passed object cannot be formatted into a URI string by the application's router. An appropriate route should be registered.",
            E3003: "Unable to navigate. Application is being initialized.",
            E3004: "Cannot execute the command: {0}.",
            E3005: "The '{0}' command {1} is not registered in the application's command mapping. Go to http://dxpr.es/1bTjfj1 for more details.",
            E3006: "Unknown navigation target: '{0}'. Use the 'current', 'back' or 'blank' values.",
            E3007: "Error while restoring the application state. The state has been cleared. Refresh the page.",
            E3008: "Unable to go back.",
            E3009: "Unable to go forward.",
            E3010: "The command's 'id' option should be specified.\r\nProcessed markup: {0}\n",
            E3011: "Layout controller cannot be resolved. There are no appropriate layout controllers for the current context. Check browser console for details.",
            E3012: "Layout controller cannot be resolved. Two or more layout controllers suit the current context. Check browser console for details.",
            E3013: "The '{0}' template with the '{1}' name is not found. Make sure the case is correct in the specified view name and the template fits the current context.",
            E3014: "All the children of the dxView element should be either of the dxCommand or dxContent type.\r\nProcessed markup: {0}",
            E3015: "The 'exec' method should be called before the 'finalize' method.",
            E3016: "Unknown transition type '{0}'.",
            E3018: "Unable to parse options.\nMessage: {0};\nOptions value: {1}.",
            E3019: "View templates should be updated according to the 13.1 changes. Go to http://dxpr.es/15ikrJA for more details.",
            E3020: "Concurrent templates are found:\r\n{0}Target device:\r\n{1}.",
            E3021: "Remote template cannot be loaded.\r\nUrl:{0}\r\nError:{1}.",
            E3022: "Cannot initialize the HtmlApplication component.",
            E3023: "Navigation item is not found",
            E3024: "Layout controller is not initialized",
            W3001: "A view with the '{0}' key doesn't exist.",
            W3002: "A view with the '{0}' key has already been released.",
            W3003: "Layout resolving context:\n{0}\nAvailable layout controller registrations:\n{1}\n",
            W3004: "Layout resolving context:\n{0}\nConcurent layout controller registrations for the context:\n{1}\n",
            W3005: 'Direct hash-based navigation is detected in a mobile application. Use data-bind="dxAction: url" instead of href="#url" to avoid navigation issues.\nFound markup:\n{0}\n'
        })
    },
    /*!********************************!*\
      !*** ./js/framework/router.js ***!
      \********************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 12),
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            Class = __webpack_require__( /*! ../core/class */ 25);
        var JSON_URI_PREFIX = encodeURIComponent("json:");
        var Route = Class.inherit({
            _trimSeparators: function(str) {
                return str.replace(/^[\/.]+|\/+$/g, "")
            },
            _escapeRe: function(str) {
                return str.replace(/[^-\w]/g, "\\$1")
            },
            _checkConstraint: function(param, constraint) {
                param = String(param);
                if ("string" === typeof constraint) {
                    constraint = new RegExp(constraint)
                }
                var match = constraint.exec(param);
                if (!match || match[0] !== param) {
                    return false
                }
                return true
            },
            _ensureReady: function() {
                var that = this;
                if (this._patternRe) {
                    return false
                }
                this._pattern = this._trimSeparators(this._pattern);
                this._patternRe = "";
                this._params = [];
                this._segments = [];
                this._separators = [];
                this._pattern.replace(/[^\/]+/g, function(segment, index) {
                    that._segments.push(segment);
                    if (index) {
                        that._separators.push(that._pattern.substr(index - 1, 1))
                    }
                });
                $.each(this._segments, function(index) {
                    var segment = this,
                        separator = index ? that._separators[index - 1] : "";
                    if (":" === segment.charAt(0)) {
                        segment = segment.substr(1);
                        that._params.push(segment);
                        that._patternRe += "(?:" + separator + "([^/]*))";
                        if (segment in that._defaults) {
                            that._patternRe += "?"
                        }
                    } else {
                        that._patternRe += separator + that._escapeRe(segment)
                    }
                });
                this._patternRe = new RegExp("^" + this._patternRe + "$")
            },
            ctor: function(pattern, defaults, constraints) {
                this._pattern = pattern || "";
                this._defaults = defaults || {};
                this._constraints = constraints || {}
            },
            parse: function(uri) {
                var that = this;
                this._ensureReady();
                var matches = this._patternRe.exec(uri);
                if (!matches) {
                    return false
                }
                var result = extend({}, this._defaults);
                $.each(this._params, function(i) {
                    var index = i + 1;
                    if (matches.length >= index && matches[index]) {
                        result[this] = that.parseSegment(matches[index])
                    }
                });
                $.each(this._constraints, function(key) {
                    if (!that._checkConstraint(result[key], that._constraints[key])) {
                        result = false;
                        return false
                    }
                });
                return result
            },
            format: function(routeValues) {
                var that = this,
                    query = "";
                this._ensureReady();
                var mergeValues = extend({}, this._defaults),
                    useStatic = 0,
                    result = [],
                    dels = [],
                    unusedRouteValues = {};
                $.each(routeValues, function(paramName, paramValue) {
                    routeValues[paramName] = that.formatSegment(paramValue);
                    if (!(paramName in mergeValues)) {
                        unusedRouteValues[paramName] = true
                    }
                });
                $.each(this._segments, function(index, segment) {
                    result[index] = index ? that._separators[index - 1] : "";
                    if (":" === segment.charAt(0)) {
                        var paramName = segment.substr(1);
                        if (!(paramName in routeValues) && !(paramName in that._defaults)) {
                            result = null;
                            return false
                        }
                        if (paramName in that._constraints && !that._checkConstraint(routeValues[paramName], that._constraints[paramName])) {
                            result = null;
                            return false
                        }
                        if (paramName in routeValues) {
                            if (void 0 !== routeValues[paramName]) {
                                mergeValues[paramName] = routeValues[paramName];
                                result[index] += routeValues[paramName];
                                useStatic = index
                            }
                            delete unusedRouteValues[paramName]
                        } else {
                            if (paramName in mergeValues) {
                                result[index] += mergeValues[paramName];
                                dels.push(index)
                            }
                        }
                    } else {
                        result[index] += segment;
                        useStatic = index
                    }
                });
                $.each(mergeValues, function(key, value) {
                    if (!!value && inArray(":" + key, that._segments) === -1 && routeValues[key] !== value) {
                        result = null;
                        return false
                    }
                });
                var unusedCount = 0;
                if (!typeUtils.isEmptyObject(unusedRouteValues)) {
                    query = "?";
                    $.each(unusedRouteValues, function(key) {
                        query += key + "=" + routeValues[key] + "&";
                        unusedCount++
                    });
                    query = query.substr(0, query.length - 1)
                }
                if (null === result) {
                    return false
                }
                if (dels.length) {
                    $.map(dels, function(i) {
                        if (i >= useStatic) {
                            result[i] = ""
                        }
                    })
                }
                var path = result.join("");
                path = path.replace(/\/+$/, "");
                return {
                    uri: path + query,
                    unusedCount: unusedCount
                }
            },
            formatSegment: function(value) {
                if (Array.isArray(value) || typeUtils.isPlainObject(value)) {
                    return JSON_URI_PREFIX + encodeURIComponent(JSON.stringify(value))
                }
                return encodeURIComponent(value)
            },
            parseSegment: function(value) {
                if (value.substr(0, JSON_URI_PREFIX.length) === JSON_URI_PREFIX) {
                    try {
                        return JSON.parse(decodeURIComponent(value.substr(JSON_URI_PREFIX.length)))
                    } catch (x) {}
                }
                return decodeURIComponent(value)
            }
        });
        var Router = Class.inherit({
            ctor: function() {
                this._registry = []
            },
            _trimSeparators: function(str) {
                return str.replace(/^[\/.]+|\/+$/g, "")
            },
            _createRoute: function(pattern, defaults, constraints) {
                return new Route(pattern, defaults, constraints)
            },
            register: function(pattern, defaults, constraints) {
                this._registry.push(this._createRoute(pattern, defaults, constraints))
            },
            _parseQuery: function(query) {
                var result = {},
                    values = query.split("&");
                $.each(values, function(index, value) {
                    var keyValuePair = value.split("=");
                    result[keyValuePair[0]] = decodeURIComponent(keyValuePair[1])
                });
                return result
            },
            parse: function(uri) {
                var result, that = this;
                uri = this._trimSeparators(uri);
                var parts = uri.split("?", 2),
                    path = parts[0],
                    query = parts[1];
                $.each(this._registry, function() {
                    var parseResult = this.parse(path);
                    if (false !== parseResult) {
                        result = parseResult;
                        if (query) {
                            result = extend(result, that._parseQuery(query))
                        }
                        return false
                    }
                });
                return result ? result : false
            },
            format: function(obj) {
                var result = false,
                    minUnusedCount = 99999;
                obj = obj || {};
                $.each(this._registry, function() {
                    var toFormat = extend(true, {}, obj);
                    var formatResult = this.format(toFormat);
                    if (false !== formatResult) {
                        if (minUnusedCount > formatResult.unusedCount) {
                            minUnusedCount = formatResult.unusedCount;
                            result = formatResult.uri
                        }
                    }
                });
                return result
            }
        });
        Route.__internals = {
            JSON_URI_PREFIX: JSON_URI_PREFIX
        };
        module.exports = Router;
        module.exports.Route = Route
    },
    /*!***************************************!*\
      !*** ./js/framework/state_manager.js ***!
      \***************************************/
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 25),
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            $ = __webpack_require__( /*! ../core/renderer */ 9);
        var MemoryKeyValueStorage = Class.inherit({
            ctor: function() {
                this.storage = {}
            },
            getItem: function(key) {
                return this.storage[key]
            },
            setItem: function(key, value) {
                this.storage[key] = value
            },
            removeItem: function(key) {
                delete this.storage[key]
            }
        });
        var StateManager = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this.storage = options.storage || new MemoryKeyValueStorage;
                this.stateSources = options.stateSources || []
            },
            addStateSource: function(stateSource) {
                this.stateSources.push(stateSource)
            },
            removeStateSource: function(stateSource) {
                var index = inArray(stateSource, this.stateSources);
                if (index > -1) {
                    this.stateSources.splice(index, 1);
                    stateSource.removeState(this.storage)
                }
            },
            saveState: function() {
                var that = this;
                $.each(this.stateSources, function(index, stateSource) {
                    stateSource.saveState(that.storage)
                })
            },
            restoreState: function() {
                var that = this;
                $.each(this.stateSources, function(index, stateSource) {
                    stateSource.restoreState(that.storage)
                })
            },
            clearState: function() {
                var that = this;
                $.each(this.stateSources, function(index, stateSource) {
                    stateSource.removeState(that.storage)
                })
            }
        });
        module.exports = StateManager;
        module.exports.MemoryKeyValueStorage = MemoryKeyValueStorage
    },
    /*!************************************!*\
      !*** ./js/framework/view_cache.js ***!
      \************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            Class = __webpack_require__( /*! ../core/class */ 25),
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 51);
        var ViewCache = Class.inherit({
            ctor: function() {
                this._cache = {}
            },
            setView: function(key, viewInfo) {
                this._cache[key] = viewInfo
            },
            getView: function(key) {
                return this._cache[key]
            },
            removeView: function(key) {
                var result = this._cache[key];
                if (result) {
                    delete this._cache[key];
                    this.fireEvent("viewRemoved", [{
                        viewInfo: result
                    }])
                }
                return result
            },
            clear: function() {
                var that = this;
                $.each(this._cache, function(key) {
                    that.removeView(key)
                })
            },
            hasView: function(key) {
                return key in this._cache
            }
        }).include(EventsMixin);
        var NullViewCache = ViewCache.inherit({
            setView: function(key, viewInfo) {
                this.callBase(key, viewInfo);
                this.removeView(key)
            }
        });

        function delegateEvent(eventName, source, target) {
            source.on(eventName, function() {
                target.fireEvent(eventName, arguments)
            })
        }
        var ConditionalViewCacheDecorator = Class.inherit({
            ctor: function(options) {
                this._filter = options.filter;
                this._viewCache = options.viewCache;
                this.viewRemoved = this._viewCache.viewRemoved;
                delegateEvent("viewRemoved", this._viewCache, this)
            },
            setView: function(key, viewInfo) {
                this._viewCache.setView(key, viewInfo);
                if (!this._filter(key, viewInfo)) {
                    this._viewCache.removeView(key)
                }
            },
            getView: function(key) {
                return this._viewCache.getView(key)
            },
            removeView: function(key) {
                return this._viewCache.removeView(key)
            },
            clear: function() {
                return this._viewCache.clear()
            },
            hasView: function(key) {
                return this._viewCache.hasView(key)
            }
        }).include(EventsMixin);
        var DEFAULT_VIEW_CACHE_CAPACITY = 5;
        var CapacityViewCacheDecorator = Class.inherit({
            ctor: function(options) {
                this._keys = [];
                this._size = options.size || DEFAULT_VIEW_CACHE_CAPACITY;
                this._viewCache = options.viewCache;
                this.viewRemoved = this._viewCache.viewRemoved;
                delegateEvent("viewRemoved", this._viewCache, this)
            },
            setView: function(key, viewInfo) {
                if (!this.hasView(key)) {
                    if (this._keys.length === this._size) {
                        this.removeView(this._keys[0])
                    }
                    this._keys.push(key)
                }
                this._viewCache.setView(key, viewInfo)
            },
            getView: function(key) {
                var index = inArray(key, this._keys);
                if (index < 0) {
                    return null
                }
                this._keys.push(key);
                this._keys.splice(index, 1);
                return this._viewCache.getView(key)
            },
            removeView: function(key) {
                var index = inArray(key, this._keys);
                if (index > -1) {
                    this._keys.splice(index, 1)
                }
                return this._viewCache.removeView(key)
            },
            clear: function() {
                this._keys = [];
                return this._viewCache.clear()
            },
            hasView: function(key) {
                return this._viewCache.hasView(key)
            }
        }).include(EventsMixin);
        var HistoryDependentViewCacheDecorator = Class.inherit({
            ctor: function(options) {
                this._viewCache = options.viewCache || new ViewCache;
                this._navigationManager = options.navigationManager;
                this._navigationManager.on("itemRemoved", this._onNavigationItemRemoved.bind(this));
                this.viewRemoved = this._viewCache.viewRemoved;
                delegateEvent("viewRemoved", this._viewCache, this)
            },
            _onNavigationItemRemoved: function(item) {
                this.removeView(item.key)
            },
            setView: function(key, viewInfo) {
                this._viewCache.setView(key, viewInfo)
            },
            getView: function(key) {
                return this._viewCache.getView(key)
            },
            removeView: function(key) {
                return this._viewCache.removeView(key)
            },
            clear: function() {
                return this._viewCache.clear()
            },
            hasView: function(key) {
                return this._viewCache.hasView(key)
            }
        }).include(EventsMixin);
        module.exports = ViewCache;
        module.exports.NullViewCache = NullViewCache;
        module.exports.ConditionalViewCacheDecorator = ConditionalViewCacheDecorator;
        module.exports.CapacityViewCacheDecorator = CapacityViewCacheDecorator;
        module.exports.HistoryDependentViewCacheDecorator = HistoryDependentViewCacheDecorator
    },
    /*!************************************************!*\
      !*** ./js/framework/html/command_container.js ***!
      \************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            MarkupComponent = __webpack_require__( /*! ./markup_component */ 127).MarkupComponent,
            isPlainObject = __webpack_require__( /*! ../../core/utils/type */ 12).isPlainObject,
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 57);
        __webpack_require__( /*! ../../integration/knockout */ 92);
        var CommandContainer = MarkupComponent.inherit({
            ctor: function(element, options) {
                if (isPlainObject(element)) {
                    options = element;
                    element = $("<div />")
                }
                this.callBase(element, options)
            },
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    id: null
                })
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-command-container")
            }
        });
        registerComponent("dxCommandContainer", CommandContainer);
        module.exports = CommandContainer
    },
    /*!***********************************************!*\
      !*** ./js/framework/html/markup_component.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            noop = __webpack_require__( /*! ../../core/utils/common */ 14).noop,
            publicComponentUtils = __webpack_require__( /*! ../../core/utils/public_component */ 45);
        var MarkupComponent = Class.inherit({
            ctor: function(element, options) {
                this.NAME = publicComponentUtils.name(this.constructor);
                options = options || {};
                this._$element = $(element);
                publicComponentUtils.attachInstanceToElement(this._$element, this, this._dispose);
                if (options.fromCache) {
                    this._options = options
                } else {
                    this._options = {};
                    this._setDefaultOptions();
                    if (options) {
                        this.option(options)
                    }
                    this._render()
                }
            },
            _setDefaultOptions: noop,
            _render: noop,
            _dispose: noop,
            element: function() {
                return this._$element
            },
            option: function(name, value) {
                if (0 === arguments.length) {
                    return this._options
                } else {
                    if (1 === arguments.length) {
                        if ("string" === typeof name) {
                            return this._options[name]
                        } else {
                            value = name;
                            extend(this._options, value)
                        }
                    } else {
                        this._options[name] = value
                    }
                }
            },
            instance: function() {
                return this
            }
        });
        MarkupComponent.getInstance = function($element) {
            return publicComponentUtils.getInstanceByElement($($element), this)
        };
        exports.MarkupComponent = MarkupComponent
    },
    /*!*****************************************************!*\
      !*** ./js/framework/html/view_engine_components.js ***!
      \*****************************************************/
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 122),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56),
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 57),
            MarkupComponent = __webpack_require__( /*! ./markup_component */ 127).MarkupComponent;
        __webpack_require__( /*! ../../integration/knockout */ 92);
        var View = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null,
                    title: null
                })
            },
            ctor: function() {
                this._id = domUtils.uniqueId();
                this.callBase.apply(this, arguments)
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-view");
                this.element().attr("dx-data-template-id", this._id)
            },
            getId: function() {
                return this._id
            }
        });
        var Layout = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null
                })
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-layout")
            }
        });
        var ViewPlaceholder = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    viewName: null
                })
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-view-placeholder")
            }
        });
        var setupTransitionElement = function($element, transitionType, transitionName, contentCssPosition) {
            if ("absolute" === contentCssPosition) {
                $element.addClass("dx-transition-absolute")
            } else {
                $element.addClass("dx-transition-static")
            }
            $element.addClass("dx-transition").addClass("dx-transition-" + transitionName).addClass("dx-transition-" + transitionType).attr("data-dx-transition-type", transitionType).attr("data-dx-transition-name", transitionName)
        };
        var setupTransitionInnerElement = function($element) {
            $element.addClass("dx-transition-inner-wrapper")
        };
        var Transition = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null,
                    type: void 0,
                    animation: "slide"
                })
            },
            _render: function() {
                this.callBase();
                var element = this.element();
                setupTransitionElement(element, this.option("type") || this.option("animation"), this.option("name"), "absolute");
                element.wrapInner("<div/>");
                setupTransitionInnerElement(element.children());
                if (this.option("type")) {
                    errors.log("W0003", "dxTransition", "type", "15.1", "Use the 'animation' property instead")
                }
            },
            _clean: function() {
                this.callBase();
                this.element().empty()
            }
        });
        var ContentPlaceholder = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null,
                    transition: void 0,
                    animation: "none",
                    contentCssPosition: "absolute"
                })
            },
            _render: function() {
                this.callBase();
                var $element = this.element();
                $element.addClass("dx-content-placeholder").addClass("dx-content-placeholder-" + this.option("name"));
                $element.attr("data-dx-content-placeholder-name", this.option("name"));
                setupTransitionElement($element, this.option("transition") || this.option("animation"), this.option("name"), this.option("contentCssPosition"));
                if (this.option("transition")) {
                    errors.log("W0003", "dxContentPlaceholder", "transition", "15.1", "Use the 'animation' property instead")
                }
            }
        });
        var Content = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    targetPlaceholder: null
                })
            },
            _optionChanged: function() {
                this._refresh()
            },
            _clean: function() {
                this.callBase();
                this.element().removeClass(this._currentClass)
            },
            _render: function() {
                this.callBase();
                var element = this.element();
                element.addClass("dx-content");
                this._currentClass = "dx-content-" + this.option("targetPlaceholder");
                element.attr("data-dx-target-placeholder-id", this.option("targetPlaceholder"));
                element.addClass(this._currentClass);
                setupTransitionInnerElement(element)
            }
        });
        registerComponent("dxView", View);
        registerComponent("dxLayout", Layout);
        registerComponent("dxViewPlaceholder", ViewPlaceholder);
        registerComponent("dxContentPlaceholder", ContentPlaceholder);
        registerComponent("dxTransition", Transition);
        registerComponent("dxContent", Content);
        exports.dxView = View;
        exports.dxLayout = Layout;
        exports.dxViewPlaceholder = ViewPlaceholder;
        exports.dxContentPlaceholder = ContentPlaceholder;
        exports.dxTransition = Transition;
        exports.dxContent = Content
    },
    /*!***********************************************!*\
      !*** ./js/framework/html/html_application.js ***!
      \***********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            Component = __webpack_require__( /*! ../../core/component */ 48),
            extendUtils = __webpack_require__( /*! ../../core/utils/extend */ 11),
            errors = __webpack_require__( /*! ../errors */ 122),
            Application = __webpack_require__( /*! ../application */ 130).Application,
            ConditionalViewCacheDecorator = __webpack_require__( /*! ../view_cache */ 125).ConditionalViewCacheDecorator,
            html = __webpack_require__( /*! ./presets */ 138),
            CommandManager = __webpack_require__( /*! ./command_manager */ 139),
            ViewEngine = __webpack_require__( /*! ./view_engine */ 141).ViewEngine,
            messageLocalization = __webpack_require__( /*! ../../localization/message */ 89),
            viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 55).value,
            initMobileViewportModule = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 60),
            devices = __webpack_require__( /*! ../../core/devices */ 53),
            feedbackEvents = __webpack_require__( /*! ../../events/core/emitter.feedback */ 104),
            TransitionExecutorModule = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 74),
            animationPresetsModule = __webpack_require__( /*! ../../animation/presets/presets */ 67),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when;
        __webpack_require__( /*! ./layout_controller */ 142);
        __webpack_require__( /*! ../../ui/themes */ 143);
        var VIEW_PORT_CLASSNAME = "dx-viewport",
            LAYOUT_CHANGE_ANIMATION_NAME = "layout-change";
        var HtmlApplication = Application.inherit({
            ctor: function(options) {
                options = options || {};
                this.callBase(options);
                this._$root = $(options.rootNode || document.body);
                this._initViewport(options.viewPort);
                if ("mobileApp" === this._applicationMode) {
                    initMobileViewportModule.initMobileViewport(options.viewPort)
                }
                this.device = options.device || devices.current();
                this.commandManager = options.commandManager || new CommandManager({
                    commandMapping: this.commandMapping
                });
                this._initTemplateContext();
                this.viewEngine = options.viewEngine || new ViewEngine({
                    $root: this._$root,
                    device: this.device,
                    templateCacheStorage: options.templateCacheStorage || window.localStorage,
                    templatesVersion: options.templatesVersion,
                    templateContext: this._templateContext
                });
                this.components.push(this.viewEngine);
                this._initMarkupFilters(this.viewEngine);
                this._layoutSet = options.layoutSet || html.layoutSets.default;
                this._animationSet = options.animationSet || html.animationSets.default;
                this._availableLayoutControllers = [];
                this._activeLayoutControllersStack = [];
                this.transitionExecutor = new TransitionExecutorModule.TransitionExecutor;
                this._initAnimations(this._animationSet)
            },
            _initAnimations: function(animationSet) {
                if (!animationSet) {
                    return
                }
                $.each(animationSet, function(name, configs) {
                    $.each(configs, function(index, config) {
                        animationPresetsModule.presets.registerPreset(name, config)
                    })
                });
                animationPresetsModule.presets.applyChanges()
            },
            _localizeMarkup: function($markup) {
                messageLocalization.localizeNode($markup)
            },
            _notifyIfBadMarkup: function($markup) {
                $markup.each(function() {
                    var html = $(this).html();
                    if (/href="#/.test(html)) {
                        errors.log("W3005", html)
                    }
                })
            },
            _initMarkupFilters: function(viewEngine) {
                var filters = [];
                filters.push(this._localizeMarkup);
                if ("mobileApp" === this._applicationMode) {
                    filters.push(this._notifyIfBadMarkup)
                }
                if (viewEngine.markupLoaded) {
                    viewEngine.markupLoaded.add(function(args) {
                        $.each(filters, function(_, filter) {
                            filter(args.markup)
                        })
                    })
                }
            },
            _createViewCache: function(options) {
                var result = this.callBase(options);
                if (!options.viewCache) {
                    result = new ConditionalViewCacheDecorator({
                        filter: function(key, viewInfo) {
                            return !viewInfo.viewTemplateInfo.disableCache
                        },
                        viewCache: result
                    })
                }
                return result
            },
            _initViewport: function() {
                this._$viewPort = this._getViewPort();
                viewPort(this._$viewPort)
            },
            _getViewPort: function() {
                var $viewPort = $("." + VIEW_PORT_CLASSNAME);
                if (!$viewPort.length) {
                    $viewPort = $("<div>").addClass(VIEW_PORT_CLASSNAME).appendTo(this._$root)
                }
                return $viewPort
            },
            _initTemplateContext: function() {
                this._templateContext = new Component({
                    orientation: devices.orientation()
                });
                devices.on("orientationChanged", function(args) {
                    this._templateContext.option("orientation", args.orientation)
                }.bind(this))
            },
            _showViewImpl: function(viewInfo, direction) {
                var that = this,
                    deferred = $.Deferred(),
                    result = deferred.promise(),
                    layoutController = viewInfo.layoutController;
                that._obtainViewLink(viewInfo);
                layoutController.showView(viewInfo, direction).done(function() {
                    that._activateLayoutController(layoutController, that._getTargetNode(viewInfo), direction).done(function() {
                        deferred.resolve()
                    })
                });
                feedbackEvents.lock(result);
                return result
            },
            _resolveLayoutController: function(viewInfo) {
                var args = {
                    viewInfo: viewInfo,
                    layoutController: null,
                    availableLayoutControllers: this._availableLayoutControllers
                };
                this._processEvent("resolveLayoutController", args, viewInfo.model);
                this._checkLayoutControllerIsInitialized(args.layoutController);
                return args.layoutController || this._resolveLayoutControllerImpl(viewInfo)
            },
            _checkLayoutControllerIsInitialized: function(layoutController) {
                if (layoutController) {
                    var isControllerInited = false;
                    $.each(this._layoutSet, function(_, controllerInfo) {
                        if (controllerInfo.controller === layoutController) {
                            isControllerInited = true;
                            return false
                        }
                    });
                    if (!isControllerInited) {
                        throw errors.Error("E3024")
                    }
                }
            },
            _ensureOneLayoutControllerFound: function(target, matches) {
                var toJSONInterceptor = function(key, value) {
                    if ("controller" === key) {
                        return "[controller]: { name:" + value.name + " }"
                    }
                    return value
                };
                if (!matches.length) {
                    errors.log("W3003", JSON.stringify(target, null, 4), JSON.stringify(this._availableLayoutControllers, toJSONInterceptor, 4));
                    throw errors.Error("E3011")
                }
                if (matches.length > 1) {
                    errors.log("W3004", JSON.stringify(target, null, 4), JSON.stringify(matches, toJSONInterceptor, 4));
                    throw errors.Error("E3012")
                }
            },
            _resolveLayoutControllerImpl: function(viewInfo) {
                var templateInfo = viewInfo.viewTemplateInfo || {},
                    navigateOptions = viewInfo.navigateOptions || {},
                    target = extendUtils.extend({
                        root: !viewInfo.canBack,
                        customResolveRequired: false,
                        pane: templateInfo.pane,
                        modal: void 0 !== navigateOptions.modal ? navigateOptions.modal : templateInfo.modal || false
                    }, devices.current());
                var matches = commonUtils.findBestMatches(target, this._availableLayoutControllers);
                this._ensureOneLayoutControllerFound(target, matches);
                return matches[0].controller
            },
            _onNavigatingBack: function(args) {
                this.callBase.apply(this, arguments);
                if (!args.cancel && !this.canBack() && this._activeLayoutControllersStack.length > 1) {
                    var previousActiveLayoutController = this._activeLayoutControllersStack[this._activeLayoutControllersStack.length - 2],
                        previousViewInfo = previousActiveLayoutController.activeViewInfo();
                    args.cancel = true;
                    this._activateLayoutController(previousActiveLayoutController, void 0, "backward");
                    this.navigationManager.currentItem(previousViewInfo.key)
                }
            },
            _activeLayoutController: function() {
                return this._activeLayoutControllersStack.length ? this._activeLayoutControllersStack[this._activeLayoutControllersStack.length - 1] : void 0
            },
            _getTargetNode: function(viewInfo) {
                var jQueryEvent = (viewInfo.navigateOptions || {}).jQueryEvent;
                return jQueryEvent ? $(jQueryEvent.target) : void 0
            },
            _activateLayoutController: function(layoutController, targetNode, direction) {
                var that = this,
                    previousLayoutController = that._activeLayoutController();
                if (previousLayoutController === layoutController) {
                    return $.Deferred().resolve().promise()
                }
                var d = $.Deferred();
                layoutController.ensureActive(targetNode).done(function(result) {
                    that._deactivatePreviousLayoutControllers(layoutController, direction, result).done(function() {
                        that._activeLayoutControllersStack.push(layoutController);
                        d.resolve()
                    })
                });
                return d.promise()
            },
            _deactivatePreviousLayoutControllers: function(layoutController, direction) {
                var that = this,
                    tasks = [],
                    controllerToDeactivate = that._activeLayoutControllersStack.pop();
                if (!controllerToDeactivate) {
                    return $.Deferred().resolve().promise()
                }
                if (layoutController.isOverlay) {
                    that._activeLayoutControllersStack.push(controllerToDeactivate);
                    tasks.push(controllerToDeactivate.disable())
                } else {
                    var transitionDeferred = $.Deferred(),
                        skipAnimation = false;
                    var getControllerDeactivator = function(controllerToDeactivate, d) {
                        return function() {
                            controllerToDeactivate.deactivate().done(function() {
                                d.resolve()
                            })
                        }
                    };
                    while (controllerToDeactivate && controllerToDeactivate !== layoutController) {
                        var d = $.Deferred();
                        if (controllerToDeactivate.isOverlay) {
                            skipAnimation = true
                        } else {
                            that.transitionExecutor.leave(controllerToDeactivate.element(), LAYOUT_CHANGE_ANIMATION_NAME, {
                                direction: direction
                            })
                        }
                        transitionDeferred.promise().done(getControllerDeactivator(controllerToDeactivate, d));
                        tasks.push(d.promise());
                        controllerToDeactivate = that._activeLayoutControllersStack.pop()
                    }
                    if (skipAnimation) {
                        transitionDeferred.resolve()
                    } else {
                        that.transitionExecutor.enter(layoutController.element(), LAYOUT_CHANGE_ANIMATION_NAME, {
                            direction: direction
                        });
                        that.transitionExecutor.start().done(function() {
                            transitionDeferred.resolve()
                        })
                    }
                }
                return when.apply($, tasks)
            },
            init: function() {
                var that = this,
                    result = this.callBase();
                result.done(function() {
                    that._initLayoutControllers();
                    that.renderNavigation()
                });
                return result
            },
            _disposeView: function(viewInfo) {
                if (viewInfo.layoutController.disposeView) {
                    viewInfo.layoutController.disposeView(viewInfo)
                }
                this.callBase(viewInfo)
            },
            viewPort: function() {
                return this._$viewPort
            },
            _createViewInfo: function() {
                var viewInfo = this.callBase.apply(this, arguments),
                    templateInfo = this.getViewTemplateInfo(viewInfo.viewName);
                if (!templateInfo) {
                    throw errors.Error("E3013", "dxView", viewInfo.viewName)
                }
                viewInfo.viewTemplateInfo = templateInfo;
                viewInfo.layoutController = this._resolveLayoutController(viewInfo);
                return viewInfo
            },
            _createViewModel: function(viewInfo) {
                this.callBase(viewInfo);
                extendUtils.extendFromObject(viewInfo.model, viewInfo.viewTemplateInfo)
            },
            _initLayoutControllers: function() {
                var that = this;
                $.each(that._layoutSet, function(index, controllerInfo) {
                    var controller = controllerInfo.controller,
                        target = devices.current();
                    if (commonUtils.findBestMatches(target, [controllerInfo]).length) {
                        that._availableLayoutControllers.push(controllerInfo);
                        if (controller.init) {
                            controller.init({
                                app: that,
                                $viewPort: that._$viewPort,
                                navigationManager: that.navigationManager,
                                viewEngine: that.viewEngine,
                                templateContext: that._templateContext,
                                commandManager: that.commandManager
                            })
                        }
                        if (controller.on) {
                            controller.on("viewReleased", function(viewInfo) {
                                that._onViewReleased(viewInfo)
                            });
                            controller.on("viewHidden", function(viewInfo) {
                                that._onViewHidden(viewInfo)
                            });
                            controller.on("viewRendered", function(viewInfo) {
                                that._processEvent("viewRendered", {
                                    viewInfo: viewInfo
                                }, viewInfo.model)
                            });
                            controller.on("viewShowing", function(viewInfo, direction) {
                                that._processEvent("viewShowing", {
                                    viewInfo: viewInfo,
                                    direction: direction,
                                    params: viewInfo.routeData
                                }, viewInfo.model)
                            });
                            controller.on("viewShown", function(viewInfo, direction) {
                                that._processEvent("viewShown", {
                                    viewInfo: viewInfo,
                                    direction: direction,
                                    params: viewInfo.routeData
                                }, viewInfo.model)
                            })
                        }
                    }
                })
            },
            _onViewReleased: function(viewInfo) {
                this._releaseViewLink(viewInfo)
            },
            renderNavigation: function() {
                var that = this;
                $.each(that._availableLayoutControllers, function(index, controllerInfo) {
                    var controller = controllerInfo.controller;
                    if (controller.renderNavigation) {
                        controller.renderNavigation(that.navigation)
                    }
                })
            },
            getViewTemplate: function(viewName) {
                return this.viewEngine.getViewTemplate(viewName)
            },
            getViewTemplateInfo: function(viewName) {
                var viewComponent = this.viewEngine.getViewTemplateInfo(viewName);
                return viewComponent && viewComponent.option()
            },
            loadTemplates: function(source) {
                return this.viewEngine.loadTemplates(source)
            },
            templateContext: function() {
                return this._templateContext
            }
        });
        module.exports = HtmlApplication
    },
    /*!*************************************!*\
      !*** ./js/framework/application.js ***!
      \*************************************/
    function(module, exports, __webpack_require__) {
        var BACK_COMMAND_TITLE, $ = __webpack_require__( /*! ../core/renderer */ 9),
            Class = __webpack_require__( /*! ../core/class */ 25),
            abstract = Class.abstract,
            Action = __webpack_require__( /*! ../core/action */ 49),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 12),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            mergeCommands = __webpack_require__( /*! ./utils */ 131).utils.mergeCommands,
            createActionExecutors = __webpack_require__( /*! ./action_executors */ 132).createActionExecutors,
            Router = __webpack_require__( /*! ./router */ 123),
            NavigationManager = __webpack_require__( /*! ./navigation_manager */ 133),
            StateManager = __webpack_require__( /*! ./state_manager */ 124),
            dxCommand = __webpack_require__( /*! ./command */ 121),
            messageLocalization = __webpack_require__( /*! ../localization/message */ 89),
            CommandMapping = __webpack_require__( /*! ./command_mapping */ 136),
            ViewCache = __webpack_require__( /*! ./view_cache */ 125),
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 51),
            sessionStorage = __webpack_require__( /*! ../core/utils/storage */ 54).sessionStorage,
            dataUtils = __webpack_require__( /*! ../data/utils */ 137),
            errors = __webpack_require__( /*! ./errors */ 122),
            when = __webpack_require__( /*! ../integration/jquery/deferred */ 16).when,
            INIT_IN_PROGRESS = "InProgress",
            INIT_COMPLETE = "Inited";
        var Application = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this._options = options;
                this.namespace = options.namespace || window;
                this._applicationMode = options.mode ? options.mode : "mobileApp";
                this.components = [];
                BACK_COMMAND_TITLE = messageLocalization.localizeString("@Back");
                this.router = options.router || new Router;
                var navigationManagers = {
                    mobileApp: NavigationManager.StackBasedNavigationManager,
                    webSite: NavigationManager.HistoryBasedNavigationManager
                };
                this.navigationManager = options.navigationManager || new navigationManagers[this._applicationMode]({
                    keepPositionInStack: "keepHistory" === options.navigateToRootViewMode
                });
                this.navigationManager.on("navigating", this._onNavigating.bind(this));
                this.navigationManager.on("navigatingBack", this._onNavigatingBack.bind(this));
                this.navigationManager.on("navigated", this._onNavigated.bind(this));
                this.navigationManager.on("navigationCanceled", this._onNavigationCanceled.bind(this));
                this.stateManager = options.stateManager || new StateManager({
                    storage: options.stateStorage || sessionStorage()
                });
                this.stateManager.addStateSource(this.navigationManager);
                this.viewCache = this._createViewCache(options);
                this.commandMapping = this._createCommandMapping(options.commandMapping);
                this.createNavigation(options.navigation);
                this._isNavigating = false;
                this._viewLinksHash = {};
                Action.registerExecutor(createActionExecutors(this));
                this.components.push(this.router);
                this.components.push(this.navigationManager)
            },
            _createViewCache: function(options) {
                var result;
                if (options.viewCache) {
                    result = options.viewCache
                } else {
                    if (options.disableViewCache) {
                        result = new ViewCache.NullViewCache
                    } else {
                        result = new ViewCache.CapacityViewCacheDecorator({
                            size: options.viewCacheSize,
                            viewCache: new ViewCache
                        })
                    }
                }
                result.on("viewRemoved", function(e) {
                    this._releaseViewLink(e.viewInfo)
                }.bind(this));
                return result
            },
            _createCommandMapping: function(commandMapping) {
                var result = commandMapping;
                if (!(commandMapping instanceof CommandMapping)) {
                    result = new CommandMapping;
                    result.load(CommandMapping.defaultMapping || {}).load(commandMapping || {})
                }
                return result
            },
            createNavigation: function(navigationConfig) {
                this.navigation = this._createNavigationCommands(navigationConfig);
                this._mapNavigationCommands(this.navigation, this.commandMapping)
            },
            _createNavigationCommands: function(commandConfig) {
                if (!commandConfig) {
                    return []
                }
                var generatedIdCount = 0;
                return $.map(commandConfig, function(item) {
                    var command;
                    if (item instanceof dxCommand) {
                        command = item
                    } else {
                        command = new dxCommand(extend({
                            root: true
                        }, item))
                    }
                    if (!command.option("id")) {
                        command.option("id", "navigation_" + generatedIdCount++)
                    }
                    return command
                })
            },
            _mapNavigationCommands: function(navigationCommands, commandMapping) {
                var navigationCommandIds = $.map(navigationCommands, function(command) {
                    return command.option("id")
                });
                commandMapping.mapCommands("global-navigation", navigationCommandIds)
            },
            _callComponentMethod: function(methodName, args) {
                var tasks = [];
                $.each(this.components, function(index, component) {
                    if (component[methodName] && commonUtils.isFunction(component[methodName])) {
                        var result = component[methodName](args);
                        if (result && result.done) {
                            tasks.push(result)
                        }
                    }
                });
                return when.apply($, tasks)
            },
            init: function() {
                var that = this;
                that._initState = INIT_IN_PROGRESS;
                return that._callComponentMethod("init").done(function() {
                    that._initState = INIT_COMPLETE;
                    that._processEvent("initialized")
                }).fail(function(error) {
                    throw error || errors.Error("E3022")
                })
            },
            _onNavigatingBack: function(args) {
                this._processEvent("navigatingBack", args)
            },
            _onNavigating: function(args) {
                var that = this;
                if (that._isNavigating) {
                    that._pendingNavigationArgs = args;
                    args.cancel = true;
                    return
                } else {
                    that._isNavigating = true;
                    delete that._pendingNavigationArgs
                }
                var routeData = this.router.parse(args.uri);
                if (!routeData) {
                    throw errors.Error("E3001", args.uri)
                }
                var uri = this.router.format(routeData);
                if (args.uri !== uri && uri) {
                    args.cancel = true;
                    args.cancelReason = "redirect";
                    commonUtils.executeAsync(function() {
                        that.navigate(uri, args.options)
                    })
                } else {
                    that._processEvent("navigating", args)
                }
            },
            _onNavigated: function(args) {
                var resultDeferred, that = this,
                    direction = args.options.direction,
                    viewInfo = that._acquireViewInfo(args.item, args.options);
                if (!viewInfo.model) {
                    this._processEvent("beforeViewSetup", {
                        viewInfo: viewInfo
                    });
                    that._createViewModel(viewInfo);
                    that._createViewCommands(viewInfo);
                    this._processEvent("afterViewSetup", {
                        viewInfo: viewInfo
                    })
                }
                that._highlightCurrentNavigationCommand(viewInfo);
                resultDeferred = that._showView(viewInfo, direction).always(function() {
                    that._isNavigating = false;
                    var pendingArgs = that._pendingNavigationArgs;
                    if (pendingArgs) {
                        commonUtils.executeAsync(function() {
                            that.navigate(pendingArgs.uri, pendingArgs.options)
                        })
                    }
                });
                return resultDeferred
            },
            _isViewReadyToShow: function(viewInfo) {
                return !!viewInfo.model
            },
            _onNavigationCanceled: function(args) {
                var that = this;
                if (!that._pendingNavigationArgs || that._pendingNavigationArgs.uri !== args.uri) {
                    var currentItem = that.navigationManager.currentItem();
                    if (currentItem) {
                        commonUtils.executeAsync(function() {
                            var viewInfo = that._acquireViewInfo(currentItem, args.options);
                            that._highlightCurrentNavigationCommand(viewInfo, true)
                        })
                    }
                    that._isNavigating = false
                }
            },
            _disposeRemovedViews: function() {
                var args, that = this;
                $.each(that._viewLinksHash, function(key, link) {
                    if (!link.linkCount) {
                        args = {
                            viewInfo: link.viewInfo
                        };
                        that._processEvent("viewDisposing", args, args.viewInfo.model);
                        that._disposeView(link.viewInfo);
                        that._processEvent("viewDisposed", args, args.viewInfo.model);
                        delete that._viewLinksHash[key]
                    }
                })
            },
            _onViewHidden: function(viewInfo) {
                var args = {
                    viewInfo: viewInfo
                };
                this._processEvent("viewHidden", args, args.viewInfo.model)
            },
            _disposeView: function(viewInfo) {
                var commands = viewInfo.commands || [];
                $.each(commands, function(index, command) {
                    command._dispose()
                })
            },
            _acquireViewInfo: function(navigationItem, navigateOptions) {
                var routeData = this.router.parse(navigationItem.uri),
                    viewInfoKey = this._getViewInfoKey(navigationItem, routeData),
                    viewInfo = this.viewCache.getView(viewInfoKey);
                if (!viewInfo) {
                    viewInfo = this._createViewInfo(navigationItem, navigateOptions);
                    this._obtainViewLink(viewInfo);
                    this.viewCache.setView(viewInfoKey, viewInfo)
                } else {
                    this._updateViewInfo(viewInfo, navigationItem, navigateOptions)
                }
                return viewInfo
            },
            _getViewInfoKey: function(navigationItem, routeData) {
                var args = {
                    key: navigationItem.key,
                    navigationItem: navigationItem,
                    routeData: routeData
                };
                this._processEvent("resolveViewCacheKey", args);
                return args.key
            },
            _processEvent: function(eventName, args, model) {
                this._callComponentMethod(eventName, args);
                this.fireEvent(eventName, args && [args]);
                var modelMethod = (model || {})[eventName];
                if (modelMethod) {
                    modelMethod.call(model, args)
                }
            },
            _updateViewInfo: function(viewInfo, navigationItem, navigateOptions) {
                var uri = navigationItem.uri,
                    routeData = this.router.parse(uri);
                viewInfo.viewName = routeData.view;
                viewInfo.routeData = routeData;
                viewInfo.uri = uri;
                viewInfo.navigateOptions = navigateOptions;
                viewInfo.canBack = this.canBack(navigateOptions.stack);
                viewInfo.previousViewInfo = this._getPreviousViewInfo(navigateOptions)
            },
            _createViewInfo: function(navigationItem, navigateOptions) {
                var uri = navigationItem.uri,
                    routeData = this.router.parse(uri),
                    viewInfo = {
                        key: this._getViewInfoKey(navigationItem, routeData)
                    };
                this._updateViewInfo(viewInfo, navigationItem, navigateOptions);
                return viewInfo
            },
            _createViewModel: function(viewInfo) {
                viewInfo.model = viewInfo.model || this._callViewCodeBehind(viewInfo)
            },
            _createViewCommands: function(viewInfo) {
                viewInfo.commands = viewInfo.model.commands || [];
                if (viewInfo.canBack && "webSite" !== this._applicationMode) {
                    this._appendBackCommand(viewInfo)
                }
            },
            _callViewCodeBehind: function(viewInfo) {
                var setupFunc = commonUtils.noop,
                    routeData = viewInfo.routeData;
                if (routeData.view in this.namespace) {
                    setupFunc = this.namespace[routeData.view]
                }
                return setupFunc.call(this.namespace, routeData, viewInfo) || {}
            },
            _appendBackCommand: function(viewInfo) {
                var commands = viewInfo.commands,
                    that = this,
                    backTitle = BACK_COMMAND_TITLE;
                if (that._options.useViewTitleAsBackText) {
                    backTitle = ((viewInfo.previousViewInfo || {}).model || {}).title || backTitle
                }
                var toMergeTo = [new dxCommand({
                    id: "back",
                    title: backTitle,
                    behavior: "back",
                    onExecute: function() {
                        that.back({
                            stack: viewInfo.navigateOptions.stack
                        })
                    },
                    icon: "arrowleft",
                    type: "back",
                    renderStage: that._options.useViewTitleAsBackText ? "onViewRendering" : "onViewShown"
                })];
                var result = mergeCommands(toMergeTo, commands);
                commands.length = 0;
                commands.push.apply(commands, result)
            },
            _showView: function(viewInfo, direction) {
                var that = this;
                var eventArgs = {
                    viewInfo: viewInfo,
                    direction: direction,
                    params: viewInfo.routeData
                };
                dataUtils.processRequestResultLock.obtain();
                return that._showViewImpl(eventArgs.viewInfo, eventArgs.direction).done(function() {
                    commonUtils.executeAsync(function() {
                        dataUtils.processRequestResultLock.release();
                        that._processEvent("viewShown", eventArgs, viewInfo.model);
                        that._disposeRemovedViews()
                    })
                })
            },
            _highlightCurrentNavigationCommand: function(viewInfo, forceUpdate) {
                var selectedCommand, that = this,
                    currentNavigationItemId = viewInfo.model && viewInfo.model.currentNavigationItemId;
                if (void 0 !== currentNavigationItemId) {
                    $.each(this.navigation, function(index, command) {
                        if (command.option("id") === currentNavigationItemId) {
                            selectedCommand = command;
                            return false
                        }
                    })
                }
                if (!selectedCommand) {
                    $.each(this.navigation, function(index, command) {
                        var commandUri = command.option("onExecute");
                        if (commonUtils.isString(commandUri)) {
                            commandUri = commandUri.replace(/^#+/, "");
                            if (commandUri === that.navigationManager.rootUri()) {
                                selectedCommand = command;
                                return false
                            }
                        }
                    })
                }
                $.each(this.navigation, function(index, command) {
                    if (forceUpdate && command === selectedCommand && command.option("highlighted")) {
                        command.fireEvent("optionChanged", [{
                            name: "highlighted",
                            value: true,
                            previousValue: true
                        }])
                    }
                    command.option("highlighted", command === selectedCommand)
                })
            },
            _showViewImpl: abstract,
            _obtainViewLink: function(viewInfo) {
                var key = viewInfo.key;
                if (!this._viewLinksHash[key]) {
                    this._viewLinksHash[key] = {
                        viewInfo: viewInfo,
                        linkCount: 1
                    }
                } else {
                    this._viewLinksHash[key].linkCount++
                }
            },
            _releaseViewLink: function(viewInfo) {
                if (void 0 === this._viewLinksHash[viewInfo.key]) {
                    errors.log("W3001", viewInfo.key)
                }
                if (0 === this._viewLinksHash[viewInfo.key].linkCount) {
                    errors.log("W3002", viewInfo.key)
                }
                this._viewLinksHash[viewInfo.key].linkCount--
            },
            navigate: function(uri, options) {
                var that = this;
                if (typeUtils.isPlainObject(uri)) {
                    uri = that.router.format(uri);
                    if (false === uri) {
                        throw errors.Error("E3002")
                    }
                }
                if (!that._initState) {
                    that.init().done(function() {
                        that.restoreState();
                        that.navigate(uri, options)
                    })
                } else {
                    if (that._initState === INIT_COMPLETE) {
                        if (!that._isNavigating || uri) {
                            that.navigationManager.navigate(uri, options)
                        }
                    } else {
                        throw errors.Error("E3003")
                    }
                }
            },
            canBack: function(stackKey) {
                return this.navigationManager.canBack(stackKey)
            },
            _getPreviousViewInfo: function(navigateOptions) {
                var result, previousNavigationItem = this.navigationManager.previousItem(navigateOptions.stack);
                if (previousNavigationItem) {
                    var routeData = this.router.parse(previousNavigationItem.uri);
                    result = this.viewCache.getView(this._getViewInfoKey(previousNavigationItem, routeData))
                }
                return result
            },
            back: function(options) {
                this.navigationManager.back(options)
            },
            saveState: function() {
                this.stateManager.saveState()
            },
            restoreState: function() {
                this.stateManager.restoreState()
            },
            clearState: function() {
                this.stateManager.clearState()
            }
        }).include(EventsMixin);
        exports.Application = Application
    },
    /*!*******************************!*\
      !*** ./js/framework/utils.js ***!
      \*******************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            ko = __webpack_require__( /*! knockout */ 93),
            KoTemplate = __webpack_require__( /*! ../integration/knockout/template */ 105);
        var mergeWithReplace = function(targetArray, arrayToMerge, needReplaceFn) {
            var result = [];
            for (var i = 0, length = targetArray.length; i < length; i++) {
                if (!needReplaceFn(targetArray[i], arrayToMerge)) {
                    result.push(targetArray[i])
                }
            }
            result.push.apply(result, arrayToMerge);
            return result
        };
        var prepareCommandToReplace = function(targetCommand, commandsToMerge) {
            var needToReplace = false;
            $.each(commandsToMerge, function(_, commandToMerge) {
                var idEqual = targetCommand.option("id") === commandToMerge.option("id") && commandToMerge.option("id"),
                    behaviorEqual = targetCommand.option("behavior") === commandToMerge.option("behavior") && targetCommand.option("behavior");
                needToReplace = idEqual || behaviorEqual;
                if (behaviorEqual && null === commandToMerge.option("onExecute")) {
                    commandToMerge.option("onExecute", targetCommand.option("onExecute"))
                }
                if (needToReplace) {
                    targetCommand.element().remove();
                    return false
                }
            });
            return needToReplace
        };
        var mergeCommands = function(targetCommands, commandsToMerge) {
            return mergeWithReplace(targetCommands, commandsToMerge, prepareCommandToReplace)
        };
        var resolvePropertyValue = function(command, containerOptions, propertyName, defaultValue) {
            var containerOption = containerOptions ? containerOptions[propertyName] : void 0,
                defaultOption = void 0 === containerOption ? defaultValue : containerOption,
                commandOption = command.option(propertyName);
            return void 0 === commandOption || commandOption === defaultValue ? defaultOption : commandOption
        };
        var resolveTextValue = function(command, containerOptions) {
            var showText = resolvePropertyValue(command, containerOptions, "showText"),
                hasIcon = !!command.option("icon"),
                titleValue = resolvePropertyValue(command, containerOptions, "title", "");
            return showText || !hasIcon ? titleValue : ""
        };
        var resolveIconValue = function(command, containerOptions) {
            var showIcon = resolvePropertyValue(command, containerOptions, "showIcon"),
                hasText = !!command.option("title"),
                iconValue = resolvePropertyValue(command, containerOptions, "icon", "");
            return showIcon || !hasText ? iconValue : ""
        };
        exports.utils = {
            mergeCommands: mergeCommands,
            commandToContainer: {
                resolveIconValue: resolveIconValue,
                resolveTextValue: resolveTextValue,
                resolvePropertyValue: resolvePropertyValue
            }
        };
        exports.templateProvider = {
            createTemplate: function(element) {
                return new KoTemplate(element)
            },
            applyTemplate: function(element, model) {
                ko.applyBindings(model, element)
            }
        }
    },
    /*!******************************************!*\
      !*** ./js/framework/action_executors.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            dataCoreUtils = __webpack_require__( /*! ../core/utils/data */ 50),
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            isPlainObject = __webpack_require__( /*! ../core/utils/type */ 12).isPlainObject,
            Route = __webpack_require__( /*! ./router */ 123).Route;

        function prepareNavigateOptions(options, actionArguments) {
            if (actionArguments.args) {
                var sourceEventArguments = actionArguments.args[0];
                options.jQueryEvent = sourceEventArguments.jQueryEvent
            }
            if ("dxCommand" === (actionArguments.component || {}).NAME) {
                extend(options, actionArguments.component.option())
            }
        }

        function preventDefaultLinkBehavior(e) {
            if (!e) {
                return
            }
            var $targetElement = $(e.target);
            if ($targetElement.attr("href")) {
                e.preventDefault()
            }
        }
        var createActionExecutors = function(app) {
            return {
                routing: {
                    execute: function(e) {
                        var routeValues, uri, action = e.action,
                            options = {};
                        if (isPlainObject(action)) {
                            routeValues = action.routeValues;
                            if (routeValues && isPlainObject(routeValues)) {
                                options = action.options
                            } else {
                                routeValues = action
                            }
                            uri = app.router.format(routeValues);
                            prepareNavigateOptions(options, e);
                            preventDefaultLinkBehavior(options.jQueryEvent);
                            app.navigate(uri, options);
                            e.handled = true
                        }
                    }
                },
                hash: {
                    execute: function(e) {
                        if ("string" !== typeof e.action || "#" !== e.action.charAt(0)) {
                            return
                        }
                        var uriTemplate = e.action.substr(1),
                            args = e.args[0],
                            uri = uriTemplate;
                        var defaultEvaluate = function(expr) {
                            var getter = dataCoreUtils.compileGetter(expr),
                                model = e.args[0].model;
                            return getter(model)
                        };
                        var evaluate = args.evaluate || defaultEvaluate;
                        uri = uriTemplate.replace(/\{([^}]+)\}/g, function(entry, expr) {
                            expr = $.trim(expr);
                            if (expr.indexOf(",") > -1) {
                                expr = $.map(expr.split(","), $.trim)
                            }
                            var value = evaluate(expr);
                            if (void 0 === value) {
                                value = ""
                            }
                            value = Route.prototype.formatSegment(value);
                            return value
                        });
                        var options = {};
                        prepareNavigateOptions(options, e);
                        preventDefaultLinkBehavior(options.jQueryEvent);
                        app.navigate(uri, options);
                        e.handled = true
                    }
                },
                url: {
                    execute: function(e) {
                        if ("string" === typeof e.action && "#" !== e.action.charAt(0)) {
                            document.location = e.action
                        }
                    }
                }
            }
        };
        exports.createActionExecutors = createActionExecutors
    },
    /*!********************************************!*\
      !*** ./js/framework/navigation_manager.js ***!
      \********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            Class = __webpack_require__( /*! ../core/class */ 25),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 14),
            isPlainObject = __webpack_require__( /*! ../core/utils/type */ 12).isPlainObject,
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            navigationDevices = __webpack_require__( /*! ./navigation_devices */ 134),
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 51),
            errors = __webpack_require__( /*! ./errors */ 122),
            hardwareBackButton = __webpack_require__( /*! ../mobile/process_hardware_back_button */ 64).processCallback,
            hideTopOverlay = __webpack_require__( /*! ../mobile/hide_top_overlay */ 65),
            when = __webpack_require__( /*! ../integration/jquery/deferred */ 16).when;
        var NAVIGATION_TARGETS = {
                current: "current",
                blank: "blank",
                back: "back"
            },
            STORAGE_HISTORY_KEY = "__history";
        var HistoryBasedNavigationManager = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this._currentItem = void 0;
                this._previousItem = void 0;
                this._createNavigationDevice(options)
            },
            _createNavigationDevice: function(options) {
                this._navigationDevice = options.navigationDevice || new navigationDevices.HistoryBasedNavigationDevice;
                this._navigationDevice.uriChanged.add(this._uriChangedHandler.bind(this))
            },
            _uriChangedHandler: function(uri) {
                while (hideTopOverlay()) {}
                this.navigate(uri)
            },
            _syncUriWithCurrentNavigationItem: function() {
                var currentUri = this._currentItem && this._currentItem.uri;
                this._navigationDevice.setUri(currentUri, true)
            },
            _cancelNavigation: function(args) {
                this._syncUriWithCurrentNavigationItem();
                this.fireEvent("navigationCanceled", [args])
            },
            _getDefaultOptions: function() {
                return {
                    direction: "none",
                    target: NAVIGATION_TARGETS.blank
                }
            },
            _updateHistory: function(uri, options) {
                this._previousItem = this._currentItem;
                this._currentItem = {
                    uri: uri,
                    key: uri
                };
                this._navigationDevice.setUri(uri, options.target === NAVIGATION_TARGETS.current)
            },
            _setCurrentItem: function(item) {
                this._currentItem = item
            },
            navigate: function(uri, options) {
                options = options || {};
                var args, that = this,
                    isFirstNavigate = !that._currentItem,
                    currentItem = that._currentItem || {},
                    targetItem = options.item || {},
                    currentUri = currentItem.uri,
                    currentKey = currentItem.key,
                    targetKey = targetItem.key;
                if (void 0 === uri) {
                    uri = that._navigationDevice.getUri()
                }
                if (/^_back$/.test(uri)) {
                    that.back();
                    return
                }
                options = extend(that._getDefaultOptions(), options || {});
                if (isFirstNavigate) {
                    options.target = NAVIGATION_TARGETS.current
                }
                args = {
                    currentUri: currentUri,
                    uri: uri,
                    cancel: false,
                    navigateWhen: [],
                    options: options
                };
                that.fireEvent("navigating", [args]);
                uri = args.uri;
                if (args.cancel || currentUri === uri && (void 0 === targetKey || targetKey === currentKey) && !that._forceNavigate) {
                    that._cancelNavigation(args)
                } else {
                    that._forceNavigate = false;
                    when.apply($, args.navigateWhen).done(function() {
                        commonUtils.executeAsync(function() {
                            that._updateHistory(uri, options);
                            that.fireEvent("navigated", [{
                                uri: uri,
                                previousUri: currentUri,
                                options: options,
                                item: that._currentItem
                            }])
                        })
                    })
                }
            },
            back: function() {
                return this._navigationDevice.back()
            },
            previousItem: function() {
                return this._previousItem
            },
            currentItem: function(item) {
                if (arguments.length > 0) {
                    if (!item) {
                        throw errors.Error("E3023")
                    }
                    this._setCurrentItem(item)
                } else {
                    return this._currentItem
                }
            },
            rootUri: function() {
                return this._currentItem && this._currentItem.uri
            },
            canBack: function() {
                return true
            },
            saveState: commonUtils.noop,
            restoreState: commonUtils.noop,
            removeState: commonUtils.noop
        }).include(EventsMixin);
        var StackBasedNavigationManager = HistoryBasedNavigationManager.inherit({
            ctor: function(options) {
                options = options || {};
                this.callBase(options);
                this._createNavigationStacks(options);
                hardwareBackButton.add(this._deviceBackInitiated.bind(this));
                this._stateStorageKey = options.stateStorageKey || STORAGE_HISTORY_KEY
            },
            init: function() {
                return this._navigationDevice.init()
            },
            _createNavigationDevice: function(options) {
                if (!options.navigationDevice) {
                    options.navigationDevice = new navigationDevices.StackBasedNavigationDevice
                }
                this.callBase(options);
                this._navigationDevice.backInitiated.add(this._deviceBackInitiated.bind(this))
            },
            _uriChangedHandler: function(uri) {
                this.navigate(uri)
            },
            _createNavigationStacks: function(options) {
                this.navigationStacks = {};
                this._keepPositionInStack = options.keepPositionInStack;
                this.currentStack = new NavigationStack
            },
            _deviceBackInitiated: function() {
                if (!hideTopOverlay()) {
                    this.back({
                        isHardwareButton: true
                    })
                } else {
                    this._syncUriWithCurrentNavigationItem()
                }
            },
            _getDefaultOptions: function() {
                return {
                    target: NAVIGATION_TARGETS.blank
                }
            },
            _createNavigationStack: function() {
                var result = new NavigationStack;
                result.itemsRemoved.add(this._removeItems.bind(this));
                return result
            },
            _setCurrentItem: function(item) {
                this._setCurrentStack(item.stack);
                this.currentStack.currentItem(item);
                this.callBase(item);
                this._syncUriWithCurrentNavigationItem()
            },
            _setCurrentStack: function(stackOrStackKey) {
                var stack, stackKey;
                if ("string" === typeof stackOrStackKey) {
                    stackKey = stackOrStackKey;
                    if (!(stackKey in this.navigationStacks)) {
                        this.navigationStacks[stackKey] = this._createNavigationStack()
                    }
                    stack = this.navigationStacks[stackKey]
                } else {
                    stack = stackOrStackKey;
                    stackKey = $.map(this.navigationStacks, function(stack, key) {
                        if (stack === stackOrStackKey) {
                            return key
                        }
                        return null
                    })[0]
                }
                this.currentStack = stack;
                this.currentStackKey = stackKey
            },
            _getViewTargetStackKey: function(uri, isRoot) {
                var result;
                if (isRoot) {
                    if (void 0 !== this.navigationStacks[uri]) {
                        result = uri
                    } else {
                        for (var stackKey in this.navigationStacks) {
                            if (this.navigationStacks[stackKey].items[0].uri === uri) {
                                result = stackKey;
                                break
                            }
                        }
                        result = result || uri
                    }
                } else {
                    result = this.currentStackKey || uri
                }
                return result
            },
            _updateHistory: function(uri, options) {
                var isRoot = options.root,
                    forceIsRoot = isRoot,
                    forceToRoot = false,
                    previousStack = this.currentStack,
                    keepPositionInStack = void 0 !== options.keepPositionInStack ? options.keepPositionInStack : this._keepPositionInStack;
                options.stack = options.stack || this._getViewTargetStackKey(uri, isRoot);
                this._setCurrentStack(options.stack);
                if (isRoot || !this.currentStack.items.length) {
                    forceToRoot = this.currentStack === previousStack;
                    forceIsRoot = true
                }
                if (isRoot && this.currentStack.items.length) {
                    if (!keepPositionInStack || forceToRoot) {
                        this.currentStack.currentIndex = 0;
                        if (this.currentItem().uri !== uri) {
                            this.currentStack.navigate(uri, true)
                        }
                    }
                    options.direction = options.direction || "none"
                } else {
                    var prevIndex = this.currentStack.currentIndex,
                        prevItem = this.currentItem() || {};
                    switch (options.target) {
                        case NAVIGATION_TARGETS.blank:
                            this.currentStack.navigate(uri);
                            break;
                        case NAVIGATION_TARGETS.current:
                            this.currentStack.navigate(uri, true);
                            break;
                        case NAVIGATION_TARGETS.back:
                            if (this.currentStack.currentIndex > 0) {
                                this.currentStack.back(uri)
                            } else {
                                this.currentStack.navigate(uri, true)
                            }
                            break;
                        default:
                            throw errors.Error("E3006", options.target)
                    }
                    if (void 0 === options.direction) {
                        var indexDelta = this.currentStack.currentIndex - prevIndex;
                        if (indexDelta < 0) {
                            options.direction = this.currentStack.currentItem().backDirection || "backward"
                        } else {
                            if (indexDelta > 0 && this.currentStack.currentIndex > 0) {
                                options.direction = "forward"
                            } else {
                                options.direction = "none"
                            }
                        }
                    }
                    prevItem.backDirection = "forward" === options.direction ? "backward" : "none"
                }
                options.root = forceIsRoot;
                this._currentItem = this.currentStack.currentItem();
                this._syncUriWithCurrentNavigationItem()
            },
            _removeItems: function(items) {
                var that = this;
                $.each(items, function(index, item) {
                    that.fireEvent("itemRemoved", [item])
                })
            },
            back: function(options) {
                options = options || {};
                var navigatingBackArgs = extend({
                    cancel: false
                }, options);
                this.fireEvent("navigatingBack", [navigatingBackArgs]);
                if (navigatingBackArgs.cancel) {
                    this._syncUriWithCurrentNavigationItem();
                    return
                }
                var item = this.previousItem(navigatingBackArgs.stack);
                if (item) {
                    this.navigate(item.uri, {
                        stack: navigatingBackArgs.stack,
                        target: NAVIGATION_TARGETS.back,
                        item: item
                    })
                } else {
                    this.callBase()
                }
            },
            rootUri: function() {
                return this.currentStack.items.length ? this.currentStack.items[0].uri : this.callBase()
            },
            canBack: function(stackKey) {
                var stack = stackKey ? this.navigationStacks[stackKey] : this.currentStack;
                return stack ? stack.canBack() : false
            },
            saveState: function(storage) {
                if (this.currentStack.items.length) {
                    var state = {
                        navigationStacks: {},
                        currentStackKey: this.currentStackKey
                    };
                    $.each(this.navigationStacks, function(stackKey, stack) {
                        var stackState = {};
                        state.navigationStacks[stackKey] = stackState;
                        stackState.currentIndex = stack.currentIndex;
                        stackState.items = $.map(stack.items, function(item) {
                            return {
                                key: item.key,
                                uri: item.uri
                            }
                        })
                    });
                    var json = JSON.stringify(state);
                    storage.setItem(this._stateStorageKey, json)
                } else {
                    this.removeState(storage)
                }
            },
            restoreState: function(storage) {
                if (this.disableRestoreState) {
                    return
                }
                var json = storage.getItem(this._stateStorageKey);
                if (json) {
                    try {
                        var that = this,
                            state = JSON.parse(json);
                        $.each(state.navigationStacks, function(stackKey, stackState) {
                            var stack = that._createNavigationStack();
                            that.navigationStacks[stackKey] = stack;
                            stack.currentIndex = stackState.currentIndex;
                            stack.items = $.map(stackState.items, function(item) {
                                item.stack = stack;
                                return item
                            })
                        });
                        this.currentStackKey = state.currentStackKey;
                        this.currentStack = this.navigationStacks[this.currentStackKey];
                        this._currentItem = this.currentStack.currentItem();
                        this._navigationDevice.setUri(this.currentItem().uri);
                        this._forceNavigate = true
                    } catch (e) {
                        this.removeState(storage);
                        throw errors.Error("E3007")
                    }
                }
            },
            removeState: function(storage) {
                storage.removeItem(this._stateStorageKey)
            },
            currentIndex: function() {
                return this.currentStack.currentIndex
            },
            previousItem: function(stackKey) {
                var stack = this.navigationStacks[stackKey] || this.currentStack;
                return stack.previousItem()
            },
            getItemByIndex: function(index) {
                return this.currentStack.items[index]
            },
            clearHistory: function() {
                this._createNavigationStacks({
                    keepPositionInStack: this._keepPositionInStack
                })
            },
            itemByKey: function(itemKey) {
                var result;
                $.each(this.navigationStacks, function(stackKey, stack) {
                    var item = stack.itemByKey(itemKey);
                    if (item) {
                        result = item;
                        return false
                    }
                });
                return result
            },
            currentItem: function(itemOrItemKey) {
                var item;
                if (arguments.length > 0) {
                    if ("string" === typeof itemOrItemKey) {
                        item = this.itemByKey(itemOrItemKey)
                    } else {
                        if (isPlainObject(itemOrItemKey)) {
                            item = itemOrItemKey
                        }
                    }
                    this.callBase(item)
                } else {
                    return this.callBase()
                }
            }
        });
        var NavigationStack = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this.itemsRemoved = $.Callbacks();
                this.clear()
            },
            currentItem: function(item) {
                if (item) {
                    for (var i = 0; i < this.items.length; i++) {
                        if (item === this.items[i]) {
                            this.currentIndex = i;
                            break
                        }
                    }
                } else {
                    return this.items[this.currentIndex]
                }
            },
            previousItem: function() {
                return this.items.length > 1 ? this.items[this.currentIndex - 1] : void 0
            },
            canBack: function() {
                return this.currentIndex > 0
            },
            clear: function() {
                this._deleteItems(this.items);
                this.items = [];
                this.currentIndex = -1
            },
            back: function(uri) {
                this.currentIndex--;
                if (this.currentIndex < 0) {
                    throw errors.Error("E3008")
                }
                var currentItem = this.currentItem();
                if (currentItem.uri !== uri) {
                    this._updateItem(this.currentIndex, uri)
                }
            },
            forward: function() {
                this.currentIndex++;
                if (this.currentIndex >= this.items.length) {
                    throw errors.Error("E3009")
                }
            },
            navigate: function(uri, replaceCurrent) {
                if (this.currentIndex < this.items.length && this.currentIndex > -1 && this.items[this.currentIndex].uri === uri) {
                    return
                }
                if (replaceCurrent && this.currentIndex > -1) {
                    this.currentIndex--
                }
                if (this.currentIndex + 1 < this.items.length && this.items[this.currentIndex + 1].uri === uri) {
                    this.currentIndex++
                } else {
                    var toDelete = this.items.splice(this.currentIndex + 1, this.items.length - this.currentIndex - 1);
                    this.items.push({
                        stack: this
                    });
                    this.currentIndex++;
                    this._updateItem(this.currentIndex, uri);
                    this._deleteItems(toDelete)
                }
                return this.currentItem()
            },
            itemByKey: function(key) {
                for (var i = 0; i < this.items.length; i++) {
                    var item = this.items[i];
                    if (item.key === key) {
                        return item
                    }
                }
            },
            _updateItem: function(index, uri) {
                var item = this.items[index];
                item.uri = uri;
                item.key = this.items[0].uri + "_" + index + "_" + uri
            },
            _deleteItems: function(items) {
                if (items) {
                    this.itemsRemoved.fire(items)
                }
            }
        });
        HistoryBasedNavigationManager.NAVIGATION_TARGETS = NAVIGATION_TARGETS;
        exports.HistoryBasedNavigationManager = HistoryBasedNavigationManager;
        exports.StackBasedNavigationManager = StackBasedNavigationManager;
        exports.NavigationStack = NavigationStack
    },
    /*!********************************************!*\
      !*** ./js/framework/navigation_devices.js ***!
      \********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            noop = __webpack_require__( /*! ../core/utils/common */ 14).noop,
            Class = __webpack_require__( /*! ../core/class */ 25),
            browserAdapters = __webpack_require__( /*! ./browser_adapters */ 135),
            SessionStorage = __webpack_require__( /*! ../core/utils/storage */ 54).sessionStorage,
            devices = __webpack_require__( /*! ../core/devices */ 53);
        var SESSION_KEY = "dxPhoneJSApplication";
        var HistoryBasedNavigationDevice = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this._browserAdapter = options.browserAdapter || this._createBrowserAdapter(options);
                this.uriChanged = $.Callbacks();
                this._browserAdapter.popState.add(this._onPopState.bind(this))
            },
            init: noop,
            getUri: function() {
                return this._browserAdapter.getHash()
            },
            setUri: function(uri, replaceCurrent) {
                if (replaceCurrent) {
                    return this._browserAdapter.replaceState(uri)
                } else {
                    if (uri !== this.getUri()) {
                        return this._browserAdapter.pushState(uri)
                    } else {
                        return $.Deferred().resolve().promise()
                    }
                }
            },
            back: function() {
                return this._browserAdapter.back()
            },
            _onPopState: function() {
                this.uriChanged.fire(this.getUri())
            },
            _isBuggyAndroid2: function() {
                var realDevice = devices.real();
                var version = realDevice.version;
                return "android" === realDevice.platform && version.length > 1 && (2 === version[0] && version[1] < 4 || version[0] < 2)
            },
            _isBuggyAndroid4: function() {
                var realDevice = devices.real();
                var version = realDevice.version;
                return "android" === realDevice.platform && version.length > 1 && 4 === version[0] && 0 === version[1]
            },
            _isWindowsPhone8: function() {
                var realDevice = devices.real();
                return "win" === realDevice.platform && realDevice.phone
            },
            _createBrowserAdapter: function(options) {
                var result, sourceWindow = options.window || window,
                    supportPushReplace = sourceWindow.history.replaceState && sourceWindow.history.pushState;
                if (this._isWindowsPhone8()) {
                    result = new browserAdapters.BuggyCordovaWP81BrowserAdapter(options)
                } else {
                    if (sourceWindow !== sourceWindow.top) {
                        result = new browserAdapters.HistorylessBrowserAdapter(options)
                    } else {
                        if (this._isBuggyAndroid4()) {
                            result = new browserAdapters.BuggyAndroidBrowserAdapter(options)
                        } else {
                            if (this._isBuggyAndroid2() || !supportPushReplace) {
                                result = new browserAdapters.OldBrowserAdapter(options)
                            } else {
                                result = new browserAdapters.DefaultBrowserAdapter(options)
                            }
                        }
                    }
                }
                return result
            }
        });
        var StackBasedNavigationDevice = HistoryBasedNavigationDevice.inherit({
            ctor: function(options) {
                this.callBase(options);
                this.backInitiated = $.Callbacks();
                this._rootStateHandler = null;
                $(window).on("unload", this._saveBrowserState)
            },
            init: function() {
                var that = this;
                if (that._browserAdapter.canWorkInPureBrowser) {
                    return that._initRootPage().done(function() {
                        if (that._browserAdapter.isRootPage()) {
                            that._browserAdapter.pushState("")
                        }
                    })
                } else {
                    return $.Deferred().resolve().promise()
                }
            },
            setUri: function(uri) {
                return this.callBase(uri, !this._browserAdapter.isRootPage())
            },
            _saveBrowserState: function() {
                var sessionStorage = SessionStorage();
                if (sessionStorage) {
                    sessionStorage.setItem(SESSION_KEY, true)
                }
            },
            _initRootPage: function() {
                var hash = this.getUri(),
                    sessionStorage = SessionStorage();
                if (!sessionStorage || sessionStorage.getItem(SESSION_KEY)) {
                    return $.Deferred().resolve().promise()
                }
                sessionStorage.removeItem(SESSION_KEY);
                this._browserAdapter.createRootPage();
                return this._browserAdapter.pushState(hash)
            },
            _onPopState: function() {
                if (this._browserAdapter.isRootPage()) {
                    if (this._rootStateHandler) {
                        this._rootStateHandler()
                    } else {
                        this.backInitiated.fire()
                    }
                } else {
                    if (!this._rootStateHandler) {
                        this._createRootStateHandler()
                    }
                    this.back()
                }
            },
            _createRootStateHandler: function() {
                var uri = this.getUri();
                this._rootStateHandler = function() {
                    this.uriChanged.fire(uri);
                    this._rootStateHandler = null
                }
            }
        });
        exports.HistoryBasedNavigationDevice = HistoryBasedNavigationDevice;
        exports.StackBasedNavigationDevice = StackBasedNavigationDevice
    },
    /*!******************************************!*\
      !*** ./js/framework/browser_adapters.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            Class = __webpack_require__( /*! ../core/class */ 25),
            queue = __webpack_require__( /*! ../core/utils/queue */ 62);
        var ROOT_PAGE_URL = "__root__",
            BUGGY_ANDROID_BUFFER_PAGE_URL = "__buffer__";
        var DefaultBrowserAdapter = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this._window = options.window || window;
                this.popState = $.Callbacks();
                $(this._window).on("hashchange", this._onHashChange.bind(this));
                this._tasks = queue.create();
                this.canWorkInPureBrowser = true
            },
            replaceState: function(uri) {
                var that = this;
                return this._addTask(function() {
                    uri = that._normalizeUri(uri);
                    that._window.history.replaceState(null, null, "#" + uri);
                    that._currentTask.resolve()
                })
            },
            pushState: function(uri) {
                var that = this;
                return this._addTask(function() {
                    uri = that._normalizeUri(uri);
                    that._window.history.pushState(null, null, "#" + uri);
                    that._currentTask.resolve()
                })
            },
            createRootPage: function() {
                return this.replaceState(ROOT_PAGE_URL)
            },
            _onHashChange: function() {
                if (this._currentTask) {
                    this._currentTask.resolve()
                }
                this.popState.fire()
            },
            back: function() {
                var that = this;
                return this._addTask(function() {
                    that._window.history.back()
                })
            },
            getHash: function() {
                return this._normalizeUri(this._window.location.hash)
            },
            isRootPage: function() {
                return this.getHash() === ROOT_PAGE_URL
            },
            _normalizeUri: function(uri) {
                return (uri || "").replace(/^#+/, "")
            },
            _addTask: function(task) {
                var that = this,
                    d = $.Deferred();
                this._tasks.add(function() {
                    that._currentTask = d;
                    task();
                    return d
                });
                return d.promise()
            }
        });
        var OldBrowserAdapter = DefaultBrowserAdapter.inherit({
            ctor: function() {
                this._innerEventCount = 0;
                this.callBase.apply(this, arguments);
                this._skipNextEvent = false
            },
            replaceState: function(uri) {
                var that = this;
                uri = that._normalizeUri(uri);
                if (that.getHash() !== uri) {
                    that._addTask(function() {
                        that._skipNextEvent = true;
                        that._window.history.back()
                    });
                    return that._addTask(function() {
                        that._skipNextEvent = true;
                        that._window.location.hash = uri
                    })
                }
                return $.Deferred().resolve().promise()
            },
            pushState: function(uri) {
                var that = this;
                uri = this._normalizeUri(uri);
                if (this.getHash() !== uri) {
                    return that._addTask(function() {
                        that._skipNextEvent = true;
                        that._window.location.hash = uri
                    })
                }
                return $.Deferred().resolve().promise()
            },
            createRootPage: function() {
                return this.pushState(ROOT_PAGE_URL)
            },
            _onHashChange: function() {
                var currentTask = this._currentTask;
                this._currentTask = null;
                if (this._skipNextEvent) {
                    this._skipNextEvent = false
                } else {
                    this.popState.fire()
                }
                if (currentTask) {
                    currentTask.resolve()
                }
            }
        });
        var BuggyAndroidBrowserAdapter = OldBrowserAdapter.inherit({
            createRootPage: function() {
                this.pushState(BUGGY_ANDROID_BUFFER_PAGE_URL);
                return this.callBase()
            }
        });
        var HistorylessBrowserAdapter = DefaultBrowserAdapter.inherit({
            ctor: function(options) {
                options = options || {};
                this._window = options.window || window;
                this.popState = $.Callbacks();
                $(this._window).on("dxback", this._onHashChange.bind(this));
                this._currentHash = this._window.location.hash
            },
            replaceState: function(uri) {
                this._currentHash = this._normalizeUri(uri);
                return $.Deferred().resolve().promise()
            },
            pushState: function(uri) {
                return this.replaceState(uri)
            },
            createRootPage: function() {
                return this.replaceState(ROOT_PAGE_URL)
            },
            getHash: function() {
                return this._normalizeUri(this._currentHash)
            },
            back: function() {
                return this.replaceState(ROOT_PAGE_URL)
            },
            _onHashChange: function() {
                var promise = this.back();
                this.popState.fire();
                return promise
            }
        });
        var BuggyCordovaWP81BrowserAdapter = DefaultBrowserAdapter.inherit({
            ctor: function(options) {
                this.callBase(options);
                this.canWorkInPureBrowser = false
            }
        });
        exports.DefaultBrowserAdapter = DefaultBrowserAdapter;
        exports.OldBrowserAdapter = OldBrowserAdapter;
        exports.BuggyAndroidBrowserAdapter = BuggyAndroidBrowserAdapter;
        exports.HistorylessBrowserAdapter = HistorylessBrowserAdapter;
        exports.BuggyCordovaWP81BrowserAdapter = BuggyCordovaWP81BrowserAdapter
    },
    /*!*****************************************!*\
      !*** ./js/framework/command_mapping.js ***!
      \*****************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            Class = __webpack_require__( /*! ../core/class */ 25),
            grep = __webpack_require__( /*! ../core/utils/common */ 14).grep,
            extend = __webpack_require__( /*! ../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 26).inArray,
            errors = __webpack_require__( /*! ./errors */ 122);
        var CommandMapping = Class.inherit({
            ctor: function() {
                this._commandMappings = {};
                this._containerDefaults = {}
            },
            setDefaults: function(containerId, defaults) {
                this._containerDefaults[containerId] = defaults;
                return this
            },
            mapCommands: function(containerId, commandMappings) {
                var that = this;
                $.each(commandMappings, function(index, commandMapping) {
                    if ("string" === typeof commandMapping) {
                        commandMapping = {
                            id: commandMapping
                        }
                    }
                    var commandId = commandMapping.id;
                    var mappings = that._commandMappings[containerId] || {};
                    mappings[commandId] = extend({
                        showIcon: true,
                        showText: true
                    }, that._containerDefaults[containerId] || {}, commandMapping);
                    that._commandMappings[containerId] = mappings
                });
                this._initExistingCommands();
                return this
            },
            unmapCommands: function(containerId, commandIds) {
                var that = this;
                $.each(commandIds, function(index, commandId) {
                    var mappings = that._commandMappings[containerId] || {};
                    if (mappings) {
                        delete mappings[commandId]
                    }
                });
                this._initExistingCommands()
            },
            getCommandMappingForContainer: function(commandId, containerId) {
                return (this._commandMappings[containerId] || {})[commandId]
            },
            checkCommandsExist: function(commands) {
                var that = this,
                    result = grep(commands, function(commandName, index) {
                        return inArray(commandName, that._existingCommands) < 0 && inArray(commandName, commands) === index
                    });
                if (0 !== result.length) {
                    throw errors.Error("E3005", result.join("', '"), 1 === result.length ? " is" : "s are")
                }
            },
            load: function(config) {
                if (!config) {
                    return
                }
                var that = this;
                $.each(config, function(name, container) {
                    that.setDefaults(name, container.defaults);
                    that.mapCommands(name, container.commands)
                });
                return this
            },
            _initExistingCommands: function() {
                var that = this;
                this._existingCommands = [];
                $.each(that._commandMappings, function(name, _commands) {
                    $.each(_commands, function(index, command) {
                        if (inArray(command.id, that._existingCommands) < 0) {
                            that._existingCommands.push(command.id)
                        }
                    })
                })
            }
        });
        CommandMapping.defaultMapping = {
            "global-navigation": {
                defaults: {
                    showIcon: true,
                    showText: true
                },
                commands: []
            },
            "ios-header-toolbar": {
                defaults: {
                    showIcon: false,
                    showText: true,
                    location: "after"
                },
                commands: ["edit", "save", {
                    id: "back",
                    location: "before"
                }, {
                    id: "cancel",
                    location: "before"
                }, {
                    id: "create",
                    showIcon: true,
                    showText: false
                }]
            },
            "ios-action-sheet": {
                defaults: {
                    showIcon: false,
                    showText: true
                },
                commands: []
            },
            "ios-view-footer": {
                defaults: {
                    showIcon: false,
                    showText: true
                },
                commands: [{
                    id: "delete",
                    type: "danger"
                }]
            },
            "android-header-toolbar": {
                defaults: {
                    showIcon: true,
                    showText: false,
                    location: "after"
                },
                commands: [{
                    id: "back",
                    showIcon: false,
                    location: "before"
                }, "create", {
                    id: "save",
                    showText: true,
                    showIcon: false,
                    location: "after"
                }, {
                    id: "edit",
                    showText: false,
                    location: "after"
                }, {
                    id: "cancel",
                    showText: false,
                    location: "before"
                }, {
                    id: "delete",
                    showText: false,
                    location: "after"
                }]
            },
            "android-simple-toolbar": {
                defaults: {
                    showIcon: true,
                    showText: false,
                    location: "after"
                },
                commands: [{
                    id: "back",
                    showIcon: false,
                    location: "before"
                }, {
                    id: "create"
                }, {
                    id: "save",
                    showText: true,
                    showIcon: false,
                    location: "after"
                }, {
                    id: "edit",
                    showText: false,
                    location: "after"
                }, {
                    id: "cancel",
                    showText: false,
                    location: "before"
                }, {
                    id: "delete",
                    showText: false,
                    location: "after"
                }]
            },
            "android-footer-toolbar": {
                defaults: {
                    location: "after"
                },
                commands: [{
                    id: "create",
                    showText: false,
                    location: "center"
                }, {
                    id: "edit",
                    showText: false,
                    location: "before"
                }, {
                    id: "delete",
                    locateInMenu: "always"
                }, {
                    id: "save",
                    showIcon: false,
                    location: "before"
                }]
            },
            "generic-header-toolbar": {
                defaults: {
                    showIcon: false,
                    showText: true,
                    location: "after"
                },
                commands: ["edit", "save", {
                    id: "back",
                    location: "before"
                }, {
                    id: "cancel",
                    location: "before"
                }, {
                    id: "create",
                    showIcon: true,
                    showText: false
                }]
            },
            "generic-view-footer": {
                defaults: {
                    showIcon: false,
                    showText: true
                },
                commands: [{
                    id: "delete",
                    type: "danger"
                }]
            },
            "win8-appbar": {
                defaults: {
                    location: "after"
                },
                commands: ["edit", "cancel", "save", "delete", {
                    id: "create",
                    location: "before"
                }, {
                    id: "refresh",
                    location: "before"
                }]
            },
            "win8-toolbar": {
                defaults: {
                    showText: false,
                    location: "before"
                },
                commands: [{
                    id: "previousPage"
                }]
            },
            "win8-phone-appbar": {
                defaults: {
                    location: "center"
                },
                commands: ["create", "edit", "cancel", "save", "refresh", {
                    id: "delete",
                    locateInMenu: "always"
                }]
            },
            "win8-split-toolbar": {
                defaults: {
                    showIcon: true,
                    showText: false,
                    location: "after"
                },
                commands: [{
                    id: "back",
                    showIcon: false,
                    location: "before"
                }, {
                    id: "create"
                }, {
                    id: "save",
                    showText: true,
                    location: "before"
                }, {
                    id: "edit",
                    showText: true,
                    locateInMenu: "always"
                }, {
                    id: "cancel",
                    showText: true,
                    locateInMenu: "always"
                }, {
                    id: "delete",
                    showText: true,
                    locateInMenu: "always"
                }]
            },
            "win8-master-detail-toolbar": {
                defaults: {
                    showText: false,
                    location: "before"
                },
                commands: ["back"]
            },
            "win10-appbar": {
                defaults: {
                    showText: false,
                    location: "after"
                },
                commands: [{
                    id: "back",
                    location: "before"
                }, "edit", "cancel", "save", "delete", "create", "refresh"]
            },
            "win10-phone-appbar": {
                defaults: {
                    location: "after"
                },
                commands: ["create", "edit", "cancel", "save", "refresh", {
                    id: "delete",
                    locateInMenu: "always"
                }]
            },
            "desktop-toolbar": {
                defaults: {
                    showIcon: false,
                    showText: true,
                    location: "after"
                },
                commands: ["cancel", "create", "edit", "save", {
                    id: "delete",
                    type: "danger"
                }]
            }
        };
        module.exports = CommandMapping
    },
    /*!**************************!*\
      !*** ./js/data/utils.js ***!
      \**************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            isFunction = __webpack_require__( /*! ../core/utils/common */ 14).isFunction,
            toComparable = __webpack_require__( /*! ../core/utils/data */ 50).toComparable;
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return $.map(info, function(i) {
                var result = {
                    selector: isFunction(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var textStatusDetails = {
                timeout: "possible causes: the remote host is not accessible, overloaded or is not included into the domain white-list when being run in the native container",
                error: "if the remote host is located on another domain, make sure it properly supports cross-origin resource sharing (CORS), or use the JSONP approach instead",
                parsererror: "the remote host did not respond with valid JSON data"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                result += " (" + textStatusDetails[textStatus] + ")";
                return result
            };
            var unloading;
            window.addEventListener("beforeunload", function() {
                unloading = true
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockDeferred, lockCount = 0;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = $.Deferred()
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? $.Deferred().resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|\&\&|\&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var name, names = $.map(key1, function(v, k) {
                    return k
                });
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if (toComparable(key1[name], true) != toComparable(key2[name], true)) {
                        return false
                    }
                }
                return true
            }
            return toComparable(key1, true) == toComparable(key2, true)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i],
                    octet2 = input[i + 1],
                    octet3 = input[i + 2];
                result += $.map([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };
        var stringToByteArray = function(str) {
            var code, i, bytes = [];
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        };
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            base64_encode: base64_encode
        };
        module.exports = utils
    },
    /*!**************************************!*\
      !*** ./js/framework/html/presets.js ***!
      \**************************************/
    function(module, exports) {
        exports.layoutSets = {};
        exports.animationSets = {
            "native": {
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "none",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            },
            "default": {
                "layout-change": [{
                    animation: "none"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "pop",
                    device: {
                        platform: "android"
                    }
                }, {
                    animation: "openDoor",
                    device: {
                        deviceType: "phone",
                        platform: "win",
                        version: [8]
                    }
                }, {
                    animation: "win-pop",
                    device: {
                        deviceType: "phone",
                        platform: "win"
                    }
                }],
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-content-rendered": [{
                    animation: "fade"
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-top": [{
                    animation: "stagger-fade-drop"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }, {
                    animation: "none",
                    device: {
                        platform: "win",
                        version: [10]
                    }
                }],
                "command-rendered-bottom": [{
                    animation: "stagger-fade-rise"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }, {
                    animation: "none",
                    device: {
                        platform: "win",
                        version: [10]
                    }
                }],
                "list-item-rendered": [{
                    animation: "stagger-3d-drop",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "detail-item-rendered": [{
                    animation: "stagger-3d-drop",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "edit-item-rendered": [{
                    animation: "stagger-3d-drop",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            },
            slide: {
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-content-rendered": [{
                    animation: "fade"
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-top": [{
                    animation: "stagger-fade-drop"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-bottom": [{
                    animation: "stagger-fade-rise"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "list-item-rendered": [{
                    animation: "stagger-fade-slide",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "detail-item-rendered": [{
                    animation: "stagger-fade-slide",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "edit-item-rendered": [{
                    animation: "stagger-fade-slide",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            },
            zoom: {
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-content-rendered": [{
                    animation: "fade"
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-top": [{
                    animation: "stagger-fade-zoom"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-bottom": [{
                    animation: "stagger-fade-zoom"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "list-item-rendered": [{
                    animation: "stagger-fade-zoom",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "detail-item-rendered": [{
                    animation: "stagger-fade-zoom",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "edit-item-rendered": [{
                    animation: "stagger-fade-zoom",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            }
        }
    },
    /*!**********************************************!*\
      !*** ./js/framework/html/command_manager.js ***!
      \**********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            noop = __webpack_require__( /*! ../../core/utils/common */ 14).noop,
            errors = __webpack_require__( /*! ../errors */ 122),
            CommandMapping = __webpack_require__( /*! ../command_mapping */ 136),
            commandToDXWidgetAdapters = __webpack_require__( /*! ./widget_command_adapters */ 140),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when;
        __webpack_require__( /*! ../command */ 121);
        __webpack_require__( /*! ./command_container */ 126);
        var CommandManager = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this.defaultWidgetAdapter = options.defaultWidgetAdapter || this._getDefaultWidgetAdapter();
                this.commandMapping = options.commandMapping || new CommandMapping
            },
            _getDefaultWidgetAdapter: function() {
                return {
                    addCommand: noop,
                    clearContainer: noop
                }
            },
            _getContainerAdapter: function($container) {
                var componentNames = $container.data("dxComponents"),
                    adapters = commandToDXWidgetAdapters;
                if (componentNames) {
                    for (var index in componentNames) {
                        var widgetName = componentNames[index];
                        if (widgetName in adapters) {
                            return adapters[widgetName]
                        }
                    }
                }
                return this.defaultWidgetAdapter
            },
            findCommands: function($items) {
                var items = $items.find(".dx-command").add($items.filter(".dx-command"));
                var result = $.map(items, function(element) {
                    return $(element).dxCommand("instance")
                });
                return result
            },
            findCommandContainers: function($markup) {
                var result = $.map($markup.find(".dx-command-container"), function(element) {
                    return $(element).dxCommandContainer("instance")
                });
                return result
            },
            _checkCommandId: function(id, command) {
                if (null === id) {
                    throw errors.Error("E3010", command.element().get(0).outerHTML)
                }
            },
            renderCommandsToContainers: function(commands, containers) {
                var that = this,
                    commandHash = {},
                    commandIds = [],
                    deferreds = [];
                $.each(commands, function(i, command) {
                    var id = command.option("id");
                    that._checkCommandId(id, command);
                    commandIds.push(id);
                    commandHash[id] = command
                });
                that.commandMapping.checkCommandsExist(commandIds);
                $.each(containers, function(k, container) {
                    var commandInfos = [];
                    $.each(commandHash, function(id, command) {
                        var commandId = id;
                        var commandOptions = that.commandMapping.getCommandMappingForContainer(commandId, container.option("id"));
                        if (commandOptions) {
                            commandInfos.push({
                                command: command,
                                options: commandOptions
                            })
                        }
                    });
                    if (commandInfos.length) {
                        var deferred = that._attachCommandsToContainer(container.element(), commandInfos);
                        if (deferred) {
                            deferreds.push(deferred)
                        }
                    }
                });
                return when.apply($, deferreds)
            },
            clearContainer: function(container) {
                var $container = container.element(),
                    adapter = this._getContainerAdapter($container);
                adapter.clearContainer($container)
            },
            _arrangeCommandsToContainers: function(commands, containers) {
                errors.log("W0002", "CommandManager", "_arrangeCommandsToContainers", "14.1", "Use the 'renderCommandsToContainers' method instead.");
                this.renderCommandsToContainers(commands, containers)
            },
            _attachCommandsToContainer: function($container, commandInfos) {
                var result, adapter = this._getContainerAdapter($container);
                if (adapter.beginUpdate) {
                    adapter.beginUpdate($container)
                }
                $.each(commandInfos, function(index, commandInfo) {
                    adapter.addCommand($container, commandInfo.command, commandInfo.options)
                });
                if (adapter.endUpdate) {
                    result = adapter.endUpdate($container)
                }
                return result
            }
        });
        module.exports = CommandManager
    },
    /*!******************************************************!*\
      !*** ./js/framework/html/widget_command_adapters.js ***!
      \******************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            commandToContainer = __webpack_require__( /*! ../utils */ 131).utils.commandToContainer,
            fx = __webpack_require__( /*! ../../animation/fx */ 68),
            TransitionExecutorModule = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 74),
            DX_COMMAND_TO_WIDGET_ADAPTER = "dxCommandToWidgetAdapter";
        var WidgetItemWrapperBase = Class.inherit({
            ctor: function(command, containerOptions) {
                this.command = command;
                this.widgetItem = this._createWidgetItem(command, containerOptions)
            },
            _createWidgetItem: function(command, containerOptions) {
                var result, itemOptions = extend({}, containerOptions, command.option()),
                    executeCommandCallback = function(e) {
                        command.execute(e)
                    };
                itemOptions.text = commandToContainer.resolveTextValue(command, containerOptions);
                itemOptions.icon = commandToContainer.resolveIconValue(command, containerOptions);
                itemOptions.type = commandToContainer.resolvePropertyValue(command, containerOptions, "type");
                itemOptions.location = commandToContainer.resolvePropertyValue(command, containerOptions, "location");
                itemOptions.locateInMenu = commandToContainer.resolvePropertyValue(command, containerOptions, "locateInMenu");
                itemOptions.showText = commandToContainer.resolvePropertyValue(command, containerOptions, "showText");
                result = this._createWidgetItemCore(itemOptions, executeCommandCallback);
                result.command = command;
                return result
            },
            _createWidgetItemCore: function(itemOptions, executeCommandCallback) {
                return itemOptions
            },
            dispose: function() {
                delete this.command;
                delete this.widgetItem
            }
        });
        var WidgetAdapterBase = Class.inherit({
            ctor: function($widgetElement) {
                this._commandToWidgetItemOptionNames = {};
                this.$widgetElement = $widgetElement;
                this.$widgetElement.data(DX_COMMAND_TO_WIDGET_ADAPTER, this);
                this.widget = this._getWidgetByElement($widgetElement);
                this._widgetWidgetContentReadyHandler = this._onWidgetContentReady.bind(this);
                this._widgetWidgetItemRenderedHandler = this._onWidgetItemRendered.bind(this);
                this._widgetDisposingHandler = this._onWidgetDisposing.bind(this);
                this.widget.on("itemRendered", this._widgetWidgetItemRenderedHandler);
                this.widget.on("contentReady", this._widgetWidgetContentReadyHandler);
                this.widget.on("disposing", this._widgetDisposingHandler);
                this.itemWrappers = [];
                this._transitionExecutor = new TransitionExecutorModule.TransitionExecutor
            },
            addCommand: function(command, containerOptions) {
                var itemWrapper = this._createItemWrapper(command, containerOptions);
                this.itemWrappers.push(itemWrapper);
                this._addItemToWidget(itemWrapper);
                this._commandChangedHandler = this._onCommandChanged.bind(this);
                itemWrapper.command.on("optionChanged", this._commandChangedHandler)
            },
            beginUpdate: function() {
                this.widget.beginUpdate()
            },
            endUpdate: function() {
                this.widget.endUpdate();
                return this.animationDeferred
            },
            _onWidgetItemRendered: function(e) {
                if (e.itemData.isJustAdded && e.itemData.command && e.itemData.command.option("visible") && this._commandRenderedAnimation) {
                    this._transitionExecutor.enter(e.itemElement, this._commandRenderedAnimation);
                    delete e.itemData.isJustAdded
                }
            },
            _onWidgetContentReady: function(e) {
                this.animationDeferred = this._transitionExecutor.start()
            },
            _onWidgetDisposing: function() {
                this.dispose(true)
            },
            _setWidgetItemOption: function(optionName, optionValue, itemCommand) {
                var items = this.widget.option("items"),
                    itemIndex = inArray(itemCommand, $.map(items, function(item) {
                        return item.command || {}
                    }));
                if (itemIndex > -1) {
                    var optionPath = "items[" + itemIndex + "].";
                    if (!this._requireWidgetRefresh(optionName) && this.widget.option("items[" + itemIndex + "]").options) {
                        optionPath += "options."
                    }
                    optionPath += this._commandToWidgetItemOptionNames[optionName] || optionName;
                    this.widget.option(optionPath, optionValue)
                }
            },
            _requireWidgetRefresh: function(optionName) {
                return "visible" === optionName || "locateInMenu" === optionName || "location" === optionName
            },
            _onCommandChanged: function(args) {
                if ("highlighted" === args.name || args.component.isOptionDeprecated(args.name)) {
                    return
                }
                this._setWidgetItemOption(args.name, args.value, args.component)
            },
            _addItemToWidget: function(itemWrapper) {
                var items = this.widget.option("items");
                items.push(itemWrapper.widgetItem);
                if (this.widget.element().is(":visible")) {
                    itemWrapper.widgetItem.isJustAdded = true
                }
                this.widget.option("items", items)
            },
            refresh: function() {
                var items = this.widget.option("items");
                this.widget.option("items", items)
            },
            clear: function(widgetDisposing) {
                var that = this;
                $.each(that.itemWrappers, function(index, itemWrapper) {
                    itemWrapper.command.off("optionChanged", that._commandChangedHandler);
                    itemWrapper.dispose()
                });
                this.itemWrappers.length = 0;
                if (!widgetDisposing) {
                    this._clearWidgetItems()
                }
            },
            _clearWidgetItems: function() {
                this.widget.option("items", [])
            },
            dispose: function(widgetDisposing) {
                this.clear(widgetDisposing);
                if (this.widget) {
                    this.widget.off("itemRendered", this._widgetWidgetItemRenderedHandler);
                    this.widget.off("contentReady", this._widgetContentReadyHandler);
                    this.widget.off("disposing", this._widgetDisposingHandler);
                    this.$widgetElement.removeData(DX_COMMAND_TO_WIDGET_ADAPTER);
                    delete this.widget;
                    delete this.$widgetElement
                }
            }
        });
        var CommandToWidgetAdapter = Class.inherit({
            ctor: function(createAdapter) {
                this.createAdapter = createAdapter
            },
            _getWidgetAdapter: function($container) {
                var widgetAdapter = $container.data(DX_COMMAND_TO_WIDGET_ADAPTER);
                if (!widgetAdapter) {
                    widgetAdapter = this.createAdapter($container)
                }
                return widgetAdapter
            },
            addCommand: function($container, command, containerOptions) {
                var widgetAdapter = this._getWidgetAdapter($container);
                widgetAdapter.addCommand(command, containerOptions)
            },
            clearContainer: function($container) {
                var widgetAdapter = this._getWidgetAdapter($container);
                widgetAdapter.clear()
            },
            beginUpdate: function($container) {
                var widgetAdapter = this._getWidgetAdapter($container);
                widgetAdapter.beginUpdate()
            },
            endUpdate: function($container) {
                var widgetAdapter = this._getWidgetAdapter($container);
                return widgetAdapter.endUpdate()
            }
        });
        var dxToolbarItemWrapper = WidgetItemWrapperBase.inherit({
            _createWidgetItemCore: function(itemOptions, executeCommandCallback) {
                var widgetItem;
                itemOptions.onClick = executeCommandCallback;
                if ("menu" === itemOptions.location || "always" === itemOptions.locateInMenu) {
                    widgetItem = itemOptions;
                    widgetItem.isAction = true
                } else {
                    widgetItem = {
                        locateInMenu: itemOptions.locateInMenu,
                        location: itemOptions.location,
                        visible: itemOptions.visible,
                        options: itemOptions,
                        widget: "dxButton"
                    };
                    if ("inMenu" === itemOptions.showText) {
                        widgetItem.showText = itemOptions.showText
                    }
                    itemOptions.visible = true;
                    delete itemOptions.location
                }
                return widgetItem
            }
        });
        var dxToolbarAdapter = WidgetAdapterBase.inherit({
            ctor: function($widgetElement) {
                this.callBase($widgetElement);
                this._commandToWidgetItemOptionNames = {
                    title: "text"
                };
                if ("topToolbar" === this.widget.option("renderAs")) {
                    this._commandRenderedAnimation = "command-rendered-top"
                } else {
                    this._commandRenderedAnimation = "command-rendered-bottom"
                }
            },
            _getWidgetByElement: function($element) {
                return $element.dxToolbar("instance")
            },
            _createItemWrapper: function(command, containerOptions) {
                return new dxToolbarItemWrapper(command, containerOptions)
            },
            addCommand: function(command, containerOptions) {
                this.widget.option("visible", true);
                this.callBase(command, containerOptions)
            }
        });
        var dxListItemWrapper = WidgetItemWrapperBase.inherit({
            _createWidgetItemCore: function(itemOptions, executeCommandCallback) {
                itemOptions.title = itemOptions.text;
                itemOptions.onClick = executeCommandCallback;
                return itemOptions
            }
        });
        var dxListAdapter = WidgetAdapterBase.inherit({
            _createItemWrapper: function(command, containerOptions) {
                return new dxListItemWrapper(command, containerOptions)
            },
            _getWidgetByElement: function($element) {
                return $element.dxList("instance")
            }
        });
        var dxNavBarItemWrapper = WidgetItemWrapperBase.inherit({});
        var dxNavBarAdapter = WidgetAdapterBase.inherit({
            ctor: function($widgetElement) {
                this.callBase($widgetElement);
                this._commandToWidgetItemOptionNames = {
                    title: "text"
                };
                this.widget.option("onItemClick", this._onNavBarItemClick.bind(this))
            },
            _onNavBarItemClick: function(e) {
                var items = this.widget.option("items");
                for (var i = items.length; --i;) {
                    items[i].command.option("highlighted", false)
                }
                e.itemData.command.execute(e)
            },
            _getWidgetByElement: function($element) {
                return $element.dxNavBar("instance")
            },
            _createItemWrapper: function(command, containerOptions) {
                return new dxNavBarItemWrapper(command, containerOptions)
            },
            addCommand: function(command, containerOptions) {
                this.callBase(command, containerOptions);
                this._updateSelectedIndex()
            },
            _onCommandChanged: function(args) {
                var optionName = args.name,
                    newValue = args.value;
                if ("highlighted" === optionName && newValue) {
                    this._updateSelectedIndex()
                }
                this.callBase(args)
            },
            _updateSelectedIndex: function() {
                var items = this.widget.option("items");
                for (var i = 0, itemsCount = items.length; i < itemsCount; i++) {
                    var command = items[i].command;
                    if (command && command.option("highlighted")) {
                        this.widget.option("selectedIndex", i);
                        break
                    }
                }
            }
        });
        var dxPivotItemWrapper = WidgetItemWrapperBase.inherit({
            _createWidgetItemCore: function(itemOptions, executeCommandCallback) {
                itemOptions.title = itemOptions.text;
                return itemOptions
            }
        });
        var dxPivotAdapter = WidgetAdapterBase.inherit({
            ctor: function($widgetElement) {
                this.callBase($widgetElement);
                this.widget.option("onSelectionChanged", this._onPivotSelectionChange.bind(this))
            },
            _onPivotSelectionChange: function(e) {
                if (e.addedItems.length && e.removedItems.length && e.addedItems[0] && e.addedItems[0].command) {
                    e.addedItems[0].command.execute(e)
                }
            },
            _getWidgetByElement: function($element) {
                return $element.dxPivot("instance")
            },
            _createItemWrapper: function(command, containerOptions) {
                return new dxPivotItemWrapper(command, containerOptions)
            },
            addCommand: function(command, containerOptions) {
                this.callBase(command, containerOptions);
                this._updateSelectedIndex()
            },
            _onCommandChanged: function(args) {
                var optionName = args.name,
                    newValue = args.value;
                if ("visible" === optionName) {
                    this._reRenderPivot()
                } else {
                    if ("highlighted" === optionName && newValue) {
                        this._updateSelectedIndex()
                    }
                }
                this.callBase(args)
            },
            _addItemToWidget: function(itemWrapper) {
                if (itemWrapper.command.option("visible")) {
                    this.callBase(itemWrapper)
                }
            },
            _updateSelectedIndex: function() {
                var pivot = this.widget,
                    items = pivot.option("items") || [];
                fx.off = true;
                for (var i = 0, itemsCount = items.length; i < itemsCount; i++) {
                    var command = items[i].command;
                    if (command && command.option("highlighted")) {
                        pivot.option("selectedIndex", i);
                        break
                    }
                }
                fx.off = false
            },
            _reRenderPivot: function() {
                var that = this;
                that.widget.option("items", []);
                $.each(that.itemWrappers, function(index, itemWrapper) {
                    if (itemWrapper.command.option("visible")) {
                        that._addItemToWidget(itemWrapper)
                    }
                });
                that.refresh();
                that._updateSelectedIndex()
            }
        });
        var dxSlideOutItemWrapper = WidgetItemWrapperBase.inherit({});
        var dxSlideOutAdapter = WidgetAdapterBase.inherit({
            ctor: function($widgetElement) {
                this.callBase($widgetElement);
                this._commandToWidgetItemOptionNames = {
                    title: "text"
                };
                this.widget.option("onItemClick", this._onSlideOutItemClick.bind(this))
            },
            _onSlideOutItemClick: function(e) {
                e.itemData.command.execute(e)
            },
            _getWidgetByElement: function($element) {
                return $element.dxSlideOut("instance")
            },
            _createItemWrapper: function(command, containerOptions) {
                return new dxSlideOutItemWrapper(command, containerOptions)
            },
            _updateSelectedIndex: function() {
                var items = this.widget.option("items") || [];
                for (var i = 0, itemsCount = items.length; i < itemsCount; i++) {
                    var command = items[i].command;
                    if (command && command.option("highlighted")) {
                        this.widget.option("selectedIndex", i);
                        break
                    }
                }
            },
            addCommand: function(command, containerOptions) {
                this.callBase(command, containerOptions);
                this._updateSelectedIndex()
            },
            _onCommandChanged: function(args) {
                var optionName = args.name,
                    newValue = args.value;
                if ("highlighted" === optionName && newValue) {
                    this._updateSelectedIndex()
                }
                this.callBase(args)
            }
        });
        exports.dxToolbar = new CommandToWidgetAdapter(function($widgetElement) {
            return new dxToolbarAdapter($widgetElement)
        });
        exports.dxList = new CommandToWidgetAdapter(function($widgetElement) {
            return new dxListAdapter($widgetElement)
        });
        exports.dxNavBar = new CommandToWidgetAdapter(function($widgetElement) {
            return new dxNavBarAdapter($widgetElement)
        });
        exports.dxPivot = new CommandToWidgetAdapter(function($widgetElement) {
            return new dxPivotAdapter($widgetElement)
        });
        exports.dxSlideOut = new CommandToWidgetAdapter(function($widgetElement) {
            return new dxSlideOutAdapter($widgetElement)
        });
        exports.WidgetItemWrapperBase = WidgetItemWrapperBase;
        exports.WidgetAdapterBase = WidgetAdapterBase
    },
    /*!******************************************!*\
      !*** ./js/framework/html/view_engine.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            version = __webpack_require__( /*! ../../core/version */ 19),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            errors = __webpack_require__( /*! ../errors */ 122),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when,
            _VIEW_ROLE = "dxView",
            _LAYOUT_ROLE = "dxLayout",
            MARKUP_TEMPLATE_MARKER = "MarkupTemplate:";
        __webpack_require__( /*! ./view_engine_components */ 128);
        var ViewEngine = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this.$root = options.$root;
                this.device = options.device || {};
                this.dataOptionsAttributeName = options.dataOptionsAttributeName || "data-options";
                this._templateMap = {};
                this._pendingViewContainer = null;
                this.markupLoaded = $.Callbacks();
                this._templateContext = options.templateContext;
                this._$skippedMarkup = $();
                if (void 0 !== options.templatesVersion && options.templateCacheStorage && this._isReleaseVersion()) {
                    this._templateCacheEnabled = true;
                    this._templatesVersion = "v_" + options.templatesVersion;
                    this._templateCacheStorage = options.templateCacheStorage;
                    this._templateCacheKey = "dxTemplateCache_" + version + "_" + JSON.stringify(this.device)
                }
            },
            _isReleaseVersion: function() {
                return !/http:\/\/localhost/.test(location.href)
            },
            _enumerateTemplates: function(processFn) {
                var that = this;
                $.each(that._templateMap, function(name, templatesByRoleMap) {
                    $.each(templatesByRoleMap, function(role, templates) {
                        $.each(templates, function(index, template) {
                            processFn(template)
                        })
                    })
                })
            },
            _findComponent: function(name, role) {
                var components = (this._templateMap[name] || {})[role] || [],
                    filter = this._templateContext && this._templateContext.option() || {};
                components = this._filterTemplates(filter, components);
                this._checkMatchedTemplates(components);
                return components[0]
            },
            _findTemplate: function(name, role) {
                var component = this._findComponent(name, role);
                if (!component) {
                    this._clearCache();
                    throw errors.Error("E3013", role, name)
                }
                var $result, $template = component.element();
                if (!component._isStaticComponentsCreated) {
                    domUtils.createComponents($template, ["dxContent", "dxContentPlaceholder", "dxTransition"]);
                    component._isStaticComponentsCreated = true
                }
                $result = $template.clone().removeClass("dx-hidden");
                return $result
            },
            _clearCache: function() {
                if (this._templateCacheEnabled) {
                    this._templateCacheStorage.removeItem(this._templateCacheKey)
                }
            },
            _loadTemplatesFromMarkupCore: function($markup) {
                var that = this;
                if ($markup.find("[data-dx-role]").length) {
                    throw errors.Error("E3019")
                }
                that.markupLoaded.fire({
                    markup: $markup
                });
                var components = domUtils.createComponents($markup, [_VIEW_ROLE, _LAYOUT_ROLE]);
                $.each(components, function(index, component) {
                    var $element = component.element();
                    $element.addClass("dx-hidden");
                    that._registerTemplateComponent(component);
                    component.element().detach()
                });
                var $skipped = $markup.filter("script");
                $skipped.appendTo(that.$root);
                that._$skippedMarkup = that._$skippedMarkup.add($skipped)
            },
            _registerTemplateComponent: function(component) {
                var role = component.NAME,
                    options = component.option(),
                    templateName = options.name,
                    componentsByRoleMap = this._templateMap[templateName] || {};
                componentsByRoleMap[role] = componentsByRoleMap[role] || [];
                componentsByRoleMap[role].push(component);
                this._templateMap[templateName] = componentsByRoleMap
            },
            _applyPartialViews: function($render) {
                var that = this;
                domUtils.createComponents($render, ["dxViewPlaceholder"]);
                $.each($render.find(".dx-view-placeholder"), function() {
                    var $partialPlaceholder = $(this);
                    if ($partialPlaceholder.children().length) {
                        return
                    }
                    var viewName = $partialPlaceholder.data("dxViewPlaceholder").option("viewName"),
                        $view = that._findTemplate(viewName, _VIEW_ROLE);
                    that._applyPartialViews($view);
                    $partialPlaceholder.append($view);
                    $view.removeClass("dx-hidden")
                })
            },
            _ajaxImpl: function() {
                return $.ajax.apply($, arguments)
            },
            _loadTemplatesFromURL: function(url) {
                var that = this,
                    options = this._getLoadOptions(),
                    deferred = $.Deferred();
                url = options.winPhonePrefix + url;
                this._ajaxImpl({
                    url: url,
                    isLocal: options.isLocal,
                    dataType: "html"
                }).done(function(data) {
                    that._loadTemplatesFromMarkupCore(domUtils.createMarkupFromString(data));
                    deferred.resolve()
                }).fail(function(jqXHR, textStatus, errorThrown) {
                    var error = errors.Error("E3021", url, errorThrown);
                    deferred.reject(error)
                });
                return deferred.promise()
            },
            _getLoadOptions: function() {
                if (location.protocol.indexOf("wmapp") >= 0) {
                    return {
                        winPhonePrefix: location.protocol + "www/",
                        isLocal: true
                    }
                }
                return {
                    winPhonePrefix: "",
                    isLocal: void 0
                }
            },
            _loadExternalTemplates: function() {
                var tasks = [],
                    that = this;
                $("head").find("link[rel='dx-template']").each(function(index, link) {
                    var task = that._loadTemplatesFromURL($(link).attr("href"));
                    tasks.push(task)
                });
                return when.apply($, tasks)
            },
            _processTemplates: function() {
                var that = this;
                $.each(that._templateMap, function(name, templatesByRoleMap) {
                    $.each(templatesByRoleMap, function(role, templates) {
                        that._filterTemplatesByDevice(templates)
                    })
                });
                that._enumerateTemplates(function(template) {
                    that._applyPartialViews(template.element())
                })
            },
            _filterTemplatesByDevice: function(components) {
                var filteredComponents = this._filterTemplates(this.device, components);
                $.each(components, function(index, component) {
                    if (inArray(component, filteredComponents) < 0) {
                        component.element().remove()
                    }
                });
                components.length = 0;
                components.push.apply(components, filteredComponents)
            },
            _filterTemplates: function(filter, components) {
                return commonUtils.findBestMatches(filter, components, function(component) {
                    return component.option()
                })
            },
            _checkMatchedTemplates: function(bestMatches) {
                if (bestMatches.length > 1) {
                    var message = "";
                    $.each(bestMatches, function(index, match) {
                        message += match.element().attr("data-options") + "\r\n"
                    });
                    throw errors.Error("E3020", message, JSON.stringify(this.device))
                }
            },
            _wrapViewDefaultContent: function($viewTemplate) {
                $viewTemplate.wrapInner('<div class="dx-full-height"></div>');
                $viewTemplate.children().eq(0).dxContent({
                    targetPlaceholder: "content"
                })
            },
            _initDefaultLayout: function() {
                this._$defaultLayoutTemplate = $('<div class="dx-full-height" data-options="dxLayout : { name: \'default\' } "> \n    <div class="dx-full-height" data-options="dxContentPlaceholder : { name: \'content\' } " ></div> \n</div>');
                domUtils.createComponents(this._$defaultLayoutTemplate)
            },
            _getDefaultLayoutTemplate: function() {
                return this._$defaultLayoutTemplate.clone()
            },
            applyLayout: function($view, $layout) {
                if (void 0 === $layout || 0 === $layout.length) {
                    $layout = this._getDefaultLayoutTemplate()
                }
                if (0 === $view.children(".dx-content").length) {
                    this._wrapViewDefaultContent($view)
                }
                var $toMerge = $().add($layout).add($view);
                var $placeholderContents = $toMerge.find(".dx-content");
                $.each($placeholderContents, function() {
                    var $placeholderContent = $(this);
                    var placeholderId = $placeholderContent.attr("data-dx-target-placeholder-id");
                    var $placeholder = $toMerge.find(".dx-content-placeholder-" + placeholderId);
                    $placeholder.empty();
                    $placeholder.append($placeholderContent)
                });
                for (var i = $placeholderContents.length; i >= 0; i--) {
                    var $item = $placeholderContents.eq(i);
                    if (!$item.is(".dx-content-placeholder .dx-content")) {
                        $item.remove()
                    }
                }
                return $layout
            },
            _loadTemplatesFromCache: function() {
                if (!this._templateCacheEnabled) {
                    return
                }
                var cache;
                var fromJSONInterceptor = function(key, value) {
                    if ("string" === typeof value && 0 === value.indexOf(MARKUP_TEMPLATE_MARKER)) {
                        var data = JSON.parse(value.substr(MARKUP_TEMPLATE_MARKER.length)),
                            type = data.type,
                            options = data.options,
                            $markup = domUtils.createMarkupFromString(data.markup);
                        options.fromCache = true;
                        return $markup[type](options)[type]("instance")
                    } else {
                        if ("skippedMarkup" === key) {
                            return $("<div>").append(domUtils.createMarkupFromString(value)).contents()
                        }
                    }
                    return value
                };
                var toParse = this._templateCacheStorage.getItem(this._templateCacheKey);
                if (toParse) {
                    try {
                        var cacheContainer = JSON.parse(toParse, fromJSONInterceptor);
                        cache = cacheContainer[this._templatesVersion]
                    } catch (e) {
                        this._clearCache()
                    }
                }
                if (!cache) {
                    return
                }
                this._templateMap = cache.templates;
                this.$root.append(cache.skippedMarkup);
                return true
            },
            _putTemplatesToCache: function() {
                if (!this._templateCacheEnabled) {
                    return
                }
                var toJSONInterceptor = function(key, value) {
                    if (value && value.element) {
                        return MARKUP_TEMPLATE_MARKER + JSON.stringify({
                            markup: value.element().prop("outerHTML"),
                            options: value.option(),
                            type: value.NAME
                        })
                    } else {
                        if ("skippedMarkup" === key) {
                            return $("<div>").append(value.clone()).html()
                        }
                    }
                    return value
                };
                var cacheContainer = {};
                cacheContainer[this._templatesVersion] = {
                    templates: this._templateMap,
                    skippedMarkup: this._$skippedMarkup
                };
                this._templateCacheStorage.setItem(this._templateCacheKey, JSON.stringify(cacheContainer, toJSONInterceptor, 4))
            },
            init: function() {
                var that = this;
                this._initDefaultLayout();
                if (!this._loadTemplatesFromCache()) {
                    that._loadTemplatesFromMarkupCore(that.$root.children());
                    return this._loadExternalTemplates().done(function() {
                        that._processTemplates();
                        that._putTemplatesToCache()
                    })
                } else {
                    return $.Deferred().resolve().promise()
                }
            },
            getViewTemplate: function(viewName) {
                return this._findTemplate(viewName, _VIEW_ROLE)
            },
            getViewTemplateInfo: function(name) {
                return this._findComponent(name, _VIEW_ROLE)
            },
            getLayoutTemplate: function(layoutName) {
                if (!layoutName) {
                    return this._getDefaultLayoutTemplate()
                }
                return this._findTemplate(layoutName, _LAYOUT_ROLE)
            },
            getLayoutTemplateInfo: function(name) {
                return this._findComponent(name, _LAYOUT_ROLE)
            },
            loadTemplates: function(source) {
                var result;
                if ("string" === typeof source) {
                    result = this._loadTemplatesFromURL(source)
                } else {
                    this._loadTemplatesFromMarkupCore(source);
                    result = $.Deferred().resolve().promise()
                }
                return result.done(this._processTemplates.bind(this))
            }
        });
        exports.ViewEngine = ViewEngine
    },
    /*!************************************************!*\
      !*** ./js/framework/html/layout_controller.js ***!
      \************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            frameworkUtils = __webpack_require__( /*! ../utils */ 131),
            layoutSets = __webpack_require__( /*! ./presets */ 138).layoutSets,
            EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 51),
            errors = __webpack_require__( /*! ../errors */ 122),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when,
            HIDDEN_BAG_ID = "__hidden-bag",
            TRANSITION_SELECTOR = ".dx-transition",
            CONTENT_SELECTOR = ".dx-content",
            DEFAULT_COMMAND_RENDER_STAGE = "onViewShown",
            CONTENT_RENDERED_EVENT_NAME = "dxcontentrendered.layoutController",
            PENDING_RENDERING_SELECTOR = ".dx-pending-rendering",
            PENDING_RENDERING_MANUAL_SELECTOR = ".dx-pending-rendering-manual",
            TransitionExecutorModule = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 74);
        __webpack_require__( /*! ./command_container */ 126);
        __webpack_require__( /*! ./view_engine_components */ 128);
        var transitionSelector = function(transitionName) {
            return ".dx-transition-" + transitionName
        };
        var DefaultLayoutController = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this.name = options.name || "";
                this._layoutModel = options.layoutModel || {};
                this._defaultPaneName = options.defaultPaneName || "content";
                this._transitionDuration = void 0 === options.transitionDuration ? 400 : options.transitionDuration;
                this._showViewFired = false
            },
            init: function(options) {
                options = options || {};
                this._visibleViews = {};
                this._$viewPort = options.$viewPort || $("body");
                this._commandManager = options.commandManager;
                this._viewEngine = options.viewEngine;
                this.transitionExecutor = new TransitionExecutorModule.TransitionExecutor;
                this._prepareTemplates();
                this._$viewPort.append(this.element());
                this._hideElements(this.element());
                if (options.templateContext) {
                    this._templateContext = options.templateContext;
                    this._proxiedTemplateContextChangedHandler = this._templateContextChangedHandler.bind(this)
                }
            },
            ensureActive: function(targetNode) {
                if (this._disabledState) {
                    return this.enable()
                } else {
                    return this.activate(targetNode)
                }
            },
            activate: function() {
                this._showViewFired = false;
                var $rootElement = this.element();
                this._showElements($rootElement);
                this._attachRefreshViewRequiredHandler();
                return $.Deferred().resolve().promise()
            },
            deactivate: function() {
                this._disabledState = false;
                this._showViewFired = false;
                this._releaseVisibleViews();
                this._hideElements(this.element());
                this._detachRefreshViewRequiredHandler();
                return $.Deferred().resolve().promise()
            },
            enable: function() {
                this._disabledState = false;
                if (!this._showViewFired) {
                    this._notifyShowing()
                }
                this._showViewFired = false;
                return $.Deferred().resolve().promise()
            },
            disable: function() {
                this._disabledState = true;
                this._showViewFired = false;
                this._notifyHidden()
            },
            activeViewInfo: function() {
                return this._visibleViews[this._defaultPaneName]
            },
            _fireViewEvents: function(eventName, views) {
                var that = this;
                views = views || this._visibleViews;
                $.each(views, function(index, viewInfo) {
                    that.fireEvent(eventName, [viewInfo])
                })
            },
            _notifyShowing: function(views) {
                this._fireViewEvents("viewShowing", views)
            },
            _notifyShown: function(views) {
                this._fireViewEvents("viewShown", views)
            },
            _notifyHidden: function(views) {
                this._fireViewEvents("viewHidden", views)
            },
            _applyTemplate: function($elements, model) {
                $elements.each(function(i, element) {
                    frameworkUtils.templateProvider.applyTemplate(element, model)
                })
            },
            _releaseVisibleViews: function() {
                var that = this;
                $.each(this._visibleViews, function(index, viewInfo) {
                    that._hideView(viewInfo);
                    that._releaseView(viewInfo)
                });
                this._visibleViews = {}
            },
            _templateContextChangedHandler: function() {
                var that = this,
                    viewsToShow = [];
                $.each(that._visibleViews, function(index, viewInfo) {
                    if (viewInfo.currentViewTemplateId !== that._getViewTemplateId(viewInfo)) {
                        viewsToShow.push(viewInfo)
                    }
                });
                when.apply($, $.map(viewsToShow, function(viewInfo) {
                    return that.showView(viewInfo)
                })).done(function() {
                    that._notifyShown(viewsToShow)
                })
            },
            _attachRefreshViewRequiredHandler: function() {
                if (this._templateContext) {
                    this._templateContext.on("optionChanged", this._proxiedTemplateContextChangedHandler)
                }
            },
            _detachRefreshViewRequiredHandler: function() {
                if (this._templateContextChanged) {
                    this._templateContext.off("optionChanged", this._proxiedTemplateContextChangedHandler)
                }
            },
            _getPreviousViewInfo: function(viewInfo) {
                return this._visibleViews[this._getViewPaneName(viewInfo.viewTemplateInfo)]
            },
            _prepareTemplates: function() {
                var that = this;
                var $layoutTemplate = that._viewEngine.getLayoutTemplate(this._getLayoutTemplateName());
                that._$layoutTemplate = $layoutTemplate;
                that._$mainLayout = that._createEmptyLayout();
                that._showElements(that._$mainLayout);
                that._applyTemplate(that._$mainLayout, that._layoutModel);
                that._$navigationWidget = that._createNavigationWidget()
            },
            renderNavigation: function(navigationCommands) {
                this._clearNavigationWidget();
                this._renderNavigationImpl(navigationCommands)
            },
            _renderNavigationImpl: function(navigationCommands) {
                this._renderCommands(this._$mainLayout, navigationCommands)
            },
            _createNavigationWidget: function() {
                var result, containers = this._findCommandContainers(this._$mainLayout);
                $.each(containers, function(k, container) {
                    if ("global-navigation" === container.option("id")) {
                        result = container.element();
                        return false
                    }
                });
                return result
            },
            _clearNavigationWidget: function() {
                if (this._$navigationWidget) {
                    this._commandManager.clearContainer(this._$navigationWidget.dxCommandContainer("instance"))
                }
            },
            element: function() {
                return this._$mainLayout
            },
            _getViewFrame: function(viewInfo) {
                return this._$mainLayout
            },
            _getLayoutTemplateName: function() {
                return this.name
            },
            _applyModelToTransitionElements: function($markup, model) {
                var that = this;
                this._getTransitionElements($markup).each(function(i, item) {
                    that._applyTemplate($(item).children(), model)
                })
            },
            _createViewLayoutTemplate: function() {
                var that = this;
                var $viewLayoutTemplate = that._$layoutTemplate.clone();
                this._hideElements($viewLayoutTemplate);
                return $viewLayoutTemplate
            },
            _createEmptyLayout: function() {
                var that = this;
                var $result = that._$layoutTemplate.clone();
                this._hideElements($result);
                this._getTransitionElements($result).empty();
                $result.children(CONTENT_SELECTOR).remove();
                return $result
            },
            _getTransitionElements: function($markup) {
                var $items = $markup.find(TRANSITION_SELECTOR).add($markup.filter(TRANSITION_SELECTOR)),
                    result = [];
                for (var i = 0; i < $items.length; i++) {
                    var $item = $items.eq(i);
                    if (0 === $item.parents(TRANSITION_SELECTOR).length) {
                        result.push($item.get(0))
                    }
                }
                return $(result)
            },
            showView: function(viewInfo, direction) {
                direction = direction || "forward";
                var result, that = this,
                    previousViewInfo = that._getPreviousViewInfo(viewInfo),
                    previousViewTemplateId = previousViewInfo === viewInfo ? previousViewInfo.currentViewTemplateId : void 0;
                this._showViewFired = true;
                this._updateCurrentViewTemplateId(viewInfo);
                if (previousViewTemplateId && previousViewTemplateId === viewInfo.currentViewTemplateId && viewInfo === previousViewInfo) {
                    that.fireEvent("viewShowing", [viewInfo, direction]);
                    result = $.Deferred().resolve().promise()
                } else {
                    that._ensureViewRendered(viewInfo);
                    that.fireEvent("viewShowing", [viewInfo, direction]);
                    result = this._showViewImpl(viewInfo, direction, previousViewTemplateId).done(function() {
                        that._onViewShown(viewInfo)
                    })
                }
                return result
            },
            disposeView: function(viewInfo) {
                this._clearRenderResult(viewInfo)
            },
            _clearRenderResult: function(viewInfo) {
                if (viewInfo.renderResult) {
                    viewInfo.renderResult.$markup.remove();
                    viewInfo.renderResult.$viewItems.remove();
                    delete viewInfo.renderResult
                }
            },
            _renderViewImpl: function($viewTemplate, viewInfo) {
                var $viewItems, that = this,
                    allowedChildrenSelector = ".dx-command,.dx-content,script",
                    $layout = this._createViewLayoutTemplate(),
                    isSimplifiedMarkup = true,
                    outOfContentItems = $();
                if (0 === $viewTemplate.children(allowedChildrenSelector).length) {
                    this._viewEngine._wrapViewDefaultContent($viewTemplate)
                }
                $viewItems = $viewTemplate.children();
                this._applyModelToTransitionElements($layout, viewInfo.model);
                this._viewEngine.applyLayout($viewTemplate, $layout);
                $viewItems.each(function(i, item) {
                    var $item = $(item);
                    that._applyTemplate($item, viewInfo.model);
                    if ($item.is(allowedChildrenSelector)) {
                        isSimplifiedMarkup = false
                    } else {
                        outOfContentItems = outOfContentItems.add($item)
                    }
                });
                if (outOfContentItems.length && !isSimplifiedMarkup) {
                    throw errors.Error("E3014", outOfContentItems[0].outerHTML)
                }
                viewInfo.renderResult = viewInfo.renderResult || {};
                viewInfo.renderResult.$viewItems = $viewItems;
                viewInfo.renderResult.$markup = $layout
            },
            _renderCommands: function($markup, commands) {
                var commandContainers = this._findCommandContainers($markup);
                return this._commandManager.renderCommandsToContainers(commands, commandContainers)
            },
            _prepareViewCommands: function(viewInfo) {
                var $viewItems = viewInfo.renderResult.$viewItems,
                    viewCommands = this._commandManager.findCommands($viewItems),
                    commandsToRenderMap = {};
                viewInfo.commands = frameworkUtils.utils.mergeCommands(viewInfo.commands || [], viewCommands);
                viewInfo.commandsToRenderMap = commandsToRenderMap;
                $.each(viewInfo.commands, function(index, command) {
                    var renderStage = command.option("renderStage") || DEFAULT_COMMAND_RENDER_STAGE,
                        targetArray = commandsToRenderMap[renderStage] = commandsToRenderMap[renderStage] || [];
                    targetArray.push(command)
                })
            },
            _applyViewCommands: function(viewInfo, renderStage) {
                renderStage = renderStage || DEFAULT_COMMAND_RENDER_STAGE;
                var result, commandsToRender = viewInfo.commandsToRenderMap[renderStage],
                    $markup = viewInfo.renderResult.$markup;
                if (commandsToRender) {
                    result = this._renderCommands($markup, commandsToRender);
                    delete viewInfo.commandsToRenderMap[renderStage]
                } else {
                    result = $.Deferred().resolve().promise()
                }
                return result
            },
            _findCommandContainers: function($markup) {
                return domUtils.createComponents($markup, ["dxCommandContainer"])
            },
            _getViewTemplateId: function(viewInfo) {
                var viewTemplateInstance = viewInfo.$viewTemplate ? viewInfo.$viewTemplate.dxView("instance") : this._viewEngine.getViewTemplateInfo(viewInfo.viewName);
                return viewTemplateInstance.getId()
            },
            _updateCurrentViewTemplateId: function(viewInfo) {
                viewInfo.currentViewTemplateId = this._getViewTemplateId(viewInfo)
            },
            _ensureViewRendered: function(viewInfo) {
                var $cachedMarkup = viewInfo.renderResult && viewInfo.renderResult.markupCache[viewInfo.currentViewTemplateId];
                if ($cachedMarkup) {
                    viewInfo.renderResult.$markup = $cachedMarkup
                } else {
                    this._renderView(viewInfo);
                    viewInfo.renderResult.markupCache = viewInfo.renderResult.markupCache || {};
                    viewInfo.renderResult.markupCache[viewInfo.currentViewTemplateId] = viewInfo.renderResult.$markup
                }
            },
            _renderView: function(viewInfo) {
                var $viewTemplate = viewInfo.$viewTemplate || this._viewEngine.getViewTemplate(viewInfo.viewName);
                this._renderViewImpl($viewTemplate, viewInfo);
                this._prepareViewCommands(viewInfo);
                this._applyViewCommands(viewInfo, "onViewRendering");
                this._appendViewToLayout(viewInfo);
                $viewTemplate.remove();
                this._onRenderComplete(viewInfo);
                this.fireEvent("viewRendered", [viewInfo])
            },
            _prepareTransition: function($element, targetPlaceholderName) {
                if (0 === $element.children(".dx-content").length) {
                    $element.wrapInner("<div>");
                    $element.children().dxContent({
                        targetPlaceholder: targetPlaceholderName
                    })
                }
            },
            _appendViewToLayout: function(viewInfo) {
                var that = this,
                    $viewFrame = that._getViewFrame(viewInfo),
                    $markup = viewInfo.renderResult.$markup,
                    $transitionContentElements = $(),
                    animationItems = [];
                $.each($markup.find(".dx-content-placeholder"), function(index, el) {
                    that._prepareTransition($(el), $(el).attr("data-dx-content-placeholder-name"))
                });
                $.each(that._getTransitionElements($viewFrame), function(index, transitionElement) {
                    var $transition = $(transitionElement),
                        $viewElement = $markup.find(transitionSelector($transition.attr("data-dx-transition-name"))).children(),
                        animationItem = {
                            $element: $viewElement,
                            animation: $transition.attr("data-dx-transition-type")
                        };
                    animationItems.push(animationItem);
                    $transition.append($viewElement);
                    that._showViewElements($viewElement);
                    domUtils.triggerShownEvent($viewElement);
                    $transitionContentElements = $transitionContentElements.add($viewElement)
                });
                that._$mainLayout.append(viewInfo.renderResult.$viewItems.filter(".dx-command"));
                $markup.remove();
                viewInfo.renderResult.$markup = $transitionContentElements;
                viewInfo.renderResult.animationItems = animationItems
            },
            _onRenderComplete: function(viewInfo) {},
            _onViewShown: function(viewInfo) {
                $(document).trigger("dx.viewchanged")
            },
            _enter: function(animationItems, animationModifier) {
                var transitionExecutor = this.transitionExecutor;
                $.each(animationItems, function(index, item) {
                    transitionExecutor.enter(item.$element, item.animation, animationModifier)
                })
            },
            _leave: function(animationItems, animationModifier) {
                var transitionExecutor = this.transitionExecutor;
                $.each(animationItems, function(index, item) {
                    transitionExecutor.leave(item.$element, item.animation, animationModifier)
                })
            },
            _doTransition: function(oldViewInfo, newViewInfo, animationModifier) {
                if (oldViewInfo) {
                    this._leave(oldViewInfo.renderResult.animationItems, animationModifier)
                }
                this._enter(newViewInfo.renderResult.animationItems, animationModifier);
                this._showView(newViewInfo);
                return this.transitionExecutor.start()
            },
            _showViewImpl: function(viewInfo, direction, previousViewTemplateId) {
                var that = this,
                    previousViewInfo = this._getPreviousViewInfo(viewInfo),
                    animationModifier = {
                        direction: direction
                    };
                if (previousViewInfo === viewInfo) {
                    previousViewInfo = void 0
                }
                if (!previousViewInfo) {
                    animationModifier.duration = 0;
                    animationModifier.delay = 0
                }
                var d = $.Deferred();
                that._doTransition(previousViewInfo, viewInfo, animationModifier).done(function() {
                    that._changeView(viewInfo, previousViewTemplateId).done(function(result) {
                        d.resolve(result)
                    })
                });
                return d.promise()
            },
            _releaseView: function(viewInfo) {
                this.fireEvent("viewReleased", [viewInfo])
            },
            _getReadyForRenderDeferredItems: function(viewInfo) {
                return $.Deferred().resolve().promise()
            },
            _changeView: function(viewInfo, previousViewTemplateId) {
                var that = this;
                if (previousViewTemplateId) {
                    that._hideView(viewInfo, previousViewTemplateId)
                } else {
                    var previousViewInfo = that._getPreviousViewInfo(viewInfo);
                    if (previousViewInfo && previousViewInfo !== viewInfo) {
                        that._hideView(previousViewInfo);
                        that._releaseView(previousViewInfo)
                    }
                    this._visibleViews[this._getViewPaneName(viewInfo.viewTemplateInfo)] = viewInfo
                }
                this._subscribeToDeferredItems(viewInfo);
                var d = $.Deferred();
                this._getReadyForRenderDeferredItems(viewInfo).done(function() {
                    that._applyViewCommands(viewInfo).done(function() {
                        that._renderDeferredItems(viewInfo.renderResult.$markup).done(function() {
                            d.resolve()
                        })
                    })
                });
                return d.promise()
            },
            _subscribeToDeferredItems: function(viewInfo) {
                var that = this,
                    $markup = viewInfo.renderResult.$markup;
                $markup.find(PENDING_RENDERING_SELECTOR).add($markup.filter(PENDING_RENDERING_SELECTOR)).each(function() {
                    var eventData = {
                        viewInfo: viewInfo,
                        context: that
                    };
                    $(this).on(CONTENT_RENDERED_EVENT_NAME, eventData, that._onDeferredContentRendered)
                })
            },
            _onDeferredContentRendered: function(event) {
                var $element = $(event.target),
                    viewInfo = event.data.viewInfo,
                    that = event.data.context;
                $element.off(CONTENT_RENDERED_EVENT_NAME, that._onDeferredContentRendered);
                that._renderCommands($element, viewInfo.commands)
            },
            _renderDeferredItems: function($items) {
                var that = this,
                    result = $.Deferred();
                var $pendingItem = $items.find(PENDING_RENDERING_MANUAL_SELECTOR).add($items.filter(PENDING_RENDERING_MANUAL_SELECTOR)).first();
                if ($pendingItem.length) {
                    var render = $pendingItem.data("dx-render-delegate");
                    commonUtils.executeAsync(function() {
                        render().done(function() {
                            that._renderDeferredItems($items).done(function() {
                                result.resolve()
                            })
                        })
                    })
                } else {
                    result.resolve()
                }
                return result.promise()
            },
            _getViewPaneName: function(viewTemplateInfo) {
                return this._defaultPaneName
            },
            _hideElements: function($elements) {
                $elements.addClass("dx-fast-hidden")
            },
            _showElements: function($elements) {
                $elements.removeClass("dx-fast-hidden")
            },
            _hideViewElements: function($elements) {
                this._patchIds($elements);
                this._disableInputs($elements);
                $elements.removeClass("dx-active-view").addClass("dx-inactive-view")
            },
            _hideView: function(viewInfo, templateId) {
                if (viewInfo.renderResult) {
                    var $markupToHide = void 0 === templateId ? viewInfo.renderResult.$markup : viewInfo.renderResult.markupCache[templateId];
                    this._hideViewElements($markupToHide);
                    this.fireEvent("viewHidden", [viewInfo])
                }
            },
            _showViewElements: function($elements) {
                this._unPatchIds($elements);
                this._enableInputs($elements);
                $elements.removeClass("dx-inactive-view").addClass("dx-active-view");
                this._skipAnimation($elements)
            },
            _showView: function(viewInfo) {
                if (viewInfo.renderResult) {
                    this._showViewElements(viewInfo.renderResult.$markup)
                }
            },
            _skipAnimation: function($elements) {
                $elements.addClass("dx-skip-animation");
                for (var i = 0; i < $elements.length; i++) {
                    $elements.eq(i).css("transform")
                }
                $elements.removeClass("dx-skip-animation")
            },
            _patchIds: function($markup) {
                this._processIds($markup, function(id) {
                    var result = id;
                    if (id.indexOf(HIDDEN_BAG_ID) === -1) {
                        result = HIDDEN_BAG_ID + "-" + id
                    }
                    return result
                })
            },
            _unPatchIds: function($markup) {
                this._processIds($markup, function(id) {
                    var result = id;
                    if (0 === id.indexOf(HIDDEN_BAG_ID)) {
                        result = id.substr(HIDDEN_BAG_ID.length + 1)
                    }
                    return result
                })
            },
            _processIds: function($markup, process) {
                var elementsWithIds = $markup.find("[id]");
                $.each(elementsWithIds, function(index, element) {
                    var $el = $(element),
                        id = $el.attr("id");
                    $el.attr("id", process(id))
                })
            },
            _enableInputs: function($markup) {
                var $inputs = this._getInputs($markup).filter("[data-disabled='true']");
                $.each($inputs, function(index, input) {
                    $(input).removeAttr("disabled").removeAttr("data-disabled")
                })
            },
            _disableInputs: function($markup) {
                var $inputs = this._getInputs($markup);
                $inputs = $inputs.filter(":not([disabled])").add($inputs.filter("[disabled=true]"));
                $.each($inputs, function(index, input) {
                    $(input).attr({
                        disabled: true,
                        "data-disabled": true
                    })
                })
            },
            _getInputs: function($markup) {
                return $markup.find("input, button, select, textarea")
            }
        }).include(EventsMixin);
        layoutSets.default = layoutSets.default || [];
        layoutSets.default.push({
            controller: new DefaultLayoutController
        });
        exports.DefaultLayoutController = DefaultLayoutController;
        exports.layoutSets = layoutSets
    },
    /*!*************************!*\
      !*** ./js/ui/themes.js ***!
      \*************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 9),
            errors = __webpack_require__( /*! ./widget/ui.errors */ 22),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 56),
            devices = __webpack_require__( /*! ../core/devices */ 53),
            viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 55),
            viewPort = viewPortUtils.value,
            viewPortChanged = viewPortUtils.changeCallback,
            holdReady = $.holdReady || $.fn.holdReady;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]",
            THEME_ATTR = "data-theme",
            ACTIVE_ATTR = "data-active",
            DX_HAIRLINES_CLASS = "dx-hairlines";
        var context, $activeThemeLink, knownThemes, currentThemeName, pendingThemeName;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            var result, element = $("<div></div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            try {
                result = element.css("font-family");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName, callback) {
            var timerId, waitStartTime;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                callback()
            }
            if (isPendingThemeLoaded()) {
                handleLoaded()
            } else {
                waitStartTime = $.now();
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded(),
                        isTimeout = !isLoaded && $.now() - waitStartTime > 15e3;
                    if (isTimeout) {
                        errors.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        clearInterval(timerId);
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            return !pendingThemeName || readThemeMarker() === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = $(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = $(domUtils.createMarkupFromString("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = $(this, context),
                    fullThemeName = link.attr(THEME_ATTR),
                    url = link.attr("href"),
                    isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName.split("."),
                result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }
                $.each(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || document);
            processMarkup();
            currentThemeName = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var currentThemeData, isAutoInit = options._autoInit,
                loadCallback = options.loadCallback;
            currentThemeName = options.theme || currentThemeName;
            if (isAutoInit && !currentThemeName) {
                currentThemeName = themeNameFromDevice(devices.current())
            }
            currentThemeName = resolveFullThemeName(currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if (loadCallback) {
                    waitForThemeLoad(currentThemeName, loadCallback)
                } else {
                    if (pendingThemeName) {
                        pendingThemeName = currentThemeName
                    }
                }
            } else {
                if (isAutoInit) {
                    if (loadCallback) {
                        loadCallback()
                    }
                } else {
                    throw errors.Error("E0021", currentThemeName)
                }
            }
            attachCssClasses(viewPortUtils.originalViewPort(), currentThemeName)
        }

        function themeNameFromDevice(device) {
            var themeName = device.platform;
            var majorVersion = device.version && device.version[0];
            switch (themeName) {
                case "ios":
                    themeName += "7";
                    break;
                case "android":
                    themeName += "5";
                    break;
                case "win":
                    themeName += majorVersion && 8 === majorVersion ? "8" : "10"
            }
            return themeName
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [],
                themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1])
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            $(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = $("<div>");
                $tester.css("border", ".5px solid transparent");
                $("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    $(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            $(element).removeClass(themeClasses)
        }
        holdReady(true);
        init({
            _autoInit: true,
            loadCallback: function() {
                holdReady(false)
            }
        });
        domUtils.ready(function() {
            if ($(DX_LINK_SELECTOR, context).length) {
                throw errors.Error("E0022")
            }
        });
        viewPortChanged.add(function(viewPort, prevViewPort) {
            detachCssClasses(prevViewPort);
            attachCssClasses(viewPort)
        });
        devices.changed.add(function() {
            init({
                _autoInit: true
            })
        });
        exports.current = current;
        exports.init = init;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.themeNameFromDevice = themeNameFromDevice;
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.resetTheme = function() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null
        }
    },
    /*!***********************************!*\
      !*** ./js/integration/angular.js ***!
      \***********************************/
    function(module, exports, __webpack_require__) {
        var angular = __webpack_require__( /*! angular */ 145);
        if (angular) {
            __webpack_require__( /*! ./angular/component_registrator */ 146);
            __webpack_require__( /*! ./angular/event_registrator */ 173);
            __webpack_require__( /*! ./angular/components */ 174);
            __webpack_require__( /*! ./angular/action_executors */ 175)
        }
    },
    /*!*********************************!*\
      !*** external "window.angular" ***!
      \*********************************/
    function(module, exports) {
        module.exports = window.angular
    },
    /*!*********************************************************!*\
      !*** ./js/integration/angular/component_registrator.js ***!
      \*********************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            Config = __webpack_require__( /*! ../../core/config */ 15),
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 57),
            Class = __webpack_require__( /*! ../../core/class */ 25),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            Locker = __webpack_require__( /*! ../../core/utils/locker */ 112),
            Widget = __webpack_require__( /*! ../../ui/widget/ui.widget */ 95),
            Editor = __webpack_require__( /*! ../../ui/editor/editor */ 106),
            NgTemplate = __webpack_require__( /*! ./template */ 147),
            ngModule = __webpack_require__( /*! ./module */ 148),
            CollectionWidget = __webpack_require__( /*! ../../ui/collection/ui.collection_widget.edit */ 149),
            compileSetter = __webpack_require__( /*! ../../core/utils/data */ 50).compileSetter,
            compileGetter = __webpack_require__( /*! ../../core/utils/data */ 50).compileGetter,
            extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 11).extendFromObject,
            isNumeric = __webpack_require__( /*! ../../core/utils/common */ 14).isNumeric,
            inflector = __webpack_require__( /*! ../../core/utils/inflector */ 39),
            errors = __webpack_require__( /*! ../../core/errors */ 7);
        var ITEM_ALIAS_ATTRIBUTE_NAME = "dxItemAlias",
            SKIP_APPLY_ACTION_CATEGORIES = ["rendering"];
        var safeApply = function(func, scope) {
            if (scope.$root.$$phase) {
                return func(scope)
            } else {
                return scope.$apply(function() {
                    return func(scope)
                })
            }
        };
        var ComponentBuilder = Class.inherit({
            ctor: function(options) {
                this._componentDisposing = $.Callbacks();
                this._optionChangedCallbacks = $.Callbacks();
                this._ngLocker = new Locker;
                this._scope = options.scope;
                this._$element = options.$element;
                this._$templates = options.$templates;
                this._componentClass = options.componentClass;
                this._parse = options.parse;
                this._compile = options.compile;
                this._itemAlias = options.itemAlias;
                this._transcludeFn = options.transcludeFn;
                this._digestCallbacks = options.dxDigestCallbacks;
                this._normalizeOptions(options.ngOptions);
                this._initComponentBindings();
                this._initComponent(this._scope);
                if (!options.ngOptions) {
                    this._addOptionsStringWatcher(options.ngOptionsString)
                }
            },
            _addOptionsStringWatcher: function(optionsString) {
                var that = this;
                var clearOptionsStringWatcher = that._scope.$watch(optionsString, function(newOptions) {
                    if (!newOptions) {
                        return
                    }
                    clearOptionsStringWatcher();
                    that._normalizeOptions(newOptions);
                    that._initComponentBindings();
                    that._component.option(that._evalOptions(that._scope))
                });
                that._componentDisposing.add(clearOptionsStringWatcher)
            },
            _normalizeOptions: function(options) {
                var that = this;
                that._ngOptions = extendFromObject({}, options);
                if (!options) {
                    return
                }
                if (!options.hasOwnProperty("bindingOptions") && options.bindingOptions) {
                    that._ngOptions.bindingOptions = options.bindingOptions
                }
                if (options.bindingOptions) {
                    $.each(options.bindingOptions, function(key, value) {
                        if ("string" === commonUtils.type(value)) {
                            that._ngOptions.bindingOptions[key] = {
                                dataPath: value
                            }
                        }
                    })
                }
            },
            _initComponent: function(scope) {
                this._component = new this._componentClass(this._$element, this._evalOptions(scope));
                this._component._isHidden = true;
                this._handleDigestPhase()
            },
            _handleDigestPhase: function() {
                var that = this,
                    beginUpdate = function() {
                        that._component.beginUpdate()
                    },
                    endUpdate = function() {
                        that._component.endUpdate()
                    };
                that._digestCallbacks.begin.add(beginUpdate);
                that._digestCallbacks.end.add(endUpdate);
                that._componentDisposing.add(function() {
                    that._digestCallbacks.begin.remove(beginUpdate);
                    that._digestCallbacks.end.remove(endUpdate)
                })
            },
            _initComponentBindings: function() {
                var that = this,
                    optionDependencies = {};
                if (!that._ngOptions.bindingOptions) {
                    return
                }
                $.each(that._ngOptions.bindingOptions, function(optionPath, value) {
                    var prevWatchMethod, clearWatcher, separatorIndex = optionPath.search(/\[|\./),
                        optionForSubscribe = separatorIndex > -1 ? optionPath.substring(0, separatorIndex) : optionPath,
                        valuePath = value.dataPath,
                        deepWatch = true,
                        forcePlainWatchMethod = false;
                    if (void 0 !== value.deep) {
                        forcePlainWatchMethod = deepWatch = !!value.deep
                    }
                    if (!optionDependencies[optionForSubscribe]) {
                        optionDependencies[optionForSubscribe] = {}
                    }
                    optionDependencies[optionForSubscribe][optionPath] = valuePath;
                    var watchCallback = function(newValue, oldValue) {
                        if (that._ngLocker.locked(optionPath)) {
                            return
                        }
                        that._ngLocker.obtain(optionPath);
                        that._component.option(optionPath, newValue);
                        updateWatcher();
                        if (that._component._optionValuesEqual(optionPath, oldValue, newValue) && that._ngLocker.locked(optionPath)) {
                            that._ngLocker.release(optionPath)
                        }
                    };
                    var updateWatcher = function() {
                        var watchMethod = Array.isArray(that._scope.$eval(valuePath)) && !forcePlainWatchMethod ? "$watchCollection" : "$watch";
                        if (prevWatchMethod !== watchMethod) {
                            if (clearWatcher) {
                                clearWatcher()
                            }
                            clearWatcher = that._scope[watchMethod](valuePath, watchCallback, deepWatch);
                            prevWatchMethod = watchMethod
                        }
                    };
                    updateWatcher();
                    that._componentDisposing.add(clearWatcher)
                });
                that._optionChangedCallbacks.add(function(args) {
                    var optionName = args.name,
                        fullName = args.fullName,
                        component = args.component;
                    if (that._ngLocker.locked(fullName)) {
                        that._ngLocker.release(fullName);
                        return
                    }
                    if (!optionDependencies || !optionDependencies[optionName]) {
                        return
                    }
                    that._ngLocker.obtain(fullName);
                    safeApply(function() {
                        $.each(optionDependencies[optionName], function(optionPath, valuePath) {
                            if (!that._optionsAreLinked(fullName, optionPath)) {
                                return
                            }
                            var value = component.option(optionPath);
                            that._parse(valuePath).assign(that._scope, value);
                            var scopeValue = that._parse(valuePath)(that._scope);
                            if (scopeValue !== value) {
                                args.component.option(optionPath, scopeValue)
                            }
                        })
                    }, that._scope);
                    var releaseOption = function() {
                        if (that._ngLocker.locked(fullName)) {
                            that._ngLocker.release(fullName)
                        }
                        that._digestCallbacks.end.remove(releaseOption)
                    };
                    releaseOption();
                    that._digestCallbacks.end.add(releaseOption)
                })
            },
            _optionsAreNested: function(optionPath1, optionPath2) {
                var parentSeparator = optionPath1[optionPath2.length];
                return 0 === optionPath1.indexOf(optionPath2) && ("." === parentSeparator || "[" === parentSeparator)
            },
            _optionsAreLinked: function(optionPath1, optionPath2) {
                if (optionPath1 === optionPath2) {
                    return true
                }
                return optionPath1.length > optionPath2.length ? this._optionsAreNested(optionPath1, optionPath2) : this._optionsAreNested(optionPath2, optionPath1)
            },
            _compilerByTemplate: function(template) {
                var that = this,
                    scopeItemsPath = this._getScopeItemsPath();
                return function(options) {
                    var $resultMarkup = $(template).clone(),
                        dataIsScope = options.model && options.model.constructor === that._scope.$root.constructor,
                        templateScope = dataIsScope ? options.model : options.noModel ? that._scope : that._createScopeWithData(options);
                    if (scopeItemsPath) {
                        that._synchronizeScopes(templateScope, scopeItemsPath, options.index)
                    }
                    $resultMarkup.appendTo(options.container);
                    if (!options.noModel) {
                        $resultMarkup.on("$destroy", function() {
                            var destroyAlreadyCalled = !templateScope.$parent;
                            if (destroyAlreadyCalled) {
                                return
                            }
                            templateScope.$destroy()
                        })
                    }
                    that._applyAsync(that._compile($resultMarkup, that._transcludeFn), templateScope);
                    return $resultMarkup
                }
            },
            _applyAsync: function(func, scope) {
                var that = this;
                func(scope);
                if (!scope.$root.$$phase) {
                    if (!that._renderingTimer) {
                        that._renderingTimer = setTimeout(function() {
                            scope.$apply();
                            that._renderingTimer = null
                        })
                    }
                    that._componentDisposing.add(function() {
                        clearTimeout(that._renderingTimer)
                    })
                }
            },
            _getScopeItemsPath: function() {
                if (this._componentClass.subclassOf(CollectionWidget) && this._ngOptions.bindingOptions && this._ngOptions.bindingOptions.items) {
                    return this._ngOptions.bindingOptions.items.dataPath
                }
            },
            _createScopeWithData: function(options) {
                var newScope = this._scope.$new();
                if (this._itemAlias) {
                    newScope[this._itemAlias] = options.model
                }
                if (commonUtils.isDefined(options.index)) {
                    newScope.$index = options.index
                }
                return newScope
            },
            _synchronizeScopes: function(itemScope, parentPrefix, itemIndex) {
                if (this._itemAlias && "object" !== typeof itemScope[this._itemAlias]) {
                    this._synchronizeScopeField({
                        parentScope: this._scope,
                        childScope: itemScope,
                        fieldPath: this._itemAlias,
                        parentPrefix: parentPrefix,
                        itemIndex: itemIndex
                    })
                }
            },
            _synchronizeScopeField: function(args) {
                var parentScope = args.parentScope,
                    childScope = args.childScope,
                    fieldPath = args.fieldPath,
                    parentPrefix = args.parentPrefix,
                    itemIndex = args.itemIndex;
                var optionOuterPath, innerPathSuffix = fieldPath === this._itemAlias ? "" : "." + fieldPath,
                    collectionField = void 0 !== itemIndex,
                    optionOuterBag = [parentPrefix];
                if (collectionField) {
                    if (!isNumeric(itemIndex)) {
                        return
                    }
                    optionOuterBag.push("[", itemIndex, "]")
                }
                optionOuterBag.push(innerPathSuffix);
                optionOuterPath = optionOuterBag.join("");
                var clearParentWatcher = parentScope.$watch(optionOuterPath, function(newValue, oldValue) {
                    if (newValue !== oldValue) {
                        compileSetter(fieldPath)(childScope, newValue)
                    }
                });
                var clearItemWatcher = childScope.$watch(fieldPath, function(newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if (collectionField && !compileGetter(parentPrefix)(parentScope)[itemIndex]) {
                            clearItemWatcher();
                            return
                        }
                        compileSetter(optionOuterPath)(parentScope, newValue)
                    }
                });
                this._componentDisposing.add([clearParentWatcher, clearItemWatcher])
            },
            _evalOptions: function(scope) {
                var result = extendFromObject({}, this._ngOptions);
                delete result.bindingOptions;
                if (this._ngOptions.bindingOptions) {
                    $.each(this._ngOptions.bindingOptions, function(key, value) {
                        result[key] = scope.$eval(value.dataPath)
                    })
                }
                result._optionChangedCallbacks = this._optionChangedCallbacks;
                result._disposingCallbacks = this._componentDisposing;
                result.onActionCreated = function(component, action, config) {
                    if (config && inArray(config.category, SKIP_APPLY_ACTION_CATEGORIES) > -1) {
                        return action
                    }
                    var wrappedAction = function() {
                        var that = this,
                            args = arguments;
                        if (!scope || !scope.$root || scope.$root.$$phase) {
                            return action.apply(that, args)
                        }
                        return safeApply(function() {
                            return action.apply(that, args)
                        }, scope)
                    };
                    return wrappedAction
                };
                result.beforeActionExecute = result.onActionCreated;
                result.nestedComponentOptions = function(component) {
                    return {
                        templatesRenderAsynchronously: component.option("templatesRenderAsynchronously"),
                        forceApplyBindings: component.option("forceApplyBindings"),
                        modelByElement: component.option("modelByElement"),
                        onActionCreated: component.option("onActionCreated"),
                        beforeActionExecute: component.option("beforeActionExecute"),
                        nestedComponentOptions: component.option("nestedComponentOptions")
                    }
                };
                result.templatesRenderAsynchronously = true;
                if (Config().wrapActionsBeforeExecute) {
                    result.forceApplyBindings = function() {
                        safeApply(function() {}, scope)
                    }
                }
                result.integrationOptions = {
                    createTemplate: function(element) {
                        return new NgTemplate(element, this._compilerByTemplate.bind(this))
                    }.bind(this),
                    watchMethod: function(fn, callback, options) {
                        options = options || {};
                        var immediateValue;
                        var skipCallback = options.skipImmediate;
                        var disposeWatcher = scope.$watch(function() {
                            var value = fn();
                            if (value instanceof Date) {
                                value = value.valueOf()
                            }
                            return value
                        }, function(newValue) {
                            var isSameValue = immediateValue === newValue;
                            if (!skipCallback && (!isSameValue || isSameValue && options.deep)) {
                                callback(newValue)
                            }
                            skipCallback = false
                        }, options.deep);
                        if (!skipCallback) {
                            immediateValue = fn();
                            callback(immediateValue)
                        }
                        if (Config().wrapActionsBeforeExecute) {
                            safeApply(function() {}, scope)
                        }
                        return disposeWatcher
                    },
                    templates: {
                        "dx-polymorph-widget": {
                            render: function(options) {
                                var widgetName = options.model.widget;
                                if (!widgetName) {
                                    return
                                }
                                if ("button" === widgetName || "tabs" === widgetName || "dropDownMenu" === widgetName) {
                                    var deprecatedName = widgetName;
                                    widgetName = inflector.camelize("dx-" + widgetName);
                                    errors.log("W0001", "dxToolbar - 'widget' item field", deprecatedName, "16.1", "Use: '" + widgetName + "' instead")
                                }
                                var markup = $("<div " + inflector.dasherize(widgetName) + '="options">').get(0);
                                var newScope = this._scope.$new();
                                newScope.options = options.model.options;
                                options.container.append(markup);
                                this._compile(markup)(newScope)
                            }.bind(this)
                        }
                    }
                };
                result.modelByElement = function() {
                    return scope
                };
                return result
            }
        });
        ComponentBuilder = ComponentBuilder.inherit({
            ctor: function(options) {
                this._componentName = options.componentName;
                this._ngModel = options.ngModel;
                this._ngModelController = options.ngModelController;
                this.callBase.apply(this, arguments)
            },
            _isNgModelRequired: function() {
                return this._componentClass.subclassOf(Editor) && this._ngModel
            },
            _initComponentBindings: function() {
                this.callBase.apply(this, arguments);
                this._initNgModelBinding()
            },
            _initNgModelBinding: function() {
                if (!this._isNgModelRequired()) {
                    return
                }
                var that = this;
                var clearNgModelWatcher = this._scope.$watch(this._ngModel, function(newValue, oldValue) {
                    if (that._ngLocker.locked(that._ngModelOption())) {
                        return
                    }
                    if (newValue === oldValue) {
                        return
                    }
                    that._component.option(that._ngModelOption(), newValue)
                });
                that._optionChangedCallbacks.add(function(args) {
                    that._ngLocker.obtain(that._ngModelOption());
                    try {
                        if (args.name !== that._ngModelOption()) {
                            return
                        }
                        that._ngModelController.$setViewValue(args.value)
                    } finally {
                        that._ngLocker.release(that._ngModelOption())
                    }
                });
                this._componentDisposing.add(clearNgModelWatcher)
            },
            _ngModelOption: function() {
                if (inArray(this._componentName, ["dxFileUploader", "dxTagBox"]) > -1) {
                    return "values"
                }
                return "value"
            },
            _evalOptions: function() {
                if (!this._isNgModelRequired()) {
                    return this.callBase.apply(this, arguments)
                }
                var result = this.callBase.apply(this, arguments);
                result[this._ngModelOption()] = this._parse(this._ngModel)(this._scope);
                return result
            }
        });
        var registeredComponents = {};
        var registerComponentDirective = function(name) {
            var priority = "dxValidator" !== name ? 1 : 10;
            ngModule.directive(name, ["$compile", "$parse", "dxDigestCallbacks", function($compile, $parse, dxDigestCallbacks) {
                return {
                    restrict: "A",
                    require: "^?ngModel",
                    priority: priority,
                    compile: function($element) {
                        var componentClass = registeredComponents[name],
                            $content = componentClass.subclassOf(Widget) ? $element.contents().detach() : null;
                        return function(scope, $element, attrs, ngModelController, transcludeFn) {
                            $element.append($content);
                            safeApply(function() {
                                new ComponentBuilder({
                                    componentClass: componentClass,
                                    componentName: name,
                                    compile: $compile,
                                    parse: $parse,
                                    $element: $element,
                                    scope: scope,
                                    ngOptionsString: attrs[name],
                                    ngOptions: attrs[name] ? scope.$eval(attrs[name]) : {},
                                    ngModel: attrs.ngModel,
                                    ngModelController: ngModelController,
                                    transcludeFn: transcludeFn,
                                    itemAlias: attrs[ITEM_ALIAS_ATTRIBUTE_NAME],
                                    dxDigestCallbacks: dxDigestCallbacks
                                })
                            }, scope)
                        }
                    }
                }
            }])
        };
        registerComponent.callbacks.add(function(name, componentClass) {
            if (!registeredComponents[name]) {
                registerComponentDirective(name)
            }
            registeredComponents[name] = componentClass
        })
    },
    /*!********************************************!*\
      !*** ./js/integration/angular/template.js ***!
      \********************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            TemplateBase = __webpack_require__( /*! ../../ui/widget/ui.template_base */ 97),
            isFunction = __webpack_require__( /*! ../../core/utils/common */ 14).isFunction,
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56);
        var NgTemplate = TemplateBase.inherit({
            ctor: function(element, templateCompiler) {
                this._element = element;
                this._compiledTemplate = templateCompiler(domUtils.normalizeTemplateElement(this._element))
            },
            _renderCore: function(options) {
                var compiledTemplate = this._compiledTemplate,
                    result = isFunction(compiledTemplate) ? compiledTemplate(options) : compiledTemplate;
                return result
            },
            source: function() {
                return $(this._element).clone()
            }
        });
        module.exports = NgTemplate
    },
    /*!******************************************!*\
      !*** ./js/integration/angular/module.js ***!
      \******************************************/
    function(module, exports, __webpack_require__) {
        var angular = __webpack_require__( /*! angular */ 145);
        module.exports = angular.module("dx", [])
    },
    /*!*******************************************************!*\
      !*** ./js/ui/collection/ui.collection_widget.edit.js ***!
      \*******************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            BaseCollectionWidget = __webpack_require__( /*! ./ui.collection_widget.base */ 150),
            errors = __webpack_require__( /*! ../widget/ui.errors */ 22),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            PlainEditStrategy = __webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 167),
            compileGetter = __webpack_require__( /*! ../../core/utils/data */ 50).compileGetter,
            DataSource = __webpack_require__( /*! ../../data/data_source/data_source */ 153).DataSource,
            Selection = __webpack_require__( /*! ../selection/selection */ 169),
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when;
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting",
            NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = BaseCollectionWidget.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule();
                if ("multi" === this.option("selectionMode")) {
                    this._showDeprecatedSelectionMode()
                }
            },
            _initKeyGetter: function() {
                this._keyGetter = compileGetter(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            keyOf: function(item) {
                var key = item,
                    store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _initSelectionModule: function() {
                var that = this,
                    itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new Selection({
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args.addedItems, args.removedItems)
                        }
                    },
                    filter: function() {
                        return that._dataSource && that._dataSource.filter()
                    },
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: function() {
                        if (that.option("keyExpr")) {
                            return that.option("keyExpr")
                        }
                        return that._dataSource && that._dataSource.key()
                    },
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        return store ? store.load(options) : $.Deferred().resolve([])
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = PlainEditStrategy;
                this._editStrategy = new Strategy(this)
            },
            _forgetNextPageLoading: function() {
                this.callBase()
            },
            _getSelectedItemIndices: function(keys) {
                var that = this,
                    indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                $.each(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                return indices
            },
            _render: function() {
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions();
                    this._normalizeSelectedItems()
                }
                this.callBase();
                var selectedItemIndices = this._getSelectedItemIndices();
                this._renderSelection(selectedItemIndices, []);
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem, selectedItems, selectedIndex;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if (commonUtils.isDefined(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedItem", selectedItem);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        selectedItems = this.option("selectedItems") || [];
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItems[0]);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            this._syncSelectionOptions("selectedIndex");
                            return
                        }
                        this._setOptionSilent("selectedItem", selectedItems[0]);
                        this._setOptionSilent("selectedIndex", selectedIndex);
                        this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            this._syncSelectionOptions("selectedIndex");
                            return
                        }
                        if (commonUtils.isDefined(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedIndex", selectedIndex);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        var selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired") && !indexExists(this._getIndexByKey(selectedItemKeys[0]))) {
                            this._syncSelectionOptions("selectedIndex");
                            return
                        }
                        this._selection.setSelection(selectedItemKeys)
                }
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var arrayOptionsDefined = function(optionName) {
                    var length = this.option(optionName).length;
                    return length || !length && optionName in this._userOptions
                }.bind(this);
                if (arrayOptionsDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (commonUtils.isDefined(this.option("selectedItem"))) {
                        optionName = "selectedItem"
                    } else {
                        if (arrayOptionsDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionSilent("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionSilent("selectedItems", [normalizedSelection]);
                            this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
            },
            _renderSelection: commonUtils.noop,
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.jQueryEvent)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: $(e.currentTarget),
                    jQueryEvent: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var $itemElement = $(args.itemElement);
                if (this._isItemSelected(this._editStrategy.getNormalizedIndex($itemElement))) {
                    $itemElement.addClass(this._selectedItemClass());
                    this._setAriaSelected($itemElement, "true")
                } else {
                    this._setAriaSelected($itemElement, "false")
                }
            },
            _updateSelectedItems: function(addedItems, removedItems) {
                var that = this;
                if (that._rendered && (addedItems.length || removedItems.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var normalizedIndex, i, addedSelection = [],
                            removedSelection = [];
                        for (i = 0; i < addedItems.length; i++) {
                            normalizedIndex = that._getIndexByItemData(addedItems[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (i = 0; i < removedItems.length; i++) {
                            normalizedIndex = that._getIndexByItemData(removedItems[i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._updateSelection(addedSelection, removedSelection)
                    }
                    when(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(addedItems, removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: function() {
                this._renderSelection.apply(this, arguments)
            },
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    $itemElement.removeClass(this._selectedItemClass());
                    this._setAriaSelected($itemElement, "false");
                    $itemElement.triggerHandler("stateChanged", false)
                }
            },
            _showDeprecatedSelectionMode: function() {
                errors.log("W0001", this.NAME, "selectionMode: 'multi'", "16.1", "Use selectionMode: 'multiple' instead");
                this.option("selectionMode", "multiple")
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    $itemElement.addClass(this._selectedItemClass());
                    this._setAriaSelected($itemElement, "true");
                    $itemElement.triggerHandler("stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                if (this._cancelOptionChange === args.name) {
                    return
                }
                switch (args.name) {
                    case "selectionMode":
                        if ("multi" === args.value) {
                            this._showDeprecatedSelectionMode()
                        } else {
                            this._invalidate()
                        }
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name);
                        this._normalizeSelectedItems();
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionSilent("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _setOptionSilent: function(name, value) {
                this._cancelOptionChange = name;
                this.option(name, value);
                this._cancelOptionChange = false
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return $.Deferred().resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = $.Deferred(),
                    deletingActionArgs = {
                        cancel: false
                    },
                    deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                        excludeValidators: ["disabled", "readOnly"]
                    });
                when(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise,
                        deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state(),
                        argumentsSpecified = !!arguments.length,
                        shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    when(deletingActionArgs.cancel).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return $.Deferred().resolve().promise()
                }
                var deferred = $.Deferred(),
                    disabledState = this.option("disabled"),
                    dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw errors.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = $.Deferred();
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys");
                    selectedItemKeys.push(key);
                    this._selection.setSelection(selectedItemKeys)
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                this._selection.deselect([key])
            },
            deleteItem: function(itemElement) {
                var that = this,
                    deferred = $.Deferred(),
                    $item = this._editStrategy.getItemElement(itemElement),
                    index = this._editStrategy.getNormalizedIndex(itemElement),
                    changingOption = this._dataSource ? "dataSource" : "items",
                    itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._updateSelectionAfterDelete(index);
                            that._editStrategy.deleteItemAtIndex(index);
                            that._simulateOptionChange(changingOption);
                            that._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                                beforeExecute: function() {
                                    $item.detach()
                                },
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            that._renderEmptyMessage();
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = $.Deferred(),
                    that = this,
                    strategy = this._editStrategy,
                    $movingItem = strategy.getItemElement(itemElement),
                    $destinationItem = strategy.getItemElement(toItemElement),
                    movingIndex = strategy.getNormalizedIndex(itemElement),
                    destinationIndex = strategy.getNormalizedIndex(toItemElement),
                    changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        module.exports = CollectionWidget
    },
    /*!*******************************************************!*\
      !*** ./js/ui/collection/ui.collection_widget.base.js ***!
      \*******************************************************/
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 9),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 14),
            isPlainObject = __webpack_require__( /*! ../../core/utils/type */ 12).isPlainObject,
            when = __webpack_require__( /*! ../../integration/jquery/deferred */ 16).when,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 11).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 26).inArray,
            Action = __webpack_require__( /*! ../../core/action */ 49),
            Guid = __webpack_require__( /*! ../../core/guid */ 151),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 56),
            dataUtils = __webpack_require__( /*! ../../core/utils/data */ 50),
            Widget = __webpack_require__( /*! ../widget/ui.widget */ 95),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 71),
            pointerEvents = __webpack_require__( /*! ../../events/pointer */ 76),
            DataHelperMixin = __webpack_require__( /*! ../../data_helper */ 152),
            CollectionWidgetItem = __webpack_require__( /*! ./item */ 163),
            selectors = __webpack_require__( /*! ../widget/jquery.selectors */ 102),
            messageLocalization = __webpack_require__( /*! ../../localization/message */ 89),
            holdEvent = __webpack_require__( /*! ../../events/hold */ 164),
            clickEvent = __webpack_require__( /*! ../../events/click */ 75),
            contextMenuEvent = __webpack_require__( /*! ../../events/contextmenu */ 165),
            BindableTemplate = __webpack_require__( /*! ../widget/bindable_template */ 166);
        var COLLECTION_CLASS = "dx-collection",
            ITEM_CLASS = "dx-item",
            CONTENT_CLASS_POSTFIX = "-content",
            ITEM_CONTENT_PLACEHOLDER_CLASS = "dx-item-content-placeholder",
            ITEM_DATA_KEY = "dxItemData",
            ITEM_INDEX_KEY = "dxItemIndex",
            ITEM_TEMPLATE_ID_PREFIX = "tmpl-",
            ITEMS_SELECTOR = "[data-options*='dxItem']",
            SELECTED_ITEM_CLASS = "dx-item-selected",
            ITEM_RESPONSE_WAIT_CLASS = "dx-item-response-wait",
            EMPTY_COLLECTION = "dx-empty-collection",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper",
            ITEM_PATH_REGEX = /^([^.]+\[\d+\]\.)+([\w\.]+)$/;
        var FOCUS_UP = "up",
            FOCUS_DOWN = "down",
            FOCUS_LEFT = "left",
            FOCUS_RIGHT = "right",
            FOCUS_PAGE_UP = "pageup",
            FOCUS_PAGE_DOWN = "pagedown",
            FOCUS_LAST = "last",
            FOCUS_FIRST = "first";
        var CollectionWidget = Widget.inherit({
            _activeStateUnit: "." + ITEM_CLASS,
            _supportedKeys: function() {
                var enter = function(e) {
                        var $itemElement = this.option("focusedElement");
                        if (!$itemElement) {
                            return
                        }
                        e.target = $itemElement;
                        e.currentTarget = $itemElement;
                        this._itemClickHandler(e)
                    },
                    space = function(e) {
                        e.preventDefault();
                        enter.call(this, e)
                    },
                    move = function(location, e) {
                        e.preventDefault();
                        e.stopPropagation();
                        this._moveFocus(location, e)
                    };
                return extend(this.callBase(), {
                    space: space,
                    enter: enter,
                    leftArrow: move.bind(this, FOCUS_LEFT),
                    rightArrow: move.bind(this, FOCUS_RIGHT),
                    upArrow: move.bind(this, FOCUS_UP),
                    downArrow: move.bind(this, FOCUS_DOWN),
                    pageUp: move.bind(this, FOCUS_UP),
                    pageDown: move.bind(this, FOCUS_DOWN),
                    home: move.bind(this, FOCUS_FIRST),
                    end: move.bind(this, FOCUS_LAST)
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    selectOnFocus: false,
                    loopItemFocus: true,
                    items: [],
                    itemTemplate: "item",
                    onItemRendered: null,
                    onItemClick: null,
                    onItemHold: null,
                    itemHoldTimeout: 750,
                    onItemContextMenu: null,
                    onFocusedItemChanged: null,
                    noDataText: messageLocalization.format("dxCollectionWidget-noDataText"),
                    dataSource: null,
                    _itemAttributes: {},
                    itemTemplateProperty: "template",
                    focusOnSelectedItem: true,
                    focusedElement: null,
                    disabledExpr: function(data) {
                        return data ? data.disabled : void 0
                    },
                    visibleExpr: function(data) {
                        return data ? data.visible : void 0
                    }
                })
            },
            _getAnonymousTemplateName: function() {
                return "item"
            },
            _init: function() {
                this.callBase();
                this._cleanRenderedItems();
                this._refreshDataSource()
            },
            _initTemplates: function() {
                this._initItemsFromMarkup();
                this.callBase();
                this._defaultTemplates.item = new BindableTemplate(function($container, data) {
                    if (isPlainObject(data)) {
                        if (data.text) {
                            $container.text(data.text)
                        }
                        if (data.html) {
                            $container.html(data.html)
                        }
                    } else {
                        $container.text(String(data))
                    }
                }, ["text", "html"], this.option("integrationOptions.watchMethod"))
            },
            _initItemsFromMarkup: function() {
                var $items = this.element().contents().filter(ITEMS_SELECTOR);
                if (!$items.length || this.option("items").length) {
                    return
                }
                var items = $.map($items, function(item) {
                    var $item = $(item);
                    var result = domUtils.getElementOptions(item).dxItem;
                    var isTemplateRequired = $.trim($item.html()) && !result.template;
                    if (isTemplateRequired) {
                        result.template = this._prepareItemTemplate($item)
                    } else {
                        $item.remove()
                    }
                    return result
                }.bind(this));
                this.option("items", items)
            },
            _prepareItemTemplate: function($item) {
                var templateId = ITEM_TEMPLATE_ID_PREFIX + new Guid;
                var templateOptions = 'dxTemplate: { name: "' + templateId + '" }';
                $item.detach().clone().attr("data-options", templateOptions).data("options", templateOptions).appendTo(this.element());
                return templateId
            },
            _dataSourceOptions: function() {
                return {
                    paginate: false
                }
            },
            _cleanRenderedItems: function() {
                this._renderedItemsCount = 0
            },
            _focusTarget: function() {
                return this.element()
            },
            _focusInHandler: function(e) {
                this.callBase.apply(this, arguments);
                if (inArray(e.target, this._focusTarget()) === -1) {
                    return
                }
                var $focusedElement = this.option("focusedElement");
                if ($focusedElement && $focusedElement.length) {
                    this._setFocusedItem($focusedElement)
                } else {
                    var $activeItem = this._getActiveItem();
                    if ($activeItem.length) {
                        this.option("focusedElement", $activeItem)
                    }
                }
            },
            _focusOutHandler: function() {
                this.callBase.apply(this, arguments);
                var $target = this.option("focusedElement");
                if ($target) {
                    this._toggleFocusClass(false, $target)
                }
            },
            _getActiveItem: function(last) {
                var $focusedElement = this.option("focusedElement");
                if ($focusedElement && $focusedElement.length) {
                    return $focusedElement
                }
                var index = this.option("focusOnSelectedItem") ? this.option("selectedIndex") : 0,
                    activeElements = this._getActiveElement(),
                    lastIndex = activeElements.length - 1;
                if (index < 0) {
                    index = last ? lastIndex : 0
                }
                return activeElements.eq(index)
            },
            _renderFocusTarget: function() {
                this.callBase.apply(this, arguments);
                this._refreshActiveDescendant()
            },
            _moveFocus: function(location) {
                var $newTarget, $items = this._getAvailableItems();
                switch (location) {
                    case FOCUS_PAGE_UP:
                    case FOCUS_UP:
                        $newTarget = this._prevItem($items);
                        break;
                    case FOCUS_PAGE_DOWN:
                    case FOCUS_DOWN:
                        $newTarget = this._nextItem($items);
                        break;
                    case FOCUS_RIGHT:
                        $newTarget = this.option("rtlEnabled") ? this._prevItem($items) : this._nextItem($items);
                        break;
                    case FOCUS_LEFT:
                        $newTarget = this.option("rtlEnabled") ? this._nextItem($items) : this._prevItem($items);
                        break;
                    case FOCUS_FIRST:
                        $newTarget = $items.first();
                        break;
                    case FOCUS_LAST:
                        $newTarget = $items.last();
                        break;
                    default:
                        return false
                }
                if (0 !== $newTarget.length) {
                    this.option("focusedElement", $newTarget)
                }
            },
            _getAvailableItems: function($itemElements) {
                $itemElements = $itemElements || this._itemElements();
                return $itemElements.filter(":visible").not(".dx-state-disabled")
            },
            _prevItem: function($items) {
                var $target = this._getActiveItem(),
                    targetIndex = $items.index($target),
                    $last = $items.last(),
                    $item = $($items[targetIndex - 1]),
                    loop = this.option("loopItemFocus");
                if (0 === $item.length && loop) {
                    $item = $last
                }
                return $item
            },
            _nextItem: function($items) {
                var $target = this._getActiveItem(true),
                    targetIndex = $items.index($target),
                    $first = $items.first(),
                    $item = $($items[targetIndex + 1]),
                    loop = this.option("loopItemFocus");
                if (0 === $item.length && loop) {
                    $item = $first
                }
                return $item
            },
            _selectFocusedItem: function($target) {
                this.selectItem($target)
            },
            _removeFocusedItem: function($target) {
                if ($target && $target.length) {
                    this._toggleFocusClass(false, $target);
                    $target.removeAttr("id")
                }
            },
            _refreshActiveDescendant: function() {
                this.setAria("activedescendant", "");
                this.setAria("activedescendant", this.getFocusedItemId())
            },
            _setFocusedItem: function($target) {
                if (!$target || !$target.length) {
                    return
                }
                $target.attr("id", this.getFocusedItemId());
                this._toggleFocusClass(true, $target);
                this.onFocusedItemChanged(this.getFocusedItemId());
                this._refreshActiveDescendant();
                if (this.option("selectOnFocus")) {
                    this._selectFocusedItem($target)
                }
            },
            _findItemElementByItem: function(item) {
                var result = $(),
                    that = this;
                this.itemElements().each(function() {
                    var $item = $(this);
                    if ($item.data(that._itemDataKey()) === item) {
                        result = $item;
                        return false
                    }
                });
                return result
            },
            _getIndexByItem: function(item) {
                return this.option("items").indexOf(item)
            },
            _itemOptionChanged: function(item, property, value, oldValue) {
                var $item = this._findItemElementByItem(item);
                if (!$item.length) {
                    return
                }
                if (!this.constructor.ItemClass.getInstance($item).setDataField(property, value)) {
                    var itemData = this._getItemData($item),
                        index = $item.data(this._itemIndexKey());
                    this._renderItem(index, itemData, null, $item)
                }
            },
            _optionChanged: function(args) {
                if ("items" === args.name) {
                    var matches = args.fullName.match(ITEM_PATH_REGEX);
                    if (matches && matches.length) {
                        var property = matches[matches.length - 1],
                            itemPath = args.fullName.replace("." + property, ""),
                            item = this.option(itemPath);
                        this._itemOptionChanged(item, property, args.value, args.previousValue);
                        return
                    }
                }
                switch (args.name) {
                    case "items":
                    case "_itemAttributes":
                    case "itemTemplateProperty":
                        this._cleanRenderedItems();
                        this._invalidate();
                        break;
                    case "dataSource":
                        this.option("items", []);
                        this._refreshDataSource();
                        this._renderEmptyMessage();
                        break;
                    case "noDataText":
                        this._renderEmptyMessage();
                        break;
                    case "itemTemplate":
                        this._invalidate();
                        break;
                    case "onItemRendered":
                        this._createItemRenderAction();
                        break;
                    case "onItemClick":
                        break;
                    case "onItemHold":
                    case "itemHoldTimeout":
                        this._attachHoldEvent();
                        break;
                    case "onItemContextMenu":
                        this._attachContextMenuEvent();
                        break;
                    case "onFocusedItemChanged":
                        this.onFocusedItemChanged = this._createActionByOption("onFocusedItemChanged");
                        break;
                    case "selectOnFocus":
                    case "loopItemFocus":
                    case "focusOnSelectedItem":
                        break;
                    case "focusedElement":
                        this._removeFocusedItem(args.previousValue);
                        this._setFocusedItem(args.value);
                        break;
                    case "visibleExpr":
                    case "disabledExpr":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _loadNextPage: function() {
                var dataSource = this._dataSource;
                this._expectNextPageLoading();
                dataSource.pageIndex(1 + dataSource.pageIndex());
                return dataSource.load()
            },
            _expectNextPageLoading: function() {
                this._startIndexForAppendedItems = 0
            },
            _expectLastItemLoading: function() {
                this._startIndexForAppendedItems = -1
            },
            _forgetNextPageLoading: function() {
                this._startIndexForAppendedItems = null
            },
            _dataSourceChangedHandler: function(newItems) {
                var items = this.option("items");
                if (this._initialized && items && this._shouldAppendItems()) {
                    this._renderedItemsCount = items.length;
                    if (!this._isLastPage() || this._startIndexForAppendedItems !== -1) {
                        this.option().items = items.concat(newItems.slice(this._startIndexForAppendedItems))
                    }
                    this._forgetNextPageLoading();
                    this._renderContent();
                    this._renderFocusTarget()
                } else {
                    this.option("items", newItems)
                }
            },
            _dataSourceLoadErrorHandler: function() {
                this._forgetNextPageLoading();
                this.option("items", this.option("items"))
            },
            _shouldAppendItems: function() {
                return null != this._startIndexForAppendedItems && this._allowDynamicItemsAppend()
            },
            _allowDynamicItemsAppend: function() {
                return false
            },
            _clean: function() {
                this._cleanFocusState();
                this._cleanItemContainer()
            },
            _cleanItemContainer: function() {
                this._itemContainer().empty()
            },
            _dispose: function() {
                this.callBase();
                clearTimeout(this._itemFocusTimeout)
            },
            _refresh: function() {
                this._cleanRenderedItems();
                this.callBase.apply(this, arguments)
            },
            _itemContainer: function() {
                return this.element()
            },
            _itemClass: function() {
                return ITEM_CLASS
            },
            _itemContentClass: function() {
                return this._itemClass() + CONTENT_CLASS_POSTFIX
            },
            _selectedItemClass: function() {
                return SELECTED_ITEM_CLASS
            },
            _itemResponseWaitClass: function() {
                return ITEM_RESPONSE_WAIT_CLASS
            },
            _itemSelector: function() {
                return "." + this._itemClass()
            },
            _itemDataKey: function() {
                return ITEM_DATA_KEY
            },
            _itemIndexKey: function() {
                return ITEM_INDEX_KEY
            },
            _itemElements: function() {
                return this._itemContainer().find(this._itemSelector())
            },
            _render: function() {
                this.onFocusedItemChanged = this._createActionByOption("onFocusedItemChanged");
                this.callBase();
                this.element().addClass(COLLECTION_CLASS);
                this._attachClickEvent();
                this._attachHoldEvent();
                this._attachContextMenuEvent()
            },
            _attachClickEvent: function() {
                var itemSelector = this._itemSelector(),
                    clickEventNamespace = eventUtils.addNamespace(clickEvent.name, this.NAME),
                    pointerDownEventNamespace = eventUtils.addNamespace(pointerEvents.down, this.NAME),
                    that = this;
                var pointerDownAction = new Action(function(args) {
                    var event = args.event;
                    that._itemPointerDownHandler(event)
                });
                this._itemContainer().off(clickEventNamespace, itemSelector).off(pointerDownEventNamespace, itemSelector).on(clickEventNamespace, itemSelector, function(e) {
                    this._itemClickHandler(e)
                }.bind(this)).on(pointerDownEventNamespace, itemSelector, function(e) {
                    pointerDownAction.execute({
                        element: $(e.target),
                        event: e
                    })
                })
            },
            _itemClickHandler: function(e, args, config) {
                this._itemJQueryEventHandler(e, "onItemClick", args, config)
            },
            _itemPointerDownHandler: function(e) {
                if (!this.option("focusStateEnabled")) {
                    return
                }
                this._itemFocusHandler = function() {
                    clearTimeout(this._itemFocusTimeout);
                    this._itemFocusHandler = null;
                    if (e.isDefaultPrevented()) {
                        return
                    }
                    var $target = $(e.target),
                        $closestItem = $target.closest(this._itemElements()),
                        $closestFocusable = this._closestFocusable($target);
                    if ($closestItem.length && inArray($closestFocusable.get(0), this._focusTarget()) !== -1) {
                        this.option("focusedElement", $closestItem)
                    }
                }.bind(this);
                this._itemFocusTimeout = setTimeout(this._forcePointerDownFocus.bind(this))
            },
            _closestFocusable: function($target) {
                if ($target.is(selectors.focusable)) {
                    return $target
                } else {
                    $target = $target.parent();
                    while ($target.length) {
                        if ($target.is(selectors.focusable)) {
                            return $target
                        }
                        $target = $target.parent()
                    }
                }
            },
            _forcePointerDownFocus: function() {
                this._itemFocusHandler && this._itemFocusHandler()
            },
            _updateFocusState: function() {
                this.callBase.apply(this, arguments);
                this._forcePointerDownFocus()
            },
            _attachHoldEvent: function() {
                var $itemContainer = this._itemContainer(),
                    itemSelector = this._itemSelector(),
                    eventName = eventUtils.addNamespace(holdEvent.name, this.NAME);
                $itemContainer.off(eventName, itemSelector);
                $itemContainer.on(eventName, itemSelector, {
                    timeout: this._getHoldTimeout()
                }, this._itemHoldHandler.bind(this))
            },
            _getHoldTimeout: function() {
                return this.option("itemHoldTimeout")
            },
            _shouldFireHoldEvent: function() {
                return this.hasActionSubscription("onItemHold")
            },
            _itemHoldHandler: function(e) {
                if (this._shouldFireHoldEvent()) {
                    this._itemJQueryEventHandler(e, "onItemHold")
                } else {
                    e.cancel = true
                }
            },
            _attachContextMenuEvent: function() {
                var $itemContainer = this._itemContainer(),
                    itemSelector = this._itemSelector(),
                    eventName = eventUtils.addNamespace(contextMenuEvent.name, this.NAME);
                $itemContainer.off(eventName, itemSelector);
                $itemContainer.on(eventName, itemSelector, this._itemContextMenuHandler.bind(this))
            },
            _shouldFireContextMenuEvent: function() {
                return this.hasActionSubscription("onItemContextMenu")
            },
            _itemContextMenuHandler: function(e) {
                if (this._shouldFireContextMenuEvent()) {
                    this._itemJQueryEventHandler(e, "onItemContextMenu")
                } else {
                    e.cancel = true
                }
            },
            _renderContentImpl: function() {
                var items = this.option("items") || [];
                if (this._renderedItemsCount) {
                    this._renderItems(items.slice(this._renderedItemsCount))
                } else {
                    this._renderItems(items)
                }
            },
            _renderItems: function(items) {
                if (items.length) {
                    $.each(items, this._renderItem.bind(this))
                }
                this._renderEmptyMessage()
            },
            _renderItem: function(index, itemData, $container, $itemToReplace) {
                $container = $container || this._itemContainer();
                var $itemFrame = this._renderItemFrame(index, itemData, $container, $itemToReplace);
                this._setElementData($itemFrame, itemData, index);
                $itemFrame.attr(this.option("_itemAttributes"));
                this._attachItemClickEvent(itemData, $itemFrame);
                var $itemContent = $itemFrame.find("." + ITEM_CONTENT_PLACEHOLDER_CLASS);
                $itemContent.removeClass(ITEM_CONTENT_PLACEHOLDER_CLASS);
                var renderContentPromise = this._renderItemContent({
                    index: index,
                    itemData: itemData,
                    container: $itemContent,
                    contentClass: this._itemContentClass(),
                    defaultTemplateName: this.option("itemTemplate")
                });
                var that = this;
                when(renderContentPromise).done(function($itemContent) {
                    that._postprocessRenderItem({
                        itemElement: $itemFrame,
                        itemContent: $itemContent,
                        itemData: itemData,
                        itemIndex: index
                    });
                    that._executeItemRenderAction(index, itemData, $itemFrame)
                });
                return $itemFrame
            },
            _attachItemClickEvent: function(itemData, $itemElement) {
                if (!itemData || !itemData.onClick) {
                    return
                }
                $itemElement.on(clickEvent.name, function(e) {
                    this._itemEventHandlerByHandler($itemElement, itemData.onClick, {
                        jQueryEvent: e
                    })
                }.bind(this))
            },
            _renderItemContent: function(args) {
                var itemTemplateName = this._getItemTemplateName(args);
                var itemTemplate = this._getTemplate(itemTemplateName);
                this._addItemContentClasses(args);
                var $templateResult = this._createItemByTemplate(itemTemplate, args);
                if (!$templateResult.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                    return args.container
                }
                return this._renderItemContentByNode(args, $templateResult)
            },
            _renderItemContentByNode: function(args, $node) {
                args.container.replaceWith($node);
                args.container = $node;
                this._addItemContentClasses(args);
                return $node
            },
            _addItemContentClasses: function(args) {
                var classes = [ITEM_CLASS + CONTENT_CLASS_POSTFIX, args.contentClass];
                args.container.addClass(classes.join(" "))
            },
            _renderItemFrame: function(index, itemData, $container, $itemToReplace) {
                var $itemFrame = $("<div>");
                new this.constructor.ItemClass($itemFrame, this._itemOptions(), itemData || {});
                if ($itemToReplace && $itemToReplace.length) {
                    $itemToReplace.replaceWith($itemFrame)
                } else {
                    $itemFrame.appendTo($container)
                }
                return $itemFrame
            },
            _itemOptions: function() {
                var that = this;
                return {
