/**
 * DevExtreme (framework/action_executors.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var $ = require("../core/renderer"),
    dataCoreUtils = require("../core/utils/data"),
    extend = require("../core/utils/extend").extend,
    isPlainObject = require("../core/utils/type").isPlainObject,
    Route = require("./router").Route;

function prepareNavigateOptions(options, actionArguments) {
    if (actionArguments.args) {
        var sourceEventArguments = actionArguments.args[0];
        options.jQueryEvent = sourceEventArguments.jQueryEvent
    }
    if ("dxCommand" === (actionArguments.component || {}).NAME) {
        extend(options, actionArguments.component.option())
    }
}

function preventDefaultLinkBehavior(e) {
    if (!e) {
        return
    }
    var $targetElement = $(e.target);
    if ($targetElement.attr("href")) {
        e.preventDefault()
    }
}
var createActionExecutors = function(app) {
    return {
        routing: {
            execute: function(e) {
                var routeValues, uri, action = e.action,
                    options = {};
                if (isPlainObject(action)) {
                    routeValues = action.routeValues;
                    if (routeValues && isPlainObject(routeValues)) {
                        options = action.options
                    } else {
                        routeValues = action
                    }
                    uri = app.router.format(routeValues);
                    prepareNavigateOptions(options, e);
                    preventDefaultLinkBehavior(options.jQueryEvent);
                    app.navigate(uri, options);
                    e.handled = true
                }
            }
        },
        hash: {
            execute: function(e) {
                if ("string" !== typeof e.action || "#" !== e.action.charAt(0)) {
                    return
                }
                var uriTemplate = e.action.substr(1),
                    args = e.args[0],
                    uri = uriTemplate;
                var defaultEvaluate = function(expr) {
                    var getter = dataCoreUtils.compileGetter(expr),
                        model = e.args[0].model;
                    return getter(model)
                };
                var evaluate = args.evaluate || defaultEvaluate;
                uri = uriTemplate.replace(/\{([^}]+)\}/g, function(entry, expr) {
                    expr = $.trim(expr);
                    if (expr.indexOf(",") > -1) {
                        expr = $.map(expr.split(","), $.trim)
                    }
                    var value = evaluate(expr);
                    if (void 0 === value) {
                        value = ""
                    }
                    value = Route.prototype.formatSegment(value);
                    return value
                });
                var options = {};
                prepareNavigateOptions(options, e);
                preventDefaultLinkBehavior(options.jQueryEvent);
                app.navigate(uri, options);
                e.handled = true
            }
        },
        url: {
            execute: function(e) {
                if ("string" === typeof e.action && "#" !== e.action.charAt(0)) {
                    document.location = e.action
                }
            }
        }
    }
};
exports.createActionExecutors = createActionExecutors;
